/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.graphhopper.api.GHMRequest;
import com.graphhopper.api.GraphHopperMatrixWeb;
import com.graphhopper.api.GzipRequestInterceptor;
import com.graphhopper.api.MatrixResponse;
import com.graphhopper.api.Version;
import com.graphhopper.util.Helper;
import com.graphhopper.util.shapes.GHPoint;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public abstract class GHMatrixAbstractRequester {
    static final String MATRIX_URL = "https://graphhopper.com/api/1/matrix";
    protected final ObjectMapper objectMapper;
    protected final String serviceUrl;
    private final Set<String> ignoreSet = new HashSet<String>();
    private OkHttpClient downloader;
    int maxUnzippedLength = 1000;

    public GHMatrixAbstractRequester() {
        this(MATRIX_URL);
    }

    public GHMatrixAbstractRequester(String serviceUrl) {
        this(serviceUrl, new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).readTimeout(5L, TimeUnit.SECONDS).build(), true);
    }

    public GHMatrixAbstractRequester(String serviceUrl, OkHttpClient client, boolean doRequestGzip) {
        if (serviceUrl.endsWith("/")) {
            serviceUrl = serviceUrl.substring(0, serviceUrl.length() - 1);
        }
        this.downloader = doRequestGzip ? client.newBuilder().addInterceptor((Interceptor)new GzipRequestInterceptor()).build() : client;
        this.serviceUrl = serviceUrl;
        this.ignoreSet.add("key");
        this.ignoreSet.add("service_url");
        this.objectMapper = new ObjectMapper();
    }

    public abstract MatrixResponse route(GHMRequest var1);

    public GHMatrixAbstractRequester setDownloader(OkHttpClient downloader) {
        this.downloader = downloader;
        return this;
    }

    public OkHttpClient getDownloader() {
        return this.downloader;
    }

    protected JsonNode createPostRequest(GHMRequest ghRequest) {
        if (ghRequest.getHints().getObject("profile", null) != null) {
            throw new IllegalArgumentException("use setProfile instead of hint 'profile'");
        }
        if (ghRequest.getProfile() == null) {
            throw new IllegalArgumentException("profile cannot be empty");
        }
        if (ghRequest.getHints().getObject("fail_fast", null) != null) {
            throw new IllegalArgumentException("use setFailFast instead of hint 'fail_fast'");
        }
        ObjectNode requestJson = this.objectMapper.createObjectNode();
        if (ghRequest.getPoints() != null) {
            if (ghRequest.getFromPoints() != null) {
                throw new IllegalArgumentException("if points are set do not use setFromPoints");
            }
            if (ghRequest.getToPoints() != null) {
                throw new IllegalArgumentException("if points are set do not use setToPoints");
            }
            this.putPoints(requestJson, "points", ghRequest.getPoints());
            this.putStrings(requestJson, "point_hints", ghRequest.getPointHints());
            this.putStrings(requestJson, "curbsides", ghRequest.getCurbsides());
        } else {
            if (ghRequest.getFromPoints() == null) {
                throw new IllegalArgumentException("if points are not set you have to use setFromPoints but was null");
            }
            if (ghRequest.getToPoints() == null) {
                throw new IllegalArgumentException("if points are not set you have to use setToPoints but was null");
            }
            this.putPoints(requestJson, "from_points", ghRequest.getFromPoints());
            this.putStrings(requestJson, "from_point_hints", ghRequest.getFromPointHints());
            this.putPoints(requestJson, "to_points", ghRequest.getToPoints());
            this.putStrings(requestJson, "to_point_hints", ghRequest.getToPointHints());
            this.putStrings(requestJson, "from_curbsides", ghRequest.getFromCurbsides());
            this.putStrings(requestJson, "to_curbsides", ghRequest.getToCurbsides());
        }
        this.putStrings(requestJson, "snap_preventions", ghRequest.getSnapPreventions());
        this.putStrings(requestJson, "out_arrays", ghRequest.getOutArrays());
        requestJson.put("fail_fast", ghRequest.getFailFast());
        requestJson.put("profile", ghRequest.getProfile());
        Map hintsMap = ghRequest.getHints().toMap();
        for (String hintKey : hintsMap.keySet()) {
            if (this.ignoreSet.contains(hintKey)) continue;
            Object hint = hintsMap.get(hintKey);
            if (hint instanceof String) {
                requestJson.put(hintKey, (String)hint);
                continue;
            }
            requestJson.putPOJO(hintKey, hint);
        }
        return requestJson;
    }

    protected JsonNode fromStringToJSON(String url, String str) {
        try {
            return this.objectMapper.readTree(str);
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot parse json " + str + " from " + url);
        }
    }

    public List<Throwable> readUsableEntityError(Collection<String> outArraysList, JsonNode solution) {
        boolean readTimes;
        boolean readWeights = outArraysList.contains("weights") && solution.has("weights");
        boolean readDistances = outArraysList.contains("distances") && solution.has("distances");
        boolean bl = readTimes = outArraysList.contains("times") && solution.has("times");
        if (!(readWeights || readDistances || readTimes)) {
            return Collections.singletonList(new RuntimeException("Cannot find usable entity like weights, distances or times in JSON"));
        }
        return Collections.emptyList();
    }

    protected void fillResponseFromJson(MatrixResponse matrixResponse, JsonNode solution, boolean failFast) {
        boolean readWeights = solution.has("weights");
        boolean readDistances = solution.has("distances");
        boolean readTimes = solution.has("times");
        int fromCount = 0;
        JsonNode weightsArray = null;
        if (readWeights) {
            weightsArray = solution.get("weights");
            fromCount = GHMatrixAbstractRequester.checkArraySizes("weights", weightsArray.size(), new JsonNode[0]);
        }
        JsonNode timesArray = null;
        if (readTimes) {
            timesArray = solution.get("times");
            fromCount = GHMatrixAbstractRequester.checkArraySizes("times", timesArray.size(), weightsArray);
        }
        JsonNode distancesArray = null;
        if (readDistances) {
            distancesArray = solution.get("distances");
            fromCount = GHMatrixAbstractRequester.checkArraySizes("distances", distancesArray.size(), weightsArray, timesArray);
        }
        for (int fromIndex = 0; fromIndex < fromCount; ++fromIndex) {
            int toCount = 0;
            JsonNode weightsFromArray = null;
            double[] weights = null;
            if (readWeights) {
                weightsFromArray = weightsArray.get(fromIndex);
                weights = new double[weightsFromArray.size()];
                toCount = GHMatrixAbstractRequester.checkArraySizes("weights", weightsFromArray.size(), new JsonNode[0]);
            }
            JsonNode timesFromArray = null;
            long[] times = null;
            if (readTimes) {
                timesFromArray = timesArray.get(fromIndex);
                times = new long[timesFromArray.size()];
                toCount = GHMatrixAbstractRequester.checkArraySizes("times", timesFromArray.size(), weightsFromArray);
            }
            JsonNode distancesFromArray = null;
            int[] distances = null;
            if (readDistances) {
                distancesFromArray = distancesArray.get(fromIndex);
                distances = new int[distancesFromArray.size()];
                toCount = GHMatrixAbstractRequester.checkArraySizes("distances", distancesFromArray.size(), weightsFromArray, timesFromArray);
            }
            for (int toIndex = 0; toIndex < toCount; ++toIndex) {
                if (readWeights) {
                    weights[toIndex] = weightsFromArray.get(toIndex).isNull() && !failFast ? Double.MAX_VALUE : weightsFromArray.get(toIndex).asDouble();
                }
                if (readTimes) {
                    times[toIndex] = timesFromArray.get(toIndex).isNull() && !failFast ? Long.MAX_VALUE : timesFromArray.get(toIndex).asLong() * 1000L;
                }
                if (!readDistances) continue;
                distances[toIndex] = distancesFromArray.get(toIndex).isNull() && !failFast ? Integer.MAX_VALUE : (int)Math.round(distancesFromArray.get(toIndex).asDouble());
            }
            if (readWeights) {
                matrixResponse.setWeightRow(fromIndex, weights);
            }
            if (readTimes) {
                matrixResponse.setTimeRow(fromIndex, times);
            }
            if (!readDistances) continue;
            matrixResponse.setDistanceRow(fromIndex, distances);
        }
        if (!failFast && solution.has("hints")) {
            this.addProblems(matrixResponse, solution.get("hints"));
        }
    }

    private void addProblems(MatrixResponse matrixResponse, JsonNode hints) {
        for (JsonNode hint : hints) {
            if (hint.has("point_pairs")) {
                matrixResponse.setDisconnectedPoints(this.readDisconnectedPoints(hint.get("point_pairs")));
            }
            if (!hint.has("invalid_from_points")) continue;
            matrixResponse.setInvalidFromPoints(this.readInvalidPoints(hint.get("invalid_from_points")));
            matrixResponse.setInvalidToPoints(this.readInvalidPoints(hint.get("invalid_to_points")));
        }
    }

    private List<MatrixResponse.PointPair> readDisconnectedPoints(JsonNode pointPairsArray) {
        ArrayList<MatrixResponse.PointPair> disconnectedPoints = new ArrayList<MatrixResponse.PointPair>(pointPairsArray.size());
        for (int i = 0; i < pointPairsArray.size(); ++i) {
            if (pointPairsArray.get(i).size() != 2) {
                throw new IllegalArgumentException("all point_pairs are expected to contain two elements");
            }
            disconnectedPoints.add(new MatrixResponse.PointPair(pointPairsArray.get(i).get(0).asInt(), pointPairsArray.get(i).get(1).asInt()));
        }
        return disconnectedPoints;
    }

    private List<Integer> readInvalidPoints(JsonNode pointsArray) {
        ArrayList<Integer> result = new ArrayList<Integer>(pointsArray.size());
        for (int i = 0; i < pointsArray.size(); ++i) {
            result.add(pointsArray.get(i).asInt());
        }
        return result;
    }

    private static int checkArraySizes(String msg, int len, JsonNode ... arrays) {
        for (JsonNode other : arrays) {
            if (len <= 0) {
                throw new IllegalArgumentException("Size " + len + " of '" + msg + "' array is too small");
            }
            if (other == null || len == other.size()) continue;
            throw new IllegalArgumentException("Size " + len + " of '" + msg + "' array is has to be equal to other arrays but wasn't");
        }
        return len;
    }

    protected String buildURLNoHints(String path, GHMRequest ghRequest) {
        String url = ghRequest.getHints().getString("service_url", this.serviceUrl) + path + "?";
        String key = ghRequest.getHints().getString("key", "");
        if (!Helper.isEmpty((String)key)) {
            url = url + "key=" + key;
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonResult postJson(String url, JsonNode data) throws IOException {
        JsonResult jsonResult;
        String stringData = data.toString();
        Request.Builder builder = new Request.Builder().url(url).post(RequestBody.create((MediaType)GraphHopperMatrixWeb.MT_JSON, (String)stringData));
        builder.header("X-GH-Client-Version", Version.GH_VERSION_FROM_MAVEN);
        if (stringData.length() < this.maxUnzippedLength) {
            builder.header("Content-Encoding", "identity");
        }
        Request okRequest = builder.build();
        ResponseBody body = null;
        try {
            Response rsp = this.getDownloader().newCall(okRequest).execute();
            body = rsp.body();
            jsonResult = new JsonResult(body.string(), rsp.code(), rsp.headers().toMultimap());
        }
        catch (Throwable throwable) {
            Helper.close(body);
            throw throwable;
        }
        Helper.close((Closeable)body);
        return jsonResult;
    }

    private void putStrings(ObjectNode requestJson, String name, Collection<String> stringList) {
        if (stringList == null || stringList.isEmpty()) {
            return;
        }
        ArrayNode outList = this.objectMapper.createArrayNode();
        for (String str : stringList) {
            outList.add(str);
        }
        requestJson.putArray(name).addAll(outList);
    }

    private void putPoints(ObjectNode requestJson, String name, List<GHPoint> pList) {
        if (pList.isEmpty()) {
            return;
        }
        ArrayNode outList = this.objectMapper.createArrayNode();
        for (GHPoint p : pList) {
            ArrayNode entry = this.objectMapper.createArrayNode();
            entry.add(p.lon);
            entry.add(p.lat);
            outList.add((JsonNode)entry);
        }
        requestJson.putArray(name).addAll(outList);
    }

    protected record JsonResult(String body, int statusCode, Map<String, List<String>> headers) {
    }
}

