/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.graphhopper.api.GHMRequest;
import com.graphhopper.api.GHMatrixAbstractRequester;
import com.graphhopper.api.MatrixResponse;
import com.graphhopper.api.Version;
import com.graphhopper.jackson.ResponsePathDeserializerHelper;
import com.graphhopper.util.Helper;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GHMatrixBatchRequester
extends GHMatrixAbstractRequester {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int maxIterations = 100;
    private long sleepAfterGET = 1000L;

    public GHMatrixBatchRequester() {
        this("https://graphhopper.com/api/1/matrix");
    }

    public GHMatrixBatchRequester(String serviceUrl) {
        this(serviceUrl, new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).readTimeout(5L, TimeUnit.SECONDS).build(), true);
    }

    public GHMatrixBatchRequester(String serviceUrl, OkHttpClient client, boolean doRequestGzip) {
        super(serviceUrl, client, doRequestGzip);
    }

    public GHMatrixBatchRequester setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
        return this;
    }

    public GHMatrixBatchRequester setSleepAfterGET(long sleepAfterGETMillis) {
        this.sleepAfterGET = sleepAfterGETMillis;
        return this;
    }

    @Override
    public MatrixResponse route(GHMRequest ghRequest) {
        JsonNode requestJson = this.createPostRequest(ghRequest);
        boolean withTimes = ghRequest.getOutArrays().contains("times");
        boolean withDistances = ghRequest.getOutArrays().contains("distances");
        boolean withWeights = ghRequest.getOutArrays().contains("weights");
        MatrixResponse matrixResponse = new MatrixResponse(ghRequest.getPoints() == null ? ghRequest.getFromPoints().size() : ghRequest.getPoints().size(), ghRequest.getPoints() == null ? ghRequest.getToPoints().size() : ghRequest.getPoints().size(), withTimes, withDistances, withWeights);
        try {
            int i;
            JsonNode responseJson;
            String postUrl = this.buildURLNoHints("/calculate", ghRequest);
            GHMatrixAbstractRequester.JsonResult jsonResult = this.postJson(postUrl, requestJson);
            matrixResponse.setHeaders(jsonResult.headers());
            boolean debug = ghRequest.getHints().getBool("debug", false);
            if (debug) {
                this.logger.info("POST URL:" + postUrl + ", request:" + String.valueOf(requestJson) + ", response: " + String.valueOf(jsonResult));
            }
            if ((responseJson = this.fromStringToJSON(postUrl, jsonResult.body())).has("message")) {
                matrixResponse.setStatusCode(jsonResult.statusCode());
                matrixResponse.addErrors(ResponsePathDeserializerHelper.readErrors((ObjectMapper)this.objectMapper, (JsonNode)responseJson));
                return matrixResponse;
            }
            if (!responseJson.has("job_id")) {
                throw new IllegalStateException("Response should contain job_id but was " + String.valueOf(jsonResult) + ", request:" + String.valueOf(requestJson) + ",url:" + postUrl);
            }
            String id = responseJson.get("job_id").asText();
            for (i = 0; i < this.maxIterations; ++i) {
                GHMatrixAbstractRequester.JsonResult rsp;
                if (this.sleepAfterGET > 0L) {
                    Thread.sleep(this.sleepAfterGET);
                }
                String getUrl = this.buildURLNoHints("/solution/" + id, ghRequest);
                try {
                    rsp = this.getJson(getUrl);
                }
                catch (SocketTimeoutException ex) {
                    rsp = this.getJson(getUrl);
                }
                JsonNode getResponseJson = this.fromStringToJSON(getUrl, rsp.body());
                if (debug) {
                    this.logger.info(i + " GET URL:" + getUrl + ", response: " + String.valueOf(rsp));
                }
                matrixResponse.addErrors(ResponsePathDeserializerHelper.readErrors((ObjectMapper)this.objectMapper, (JsonNode)getResponseJson));
                matrixResponse.setStatusCode(rsp.statusCode());
                if (matrixResponse.hasErrors()) break;
                String status = getResponseJson.get("status").asText();
                if ("processing".equals(status) || "waiting".equals(status)) continue;
                if ("finished".equals(status)) {
                    JsonNode solution = getResponseJson.get("solution");
                    matrixResponse.addErrors(this.readUsableEntityError(ghRequest.getOutArrays(), solution));
                    if (matrixResponse.hasErrors()) break;
                    this.fillResponseFromJson(matrixResponse, solution, ghRequest.getFailFast());
                    break;
                }
                matrixResponse.addError(new RuntimeException("Status not supported: " + status + " - illegal JSON format?"));
                break;
            }
            if (i >= this.maxIterations) {
                throw new IllegalStateException("Maximum number of iterations reached " + this.maxIterations + ", increasing should only be necessary for big matrices. For smaller ones this is a bug, please contact us");
            }
        }
        catch (IOException | InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        return matrixResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GHMatrixAbstractRequester.JsonResult getJson(String url) throws IOException {
        GHMatrixAbstractRequester.JsonResult jsonResult;
        Request okRequest = new Request.Builder().url(url).header("X-GH-Client-Version", Version.GH_VERSION_FROM_MAVEN).build();
        ResponseBody body = null;
        try {
            Response rsp = this.getDownloader().newCall(okRequest).execute();
            body = rsp.body();
            jsonResult = new GHMatrixAbstractRequester.JsonResult(body.string(), rsp.code(), rsp.headers().toMultimap());
        }
        catch (Throwable throwable) {
            Helper.close(body);
            throw throwable;
        }
        Helper.close((Closeable)body);
        return jsonResult;
    }
}

