/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.graphhopper.api.GHMRequest;
import com.graphhopper.api.GHMatrixAbstractRequester;
import com.graphhopper.api.MatrixResponse;
import com.graphhopper.jackson.ResponsePathDeserializerHelper;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class GHMatrixSyncRequester
extends GHMatrixAbstractRequester {
    public GHMatrixSyncRequester() {
        this("https://graphhopper.com/api/1/matrix");
    }

    public GHMatrixSyncRequester(String serviceUrl) {
        this(serviceUrl, new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).readTimeout(15L, TimeUnit.SECONDS).build(), true);
    }

    public GHMatrixSyncRequester(String serviceUrl, OkHttpClient client, boolean doRequestGzip) {
        super(serviceUrl, client, doRequestGzip);
    }

    @Override
    public MatrixResponse route(GHMRequest ghRequest) {
        JsonNode requestJson = this.createPostRequest(ghRequest);
        boolean withTimes = ghRequest.getOutArrays().contains("times");
        boolean withDistances = ghRequest.getOutArrays().contains("distances");
        boolean withWeights = ghRequest.getOutArrays().contains("weights");
        MatrixResponse matrixResponse = new MatrixResponse(ghRequest.getPoints() == null ? ghRequest.getFromPoints().size() : ghRequest.getPoints().size(), ghRequest.getPoints() == null ? ghRequest.getToPoints().size() : ghRequest.getPoints().size(), withTimes, withDistances, withWeights);
        try {
            String postUrl = this.buildURLNoHints("", ghRequest);
            GHMatrixAbstractRequester.JsonResult jsonResult = this.postJson(postUrl, requestJson);
            JsonNode responseJson = this.fromStringToJSON(postUrl, jsonResult.body());
            matrixResponse.setHeaders(jsonResult.headers());
            matrixResponse.setStatusCode(jsonResult.statusCode());
            if (responseJson.has("message")) {
                matrixResponse.addErrors(ResponsePathDeserializerHelper.readErrors((ObjectMapper)this.objectMapper, (JsonNode)responseJson));
                return matrixResponse;
            }
            matrixResponse.addErrors(ResponsePathDeserializerHelper.readErrors((ObjectMapper)this.objectMapper, (JsonNode)responseJson));
            if (!matrixResponse.hasErrors()) {
                matrixResponse.addErrors(this.readUsableEntityError(ghRequest.getOutArrays(), responseJson));
            }
            if (!matrixResponse.hasErrors()) {
                this.fillResponseFromJson(matrixResponse, responseJson, ghRequest.getFailFast());
            }
            return matrixResponse;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

