/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.graphhopper.api.Version;
import com.graphhopper.api.model.GHGeocodingRequest;
import com.graphhopper.api.model.GHGeocodingResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class GraphHopperGeocoding {
    private final ObjectMapper objectMapper;
    private OkHttpClient downloader;
    private String routeServiceUrl;
    private String key = "";
    private final long DEFAULT_TIMEOUT = 5000L;

    public GraphHopperGeocoding() {
        this("https://graphhopper.com/api/1/geocode");
    }

    public GraphHopperGeocoding(String serviceUrl) {
        this.routeServiceUrl = serviceUrl;
        this.downloader = new OkHttpClient.Builder().connectTimeout(5000L, TimeUnit.MILLISECONDS).readTimeout(5000L, TimeUnit.MILLISECONDS).build();
        this.objectMapper = new ObjectMapper();
    }

    public GHGeocodingResponse geocode(GHGeocodingRequest request) {
        String url = this.buildUrl(request);
        try {
            Request okRequest = new Request.Builder().url(url).header("X-GH-Client-Version", Version.GH_VERSION_FROM_MAVEN).build();
            Response rsp = this.getClientForRequest(request).newCall(okRequest).execute();
            ResponseBody rspBody = rsp.body();
            if (!rsp.isSuccessful()) {
                throw new RuntimeException(rspBody.string());
            }
            GHGeocodingResponse geoRsp = (GHGeocodingResponse)this.objectMapper.readValue(rspBody.bytes(), GHGeocodingResponse.class);
            return geoRsp;
        }
        catch (IOException ex) {
            throw new RuntimeException("IO problem for geocoding URL " + url + ": " + ex.getMessage(), ex);
        }
    }

    public GraphHopperGeocoding setDownloader(OkHttpClient downloader) {
        this.downloader = downloader;
        return this;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public OkHttpClient getDownloader() {
        return this.downloader;
    }

    private OkHttpClient getClientForRequest(GHGeocodingRequest request) {
        OkHttpClient client = this.downloader;
        if (request.hasTimeout()) {
            long timeout = request.getTimeout();
            client = client.newBuilder().connectTimeout(timeout, TimeUnit.MILLISECONDS).readTimeout(timeout, TimeUnit.MILLISECONDS).build();
        }
        return client;
    }

    private String buildUrl(GHGeocodingRequest request) {
        String url = this.routeServiceUrl + "?";
        if (request.isReverse()) {
            if (!request.getPoint().isValid()) {
                throw new IllegalArgumentException("For reverse geocoding you have to pass valid lat and long values");
            }
            url = url + "reverse=true";
        } else {
            if (request.getQuery() == null) {
                throw new IllegalArgumentException("For forward geocoding you have to a string for the query");
            }
            url = url + "reverse=false";
            url = url + "&q=" + GraphHopperGeocoding.encodeURL(request.getQuery());
        }
        if (request.getPoint().isValid()) {
            url = url + "&point=" + request.getPoint().getLat() + "," + request.getPoint().getLon();
        }
        url = url + "&limit=" + request.getLimit();
        url = url + "&locale=" + GraphHopperGeocoding.encodeURL(request.getLocale());
        url = url + "&provider=" + GraphHopperGeocoding.encodeURL(request.getProvider());
        if (!this.key.isEmpty()) {
            url = url + "&key=" + GraphHopperGeocoding.encodeURL(this.key);
        }
        return url;
    }

    private static String encodeURL(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

