/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.ResponsePath;
import com.graphhopper.api.GraphHopperMatrixWeb;
import com.graphhopper.api.GzipRequestInterceptor;
import com.graphhopper.api.Version;
import com.graphhopper.jackson.Jackson;
import com.graphhopper.jackson.ResponsePathDeserializerHelper;
import com.graphhopper.util.Helper;
import com.graphhopper.util.shapes.GHPoint;
import java.io.Closeable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class GraphHopperWeb {
    public static final String X_GH_CLIENT_VERSION = "X-GH-Client-Version";
    private final ObjectMapper objectMapper;
    private final String routeServiceUrl;
    private OkHttpClient downloader;
    private String key = "";
    private boolean instructions = true;
    private boolean calcPoints = true;
    private boolean elevation = false;
    private String optimize = "false";
    private boolean postRequest = true;
    private int maxUnzippedLength = 1000;
    private final Set<String> ignoreSetForGet;
    private final Set<String> ignoreSetForPost;
    public static final String TIMEOUT = "timeout";
    private final long DEFAULT_TIMEOUT = 5000L;

    public GraphHopperWeb() {
        this("https://graphhopper.com/api/1/route");
    }

    public GraphHopperWeb(String serviceUrl) {
        this.routeServiceUrl = serviceUrl;
        this.downloader = new OkHttpClient.Builder().connectTimeout(5000L, TimeUnit.MILLISECONDS).readTimeout(5000L, TimeUnit.MILLISECONDS).addInterceptor((Interceptor)new GzipRequestInterceptor()).build();
        this.ignoreSetForPost = new HashSet<String>();
        this.ignoreSetForPost.add("key");
        this.ignoreSetForPost.add("service_url");
        this.ignoreSetForPost.add("calc_points");
        this.ignoreSetForPost.add("instructions");
        this.ignoreSetForPost.add("elevation");
        this.ignoreSetForPost.add("optimize");
        this.ignoreSetForPost.add("points_encoded");
        this.ignoreSetForPost.add("points_encoded_multiplier");
        this.ignoreSetForGet = new HashSet<String>();
        this.ignoreSetForGet.add("key");
        this.ignoreSetForGet.add("calc_points");
        this.ignoreSetForGet.add("calcpoints");
        this.ignoreSetForGet.add("instructions");
        this.ignoreSetForGet.add("elevation");
        this.ignoreSetForGet.add("optimize");
        this.ignoreSetForGet.add("algorithm");
        this.ignoreSetForGet.add("locale");
        this.ignoreSetForGet.add("point");
        this.ignoreSetForGet.add("points_encoded");
        this.ignoreSetForGet.add("pointsencoded");
        this.ignoreSetForGet.add("points_encoded_multiplier");
        this.ignoreSetForGet.add("type");
        this.objectMapper = Jackson.newObjectMapper();
    }

    public GraphHopperWeb setMaxUnzippedLength(int maxUnzippedLength) {
        this.maxUnzippedLength = maxUnzippedLength;
        return this;
    }

    public GraphHopperWeb setDownloader(OkHttpClient downloader) {
        this.downloader = downloader;
        return this;
    }

    public OkHttpClient getDownloader() {
        return this.downloader;
    }

    public GraphHopperWeb setKey(String key) {
        Objects.requireNonNull(key, "Key must not be null");
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Key must not be empty");
        }
        this.key = key;
        return this;
    }

    public GraphHopperWeb setPostRequest(boolean postRequest) {
        this.postRequest = postRequest;
        return this;
    }

    public GraphHopperWeb setCalcPoints(boolean calcPoints) {
        this.calcPoints = calcPoints;
        return this;
    }

    public GraphHopperWeb setInstructions(boolean b) {
        this.instructions = b;
        return this;
    }

    public GraphHopperWeb setElevation(boolean withElevation) {
        this.elevation = withElevation;
        return this;
    }

    public GraphHopperWeb setOptimize(String optimize) {
        this.optimize = optimize;
        return this;
    }

    public GHResponse route(GHRequest ghRequest) {
        GHResponse gHResponse;
        GHResponse res;
        JsonNode json;
        Response rsp;
        boolean tmpTurnDescription;
        boolean tmpElevation;
        ResponseBody rspBody;
        block7: {
            rspBody = null;
            tmpElevation = ghRequest.getHints().getBool("elevation", this.elevation);
            tmpTurnDescription = ghRequest.getHints().getBool("turn_description", true);
            ghRequest.getHints().remove("turn_description");
            Request okRequest = this.postRequest ? this.createPostRequest(ghRequest) : this.createGetRequest(ghRequest);
            rsp = this.getClientForRequest(ghRequest).newCall(okRequest).execute();
            rspBody = rsp.body();
            json = this.objectMapper.reader().readTree(rspBody.byteStream());
            res = new GHResponse();
            res.addErrors(ResponsePathDeserializerHelper.readErrors((ObjectMapper)this.objectMapper, (JsonNode)json));
            if (!res.hasErrors()) break block7;
            GHResponse gHResponse2 = res;
            Helper.close((Closeable)rspBody);
            return gHResponse2;
        }
        try {
            JsonNode paths = json.get("paths");
            for (JsonNode path : paths) {
                ResponsePath altRsp = ResponsePathDeserializerHelper.createResponsePath((ObjectMapper)this.objectMapper, (JsonNode)path, (boolean)tmpElevation, (boolean)tmpTurnDescription);
                res.add(altRsp);
            }
            for (Map.Entry entry : rsp.headers().toMultimap().entrySet()) {
                res.getHints().putObject((String)entry.getKey(), entry.getValue());
            }
            JsonNode b = json.get("hints");
            b.fields().forEachRemaining(f -> res.getHints().putObject((String)f.getKey(), Helper.toObject((String)((JsonNode)f.getValue()).asText())));
            gHResponse = res;
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Problem while fetching path " + String.valueOf(ghRequest.getPoints()) + ": " + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                Helper.close(rspBody);
                throw throwable;
            }
        }
        Helper.close((Closeable)rspBody);
        return gHResponse;
    }

    OkHttpClient getClientForRequest(GHRequest request) {
        OkHttpClient client = this.downloader;
        if (request.getHints().has(TIMEOUT)) {
            long timeout = request.getHints().getLong(TIMEOUT, 5000L);
            client = client.newBuilder().connectTimeout(timeout, TimeUnit.MILLISECONDS).readTimeout(timeout, TimeUnit.MILLISECONDS).build();
        }
        return client;
    }

    Request createPostRequest(GHRequest ghRequest) {
        String body;
        String tmpServiceURL = ghRequest.getHints().getString("service_url", this.routeServiceUrl);
        String url = tmpServiceURL + "?";
        if (!Helper.isEmpty((String)this.key)) {
            url = url + "key=" + GraphHopperWeb.encodeURL(this.key);
        }
        ObjectNode requestJson = this.requestToJson(ghRequest);
        try {
            body = this.objectMapper.writeValueAsString((Object)requestJson);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Could not write request body", e);
        }
        Request.Builder builder = new Request.Builder().url(url).post(RequestBody.create((MediaType)GraphHopperMatrixWeb.MT_JSON, (String)body));
        builder.header(X_GH_CLIENT_VERSION, Version.GH_VERSION_FROM_MAVEN);
        if (body.length() < this.maxUnzippedLength) {
            builder.header("Content-Encoding", "identity");
        }
        return builder.build();
    }

    ObjectNode requestToJson(GHRequest ghRequest) {
        ObjectNode requestJson = this.objectMapper.createObjectNode();
        requestJson.putArray("points").addAll(this.createPointList(ghRequest.getPoints()));
        if (!ghRequest.getPointHints().isEmpty()) {
            requestJson.putArray("point_hints").addAll(this.createStringList(ghRequest.getPointHints()));
        }
        if (!ghRequest.getHeadings().isEmpty()) {
            requestJson.putArray("headings").addAll(this.createDoubleList(ghRequest.getHeadings()));
        }
        if (!ghRequest.getCurbsides().isEmpty()) {
            requestJson.putArray("curbsides").addAll(this.createStringList(ghRequest.getCurbsides()));
        }
        if (ghRequest.hasSnapPreventions()) {
            requestJson.putArray("snap_preventions").addAll(this.createStringList(ghRequest.getSnapPreventions()));
        }
        if (!ghRequest.getPathDetails().isEmpty()) {
            requestJson.putArray("details").addAll(this.createStringList(ghRequest.getPathDetails()));
        }
        requestJson.put("locale", ghRequest.getLocale().toString());
        if (!ghRequest.getProfile().isEmpty()) {
            requestJson.put("profile", ghRequest.getProfile());
        }
        if (!ghRequest.getAlgorithm().isEmpty()) {
            requestJson.put("algorithm", ghRequest.getAlgorithm());
        }
        requestJson.put("points_encoded", true);
        requestJson.put("points_encoded_multiplier", 1000000.0);
        requestJson.put("instructions", ghRequest.getHints().getBool("instructions", this.instructions));
        requestJson.put("calc_points", ghRequest.getHints().getBool("calc_points", this.calcPoints));
        requestJson.put("elevation", ghRequest.getHints().getBool("elevation", this.elevation));
        requestJson.put("optimize", ghRequest.getHints().getString("optimize", this.optimize));
        if (ghRequest.getCustomModel() != null) {
            requestJson.putPOJO("custom_model", (Object)ghRequest.getCustomModel());
        }
        Map hintsMap = ghRequest.getHints().toMap();
        for (Map.Entry entry : hintsMap.entrySet()) {
            String hintKey = (String)entry.getKey();
            if (this.ignoreSetForPost.contains(hintKey)) continue;
            if (entry.getValue() instanceof String) {
                requestJson.put(hintKey, (String)entry.getValue());
                continue;
            }
            requestJson.putPOJO(hintKey, entry.getValue());
        }
        return requestJson;
    }

    Request createGetRequest(GHRequest ghRequest) {
        if (ghRequest.getCustomModel() != null) {
            throw new IllegalArgumentException("Custom models cannot be used for GET requests. Use setPostRequest(true)");
        }
        boolean tmpInstructions = ghRequest.getHints().getBool("instructions", this.instructions);
        boolean tmpCalcPoints = ghRequest.getHints().getBool("calc_points", this.calcPoints);
        String tmpOptimize = ghRequest.getHints().getString("optimize", this.optimize);
        if (tmpInstructions && !tmpCalcPoints) {
            throw new IllegalStateException("Cannot calculate instructions without points (only points without instructions). Use calc_points=false and instructions=false to disable point and instruction calculation");
        }
        boolean tmpElevation = ghRequest.getHints().getBool("elevation", this.elevation);
        Object places = "";
        for (GHPoint p : ghRequest.getPoints()) {
            places = (String)places + "&point=" + Helper.round6((double)p.lat) + "," + Helper.round6((double)p.lon);
        }
        String type = ghRequest.getHints().getString("type", "json");
        String url = this.routeServiceUrl + "?profile=" + ghRequest.getProfile() + (String)places + "&type=" + type + "&instructions=" + tmpInstructions + "&points_encoded=true&points_encoded_multiplier=1000000&calc_points=" + tmpCalcPoints + "&algorithm=" + ghRequest.getAlgorithm() + "&locale=" + ghRequest.getLocale().toString() + "&elevation=" + tmpElevation + "&optimize=" + tmpOptimize;
        for (String string : ghRequest.getPathDetails()) {
            url = url + "&details=" + GraphHopperWeb.encodeURL(string);
        }
        if (ghRequest.getPointHints().stream().anyMatch(h -> !h.isEmpty())) {
            for (String string : ghRequest.getPointHints()) {
                url = url + "&point_hint=" + GraphHopperWeb.encodeURL(string);
            }
        }
        if (ghRequest.getCurbsides().stream().anyMatch(c -> !c.isEmpty())) {
            for (String string : ghRequest.getCurbsides()) {
                url = url + "&curbside=" + GraphHopperWeb.encodeURL(string);
            }
        }
        if (ghRequest.getHeadings().stream().anyMatch(h -> !Double.isNaN(h))) {
            for (Double d : ghRequest.getHeadings()) {
                url = url + "&heading=" + d;
            }
        }
        if (ghRequest.hasSnapPreventions()) {
            if (ghRequest.getSnapPreventions().isEmpty()) {
                url = url + "&snap_prevention=";
            } else {
                for (String string : ghRequest.getSnapPreventions()) {
                    url = url + "&snap_prevention=" + GraphHopperWeb.encodeURL(string);
                }
            }
        }
        if (!this.key.isEmpty()) {
            url = url + "&key=" + GraphHopperWeb.encodeURL(this.key);
        }
        for (Map.Entry entry : ghRequest.getHints().toMap().entrySet()) {
            String urlKey = (String)entry.getKey();
            String urlValue = entry.getValue().toString();
            if (this.ignoreSetForGet.contains(Helper.toLowerCase((String)urlKey)) || urlValue == null || urlValue.isEmpty()) continue;
            url = url + "&" + GraphHopperWeb.encodeURL(urlKey) + "=" + GraphHopperWeb.encodeURL(urlValue);
        }
        return new Request.Builder().url(url).header(X_GH_CLIENT_VERSION, Version.GH_VERSION_FROM_MAVEN).build();
    }

    public String export(GHRequest ghRequest) {
        String string;
        String str = "Creating request failed";
        ResponseBody body = null;
        try {
            if (this.postRequest) {
                throw new IllegalArgumentException("GPX export only works for GET requests, make sure to use `setPostRequest(false)`");
            }
            Request okRequest = this.createGetRequest(ghRequest);
            body = this.getClientForRequest(ghRequest).newCall(okRequest).execute().body();
            string = str = body.string();
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Problem while fetching export " + String.valueOf(ghRequest.getPoints()) + ", error: " + ex.getMessage() + " response: " + str, ex);
            }
            catch (Throwable throwable) {
                Helper.close(body);
                throw throwable;
            }
        }
        Helper.close((Closeable)body);
        return string;
    }

    private ArrayNode createStringList(List<String> list) {
        ArrayNode outList = this.objectMapper.createArrayNode();
        for (String str : list) {
            outList.add(str);
        }
        return outList;
    }

    private ArrayNode createDoubleList(List<Double> list) {
        ArrayNode outList = this.objectMapper.createArrayNode();
        for (Double d : list) {
            outList.add(d);
        }
        return outList;
    }

    private ArrayNode createPointList(List<GHPoint> list) {
        ArrayNode outList = this.objectMapper.createArrayNode();
        for (GHPoint p : list) {
            ArrayNode entry = this.objectMapper.createArrayNode();
            entry.add(p.lon);
            entry.add(p.lat);
            outList.add((JsonNode)entry);
        }
        return outList;
    }

    private static String encodeURL(String str) {
        return URLEncoder.encode(str, StandardCharsets.UTF_8);
    }
}

