/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MatrixResponse {
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private String debugInfo = "";
    private final List<Throwable> errors = new ArrayList<Throwable>(4);
    private final List<PointPair> disconnectedPoints = new ArrayList<PointPair>(0);
    private final List<Integer> invalidFromPoints = new ArrayList<Integer>(0);
    private final List<Integer> invalidToPoints = new ArrayList<Integer>(0);
    private long[][] times = new long[0][];
    private int[][] distances = new int[0][];
    private double[][] weights = new double[0][];
    private final int fromCount;
    private final int toCount;
    private int statusCode;

    public MatrixResponse() {
        this(10, 10, true, true, true);
    }

    public MatrixResponse(int fromCap, int toCap, boolean withTimes, boolean withDistances, boolean withWeights) {
        if (fromCap <= 0 || toCap <= 0) {
            throw new IllegalArgumentException("Requested matrix too small: " + fromCap + "x" + toCap);
        }
        this.fromCount = fromCap;
        this.toCount = toCap;
        if (withTimes) {
            this.times = new long[fromCap][toCap];
        }
        if (withDistances) {
            this.distances = new int[fromCap][toCap];
        }
        if (withWeights) {
            this.weights = new double[fromCap][toCap];
        }
        if (!(withTimes || withDistances || withWeights)) {
            throw new IllegalArgumentException("Please specify times, distances or weights that should be calculated by the matrix");
        }
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getHeader(String key, String defaultValue) {
        List<String> res = this.headers.get(key);
        if (!res.isEmpty()) {
            return res.get(0);
        }
        return defaultValue;
    }

    public void setFromRow(int row, long[] timeRow, int[] distanceRow, double[] weightRow) {
        if (this.times.length > 0) {
            this.check(timeRow.length, this.toCount, "to times");
            this.times[row] = timeRow;
        }
        if (this.distances.length > 0) {
            this.check(distanceRow.length, this.toCount, "to distances");
            this.distances[row] = distanceRow;
        }
        if (this.weights.length > 0) {
            this.check(this.weights.length, this.toCount, "to weights");
            this.weights[row] = weightRow;
        }
    }

    private void check(int currentLength, int expectedLength, String times) {
        if (currentLength != expectedLength) {
            throw new IllegalArgumentException("Sizes do not match for '" + times + "'. Expected " + expectedLength + " was: " + currentLength + ". Matrix: " + this.fromCount + "x" + this.toCount);
        }
    }

    public void setTimeRow(int row, long[] timeRow) {
        if (this.times.length <= 0) {
            throw new UnsupportedOperationException("Cannot call setTimeRow if times are disabled");
        }
        this.check(timeRow.length, this.toCount, "to times");
        this.times[row] = timeRow;
    }

    public void setDistanceRow(int row, int[] distanceRow) {
        if (this.distances.length <= 0) {
            throw new UnsupportedOperationException("Cannot call setDistanceRow if distances are disabled");
        }
        this.check(distanceRow.length, this.toCount, "to distances");
        this.distances[row] = distanceRow;
    }

    public void setWeightRow(int row, double[] weightRow) {
        if (this.weights.length <= 0) {
            throw new UnsupportedOperationException("Cannot call setWeightRow if weights are disabled");
        }
        this.check(weightRow.length, this.toCount, "to weights");
        this.weights[row] = weightRow;
    }

    public boolean isConnected(int from, int to) {
        if (this.hasErrors()) {
            return false;
        }
        return this.getWeight(from, to) < Double.MAX_VALUE;
    }

    public long getTime(int from, int to) {
        if (this.hasErrors()) {
            throw new IllegalStateException("Cannot return time (" + from + "," + to + ") if errors occurred " + String.valueOf(this.getErrors()));
        }
        if (from >= this.times.length) {
            throw new IllegalStateException("Cannot get 'from' " + from + " from times with size " + this.times.length);
        }
        if (to >= this.times[from].length) {
            throw new IllegalStateException("Cannot get 'to' " + to + " from times with size " + this.times[from].length);
        }
        return this.times[from][to];
    }

    public double getDistance(int from, int to) {
        if (this.hasErrors()) {
            throw new IllegalStateException("Cannot return distance (" + from + "," + to + ") if errors occurred " + String.valueOf(this.getErrors()));
        }
        if (from >= this.distances.length) {
            throw new IllegalStateException("Cannot get 'from' " + from + " from distances with size " + this.distances.length);
        }
        if (to >= this.distances[from].length) {
            throw new IllegalStateException("Cannot get 'to' " + to + " from distances with size " + this.distances[from].length);
        }
        return this.distances[from][to] == Integer.MAX_VALUE ? Double.MAX_VALUE : (double)this.distances[from][to];
    }

    public double getWeight(int from, int to) {
        if (this.hasErrors()) {
            throw new IllegalStateException("Cannot return weight (" + from + "," + to + ") if errors occurred " + String.valueOf(this.getErrors()));
        }
        if (from >= this.weights.length) {
            throw new IllegalStateException("Cannot get 'from' " + from + " from weights with size " + this.weights.length);
        }
        if (to >= this.weights[from].length) {
            throw new IllegalStateException("Cannot get 'to' " + to + " from weights with size " + this.weights[from].length);
        }
        return this.weights[from][to];
    }

    public String getDebugInfo() {
        return this.debugInfo;
    }

    public MatrixResponse setDebugInfo(String debugInfo) {
        if (debugInfo != null) {
            this.debugInfo = debugInfo;
        }
        return this;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }

    public MatrixResponse addError(Throwable error) {
        this.errors.add(error);
        return this;
    }

    public MatrixResponse addErrors(Collection<Throwable> errorList) {
        this.errors.addAll(errorList);
        return this;
    }

    public boolean hasProblems() {
        return !this.disconnectedPoints.isEmpty() || !this.invalidFromPoints.isEmpty() || !this.invalidToPoints.isEmpty();
    }

    public MatrixResponse setDisconnectedPoints(List<PointPair> disconnectedPoints) {
        this.disconnectedPoints.clear();
        this.disconnectedPoints.addAll(disconnectedPoints);
        return this;
    }

    public List<PointPair> getDisconnectedPoints() {
        return this.disconnectedPoints;
    }

    public MatrixResponse setInvalidFromPoints(List<Integer> invalidFromPoints) {
        this.invalidFromPoints.clear();
        this.invalidFromPoints.addAll(invalidFromPoints);
        return this;
    }

    public MatrixResponse setInvalidToPoints(List<Integer> invalidToPoints) {
        this.invalidToPoints.clear();
        this.invalidToPoints.addAll(invalidToPoints);
        return this;
    }

    public List<Integer> getInvalidFromPoints() {
        return this.invalidFromPoints;
    }

    public List<Integer> getInvalidToPoints() {
        return this.invalidToPoints;
    }

    public String toString() {
        Object addInfo = "";
        if (this.times.length > 0) {
            addInfo = (String)addInfo + ", times: " + this.times.length + "x" + this.times[0].length;
        }
        if (this.distances.length > 0) {
            addInfo = (String)addInfo + ", distances: " + this.distances.length + "x" + this.distances[0].length;
        }
        String result = "[" + (String)addInfo + "] errors:" + this.errors.toString();
        if (!this.disconnectedPoints.isEmpty()) {
            result = result + ", disconnectedPoints: " + this.disconnectedPoints.size();
        }
        if (!this.invalidFromPoints.isEmpty()) {
            result = result + ", invalidFromPoints: " + this.invalidFromPoints.size();
        }
        if (!this.invalidToPoints.isEmpty()) {
            result = result + ", invalidToPoints: " + this.invalidToPoints.size();
        }
        return result;
    }

    public static class PointPair {
        public final int sourceIndex;
        public final int targetIndex;

        public PointPair(int sourceIndex, int targetIndex) {
            this.sourceIndex = sourceIndex;
            this.targetIndex = targetIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PointPair pointPair = (PointPair)o;
            return this.sourceIndex == pointPair.sourceIndex && this.targetIndex == pointPair.targetIndex;
        }

        public int hashCode() {
            return Objects.hash(this.sourceIndex, this.targetIndex);
        }

        public String toString() {
            return "[" + this.sourceIndex + ", " + this.targetIndex + "]";
        }
    }
}

