/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.locationtech.jts.geom.Envelope;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GHGeocodingEntry {
    private Long osmId;
    private String osmType;
    private Point point;
    private String name;
    private String country;
    private String city;
    private String state;
    private String street;
    private String houseNumber;
    private String postcode;
    private String osmKey;
    private String osmValue;
    private Envelope extent;

    public GHGeocodingEntry(Long osmId, String type, double lat, double lng, String name, String osmKey, String osmValue, String country, String city, String state, String street, String houseNumber, String postcode, Envelope extent) {
        this.osmId = osmId;
        this.osmType = type;
        this.point = new Point(lat, lng);
        this.name = name;
        this.country = country;
        this.city = city;
        this.state = state;
        this.street = street;
        this.houseNumber = houseNumber;
        this.postcode = postcode;
        this.osmKey = osmKey;
        this.osmValue = osmValue;
        this.extent = extent;
    }

    public GHGeocodingEntry() {
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty
    public String getCountry() {
        return this.country;
    }

    @JsonProperty
    public void setCountry(String country) {
        this.country = country;
    }

    @JsonProperty
    public void setState(String state) {
        this.state = state;
    }

    @JsonProperty
    public String getState() {
        return this.state;
    }

    @JsonProperty
    public String getCity() {
        return this.city;
    }

    @JsonProperty
    public void setCity(String city) {
        this.city = city;
    }

    @JsonProperty
    public Point getPoint() {
        return this.point;
    }

    @JsonProperty
    public void setPoint(Point point) {
        this.point = point;
    }

    @JsonProperty(value="osm_id")
    public Long getOsmId() {
        return this.osmId;
    }

    @JsonProperty(value="osm_id")
    public void setOsmId(Long osmId) {
        this.osmId = osmId;
    }

    @JsonProperty(value="osm_type")
    public String getOsmType() {
        return this.osmType;
    }

    @JsonProperty(value="osm_type")
    public void setOsmType(String type) {
        this.osmType = type;
    }

    @JsonProperty
    public String getStreet() {
        return this.street;
    }

    @JsonProperty
    public void setStreet(String street) {
        this.street = street;
    }

    @JsonProperty(value="housenumber")
    public String getHouseNumber() {
        return this.houseNumber;
    }

    @JsonProperty(value="housenumber")
    public void setHouseNumber(String houseNumber) {
        this.houseNumber = houseNumber;
    }

    @JsonProperty
    public String getPostcode() {
        return this.postcode;
    }

    @JsonProperty
    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    @JsonProperty(value="osm_key")
    public String getOsmKey() {
        return this.osmKey;
    }

    @JsonProperty(value="osm_key")
    public void setOsmKey(String osmKey) {
        this.osmKey = osmKey;
    }

    @JsonProperty(value="osm_value")
    public String getOsmValue() {
        return this.osmValue;
    }

    @JsonProperty(value="osm_value")
    public void setOsmValue(String osmValue) {
        this.osmValue = osmValue;
    }

    public Envelope getExtent() {
        return this.extent;
    }

    @JsonProperty
    public void setExtent(Double[] extent) {
        if (extent == null) {
            this.extent = null;
        } else if (extent.length == 4) {
            this.extent = new Envelope(extent[0].doubleValue(), extent[2].doubleValue(), extent[3].doubleValue(), extent[1].doubleValue());
        } else {
            throw new RuntimeException("Extent had an unexpected length: " + extent.length);
        }
    }

    public class Point {
        private double lat;
        private double lng;

        public Point(double lat, double lng) {
            this.lat = lat;
            this.lng = lng;
        }

        public Point() {
        }

        @JsonProperty
        public double getLat() {
            return this.lat;
        }

        @JsonProperty
        public void setLat(double lat) {
            this.lat = lat;
        }

        @JsonProperty
        public double getLng() {
            return this.lng;
        }

        @JsonProperty
        public void setLng(double lng) {
            this.lng = lng;
        }
    }
}

