/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.api.model;

import com.graphhopper.util.shapes.GHPoint;

public class GHGeocodingRequest {
    private final boolean reverse;
    private final GHPoint point;
    private final String query;
    private final String locale;
    private final int limit;
    private final String provider;
    private final long timeout;

    public GHGeocodingRequest(double lat, double lon, String locale, int limit) {
        this(true, new GHPoint(lat, lon), null, locale, limit, "default", -1L);
    }

    public GHGeocodingRequest(GHPoint point, String locale, int limit) {
        this(true, point, null, locale, limit, "default", -1L);
    }

    public GHGeocodingRequest(String query, String locale, int limit) {
        this(false, null, query, locale, limit, "default", -1L);
    }

    public GHGeocodingRequest(boolean reverse, GHPoint point, String query, String locale, int limit, String provider, long timeout) {
        this.reverse = reverse;
        this.point = point == null ? new GHPoint() : point;
        this.query = query;
        this.locale = locale;
        this.limit = limit;
        this.provider = provider;
        this.timeout = timeout;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public GHPoint getPoint() {
        return this.point;
    }

    public String getQuery() {
        return this.query;
    }

    public String getLocale() {
        return this.locale;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getProvider() {
        return this.provider;
    }

    public boolean hasTimeout() {
        return this.timeout > 0L;
    }

    public long getTimeout() {
        return this.timeout;
    }
}

