/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.graphhopper.GraphHopper;
import com.graphhopper.config.CHProfile;
import com.graphhopper.config.LMProfile;
import com.graphhopper.config.Profile;
import com.graphhopper.jackson.Jackson;
import com.graphhopper.routing.TestProfiles;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GraphHopperProfileTest {
    private static final String GH_LOCATION = "target/gh-profile-config-gh";

    @Test
    public void deserialize() throws IOException {
        ObjectMapper objectMapper = Jackson.newObjectMapper();
        String json = "{\"name\":\"my_car\",\"weighting\":\"custom\",\"turn_costs\":{\"vehicle_types\":[\"motorcar\"]},\"foo\":\"bar\",\"baz\":\"buzz\"}";
        Profile profile = (Profile)objectMapper.readValue(json, Profile.class);
        Assertions.assertEquals((Object)"my_car", (Object)profile.getName());
        Assertions.assertEquals(List.of("motorcar"), (Object)profile.getTurnCostsConfig().getVehicleTypes());
        Assertions.assertEquals((Object)"custom", (Object)profile.getWeighting());
        Assertions.assertTrue((boolean)profile.hasTurnCosts());
        Assertions.assertEquals((int)2, (int)profile.getHints().toMap().size());
        Assertions.assertEquals((Object)"bar", (Object)profile.getHints().getString("foo", ""));
        Assertions.assertEquals((Object)"buzz", (Object)profile.getHints().getString("baz", ""));
    }

    @Test
    public void duplicateProfileName_error() {
        GraphHopper hopper = this.createHopper();
        GraphHopperProfileTest.assertIllegalArgument(() -> hopper.setProfiles(new Profile[]{new Profile("my_profile"), new Profile("your_profile"), new Profile("my_profile")}), "Profile names must be unique. Duplicate name: 'my_profile'");
    }

    @Test
    public void profileWithUnknownWeighting_error() {
        GraphHopper hopper = this.createHopper();
        hopper.setProfiles(new Profile[]{new Profile("profile").setWeighting("your_weighting")});
        GraphHopperProfileTest.assertIllegalArgument(() -> ((GraphHopper)hopper).importOrLoad(), "Could not create weighting for profile: 'profile'", "Weighting 'your_weighting' not supported");
    }

    @Test
    public void chProfileDoesNotExist_error() {
        GraphHopper hopper = this.createHopper();
        hopper.setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"profile1")});
        hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("other_profile")});
        GraphHopperProfileTest.assertIllegalArgument(() -> ((GraphHopper)hopper).importOrLoad(), "CH profile references unknown profile 'other_profile'");
    }

    @Test
    public void duplicateCHProfile_error() {
        GraphHopper hopper = this.createHopper();
        hopper.setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"profile")});
        hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("profile"), new CHProfile("profile")});
        GraphHopperProfileTest.assertIllegalArgument(() -> ((GraphHopper)hopper).importOrLoad(), "Duplicate CH reference to profile 'profile'");
    }

    @Test
    public void lmProfileDoesNotExist_error() {
        GraphHopper hopper = this.createHopper();
        hopper.setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"profile1")});
        hopper.getLMPreparationHandler().setLMProfiles(new LMProfile[]{new LMProfile("other_profile")});
        GraphHopperProfileTest.assertIllegalArgument(() -> ((GraphHopper)hopper).importOrLoad(), "LM profile references unknown profile 'other_profile'");
    }

    @Test
    public void duplicateLMProfile_error() {
        GraphHopper hopper = this.createHopper();
        hopper.setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"profile")});
        hopper.getLMPreparationHandler().setLMProfiles(new LMProfile[]{new LMProfile("profile"), new LMProfile("profile")});
        GraphHopperProfileTest.assertIllegalArgument(() -> ((GraphHopper)hopper).importOrLoad(), "Multiple LM profiles are using the same profile 'profile'");
    }

    @Test
    public void unknownLMPreparationProfile_error() {
        GraphHopper hopper = this.createHopper();
        hopper.setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"profile")});
        hopper.getLMPreparationHandler().setLMProfiles(new LMProfile[]{new LMProfile("profile").setPreparationProfile("xyz")});
        GraphHopperProfileTest.assertIllegalArgument(() -> ((GraphHopper)hopper).importOrLoad(), "LM profile references unknown preparation profile 'xyz'");
    }

    @Test
    public void lmPreparationProfileChain_error() {
        GraphHopper hopper = this.createHopper();
        hopper.setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"profile1"), TestProfiles.constantSpeed((String)"profile2"), TestProfiles.constantSpeed((String)"profile3")});
        hopper.getLMPreparationHandler().setLMProfiles(new LMProfile[]{new LMProfile("profile1"), new LMProfile("profile2").setPreparationProfile("profile1"), new LMProfile("profile3").setPreparationProfile("profile2")});
        GraphHopperProfileTest.assertIllegalArgument(() -> ((GraphHopper)hopper).importOrLoad(), "Cannot use 'profile2' as preparation_profile for LM profile 'profile3', because it uses another profile for preparation itself.");
    }

    @Test
    public void noLMProfileForPreparationProfile_error() {
        GraphHopper hopper = this.createHopper();
        hopper.setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"profile1"), TestProfiles.constantSpeed((String)"profile2"), TestProfiles.constantSpeed((String)"profile3")});
        hopper.getLMPreparationHandler().setLMProfiles(new LMProfile[]{new LMProfile("profile1").setPreparationProfile("profile2")});
        GraphHopperProfileTest.assertIllegalArgument(() -> ((GraphHopper)hopper).importOrLoad(), "Unknown LM preparation profile 'profile2' in LM profile 'profile1' cannot be used as preparation_profile");
    }

    private GraphHopper createHopper() {
        GraphHopper hopper = new GraphHopper();
        hopper.setGraphHopperLocation(GH_LOCATION);
        hopper.setStoreOnFlush(false);
        return hopper;
    }

    private static void assertIllegalArgument(Runnable runnable, String ... messageParts) {
        try {
            runnable.run();
            Assertions.fail((String)("There should have been an error containing:\n\t" + String.valueOf(Arrays.asList(messageParts))));
        }
        catch (IllegalArgumentException e) {
            for (String messagePart : messageParts) {
                Assertions.assertTrue((boolean)e.getMessage().contains(messagePart), (String)("Unexpected error message:\n\t" + e.getMessage() + "\nExpected the message to contain:\n\t" + messagePart));
            }
        }
    }
}

