/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopper;
import com.graphhopper.ResponsePath;
import com.graphhopper.config.CHProfile;
import com.graphhopper.config.LMProfile;
import com.graphhopper.config.Profile;
import com.graphhopper.json.Statement;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.reader.dem.ElevationProvider;
import com.graphhopper.reader.dem.SRTMProvider;
import com.graphhopper.reader.dem.SkadiProvider;
import com.graphhopper.routing.TestProfiles;
import com.graphhopper.routing.ev.DefaultImportRegistry;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.ImportRegistry;
import com.graphhopper.routing.ev.ImportUnit;
import com.graphhopper.routing.ev.RoadEnvironment;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.DefaultSnapFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.countryrules.CountryRuleFactory;
import com.graphhopper.routing.util.parsers.OSMRoadEnvironmentParser;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.JsonFeature;
import com.graphhopper.util.PMap;
import com.graphhopper.util.PointList;
import com.graphhopper.util.RoundaboutInstruction;
import com.graphhopper.util.ShallowImmutablePointList;
import com.graphhopper.util.Translation;
import com.graphhopper.util.TurnCostsConfig;
import com.graphhopper.util.details.PathDetail;
import com.graphhopper.util.exceptions.ConnectionNotFoundException;
import com.graphhopper.util.exceptions.MaximumNodesExceededException;
import com.graphhopper.util.exceptions.PointDistanceExceededException;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;
import com.graphhopper.util.shapes.GHPoint3D;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class GraphHopperTest {
    public static final String DIR = "../core/files";
    private static final String BAYREUTH = "../core/files/north-bayreuth.osm.gz";
    private static final String BAUTZEN = "../core/files/bautzen.osm";
    private static final String BERLIN = "../core/files/berlin-siegessaeule.osm.gz";
    private static final String KREMS = "../core/files/krems.osm.gz";
    private static final String LAUF = "../core/files/Laufamholzstrasse.osm.xml";
    private static final String MONACO = "../core/files/monaco.osm.gz";
    private static final String MOSCOW = "../core/files/moscow.osm.gz";
    private static final String ESSEN = "../core/files/edge_based_subnetwork.osm.xml.gz";
    private static final String GH_LOCATION = "target/graphhopper-test-gh";

    @BeforeEach
    @AfterEach
    public void setup() {
        Helper.removeDir((File)new File(GH_LOCATION));
    }

    private void assertRoute(GHResponse response, double distance, int time, int points) {
        Assertions.assertFalse((boolean)response.hasErrors(), (String)response.getErrors().toString());
        ResponsePath res = response.getBest();
        Assertions.assertEquals((double)distance, (double)res.getDistance(), (double)0.1);
        Assertions.assertEquals((float)time, (float)res.getTime(), (float)10.0f);
        Assertions.assertEquals((int)points, (int)res.getPoints().size());
    }

    @ParameterizedTest
    @CsvSource(value={"dijkstra,false,703", "astar,false,361", "dijkstrabi,false,340", "astarbi,false,192", "dijkstrabi,true,45", "astarbi,true,43"})
    public void testMonacoDifferentAlgorithms(String algo, boolean withCH, int expectedVisitedNodes) {
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"profile", (String)"car")}).setStoreOnFlush(true);
        hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("profile")});
        hopper.setMinNetworkSize(0);
        hopper.importOrLoad();
        GHRequest req = new GHRequest(43.727687, 7.418737, 43.74958, 7.436566).setAlgorithm(algo).setProfile("profile");
        req.putHint("ch.disable", (Object)(!withCH ? 1 : 0));
        GHResponse rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Assertions.assertEquals((long)expectedVisitedNodes, (long)rsp.getHints().getLong("visited_nodes.sum", 0L));
        ResponsePath res = rsp.getBest();
        Assertions.assertEquals((double)3587.6, (double)res.getDistance(), (double)0.1);
        Assertions.assertEquals((float)274255.0f, (float)res.getTime(), (float)10.0f);
        Assertions.assertEquals((int)105, (int)res.getPoints().size());
        Assertions.assertEquals((double)43.7276852, (double)res.getWaypoints().getLat(0), (double)1.0E-7);
        Assertions.assertEquals((double)43.7495432, (double)res.getWaypoints().getLat(1), (double)1.0E-7);
        req.putHint("timeout_ms", (Object)-1);
        rsp = hopper.route(req);
        Assertions.assertTrue((boolean)rsp.hasErrors());
        Assertions.assertTrue((boolean)rsp.getErrors().toString().contains("ConnectionNotFoundException"), (String)rsp.getErrors().toString());
    }

    @Test
    public void testUTurnTimes() {
        Profile uTurnTimes = TestProfiles.accessAndSpeed((String)"uturn_times", (String)"car").setTurnCostsConfig(new TurnCostsConfig(List.of("motorcar", "motor_vehicle"), 60).setEnableUTurnTimes(true));
        Profile uTurnNoTimes = TestProfiles.accessAndSpeed((String)"uturn_notimes", (String)"car").setTurnCostsConfig(new TurnCostsConfig(List.of("motorcar", "motor_vehicle"), 60).setEnableUTurnTimes(false));
        Profile uTurnDefault = TestProfiles.accessAndSpeed((String)"uturn_default", (String)"car").setTurnCostsConfig(new TurnCostsConfig(List.of("motorcar", "motor_vehicle")));
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(KREMS).setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{uTurnTimes, uTurnNoTimes, uTurnDefault}).setStoreOnFlush(true);
        hopper.setMinNetworkSize(0);
        hopper.importOrLoad();
        GHRequest req = new GHRequest(48.40734, 15.6683, 48.407162, 15.668493).setAlgorithm("dijkstra").setProfile("uturn_times");
        req.putHint("ch.disable", (Object)true);
        GHResponse rsp = hopper.route(req);
        this.assertRoute(rsp, 706.7, 96664, 5);
        req.setProfile("uturn_notimes");
        rsp = hopper.route(req);
        this.assertRoute(rsp, 706.7, 36664, 5);
        req.setProfile("uturn_default");
        rsp = hopper.route(req);
        this.assertRoute(rsp, 2330.2, 107522, 56);
    }

    @Test
    public void testMonacoWithInstructions() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setEncodedValuesString("foot_access, foot_priority, foot_average_speed").setProfiles(new Profile[]{TestProfiles.accessSpeedAndPriority((String)"profile", (String)"foot")}).setStoreOnFlush(true).importOrLoad();
        GHResponse rsp = hopper.route(new GHRequest(43.727687, 7.418737, 43.74958, 7.436566).setAlgorithm("astar").setProfile("profile"));
        Assertions.assertEquals((long)1033L, (long)rsp.getHints().getLong("visited_nodes.sum", 0L));
        ResponsePath res = rsp.getBest();
        Assertions.assertEquals((double)3536.0, (double)res.getDistance(), (double)1.0);
        Assertions.assertEquals((int)131, (int)res.getPoints().size());
        Assertions.assertEquals((double)43.7276852, (double)res.getWaypoints().getLat(0), (double)1.0E-7);
        Assertions.assertEquals((double)43.7495432, (double)res.getWaypoints().getLat(1), (double)1.0E-7);
        InstructionList il = res.getInstructions();
        Assertions.assertEquals((int)31, (int)il.size());
        Translation tr = hopper.getTranslationMap().getWithFallBack(Locale.US);
        Assertions.assertEquals((Object)"continue onto Avenue des Guelfes", (Object)il.get(0).getTurnDescription(tr));
        Assertions.assertEquals((Object)"continue onto Avenue des Papalins", (Object)il.get(1).getTurnDescription(tr));
        Assertions.assertEquals((Object)"turn sharp right onto Quai Jean-Charles Rey", (Object)il.get(4).getTurnDescription(tr));
        Assertions.assertEquals((Object)"turn left", (Object)il.get(5).getTurnDescription(tr));
        Assertions.assertEquals((Object)"turn right onto Avenue Albert II", (Object)il.get(6).getTurnDescription(tr));
        Assertions.assertEquals((double)11.0, (double)il.get(0).getDistance(), (double)1.0);
        Assertions.assertEquals((double)96.0, (double)il.get(1).getDistance(), (double)1.0);
        Assertions.assertEquals((double)178.0, (double)il.get(2).getDistance(), (double)1.0);
        Assertions.assertEquals((double)13.0, (double)il.get(3).getDistance(), (double)1.0);
        Assertions.assertEquals((double)10.0, (double)il.get(4).getDistance(), (double)1.0);
        Assertions.assertEquals((double)42.0, (double)il.get(5).getDistance(), (double)1.0);
        Assertions.assertEquals((long)7L, (long)(il.get(0).getTime() / 1000L));
        Assertions.assertEquals((long)69L, (long)(il.get(1).getTime() / 1000L));
        Assertions.assertEquals((long)128L, (long)(il.get(2).getTime() / 1000L));
        Assertions.assertEquals((long)9L, (long)(il.get(3).getTime() / 1000L));
        Assertions.assertEquals((long)7L, (long)(il.get(4).getTime() / 1000L));
        Assertions.assertEquals((long)30L, (long)(il.get(5).getTime() / 1000L));
        Assertions.assertEquals((int)131, (int)res.getPoints().size());
    }

    @Test
    public void withoutInstructions() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setEncodedValuesString("foot_access, foot_priority, foot_average_speed").setProfiles(new Profile[]{TestProfiles.accessSpeedAndPriority((String)"profile", (String)"foot")}).setStoreOnFlush(true).importOrLoad();
        GHRequest request = new GHRequest().setAlgorithm("astar").setProfile("profile");
        request.addPoint(new GHPoint(43.729584, 7.410965));
        request.addPoint(new GHPoint(43.732499, 7.426758));
        request.getHints().putObject("instructions", (Object)true);
        hopper.getRouterConfig().setSimplifyResponse(false);
        GHResponse routeRsp = hopper.route(request);
        Assertions.assertEquals((int)8, (int)routeRsp.getBest().getInstructions().size());
        Assertions.assertEquals((int)50, (int)routeRsp.getBest().getPoints().size());
        hopper.getRouterConfig().setSimplifyResponse(true);
        routeRsp = hopper.route(request);
        Assertions.assertEquals((int)8, (int)routeRsp.getBest().getInstructions().size());
        Assertions.assertEquals((int)46, (int)routeRsp.getBest().getPoints().size());
        request.getHints().putObject("instructions", (Object)false);
        routeRsp = hopper.route(request);
        Assertions.assertEquals((int)46, (int)routeRsp.getBest().getPoints().size());
    }

    @Test
    public void testUTurnInstructions() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"profile", (String)"car").setTurnCostsConfig(new TurnCostsConfig(List.of("motorcar", "motor_vehicle"), 20))});
        hopper.importOrLoad();
        Translation tr = hopper.getTranslationMap().getWithFallBack(Locale.US);
        GHRequest request = new GHRequest();
        request.addPoint(new GHPoint(43.747418, 7.430371));
        request.addPoint(new GHPoint(43.746853, 7.42974));
        request.addPoint(new GHPoint(43.746929, 7.430458));
        request.setProfile("profile");
        request.setCurbsides(Arrays.asList("right", "any", "right"));
        GHResponse rsp = hopper.route(request);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        ResponsePath res = rsp.getBest();
        Assertions.assertEquals((double)286.0, (double)res.getDistance(), (double)1.0);
        Assertions.assertEquals((float)34358.0f, (float)res.getTime(), (float)1.0f);
        InstructionList il = res.getInstructions();
        Assertions.assertEquals((int)6, (int)il.size());
        Assertions.assertEquals((Object)"continue", (Object)il.get(0).getTurnDescription(tr));
        Assertions.assertEquals((Object)"waypoint 1", (Object)il.get(1).getTurnDescription(tr));
        Assertions.assertEquals((Object)"make a U-turn", (Object)il.get(2).getTurnDescription(tr));
        Assertions.assertEquals((Object)"turn sharp right", (Object)il.get(3).getTurnDescription(tr));
        Assertions.assertEquals((Object)"make a U-turn", (Object)il.get(4).getTurnDescription(tr));
        Assertions.assertEquals((Object)"arrive at destination", (Object)il.get(5).getTurnDescription(tr));
        request = new GHRequest();
        request.addPoint(new GHPoint(43.743887, 7.431151));
        request.addPoint(new GHPoint(43.744007, 7.431076));
        request.setHeadings(Arrays.asList(200.0));
        request.setProfile("profile");
        rsp = hopper.route(request);
        Assertions.assertFalse((boolean)rsp.hasErrors());
        res = rsp.getBest();
        il = res.getInstructions();
        Assertions.assertEquals((int)4, (int)il.size());
        Assertions.assertEquals((Object)"make a U-turn onto Avenue Princesse Grace", (Object)il.get(1).getTurnDescription(tr));
        Assertions.assertEquals((Object)"make a U-turn onto Avenue Princesse Grace", (Object)il.get(2).getTurnDescription(tr));
    }

    private void testImportCloseAndLoad(boolean ch, boolean lm) {
        long sum;
        ResponsePath bestPath;
        GHResponse rsp;
        GHRequest req;
        String profileName = "profile";
        GraphHopper hopper = new GraphHopper().setEncodedValuesString("foot_access, foot_priority, foot_average_speed").setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setStoreOnFlush(true);
        JsonFeature area51Feature = new JsonFeature();
        area51Feature.setId("area51");
        area51Feature.setGeometry((Geometry)new GeometryFactory().createPolygon(new Coordinate[]{new Coordinate(7.4174, 43.7345), new Coordinate(7.4198, 43.7355), new Coordinate(7.4207, 43.7344), new Coordinate(7.4174, 43.7345)}));
        Profile profile = TestProfiles.accessSpeedAndPriority((String)"profile", (String)"foot");
        CustomModel customModel = profile.getCustomModel();
        customModel.getPriority().add(Statement.If((String)"in_area51", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.1"));
        customModel.getAreas().getFeatures().add(area51Feature);
        hopper.setProfiles(new Profile[]{profile});
        if (ch) {
            hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("profile")});
        }
        if (lm) {
            hopper.getLMPreparationHandler().setLMProfiles(new LMProfile[]{new LMProfile("profile")});
        }
        hopper.importAndClose();
        hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setProfiles(new Profile[]{profile}).setStoreOnFlush(true).setAllowWrites(false);
        if (ch) {
            hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("profile")});
        }
        if (lm) {
            hopper.getLMPreparationHandler().setLMProfiles(new LMProfile[]{new LMProfile("profile")});
        }
        hopper.importOrLoad();
        if (ch) {
            req = new GHRequest(43.727687, 7.418737, 43.74958, 7.436566).setProfile("profile");
            req.putHint("ch.disable", (Object)false);
            req.putHint("lm.disable", (Object)true);
            rsp = hopper.route(req);
            bestPath = rsp.getBest();
            sum = rsp.getHints().getLong("visited_nodes.sum", 0L);
            Assertions.assertNotEquals((long)sum, (long)0L);
            Assertions.assertTrue((sum < 155L ? 1 : 0) != 0, (String)("Too many nodes visited " + sum));
            Assertions.assertEquals((double)3536.0, (double)bestPath.getDistance(), (double)1.0);
            Assertions.assertEquals((int)131, (int)bestPath.getPoints().size());
        }
        if (lm) {
            req = new GHRequest(43.727687, 7.418737, 43.74958, 7.436566).setProfile("profile").setAlgorithm("astarbi");
            req.putHint("ch.disable", (Object)true);
            req.putHint("lm.disable", (Object)false);
            rsp = hopper.route(req);
            bestPath = rsp.getBest();
            sum = rsp.getHints().getLong("visited_nodes.sum", 0L);
            Assertions.assertNotEquals((long)sum, (long)0L);
            Assertions.assertTrue((sum < 125L ? 1 : 0) != 0, (String)("Too many nodes visited " + sum));
            Assertions.assertEquals((double)3536.0, (double)bestPath.getDistance(), (double)1.0);
            Assertions.assertEquals((int)131, (int)bestPath.getPoints().size());
        }
        req = new GHRequest(43.727687, 7.418737, 43.74958, 7.436566).setProfile("profile");
        req.putHint("ch.disable", (Object)true);
        req.putHint("lm.disable", (Object)true);
        rsp = hopper.route(req);
        bestPath = rsp.getBest();
        sum = rsp.getHints().getLong("visited_nodes.sum", 0L);
        Assertions.assertNotEquals((long)sum, (long)0L);
        Assertions.assertTrue((sum > 120L ? 1 : 0) != 0, (String)("Too few nodes visited " + sum));
        Assertions.assertEquals((double)3536.0, (double)bestPath.getDistance(), (double)1.0);
        Assertions.assertEquals((int)131, (int)bestPath.getPoints().size());
        hopper.close();
    }

    @Test
    public void testImportThenLoadCH() {
        this.testImportCloseAndLoad(true, false);
    }

    @Test
    public void testImportThenLoadLM() {
        this.testImportCloseAndLoad(false, true);
    }

    @Test
    public void testImportThenLoadCHLM() {
        this.testImportCloseAndLoad(true, true);
    }

    @Test
    public void testImportThenLoadCHLMAndSort() {
        this.testImportCloseAndLoad(true, true);
    }

    @Test
    public void testImportThenLoadFlexible() {
        this.testImportCloseAndLoad(false, false);
    }

    @Test
    public void testAlternativeRoutes() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setEncodedValuesString("car_access, car_average_speed, foot_access, foot_priority, foot_average_speed").setProfiles(new Profile[]{TestProfiles.accessSpeedAndPriority((String)"profile", (String)"foot")}).setStoreOnFlush(true).importOrLoad();
        GHRequest req = new GHRequest(43.729057, 7.41251, 43.740298, 7.423561).setAlgorithm("alternative_route").setProfile("profile");
        GHResponse rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors());
        Assertions.assertEquals((int)2, (int)rsp.getAll().size());
        Assertions.assertEquals((long)1600L, (long)(((ResponsePath)rsp.getAll().get(0)).getTime() / 1000L));
        Assertions.assertEquals((long)1429L, (long)(((ResponsePath)rsp.getAll().get(1)).getTime() / 1000L));
        req.putHint("alternative_route.max_paths", (Object)3);
        req.putHint("alternative_route.min_plateau_factor", (Object)0.1);
        rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors());
        Assertions.assertEquals((int)3, (int)rsp.getAll().size());
        Assertions.assertEquals((long)1600L, (long)(((ResponsePath)rsp.getAll().get(0)).getTime() / 1000L));
        Assertions.assertEquals((long)1429L, (long)(((ResponsePath)rsp.getAll().get(1)).getTime() / 1000L));
        Assertions.assertEquals((long)1420L, (long)(((ResponsePath)rsp.getAll().get(2)).getTime() / 1000L));
    }

    @Test
    public void testAlternativeRoutesBike() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(BAYREUTH).setEncodedValuesString("car_access, car_average_speed, bike_access, bike_priority, bike_average_speed").setProfiles(new Profile[]{TestProfiles.accessSpeedAndPriority((String)"profile", (String)"bike")});
        hopper.importOrLoad();
        GHRequest req = new GHRequest(50.028917, 11.496506, 49.982089, 11.599224).setAlgorithm("alternative_route").setProfile("profile");
        req.putHint("alternative_route.max_paths", (Object)3);
        GHResponse rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Assertions.assertEquals((int)3, (int)rsp.getAll().size());
        Assertions.assertEquals((long)2636L, (long)(((ResponsePath)rsp.getAll().get(0)).getTime() / 1000L));
        Assertions.assertEquals((long)2783L, (long)(((ResponsePath)rsp.getAll().get(1)).getTime() / 1000L));
        Assertions.assertEquals((long)2985L, (long)(((ResponsePath)rsp.getAll().get(2)).getTime() / 1000L));
    }

    @Test
    public void testAlternativeRoutesCar() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(BAYREUTH).setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"profile", (String)"car")});
        hopper.importOrLoad();
        GHRequest req = new GHRequest(50.023513, 11.548862, 49.969441, 11.537876).setAlgorithm("alternative_route").setProfile("profile");
        req.putHint("alternative_route.max_paths", (Object)3);
        req.putHint("alternative_route.max_exploration_factor", (Object)1.2);
        GHResponse rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Assertions.assertEquals((int)3, (int)rsp.getAll().size());
        Assertions.assertEquals((long)855L, (long)(((ResponsePath)rsp.getAll().get(0)).getTime() / 1000L));
        Assertions.assertEquals((long)910L, (long)(((ResponsePath)rsp.getAll().get(1)).getTime() / 1000L));
        Assertions.assertEquals((long)955L, (long)(((ResponsePath)rsp.getAll().get(2)).getTime() / 1000L));
    }

    @Test
    public void testPointHint() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(LAUF).setEncodedValuesString("car_access,car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"profile", (String)"car")});
        hopper.importOrLoad();
        GHRequest req = new GHRequest(49.46553, 11.154669, 49.465244, 11.152577).setProfile("profile");
        req.setPointHints(new ArrayList<String>(Arrays.asList("Laufamholzstra\u00dfe, 90482, N\u00fcrnberg, Deutschland", "")));
        GHResponse rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        GHPoint3D snappedPoint = rsp.getBest().getWaypoints().get(0);
        Assertions.assertEquals((double)49.465686, (double)snappedPoint.getLat(), (double)1.0E-6);
        Assertions.assertEquals((double)11.154605, (double)snappedPoint.getLon(), (double)1.0E-6);
        req.setPointHints(new ArrayList<String>(Arrays.asList("", "")));
        rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        snappedPoint = rsp.getBest().getWaypoints().get(0);
        Assertions.assertEquals((double)49.465502, (double)snappedPoint.getLat(), (double)1.0E-6);
        Assertions.assertEquals((double)11.154498, (double)snappedPoint.getLon(), (double)1.0E-6);
        req.setPointHints(new ArrayList<String>(Arrays.asList("xy", "")));
        rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        snappedPoint = rsp.getBest().getWaypoints().get(0);
        Assertions.assertEquals((double)49.465502, (double)snappedPoint.getLat(), (double)1.0E-6);
        Assertions.assertEquals((double)11.154498, (double)snappedPoint.getLon(), (double)1.0E-6);
    }

    @Test
    public void testForwardBackwardDestination() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(BAUTZEN).setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"profile", (String)"car")});
        hopper.setMinNetworkSize(0);
        hopper.importOrLoad();
        Translation tr = hopper.getTranslationMap().getWithFallBack(Locale.US);
        GHResponse rsp = hopper.route(new GHRequest(51.1915, 14.416, 51.192, 14.412).setProfile("profile"));
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Assertions.assertEquals((Object)"keep right and take B 96 toward Bautzen-West, Hoyerswerda", (Object)rsp.getBest().getInstructions().get(1).getTurnDescription(tr));
        Assertions.assertEquals((Object)"Bautzen-West", rsp.getBest().getInstructions().get(1).getExtraInfoJSON().get("motorway_junction"));
        Assertions.assertEquals((Object)"turn left onto Hoyerswerdaer Stra\u00dfe and drive toward Hoyerswerda, Kleinwelka", (Object)rsp.getBest().getInstructions().get(2).getTurnDescription(tr));
        rsp = hopper.route(new GHRequest(51.191, 14.414, 51.1884, 14.41).setProfile("profile"));
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Assertions.assertEquals((Object)"turn left and take A 4 toward Dresden", (Object)rsp.getBest().getInstructions().get(1).getTurnDescription(tr));
    }

    @Test
    public void testNorthBayreuthAccessDestination() {
        String profile = "profile";
        Profile p = TestProfiles.accessAndSpeed((String)"profile", (String)"car");
        p.getCustomModel().addToPriority(Statement.If((String)"road_access == DESTINATION", (Statement.Op)Statement.Op.MULTIPLY, (String)".1"));
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(BAYREUTH).setEncodedValuesString("car_access, road_access, car_average_speed").setProfiles(new Profile[]{p});
        hopper.importOrLoad();
        GHRequest req = new GHRequest(49.985307, 11.50628, 49.985731, 11.507465).setProfile("profile");
        GHResponse rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Assertions.assertEquals((double)550.0, (double)rsp.getBest().getDistance(), (double)1.0);
    }

    @Test
    public void testNorthBayreuthBlockedEdges() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(BAYREUTH).setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"profile", (String)"car")});
        hopper.importOrLoad();
        GHRequest req = new GHRequest(49.985272, 11.506151, 49.986107, 11.507202).setProfile("profile");
        GHResponse rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Assertions.assertEquals((double)122.0, (double)rsp.getBest().getDistance(), (double)1.0);
        CustomModel customModel = new CustomModel().addToPriority(Statement.If((String)"in_blocked_area", (Statement.Op)Statement.Op.MULTIPLY, (String)"0"));
        customModel.getAreas().getFeatures().add(GHUtility.createCircle((String)"blocked_area", (double)49.985759, (double)11.50687, (double)5.0));
        req.setCustomModel(customModel);
        rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Assertions.assertEquals((double)365.0, (double)rsp.getBest().getDistance(), (double)1.0);
        req = new GHRequest(49.975845, 11.522598, 50.026821, 11.497364).setProfile("profile");
        rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Assertions.assertEquals((double)6685.0, (double)rsp.getBest().getDistance(), (double)1.0);
        customModel.getAreas().getFeatures().clear();
        customModel.getAreas().getFeatures().add(GHUtility.createRectangle((String)"blocked_area", (double)49.97986, (double)11.472902, (double)50.003946, (double)11.534357));
        req.setCustomModel(customModel);
        rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Assertions.assertEquals((double)13988.0, (double)rsp.getBest().getDistance(), (double)1.0);
        customModel.getAreas().getFeatures().add(GHUtility.createCircle((String)"blocked_point", (double)50.017578, (double)11.547527, (double)5.0));
        customModel.addToPriority(Statement.If((String)"in_blocked_point", (Statement.Op)Statement.Op.MULTIPLY, (String)"0"));
        rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Assertions.assertEquals((double)14601.0, (double)rsp.getBest().getDistance(), (double)1.0);
        customModel = new CustomModel().addToPriority(Statement.If((String)"in_blocked_area", (Statement.Op)Statement.Op.MULTIPLY, (String)"0"));
        customModel.getAreas().getFeatures().add(GHUtility.createCircle((String)"blocked_area", (double)49.979929, (double)11.520066, (double)200.0));
        req.setCustomModel(customModel);
        rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Assertions.assertEquals((double)12173.0, (double)rsp.getBest().getDistance(), (double)1.0);
        customModel.getAreas().getFeatures().clear();
        customModel.getAreas().getFeatures().add(GHUtility.createCircle((String)"blocked_area", (double)49.980868, (double)11.516397, (double)150.0));
        rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Assertions.assertEquals((double)12173.0, (double)rsp.getBest().getDistance(), (double)1.0);
        customModel.getAreas().getFeatures().clear();
        customModel.getAreas().getFeatures().add(GHUtility.createRectangle((String)"blocked_area", (double)49.981875, (double)11.515818, (double)49.979522, (double)11.521407));
        rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Assertions.assertEquals((double)12173.0, (double)rsp.getBest().getDistance(), (double)1.0);
        req = new GHRequest(50.009504, 11.490669, 50.024726, 11.496162).setProfile("profile");
        rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Assertions.assertEquals((double)1807.0, (double)rsp.getBest().getDistance(), (double)1.0);
        customModel.getAreas().getFeatures().clear();
        customModel.getAreas().getFeatures().add(GHUtility.createCircle((String)"blocked_area", (double)50.018277, (double)11.492336, (double)5.0));
        req.setCustomModel(customModel);
        rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Assertions.assertEquals((double)3363.0, (double)rsp.getBest().getDistance(), (double)1.0);
        req = new GHRequest(49.984465, 11.507009, 49.986107, 11.507202).setProfile("profile");
        rsp = hopper.route(req);
        Assertions.assertEquals((double)11.506, (double)rsp.getBest().getWaypoints().getLon(0), (double)0.001);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Assertions.assertEquals((double)155.0, (double)rsp.getBest().getDistance(), (double)10.0);
        customModel.getAreas().getFeatures().clear();
        customModel.getAreas().getFeatures().add(GHUtility.createRectangle((String)"blocked_area", (double)49.984434, (double)11.505212, (double)49.985394, (double)11.506333));
        req.setCustomModel(customModel);
        rsp = hopper.route(req);
        Assertions.assertEquals((double)11.506, (double)rsp.getBest().getWaypoints().getLon(0), (double)0.001);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Assertions.assertEquals((double)510.0, (double)rsp.getBest().getDistance(), (double)10.0);
        req = new GHRequest(49.979, 11.516, 49.986107, 11.507202).setProfile("profile");
        customModel.getAreas().getFeatures().clear();
        customModel.getAreas().getFeatures().add(GHUtility.createRectangle((String)"blocked_area", (double)49.981875, (double)11.515818, (double)49.979522, (double)11.521407));
        req.setCustomModel(customModel);
        rsp = hopper.route(req);
        Assertions.assertTrue((boolean)rsp.hasErrors(), (String)"expected errors");
        Assertions.assertEquals((int)1, (int)rsp.getErrors().size());
        Assertions.assertTrue((boolean)(rsp.getErrors().get(0) instanceof ConnectionNotFoundException));
    }

    @Test
    public void testCustomModel() {
        String customCar = "custom_car";
        String emptyCar = "empty_car";
        Profile p1 = TestProfiles.accessAndSpeed((String)"custom_car", (String)"car");
        p1.getCustomModel().addToSpeed(Statement.If((String)"road_class == TERTIARY || road_class == TRACK", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.1"));
        Profile p2 = TestProfiles.accessAndSpeed((String)"empty_car", (String)"car");
        GraphHopper hopper = new GraphHopper().setEncodedValuesString("car_average_speed,car_access,road_class").setGraphHopperLocation(GH_LOCATION).setOSMFile(BAYREUTH).setProfiles(new Profile[]{p1, p2}).importOrLoad();
        this.assertDistance(hopper, "empty_car", null, 8725.0);
        this.assertDistance(hopper, "custom_car", null, 13223.0);
        this.assertDistance(hopper, "empty_car", new CustomModel(p1.getCustomModel()), 13223.0);
        CustomModel strictCustomModel = new CustomModel().addToSpeed(Statement.If((String)"road_class == TERTIARY || road_class == TRACK || road_class == UNCLASSIFIED", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.1"));
        this.assertDistance(hopper, "empty_car", strictCustomModel, 19289.0);
        CustomModel customModelWithUnclassifiedRule = new CustomModel().addToSpeed(Statement.If((String)"road_class == UNCLASSIFIED", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.1"));
        this.assertDistance(hopper, "custom_car", customModelWithUnclassifiedRule, 19289.0);
        this.assertDistance(hopper, "custom_car", new CustomModel(customModelWithUnclassifiedRule).setDistanceInfluence(Double.valueOf(200.0)), 8725.0);
        this.assertDistance(hopper, "custom_car", new CustomModel(customModelWithUnclassifiedRule).setDistanceInfluence(Double.valueOf(100.0)), 14475.0);
    }

    private void assertDistance(GraphHopper hopper, String profile, CustomModel customModel, double expectedDistance) {
        GHRequest req = new GHRequest(50.008732, 11.596413, 49.974361, 11.514509);
        req.setProfile(profile);
        if (customModel != null) {
            req.setCustomModel(customModel);
        }
        GHResponse rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Assertions.assertEquals((double)expectedDistance, (double)rsp.getBest().getDistance(), (double)1.0);
    }

    @Test
    public void testMonacoVia() {
        String profile = "profile";
        Profile p = TestProfiles.accessSpeedAndPriority((String)"profile", (String)"foot");
        p.getCustomModel().setDistanceInfluence(Double.valueOf(10000.0));
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setEncodedValuesString("foot_access, foot_priority, foot_average_speed").setProfiles(new Profile[]{p}).setStoreOnFlush(true).importOrLoad();
        Translation tr = hopper.getTranslationMap().getWithFallBack(Locale.US);
        GHResponse rsp = hopper.route(new GHRequest().addPoint(new GHPoint(43.727687, 7.418737)).addPoint(new GHPoint(43.74958, 7.436566)).addPoint(new GHPoint(43.727687, 7.418737)).setAlgorithm("astar").setProfile("profile"));
        ResponsePath res = rsp.getBest();
        Assertions.assertEquals((double)6874.0, (double)res.getDistance(), (double)1.0);
        Assertions.assertEquals((int)197, (int)res.getPoints().size());
        InstructionList il = res.getInstructions();
        Assertions.assertEquals((int)30, (int)il.size());
        Assertions.assertEquals((Object)"continue onto Avenue des Guelfes", (Object)il.get(0).getTurnDescription(tr));
        Assertions.assertEquals((Object)"continue onto Avenue des Papalins", (Object)il.get(1).getTurnDescription(tr));
        Assertions.assertEquals((Object)"turn sharp right onto Quai Jean-Charles Rey", (Object)il.get(4).getTurnDescription(tr));
        Assertions.assertEquals((Object)"turn left", (Object)il.get(5).getTurnDescription(tr));
        Assertions.assertEquals((Object)"turn right onto Avenue Albert II", (Object)il.get(6).getTurnDescription(tr));
        Assertions.assertEquals((Object)"waypoint 1", (Object)il.get(15).getTurnDescription(tr));
        Assertions.assertEquals((int)-98, (int)il.get(16).getSign());
        Assertions.assertEquals((Object)"continue onto Avenue Albert II", (Object)il.get(23).getTurnDescription(tr));
        Assertions.assertEquals((Object)"turn left", (Object)il.get(24).getTurnDescription(tr));
        Assertions.assertEquals((Object)"turn right onto Quai Jean-Charles Rey", (Object)il.get(25).getTurnDescription(tr));
        Assertions.assertEquals((Object)"turn sharp left onto Avenue des Papalins", (Object)il.get(26).getTurnDescription(tr));
        Assertions.assertEquals((Object)"continue onto Avenue des Guelfes", (Object)il.get(28).getTurnDescription(tr));
        Assertions.assertEquals((Object)"arrive at destination", (Object)il.get(29).getTurnDescription(tr));
        Assertions.assertEquals((double)11.0, (double)il.get(0).getDistance(), (double)1.0);
        Assertions.assertEquals((double)97.0, (double)il.get(1).getDistance(), (double)1.0);
        Assertions.assertEquals((double)178.0, (double)il.get(2).getDistance(), (double)1.0);
        Assertions.assertEquals((double)13.0, (double)il.get(3).getDistance(), (double)1.0);
        Assertions.assertEquals((double)10.0, (double)il.get(4).getDistance(), (double)1.0);
        Assertions.assertEquals((double)42.0, (double)il.get(5).getDistance(), (double)1.0);
        Assertions.assertEquals((long)7L, (long)(il.get(0).getTime() / 1000L));
        Assertions.assertEquals((long)69L, (long)(il.get(1).getTime() / 1000L));
        Assertions.assertEquals((long)128L, (long)(il.get(2).getTime() / 1000L));
        Assertions.assertEquals((long)9L, (long)(il.get(3).getTime() / 1000L));
        Assertions.assertEquals((long)7L, (long)(il.get(4).getTime() / 1000L));
        Assertions.assertEquals((long)30L, (long)(il.get(5).getTime() / 1000L));
        rsp = hopper.route(new GHRequest().addPoint(new GHPoint(43.727687, 7.418737)).addPoint(new GHPoint(43.727687, 7.418737)).setAlgorithm("astar").setProfile("profile"));
        res = rsp.getBest();
        Assertions.assertEquals((double)0.0, (double)res.getDistance(), (double)0.1);
        Assertions.assertEquals((double)0.0, (double)res.getRouteWeight(), (double)0.1);
        Assertions.assertEquals((int)1, (int)res.getPoints().size());
        Assertions.assertEquals((int)1, (int)res.getInstructions().size());
        Assertions.assertEquals((Object)"arrive at destination", (Object)res.getInstructions().get(0).getTurnDescription(tr));
        Assertions.assertEquals((int)4, (int)res.getInstructions().get(0).getSign());
        rsp = hopper.route(new GHRequest().setPoints(Arrays.asList(new GHPoint(43.727687, 7.418737), new GHPoint(43.727687, 7.418737), new GHPoint(43.727687, 7.418737))).setAlgorithm("astar").setProfile("profile"));
        res = rsp.getBest();
        Assertions.assertEquals((double)0.0, (double)res.getDistance(), (double)0.1);
        Assertions.assertEquals((double)0.0, (double)res.getRouteWeight(), (double)0.1);
        Assertions.assertEquals((int)1, (int)res.getPoints().size());
        Assertions.assertEquals((int)2, (int)res.getInstructions().size());
        Assertions.assertEquals((int)5, (int)res.getInstructions().get(0).getSign());
        Assertions.assertEquals((int)4, (int)res.getInstructions().get(1).getSign());
    }

    @Test
    public void testMonacoPathDetails() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setEncodedValuesString("foot_access, foot_priority, foot_average_speed").setProfiles(new Profile[]{TestProfiles.accessSpeedAndPriority((String)"profile", (String)"foot")}).setStoreOnFlush(true).importOrLoad();
        GHRequest request = new GHRequest();
        request.addPoint(new GHPoint(43.727687, 7.418737));
        request.addPoint(new GHPoint(43.74958, 7.436566));
        request.addPoint(new GHPoint(43.727687, 7.418737));
        request.setAlgorithm("astar").setProfile("profile");
        request.setPathDetails(Collections.singletonList("average_speed"));
        GHResponse rsp = hopper.route(request);
        ResponsePath res = rsp.getBest();
        Map details = res.getPathDetails();
        Assertions.assertEquals((int)1, (int)details.size());
        List detailList = (List)details.get("average_speed");
        Assertions.assertEquals((int)18, (int)detailList.size());
        Assertions.assertEquals((Object)5.0, (Object)((PathDetail)detailList.get(0)).getValue());
        Assertions.assertEquals((int)0, (int)((PathDetail)detailList.get(0)).getFirst());
        Assertions.assertEquals((Object)3.0, (Object)((PathDetail)detailList.get(1)).getValue());
        Assertions.assertEquals((int)(res.getPoints().size() - 1), (int)((PathDetail)detailList.get(17)).getLast());
    }

    @Test
    public void testMonacoEnforcedDirection() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setEncodedValuesString("foot_access, foot_priority, foot_average_speed").setProfiles(new Profile[]{TestProfiles.accessSpeedAndPriority((String)"profile", (String)"foot")}).setStoreOnFlush(true).importOrLoad();
        GHRequest req = new GHRequest().addPoint(new GHPoint(43.741069, 7.426854)).addPoint(new GHPoint(43.744445, 7.429483)).setHeadings(Arrays.asList(0.0, 190.0)).setProfile("profile");
        req.putHint("heading_penalty", (Object)"400");
        GHResponse rsp = hopper.route(req);
        ResponsePath res = rsp.getBest();
        Assertions.assertEquals((double)575.0, (double)res.getDistance(), (double)10.0);
        Assertions.assertEquals((int)26, (int)res.getPoints().size());
        req = new GHRequest().addPoint(new GHPoint(43.741069, 7.426854)).addPoint(new GHPoint(43.744445, 7.429483)).setHeadings(Arrays.asList(10.0, 370.0)).setProfile("profile");
        rsp = hopper.route(req);
        Assertions.assertTrue((boolean)rsp.hasErrors());
        Assertions.assertTrue((boolean)rsp.getErrors().toString().contains("Heading for point 1 must be in range [0,360) or NaN, but was: 370"), (String)rsp.getErrors().toString());
        req = new GHRequest().addPoint(new GHPoint(43.741069, 7.426854)).addPoint(new GHPoint(43.742069, 7.427854)).addPoint(new GHPoint(43.744445, 7.429483)).setHeadings(Arrays.asList(0.0, 190.0)).setProfile("profile");
        rsp = hopper.route(req);
        Assertions.assertTrue((boolean)rsp.hasErrors());
        Assertions.assertTrue((boolean)rsp.getErrors().toString().contains("The number of 'heading' parameters must be zero, one or equal to the number of points"), (String)rsp.getErrors().toString());
    }

    @Test
    public void testHeading() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(BAYREUTH).setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"profile", (String)"car")}).setStoreOnFlush(true).importOrLoad();
        GHRequest req = new GHRequest().addPoint(new GHPoint(49.985917, 11.510603)).addPoint(new GHPoint(49.98669, 11.509482)).setProfile("profile");
        GHResponse rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors());
        Assertions.assertEquals((double)138.0, (double)rsp.getBest().getDistance(), (double)1.0);
        Assertions.assertEquals((double)17.0, (double)rsp.getBest().getRouteWeight(), (double)1.0);
        Assertions.assertEquals((float)17000.0f, (float)rsp.getBest().getTime(), (float)1000.0f);
        req.setHeadings(Arrays.asList(100.0, 0.0));
        rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors());
        Assertions.assertEquals((double)138.0, (double)rsp.getBest().getDistance(), (double)1.0);
        Assertions.assertEquals((double)317.0, (double)rsp.getBest().getRouteWeight(), (double)1.0);
        Assertions.assertEquals((float)17000.0f, (float)rsp.getBest().getTime(), (float)1000.0f);
    }

    @Test
    public void testMonacoMaxVisitedNodes() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setEncodedValuesString("foot_access, foot_priority, foot_average_speed").setProfiles(new Profile[]{TestProfiles.accessSpeedAndPriority((String)"profile", (String)"foot")}).setStoreOnFlush(true).importOrLoad();
        GHPoint from = new GHPoint(43.741069, 7.426854);
        GHPoint to = new GHPoint(43.744445, 7.429483);
        GHRequest req = new GHRequest(from, to).setProfile("profile");
        req.putHint("max_visited_nodes", (Object)5);
        GHResponse rsp = hopper.route(req);
        Assertions.assertTrue((boolean)rsp.hasErrors());
        Throwable throwable = (Throwable)rsp.getErrors().get(0);
        Assertions.assertInstanceOf(MaximumNodesExceededException.class, (Object)throwable);
        Object nodesDetail = ((MaximumNodesExceededException)throwable).getDetails().get("max_visited_nodes");
        Assertions.assertEquals((Object)5, nodesDetail);
        req = new GHRequest(from, to).setProfile("profile");
        rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
    }

    @Test
    public void testMonacoNonChMaxWaypointDistance() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"profile")}).setStoreOnFlush(true).importOrLoad();
        GHPoint from = new GHPoint(43.741069, 7.426854);
        GHPoint to = new GHPoint(43.727697, 7.419199);
        GHRequest req = new GHRequest(from, to).setProfile("profile");
        hopper.getRouterConfig().setNonChMaxWaypointDistance(1000);
        GHResponse rsp = hopper.route(req);
        Assertions.assertTrue((boolean)rsp.hasErrors());
        String errorString = rsp.getErrors().toString();
        Assertions.assertTrue((boolean)errorString.contains("Point 1 is too far from Point 0"), (String)errorString);
        hopper.getRouterConfig().setNonChMaxWaypointDistance(Integer.MAX_VALUE);
        rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
    }

    @Test
    public void testMonacoNonChMaxWaypointDistanceMultiplePoints() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"profile")}).setStoreOnFlush(true).importOrLoad();
        GHPoint from = new GHPoint(43.741069, 7.426854);
        GHPoint via = new GHPoint(43.744445, 7.429483);
        GHPoint to = new GHPoint(43.727697, 7.419199);
        GHRequest req = new GHRequest().setPoints(Arrays.asList(from, via, to)).setProfile("profile");
        hopper.getRouterConfig().setNonChMaxWaypointDistance(1000);
        GHResponse rsp = hopper.route(req);
        Assertions.assertTrue((boolean)rsp.hasErrors());
        String errorString = rsp.getErrors().toString();
        Assertions.assertTrue((boolean)errorString.contains("Point 2 is too far from Point 1"), (String)errorString);
        PointDistanceExceededException exception = (PointDistanceExceededException)rsp.getErrors().get(0);
        Assertions.assertEquals((Object)1, exception.getDetails().get("from"));
        Assertions.assertEquals((Object)2, exception.getDetails().get("to"));
        hopper.getRouterConfig().setNonChMaxWaypointDistance(Integer.MAX_VALUE);
        rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
    }

    @Test
    public void testMonacoStraightVia() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setEncodedValuesString("foot_access, foot_priority, foot_average_speed").setProfiles(new Profile[]{TestProfiles.accessSpeedAndPriority((String)"profile", (String)"foot")}).setStoreOnFlush(true).importOrLoad();
        GHRequest rq = new GHRequest().addPoint(new GHPoint(43.741069, 7.426854)).addPoint(new GHPoint(43.740371, 7.426946)).addPoint(new GHPoint(43.740794, 7.427294)).setProfile("profile");
        rq.putHint("pass_through", (Object)true);
        GHResponse rsp = hopper.route(rq);
        ResponsePath res = rsp.getBest();
        Assertions.assertEquals((double)297.0, (double)res.getDistance(), (double)5.0);
        Assertions.assertEquals((int)25, (int)res.getPoints().size());
        rq = new GHRequest().addPoint(new GHPoint(43.741069, 7.426854)).addPoint(new GHPoint(43.741069, 7.426854)).addPoint(new GHPoint(43.740371, 7.426946)).setProfile("profile");
        rq.putHint("pass_through", (Object)true);
        rsp = hopper.route(rq);
        Assertions.assertEquals((double)91.0, (double)rsp.getBest().getDistance(), (double)5.0);
    }

    @Test
    public void testSRTMWithInstructions() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setEncodedValuesString("foot_access, foot_priority, foot_average_speed").setProfiles(new Profile[]{TestProfiles.accessSpeedAndPriority((String)"profile", (String)"foot")}).setStoreOnFlush(true);
        hopper.setElevationProvider((ElevationProvider)new SRTMProvider(DIR));
        hopper.importOrLoad();
        GHResponse rsp = hopper.route(new GHRequest(43.730729, 7.421288, 43.727697, 7.419199).setAlgorithm("astar").setProfile("profile"));
        ResponsePath res = rsp.getBest();
        Assertions.assertEquals((double)1617.5, (double)res.getDistance(), (double)0.1);
        Assertions.assertEquals((int)68, (int)res.getPoints().size());
        Assertions.assertTrue((boolean)res.getPoints().is3D());
        InstructionList il = res.getInstructions();
        Assertions.assertEquals((int)12, (int)il.size());
        Assertions.assertTrue((boolean)il.get(0).getPoints().is3D());
        Assertions.assertEquals((Object)Helper.createPointList3D((double[])new double[]{43.730684662577524, 7.421283725164733, 62.0, 43.7306797, 7.4213823, 66.0, 43.730949, 7.4214948, 66.0, 43.731098, 7.4215463, 45.0, 43.7312269, 7.4215824, 45.0, 43.7312991, 7.42159, 45.0, 43.7313271, 7.4214147, 45.0, 43.7312506, 7.4213664, 45.0, 43.7312546, 7.4212741, 52.0, 43.7312822, 7.4211156, 52.0, 43.7313624, 7.4211455, 52.0, 43.7313714, 7.4211233, 52.0, 43.7314858, 7.4211734, 52.0, 43.7315522, 7.4209778, 52.0, 43.7315753, 7.4208688, 52.0, 43.7316061, 7.4208249, 52.0, 43.7316404, 7.4208503, 52.0, 43.7316741, 7.4210502, 52.0, 43.7316276, 7.4214636, 45.0, 43.7316391, 7.4215065, 45.0, 43.7316664, 7.4214904, 45.0, 43.7316981, 7.4212652, 52.0, 43.7317185, 7.4211861, 52.0, 43.7319676, 7.4206159, 19.0, 43.732038, 7.4203936, 20.0, 43.732173, 7.4198886, 20.0, 43.7322266, 7.4196414, 26.0, 43.732266, 7.4194654, 26.0, 43.7323236, 7.4192656, 26.0, 43.7323374, 7.4191503, 26.0, 43.7323374, 7.4190461, 26.0, 43.7323875, 7.4189195, 26.0, 43.7323444, 7.4188579, 26.0, 43.731974, 7.4181688, 29.0, 43.7316421, 7.4173042, 23.0, 43.7315686, 7.4170356, 31.0, 43.7314269, 7.4166815, 31.0, 43.7312401, 7.4163184, 49.0, 43.7308286, 7.4157613, 29.4, 43.730662, 7.4155599, 22.0, 43.7303643, 7.4151193, 51.0, 43.729579, 7.4137274, 40.0, 43.7295167, 7.4137244, 40.0, 43.7294669, 7.4137725, 40.0, 43.7285987, 7.4149068, 23.0, 43.7285167, 7.4149272, 22.0, 43.7283974, 7.4148646, 22.0, 43.7285619, 7.4151365, 23.0, 43.7285774, 7.4152444, 23.0, 43.7285863, 7.4157656, 21.0, 43.7285763, 7.4159759, 21.0, 43.7285238, 7.4161982, 20.0, 43.7284592, 7.4163655, 18.0, 43.72838, 7.4165003, 18.0, 43.7281669, 7.4168192, 18.0, 43.7281442, 7.4169449, 18.0, 43.7281477, 7.4170695, 18.0, 43.7281684, 7.4172435, 14.0, 43.7282784, 7.4179606, 14.0, 43.7282757, 7.418175, 11.0, 43.7282319, 7.4183683, 11.0, 43.7281482, 7.4185473, 11.0, 43.7280654, 7.4186535, 11.0, 43.7279259, 7.418748, 11.0, 43.7278398, 7.4187697, 11.0, 43.727779, 7.4187731, 11.0, 43.7276825, 7.4190072, 11.0, 43.72767974015672, 7.419198523220426, 11.0}), (Object)res.getPoints());
        Assertions.assertEquals((double)84.0, (double)res.getAscend(), (double)0.1);
        Assertions.assertEquals((double)135.0, (double)res.getDescend(), (double)0.1);
        Assertions.assertEquals((int)68, (int)res.getPoints().size());
        Assertions.assertEquals((Object)new GHPoint3D(43.73068455771767, 7.421283689825812, 62.0), (Object)res.getPoints().get(0));
        Assertions.assertEquals((Object)new GHPoint3D(43.727679637988224, 7.419198521975086, 11.0), (Object)res.getPoints().get(res.getPoints().size() - 1));
        Assertions.assertEquals((double)62.0, (double)res.getPoints().get(0).getEle(), (double)0.01);
        Assertions.assertEquals((double)66.0, (double)res.getPoints().get(1).getEle(), (double)0.01);
        Assertions.assertEquals((double)52.0, (double)res.getPoints().get(10).getEle(), (double)0.01);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSRTMWithTunnelInterpolation(boolean withTunnelInterpolation) {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setEncodedValuesString("foot_access, foot_priority, foot_average_speed").setProfiles(new Profile[]{TestProfiles.accessSpeedAndPriority((String)"profile", (String)"foot")}).setStoreOnFlush(true);
        if (!withTunnelInterpolation) {
            hopper.setImportRegistry((ImportRegistry)new DefaultImportRegistry(){

                public ImportUnit createImportUnit(String name) {
                    ImportUnit importUnit = super.createImportUnit(name);
                    if ("road_environment".equals(name)) {
                        importUnit = ImportUnit.create((String)name, props -> RoadEnvironment.create(), (lookup, props) -> new OSMRoadEnvironmentParser(lookup.getEnumEncodedValue("road_environment", RoadEnvironment.class)){

                            public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay readerWay, IntsRef relationFlags) {
                            }
                        }, (String[])new String[0]);
                    }
                    return importUnit;
                }
            });
        }
        hopper.setElevationProvider((ElevationProvider)new SRTMProvider(DIR));
        hopper.importOrLoad();
        GHPoint from = new GHPoint(43.7405647, 7.4299266);
        GHPoint to = new GHPoint(43.737899, 7.427978);
        Assertions.assertEquals((Object)Snap.Position.TOWER, (Object)hopper.getLocationIndex().findClosest(from.lat, from.lon, EdgeFilter.ALL_EDGES).getSnappedPosition());
        Assertions.assertEquals((Object)Snap.Position.TOWER, (Object)hopper.getLocationIndex().findClosest(to.lat, to.lon, EdgeFilter.ALL_EDGES).getSnappedPosition());
        GHResponse rsp = hopper.route(new GHRequest(from, to).setProfile("profile"));
        ResponsePath res = rsp.getBest();
        PointList pointList = res.getPoints();
        Assertions.assertEquals((int)6, (int)pointList.size());
        Assertions.assertTrue((boolean)pointList.is3D());
        if (withTunnelInterpolation) {
            Assertions.assertEquals((double)351.8, (double)res.getDistance(), (double)0.1);
            Assertions.assertEquals((double)17.0, (double)pointList.getEle(0), (double)0.1);
            Assertions.assertEquals((double)19.04, (double)pointList.getEle(1), (double)0.1);
            Assertions.assertEquals((double)21.67, (double)pointList.getEle(2), (double)0.1);
            Assertions.assertEquals((double)25.03, (double)pointList.getEle(3), (double)0.1);
            Assertions.assertEquals((double)28.65, (double)pointList.getEle(4), (double)0.1);
            Assertions.assertEquals((double)34.0, (double)pointList.getEle(5), (double)0.1);
        } else {
            Assertions.assertEquals((double)358.3, (double)res.getDistance(), (double)0.1);
            Assertions.assertEquals((double)17.0, (double)pointList.getEle(0), (double)0.1);
            Assertions.assertEquals((double)23.0, (double)pointList.getEle(1), (double)0.1);
            Assertions.assertEquals((double)23.0, (double)pointList.getEle(2), (double)0.1);
            Assertions.assertEquals((double)41.0, (double)pointList.getEle(3), (double)0.1);
            Assertions.assertEquals((double)19.0, (double)pointList.getEle(4), (double)0.1);
            Assertions.assertEquals((double)34.0, (double)pointList.getEle(5), (double)0.1);
        }
    }

    @Test
    public void testSRTMWithLongEdgeSampling() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setStoreOnFlush(true).setEncodedValuesString("foot_access, foot_priority, foot_average_speed").setProfiles(new Profile[]{TestProfiles.accessSpeedAndPriority((String)"profile", (String)"foot")});
        hopper.getRouterConfig().setElevationWayPointMaxDistance(1.0);
        hopper.getReaderConfig().setElevationMaxWayPointDistance(1.0).setLongEdgeSamplingDistance(30.0);
        SRTMProvider elevationProvider = new SRTMProvider(DIR);
        elevationProvider.setInterpolate(true);
        hopper.setElevationProvider((ElevationProvider)elevationProvider);
        hopper.importOrLoad();
        GHResponse rsp = hopper.route(new GHRequest(43.730729, 7.421288, 43.727697, 7.419199).setAlgorithm("astar").setProfile("profile"));
        ResponsePath arsp = rsp.getBest();
        Assertions.assertEquals((double)1570.0, (double)arsp.getDistance(), (double)1.0);
        Assertions.assertEquals((int)74, (int)arsp.getPoints().size());
        Assertions.assertTrue((boolean)arsp.getPoints().is3D());
        InstructionList il = arsp.getInstructions();
        Assertions.assertEquals((int)12, (int)il.size());
        Assertions.assertTrue((boolean)il.get(0).getPoints().is3D());
        Assertions.assertEquals((double)23.8, (double)arsp.getAscend(), (double)0.1);
        Assertions.assertEquals((double)67.4, (double)arsp.getDescend(), (double)0.1);
        Assertions.assertEquals((int)74, (int)arsp.getPoints().size());
        Assertions.assertEquals((Object)new GHPoint3D(43.73068455771767, 7.421283689825812, 55.83), (Object)arsp.getPoints().get(0));
        Assertions.assertEquals((Object)new GHPoint3D(43.727679637988224, 7.419198521975086, 12.27), (Object)arsp.getPoints().get(arsp.getPoints().size() - 1));
        Assertions.assertEquals((double)55.83, (double)arsp.getPoints().get(0).getEle(), (double)0.01);
        Assertions.assertEquals((double)57.78, (double)arsp.getPoints().get(1).getEle(), (double)0.01);
        Assertions.assertEquals((double)53.62, (double)arsp.getPoints().get(10).getEle(), (double)0.01);
    }

    @Disabled
    @Test
    public void testSkadiElevationProvider() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setProfiles(new Profile[]{TestProfiles.accessSpeedAndPriority((String)"profile", (String)"foot")}).setStoreOnFlush(true);
        hopper.setElevationProvider((ElevationProvider)new SkadiProvider(DIR));
        hopper.importOrLoad();
        GHResponse rsp = hopper.route(new GHRequest(43.730729, 7.421288, 43.727697, 7.419199).setProfile("profile"));
        ResponsePath res = rsp.getBest();
        Assertions.assertEquals((double)1601.6, (double)res.getDistance(), (double)0.1);
        Assertions.assertEquals((int)55, (int)res.getPoints().size());
        Assertions.assertTrue((boolean)res.getPoints().is3D());
        Assertions.assertEquals((double)69.0, (double)res.getAscend(), (double)0.1);
        Assertions.assertEquals((double)121.0, (double)res.getDescend(), (double)0.1);
        Assertions.assertEquals((double)64.5, (double)res.getPoints().get(0).getEle(), (double)0.01);
    }

    @Test
    public void testKremsCyclewayInstructionsWithWayTypeInfo() {
        String footProfile = "foot_profile";
        String bikeProfile = "bike_profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(KREMS).setEncodedValuesString("foot_access, foot_priority, foot_average_speed, bike_access, bike_priority, bike_average_speed").setProfiles(new Profile[]{TestProfiles.accessSpeedAndPriority((String)"foot_profile", (String)"foot"), TestProfiles.accessSpeedAndPriority((String)"bike_profile", (String)"bike")}).setStoreOnFlush(true).importOrLoad();
        Translation tr = hopper.getTranslationMap().getWithFallBack(Locale.US);
        GHResponse rsp = hopper.route(new GHRequest(48.410987, 15.599492, 48.383419, 15.659294).setProfile("bike_profile"));
        Assertions.assertFalse((boolean)rsp.hasErrors());
        ResponsePath res = rsp.getBest();
        Assertions.assertEquals((double)6932.2, (double)res.getDistance(), (double)0.1);
        Assertions.assertEquals((int)117, (int)res.getPoints().size());
        InstructionList il = res.getInstructions();
        Assertions.assertEquals((int)19, (int)il.size());
        Assertions.assertEquals((Object)"continue onto Obere Landstra\u00dfe", (Object)il.get(0).getTurnDescription(tr));
        Assertions.assertEquals((double)69.28, (double)((Double)il.get(0).getExtraInfoJSON().get("heading")), (double)0.01);
        Assertions.assertEquals((Object)"turn left onto Kirchengasse", (Object)il.get(1).getTurnDescription(tr));
        Assertions.assertEquals((Object)"turn right onto Pfarrplatz", (Object)il.get(2).getTurnDescription(tr));
        Assertions.assertEquals((Object)"turn right onto Margarethenstra\u00dfe", (Object)il.get(3).getTurnDescription(tr));
        Assertions.assertEquals((Object)"keep left onto Hoher Markt", (Object)il.get(4).getTurnDescription(tr));
        Assertions.assertEquals((Object)"turn right onto Wegscheid", (Object)il.get(6).getTurnDescription(tr));
        Assertions.assertEquals((Object)"continue onto Wegscheid", (Object)il.get(7).getTurnDescription(tr));
        Assertions.assertEquals((Object)"turn right onto Ringstra\u00dfe", (Object)il.get(8).getTurnDescription(tr));
        Assertions.assertEquals((Object)"keep left onto Eyblparkstra\u00dfe", (Object)il.get(9).getTurnDescription(tr));
        Assertions.assertEquals((Object)"keep left onto Austra\u00dfe", (Object)il.get(10).getTurnDescription(tr));
        Assertions.assertEquals((Object)"keep left onto Rechte Kremszeile", (Object)il.get(11).getTurnDescription(tr));
        Assertions.assertEquals((Object)"turn right onto Treppelweg", (Object)il.get(15).getTurnDescription(tr));
        rsp = hopper.route(new GHRequest(48.410987, 15.599492, 48.411172, 15.600371).setAlgorithm("astar").setProfile("foot_profile"));
        Assertions.assertFalse((boolean)rsp.hasErrors());
        il = rsp.getBest().getInstructions();
        Assertions.assertEquals((Object)"continue onto Obere Landstra\u00dfe", (Object)il.get(0).getTurnDescription(tr));
    }

    @Test
    public void testRoundaboutInstructionsWithCH() {
        String profile1 = "my_profile";
        String profile2 = "your_profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setEncodedValuesString("car_access, car_average_speed, bike_access, bike_priority, bike_average_speed").setProfiles(Arrays.asList(TestProfiles.accessAndSpeed((String)"my_profile", (String)"car"), TestProfiles.accessSpeedAndPriority((String)"your_profile", (String)"bike"))).setStoreOnFlush(true);
        hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("my_profile"), new CHProfile("your_profile")});
        hopper.setMinNetworkSize(0);
        hopper.importOrLoad();
        Assertions.assertEquals((int)2, (int)hopper.getCHGraphs().size());
        GHResponse rsp = hopper.route(new GHRequest(43.745084, 7.430513, 43.745247, 7.430347).setProfile("my_profile"));
        ResponsePath res = rsp.getBest();
        Assertions.assertEquals((int)2, (int)((RoundaboutInstruction)res.getInstructions().get(1)).getExitNumber());
        rsp = hopper.route(new GHRequest(43.745968, 7.42907, 43.745832, 7.428614).setProfile("my_profile"));
        res = rsp.getBest();
        Assertions.assertEquals((int)2, (int)((RoundaboutInstruction)res.getInstructions().get(1)).getExitNumber());
        rsp = hopper.route(new GHRequest(43.745948, 7.42914, 43.746173, 7.428834).setProfile("my_profile"));
        res = rsp.getBest();
        Assertions.assertEquals((int)1, (int)((RoundaboutInstruction)res.getInstructions().get(1)).getExitNumber());
        rsp = hopper.route(new GHRequest(43.735817, 7.417096, 43.735666, 7.416587).setProfile("my_profile"));
        res = rsp.getBest();
        Assertions.assertEquals((int)2, (int)((RoundaboutInstruction)res.getInstructions().get(1)).getExitNumber());
    }

    @Test
    public void testCircularJunctionInstructionsWithCH() {
        String profile1 = "profile1";
        String profile2 = "profile2";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(BERLIN).setEncodedValuesString("car_access, car_average_speed, bike_access, bike_priority, bike_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)profile1, (String)"car"), TestProfiles.accessSpeedAndPriority((String)profile2, (String)"bike")}).setStoreOnFlush(true);
        hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile(profile1), new CHProfile(profile2)});
        hopper.setMinNetworkSize(0);
        hopper.importOrLoad();
        Assertions.assertEquals((int)2, (int)hopper.getCHGraphs().size());
        GHResponse rsp = hopper.route(new GHRequest(52.513505, 13.350443, 52.513505, 13.350245).setProfile(profile1));
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Instruction instr = rsp.getBest().getInstructions().get(1);
        Assertions.assertTrue((boolean)(instr instanceof RoundaboutInstruction));
        Assertions.assertEquals((int)5, (int)((RoundaboutInstruction)instr).getExitNumber());
    }

    @Test
    public void testMultipleVehiclesWithCH() {
        String bikeProfile = "bike_profile";
        String carProfile = "car_profile";
        List<Profile> profiles = Arrays.asList(TestProfiles.accessSpeedAndPriority((String)"bike_profile", (String)"bike"), TestProfiles.accessAndSpeed((String)"car_profile", (String)"car"));
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setEncodedValuesString("bike_access, bike_priority, bike_average_speed, car_access, car_average_speed").setProfiles(profiles).setStoreOnFlush(true);
        hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("bike_profile"), new CHProfile("car_profile")});
        hopper.importOrLoad();
        GHResponse rsp = hopper.route(new GHRequest(43.73005, 7.415707, 43.741522, 7.42826).setProfile("car_profile"));
        ResponsePath res = rsp.getBest();
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Assertions.assertEquals((float)205.0f, (float)((float)res.getTime() / 1000.0f), (float)1.0f);
        Assertions.assertEquals((double)2837.0, (double)res.getDistance(), (double)1.0);
        rsp = hopper.route(new GHRequest(43.73005, 7.415707, 43.741522, 7.42826).setProfile("bike_profile"));
        res = rsp.getBest();
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Assertions.assertEquals((float)536.0f, (float)((float)res.getTime() / 1000.0f), (float)1.0f);
        Assertions.assertEquals((double)2522.0, (double)res.getDistance(), (double)1.0);
        rsp = hopper.route(new GHRequest(43.73005, 7.415707, 43.741522, 7.42826).setProfile("profile3"));
        Assertions.assertTrue((boolean)rsp.hasErrors(), (String)"only car_profile and bike_profile exist, request for profile3 should fail");
        GHRequest req = new GHRequest().addPoint(new GHPoint(43.741069, 7.426854)).addPoint(new GHPoint(43.744445, 7.429483)).setHeadings(Arrays.asList(0.0, 190.0)).setProfile("bike_profile");
        rsp = hopper.route(req);
        Assertions.assertTrue((boolean)rsp.hasErrors(), (String)"heading not allowed for CH enabled graph");
    }

    @Test
    public void testIfCHIsUsed() {
        this.executeCHFootRoute();
        this.executeCHFootRoute();
    }

    private void executeCHFootRoute() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setEncodedValuesString("car_access, car_average_speed, foot_access, foot_priority, foot_average_speed").setProfiles(new Profile[]{TestProfiles.accessSpeedAndPriority((String)"profile", (String)"foot")}).setStoreOnFlush(true);
        hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("profile")});
        hopper.importOrLoad();
        GHResponse rsp = hopper.route(new GHRequest(43.727687, 7.418737, 43.74958, 7.436566).setProfile("profile"));
        ResponsePath bestPath = rsp.getBest();
        long sum = rsp.getHints().getLong("visited_nodes.sum", 0L);
        Assertions.assertNotEquals((long)sum, (long)0L);
        Assertions.assertTrue((sum < 147L ? 1 : 0) != 0, (String)("Too many nodes visited " + sum));
        Assertions.assertEquals((double)3536.0, (double)bestPath.getDistance(), (double)1.0);
        Assertions.assertEquals((int)131, (int)bestPath.getPoints().size());
        hopper.close();
    }

    @Test
    public void testRoundTour() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setEncodedValuesString("foot_access, foot_priority, foot_average_speed").setProfiles(new Profile[]{TestProfiles.accessSpeedAndPriority((String)"profile", (String)"foot")}).setStoreOnFlush(true).importOrLoad();
        GHRequest rq = new GHRequest().addPoint(new GHPoint(43.741069, 7.426854)).setHeadings(Collections.singletonList(50.0)).setProfile("profile").setAlgorithm("round_trip");
        rq.putHint("round_trip.distance", (Object)1000);
        rq.putHint("round_trip.seed", (Object)0);
        GHResponse rsp = hopper.route(rq);
        Assertions.assertEquals((int)1, (int)rsp.getAll().size());
        ResponsePath res = rsp.getBest();
        Assertions.assertEquals((double)1.47, (double)(rsp.getBest().getDistance() / 1000.0), (double)0.01);
        Assertions.assertEquals((float)19.0f, (float)((float)rsp.getBest().getTime() / 1000.0f / 60.0f), (float)1.0f);
        Assertions.assertEquals((int)68, (int)res.getPoints().size());
    }

    @Test
    public void testPathDetails1216() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(BAYREUTH).setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"profile", (String)"car")});
        hopper.importOrLoad();
        GHRequest req = new GHRequest().setPoints(Arrays.asList(new GHPoint(49.984352, 11.498802), new GHPoint(49.984565, 11.499188), new GHPoint(49.9847, 11.499612))).setProfile("profile").setPathDetails(Collections.singletonList("average_speed"));
        GHResponse rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
    }

    @Test
    public void testPathDetailsSamePoint() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(BAYREUTH).setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"profile")});
        hopper.importOrLoad();
        GHRequest req = new GHRequest().addPoint(new GHPoint(49.984352, 11.498802)).addPoint(new GHPoint(49.984352, 11.498802)).setProfile("profile").setPathDetails(Collections.singletonList("average_speed"));
        GHResponse rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors());
    }

    @Test
    public void testFlexMode_631() {
        String profile = "car_profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"car_profile", (String)"car")}).setStoreOnFlush(true);
        hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("car_profile")});
        hopper.getLMPreparationHandler().setLMProfiles(new LMProfile[]{new LMProfile("car_profile").setMaximumLMWeight(2000.0)});
        hopper.importOrLoad();
        GHRequest req = new GHRequest(43.727687, 7.418737, 43.74958, 7.436566).setProfile("car_profile");
        req.putHint("lm.disable", (Object)true);
        req.putHint("ch.disable", (Object)false);
        GHResponse rsp = hopper.route(req);
        long chSum = rsp.getHints().getLong("visited_nodes.sum", 0L);
        Assertions.assertTrue((chSum < 70L ? 1 : 0) != 0, (String)("Too many visited nodes for ch mode " + chSum));
        ResponsePath bestPath = rsp.getBest();
        Assertions.assertEquals((double)3587.0, (double)bestPath.getDistance(), (double)1.0);
        Assertions.assertEquals((int)105, (int)bestPath.getPoints().size());
        req.setAlgorithm("astarbi");
        req.putHint("lm.disable", (Object)true);
        req.putHint("ch.disable", (Object)true);
        rsp = hopper.route(req);
        long flexSum = rsp.getHints().getLong("visited_nodes.sum", 0L);
        Assertions.assertTrue((flexSum > 60L ? 1 : 0) != 0, (String)("Too few visited nodes for flex mode " + flexSum));
        bestPath = rsp.getBest();
        Assertions.assertEquals((double)3587.0, (double)bestPath.getDistance(), (double)1.0);
        Assertions.assertEquals((int)105, (int)bestPath.getPoints().size());
        req.putHint("lm.disable", (Object)false);
        req.putHint("ch.disable", (Object)true);
        rsp = hopper.route(req);
        long hSum = rsp.getHints().getLong("visited_nodes.sum", 0L);
        Assertions.assertTrue((hSum != chSum ? 1 : 0) != 0, (String)("Visited nodes for hybrid mode should be different to CH but " + hSum + "==" + chSum));
        Assertions.assertTrue((hSum < flexSum ? 1 : 0) != 0, (String)("Too many visited nodes for hybrid mode " + hSum + ">=" + flexSum));
        bestPath = rsp.getBest();
        Assertions.assertEquals((double)3587.0, (double)bestPath.getDistance(), (double)1.0);
        Assertions.assertEquals((int)105, (int)bestPath.getPoints().size());
    }

    @Test
    public void testCrossQuery() {
        String profile1 = "p1";
        String profile2 = "p2";
        String profile3 = "p3";
        Profile p1 = TestProfiles.accessAndSpeed((String)"p1", (String)"car");
        Profile p2 = TestProfiles.accessAndSpeed((String)"p2", (String)"car");
        Profile p3 = TestProfiles.accessAndSpeed((String)"p3", (String)"car");
        p1.getCustomModel().setDistanceInfluence(Double.valueOf(70.0));
        p2.getCustomModel().setDistanceInfluence(Double.valueOf(100.0));
        p3.getCustomModel().setDistanceInfluence(Double.valueOf(150.0));
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{p1, p2, p3}).setStoreOnFlush(true);
        hopper.getLMPreparationHandler().setLMProfiles(new LMProfile[]{new LMProfile("p1"), new LMProfile("p2").setPreparationProfile("p1"), new LMProfile("p3").setPreparationProfile("p1")});
        hopper.setMinNetworkSize(0);
        hopper.importOrLoad();
        this.testCrossQueryAssert("p1", hopper, 525.3, 196, true);
        this.testCrossQueryAssert("p2", hopper, 633.0, 198, true);
        this.testCrossQueryAssert("p3", hopper, 812.4, 198, true);
        this.testCrossQueryAssert("p1", hopper, 525.3, 108, false);
        this.testCrossQueryAssert("p2", hopper, 633.0, 126, false);
        this.testCrossQueryAssert("p3", hopper, 812.4, 192, false);
    }

    private void testCrossQueryAssert(String profile, GraphHopper hopper, double expectedWeight, int expectedVisitedNodes, boolean disableLM) {
        GHResponse response = hopper.route(new GHRequest(43.727687, 7.418737, 43.74958, 7.436566).setProfile(profile).putHint("lm.disable", (Object)disableLM));
        Assertions.assertEquals((double)expectedWeight, (double)response.getBest().getRouteWeight(), (double)0.1);
        int visitedNodes = response.getHints().getInt("visited_nodes.sum", 0);
        Assertions.assertEquals((int)expectedVisitedNodes, (int)visitedNodes);
    }

    @Test
    public void testLMConstraints() {
        Profile p1 = TestProfiles.accessAndSpeed((String)"p1", (String)"car");
        Profile p2 = TestProfiles.accessAndSpeed((String)"p2", (String)"car");
        p1.getCustomModel().setDistanceInfluence(Double.valueOf(100.0));
        p2.getCustomModel().setDistanceInfluence(Double.valueOf(100.0));
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{p1, p2}).setStoreOnFlush(true);
        hopper.getLMPreparationHandler().setLMProfiles(new LMProfile[]{new LMProfile("p1")});
        hopper.setMinNetworkSize(0);
        hopper.importOrLoad();
        GHResponse response = hopper.route(new GHRequest(43.727687, 7.418737, 43.74958, 7.436566).setProfile("p1").putHint("lm.disable", (Object)false));
        Assertions.assertEquals((double)3587.0, (double)response.getBest().getDistance(), (double)1.0);
        CustomModel customModel = new CustomModel().setDistanceInfluence(Double.valueOf(0.0));
        response = hopper.route(new GHRequest(43.727687, 7.418737, 43.74958, 7.436566).setCustomModel(customModel).setProfile("p1").putHint("lm.disable", (Object)false));
        Assertions.assertTrue((boolean)response.hasErrors(), (String)response.getErrors().toString());
        Assertions.assertEquals(IllegalArgumentException.class, ((Throwable)response.getErrors().get(0)).getClass());
        response = hopper.route(new GHRequest(43.727687, 7.418737, 43.74958, 7.436566).setCustomModel(customModel).setProfile("p1").putHint("lm.disable", (Object)true));
        Assertions.assertFalse((boolean)response.hasErrors(), (String)response.getErrors().toString());
        Assertions.assertEquals((double)3587.0, (double)response.getBest().getDistance(), (double)1.0);
        response = hopper.route(new GHRequest(43.727687, 7.418737, 43.74958, 7.436566).setCustomModel(customModel).setProfile("p2"));
        Assertions.assertTrue((boolean)((Throwable)response.getErrors().get(0)).toString().contains("Cannot find LM preparation for the requested profile: 'p2'"), (String)response.getErrors().toString());
        Assertions.assertEquals(IllegalArgumentException.class, ((Throwable)response.getErrors().get(0)).getClass());
        response = hopper.route(new GHRequest(43.727687, 7.418737, 43.74958, 7.436566).setCustomModel(customModel).setProfile("p2").putHint("lm.disable", (Object)true));
        Assertions.assertFalse((boolean)response.hasErrors(), (String)response.getErrors().toString());
        Assertions.assertEquals((double)3587.0, (double)response.getBest().getDistance(), (double)1.0);
    }

    @Test
    public void testCreateWeightingHintsMerging() {
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setEncodedValuesString("car_access, car_average_speed, mtb_access, mtb_priority, mtb_average_speed").setProfiles(new Profile[]{TestProfiles.accessSpeedAndPriority((String)"profile", (String)"mtb").setTurnCostsConfig(new TurnCostsConfig(List.of("bicycle"), 123))});
        hopper.importOrLoad();
        Weighting w = hopper.createWeighting((Profile)hopper.getProfiles().get(0), new PMap());
        Assertions.assertEquals((double)123.0, (double)w.calcTurnWeight(5, 6, 5));
        w = hopper.createWeighting((Profile)hopper.getProfiles().get(0), new PMap().putObject("u_turn_costs", (Object)46));
        Assertions.assertEquals((double)46.0, (double)w.calcTurnWeight(5, 6, 5));
    }

    @Test
    public void testPreparedProfileNotAvailable() {
        String profile1 = "fast_profile";
        String profile2 = "short_fast_profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"fast_profile", (String)"car"), TestProfiles.accessAndSpeed((String)"short_fast_profile", (String)"car")}).setStoreOnFlush(true);
        hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("fast_profile")});
        hopper.getLMPreparationHandler().setLMProfiles(new LMProfile[]{new LMProfile("fast_profile").setMaximumLMWeight(2000.0)});
        hopper.importOrLoad();
        GHRequest req = new GHRequest(43.727687, 7.418737, 43.74958, 7.436566).setProfile("short_fast_profile");
        req.putHint("ch.disable", (Object)false);
        req.putHint("lm.disable", (Object)false);
        GHResponse res = hopper.route(req);
        Assertions.assertTrue((boolean)res.hasErrors(), (String)res.getErrors().toString());
        Assertions.assertTrue((boolean)((Throwable)res.getErrors().get(0)).getMessage().contains("Cannot find CH preparation for the requested profile: 'short_fast_profile'"), (String)res.getErrors().toString());
        req.putHint("ch.disable", (Object)true);
        req.putHint("lm.disable", (Object)false);
        res = hopper.route(req);
        Assertions.assertTrue((boolean)res.hasErrors(), (String)res.getErrors().toString());
        Assertions.assertTrue((boolean)((Throwable)res.getErrors().get(0)).getMessage().contains("Cannot find LM preparation for the requested profile: 'short_fast_profile'"), (String)res.getErrors().toString());
        req.putHint("ch.disable", (Object)true);
        req.putHint("lm.disable", (Object)true);
        res = hopper.route(req);
        Assertions.assertFalse((boolean)res.hasErrors(), (String)res.getErrors().toString());
        Assertions.assertEquals((double)3587.0, (double)res.getBest().getDistance(), (double)1.0);
    }

    @Test
    public void testDisablingLM() {
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"car")}).setStoreOnFlush(true);
        hopper.getLMPreparationHandler().setLMProfiles(new LMProfile[]{new LMProfile("car").setMaximumLMWeight(2000.0)});
        hopper.importOrLoad();
        GHRequest req = new GHRequest(43.727687, 7.418737, 43.74958, 7.436566).setProfile("car");
        req.putHint("lm.disable", (Object)false);
        GHResponse res = hopper.route(req);
        Assertions.assertTrue((res.getHints().getInt("visited_nodes.sum", 0) < 150 ? 1 : 0) != 0);
        req.putHint("lm.disable", (Object)true);
        res = hopper.route(req);
        Assertions.assertTrue((res.getHints().getInt("visited_nodes.sum", 0) > 170 ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCompareAlgos(boolean turnCosts) {
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MOSCOW).setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"car").setTurnCostsConfig((TurnCostsConfig)(turnCosts ? TurnCostsConfig.car() : null))});
        hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("car")});
        hopper.getLMPreparationHandler().setLMProfiles(new LMProfile[]{new LMProfile("car")});
        hopper.importOrLoad();
        long seed = System.nanoTime();
        Random rnd = new Random(seed);
        for (int i = 0; i < 100; ++i) {
            BBox bounds = hopper.getBaseGraph().getBounds();
            double lat1 = bounds.minLat + rnd.nextDouble() * (bounds.maxLat - bounds.minLat);
            double lat2 = bounds.minLat + rnd.nextDouble() * (bounds.maxLat - bounds.minLat);
            double lon1 = bounds.minLon + rnd.nextDouble() * (bounds.maxLon - bounds.minLon);
            double lon2 = bounds.minLon + rnd.nextDouble() * (bounds.maxLon - bounds.minLon);
            GHRequest req = new GHRequest(lat1, lon1, lat2, lon2);
            req.setProfile("car");
            req.getHints().putObject("ch.disable", (Object)false).putObject("lm.disable", (Object)true);
            ResponsePath pathCH = hopper.route(req).getBest();
            req.getHints().putObject("ch.disable", (Object)true).putObject("lm.disable", (Object)false);
            ResponsePath pathLM = hopper.route(req).getBest();
            req.getHints().putObject("ch.disable", (Object)true).putObject("lm.disable", (Object)true);
            ResponsePath path = hopper.route(req).getBest();
            String failMessage = "seed: " + seed + ", i=" + i;
            Assertions.assertEquals((Object)path.hasErrors(), (Object)pathCH.hasErrors(), (String)failMessage);
            Assertions.assertEquals((Object)path.hasErrors(), (Object)pathLM.hasErrors(), (String)failMessage);
            if (path.hasErrors()) continue;
            Assertions.assertEquals((double)path.getDistance(), (double)pathCH.getDistance(), (double)0.1, (String)failMessage);
            Assertions.assertEquals((double)path.getDistance(), (double)pathLM.getDistance(), (double)0.1, (String)failMessage);
            Assertions.assertEquals((long)path.getTime(), (long)pathCH.getTime(), (String)failMessage);
            Assertions.assertEquals((long)path.getTime(), (long)pathLM.getTime(), (String)failMessage);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testAStarCHBug(boolean turnCosts) {
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MOSCOW).setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"car").setTurnCostsConfig((TurnCostsConfig)(turnCosts ? TurnCostsConfig.car() : null))});
        hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("car")});
        hopper.importOrLoad();
        GHRequest req = new GHRequest(55.821744463888116, 37.60380604129401, 55.82608197039734, 37.62055856655137);
        req.setProfile("car");
        req.getHints().putObject("ch.disable", (Object)false);
        ResponsePath pathCH = hopper.route(req).getBest();
        req.getHints().putObject("ch.disable", (Object)true);
        ResponsePath path = hopper.route(req).getBest();
        Assertions.assertFalse((boolean)path.hasErrors());
        Assertions.assertFalse((boolean)pathCH.hasErrors());
        Assertions.assertEquals((double)path.getDistance(), (double)pathCH.getDistance(), (double)0.1);
        Assertions.assertEquals((long)path.getTime(), (long)pathCH.getTime());
    }

    @Test
    public void testIssue1960() {
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MOSCOW).setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"car").setTurnCostsConfig(TurnCostsConfig.car())});
        hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("car")});
        hopper.getLMPreparationHandler().setLMProfiles(new LMProfile[]{new LMProfile("car")});
        hopper.importOrLoad();
        GHRequest req = new GHRequest(55.81567, 37.604613, 55.806151, 37.617823);
        req.setProfile("car");
        req.getHints().putObject("ch.disable", (Object)false).putObject("lm.disable", (Object)true);
        ResponsePath pathCH = hopper.route(req).getBest();
        req.getHints().putObject("ch.disable", (Object)true).putObject("lm.disable", (Object)false);
        ResponsePath pathLM = hopper.route(req).getBest();
        req.getHints().putObject("ch.disable", (Object)true).putObject("lm.disable", (Object)true);
        ResponsePath path = hopper.route(req).getBest();
        Assertions.assertEquals((double)1995.18, (double)pathCH.getDistance(), (double)0.1);
        Assertions.assertEquals((double)1995.18, (double)pathLM.getDistance(), (double)0.1);
        Assertions.assertEquals((double)1995.18, (double)path.getDistance(), (double)0.1);
        Assertions.assertEquals((long)149482L, (long)pathCH.getTime());
        Assertions.assertEquals((long)149482L, (long)pathLM.getTime());
        Assertions.assertEquals((long)149482L, (long)path.getTime());
    }

    @Test
    public void testTurnCostsOnOff() {
        String profile1 = "profile_no_turn_costs";
        String profile2 = "profile_turn_costs";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MOSCOW).setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"profile_turn_costs", (String)"car").setTurnCostsConfig(new TurnCostsConfig(List.of("motorcar", "motor_vehicle"), 30)), TestProfiles.accessAndSpeed((String)"profile_no_turn_costs", (String)"car")}).setStoreOnFlush(true);
        hopper.importOrLoad();
        GHRequest req = new GHRequest(55.813357, 37.5958585, 55.811042, 37.594689);
        req.setPathDetails(Arrays.asList("distance", "time")).getHints().putObject("instructions", (Object)true);
        req.setProfile("profile_no_turn_costs");
        ResponsePath best = hopper.route(req).getBest();
        Assertions.assertEquals((double)400.0, (double)best.getDistance(), (double)1.0);
        this.consistenceCheck(best);
        req.setProfile("profile_turn_costs");
        best = hopper.route(req).getBest();
        Assertions.assertEquals((double)476.0, (double)best.getDistance(), (double)1.0);
        this.consistenceCheck(best);
    }

    @Test
    public void testTurnCostsOnOffCH() {
        String profile1 = "profile_turn_costs";
        String profile2 = "profile_no_turn_costs";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MOSCOW).setEncodedValuesString("car_access, car_average_speed").setProfiles(List.of(TestProfiles.accessAndSpeed((String)"profile_turn_costs", (String)"car").setTurnCostsConfig(TurnCostsConfig.car()), TestProfiles.accessAndSpeed((String)"profile_no_turn_costs", (String)"car"))).setStoreOnFlush(true);
        hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("profile_turn_costs"), new CHProfile("profile_no_turn_costs")});
        hopper.importOrLoad();
        GHRequest req = new GHRequest(55.813357, 37.5958585, 55.811042, 37.594689);
        req.setProfile("profile_no_turn_costs");
        Assertions.assertEquals((double)400.0, (double)hopper.route(req).getBest().getDistance(), (double)1.0);
        req.setProfile("profile_turn_costs");
        Assertions.assertEquals((double)1044.0, (double)hopper.route(req).getBest().getDistance(), (double)1.0);
    }

    @Test
    public void testCHOnOffWithTurnCosts() {
        String profile = "my_car";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MOSCOW).setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"my_car", (String)"car").setTurnCostsConfig(TurnCostsConfig.car())}).setStoreOnFlush(true);
        hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("my_car")});
        hopper.importOrLoad();
        GHRequest req = new GHRequest(55.81358, 37.598616, 55.809915, 37.5947);
        req.setProfile("my_car");
        req.putHint("ch.disable", (Object)true);
        GHResponse rsp1 = hopper.route(req);
        Assertions.assertEquals((double)1350.0, (double)rsp1.getBest().getDistance(), (double)1.0);
        req.putHint("ch.disable", (Object)false);
        GHResponse rsp2 = hopper.route(req);
        Assertions.assertEquals((double)1350.0, (double)rsp2.getBest().getDistance(), (double)1.0);
        Assertions.assertNotEquals((int)rsp1.getHints().getInt("visited_nodes.sum", -1), (int)rsp2.getHints().getInt("visited_nodes.sum", -1));
    }

    @Test
    public void testNodeBasedCHOnlyButTurnCostForNonCH() {
        String profile1 = "car_profile_tc";
        String profile2 = "car_profile_notc";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MOSCOW).setEncodedValuesString("car_access, car_average_speed").setProfiles(List.of(TestProfiles.accessAndSpeed((String)"car_profile_tc", (String)"car").setTurnCostsConfig(TurnCostsConfig.car()), TestProfiles.accessAndSpeed((String)"car_profile_notc", (String)"car"))).setStoreOnFlush(true);
        hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("car_profile_notc")});
        hopper.importOrLoad();
        GHRequest req = new GHRequest(55.813357, 37.5958585, 55.811042, 37.594689);
        req.putHint("ch.disable", (Object)true);
        req.setProfile("car_profile_tc");
        Assertions.assertEquals((double)1044.0, (double)hopper.route(req).getBest().getDistance(), (double)1.0);
        req.setProfile("car_profile_notc");
        Assertions.assertEquals((double)400.0, (double)hopper.route(req).getBest().getDistance(), (double)1.0);
        req.putHint("ch.disable", (Object)false);
        req.setProfile("car_profile_notc");
        Assertions.assertEquals((double)400.0, (double)hopper.route(req).getBest().getDistance(), (double)1.0);
        req.setProfile("car_profile_tc");
        GHResponse rsp = hopper.route(req);
        Assertions.assertEquals((int)1, (int)rsp.getErrors().size());
        String expected = "Cannot find CH preparation for the requested profile: 'car_profile_tc'\nYou can try disabling CH using ch.disable=true\navailable CH profiles: [car_profile_notc]";
        Assertions.assertTrue((boolean)rsp.getErrors().toString().contains(expected), (String)("unexpected error:\n" + rsp.getErrors().toString() + "\nwhen expecting an error containing:\n" + expected));
    }

    @Test
    public void testProfileWithTurnCostSupport_stillAllows_nodeBasedRouting() {
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MOSCOW).setEncodedValuesString("foot_access, foot_priority, foot_average_speed, car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessSpeedAndPriority((String)"foot"), TestProfiles.accessAndSpeed((String)"car").setTurnCostsConfig(TurnCostsConfig.car())});
        hopper.importOrLoad();
        GHPoint p = new GHPoint(55.813357, 37.5958585);
        GHPoint q = new GHPoint(55.811042, 37.594689);
        GHRequest req = new GHRequest(p, q);
        req.setProfile("foot");
        GHResponse rsp = hopper.route(req);
        Assertions.assertEquals((int)0, (int)rsp.getErrors().size(), (String)("there should not be an error, but was: " + String.valueOf(rsp.getErrors())));
    }

    @Test
    public void testOneWaySubnetwork_issue1807() {
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(ESSEN).setMinNetworkSize(50).setEncodedValuesString("foot_access, foot_priority, foot_average_speed, car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessSpeedAndPriority((String)"foot"), TestProfiles.accessAndSpeed((String)"car").setTurnCostsConfig(TurnCostsConfig.car())});
        hopper.importOrLoad();
        GHPoint p = new GHPoint(51.433417, 7.009395);
        GHPoint q = new GHPoint(51.432872, 7.010066);
        GHRequest req = new GHRequest(p, q);
        req.setProfile("foot");
        GHResponse rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Assertions.assertEquals((double)95.0, (double)rsp.getBest().getDistance(), (double)1.0);
        req.setProfile("car");
        rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Assertions.assertEquals((double)658.0, (double)rsp.getBest().getDistance(), (double)1.0);
    }

    @Test
    public void testTagParserProcessingOrder() {
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(BAYREUTH).setMinNetworkSize(0).setEncodedValuesString("bike_access, bike_priority, bike_average_speed").setProfiles(new Profile[]{TestProfiles.accessSpeedAndPriority((String)"bike")});
        hopper.importOrLoad();
        GHRequest req = new GHRequest(new GHPoint(49.98021, 11.5073), new GHPoint(49.98026, 11.50795));
        req.setProfile("bike");
        GHResponse rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Assertions.assertEquals((double)21.0, (double)((double)rsp.getBest().getTime() / 1000.0), (double)1.0);
        req = new GHRequest(new GHPoint(50.015067, 11.502093), new GHPoint(50.014694, 11.499748));
        req.setProfile("bike");
        rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Assertions.assertEquals((double)23.2, (double)rsp.getBest().getRouteWeight(), (double)0.1);
    }

    @Test
    public void testEdgeCount() {
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(BAYREUTH).setMinNetworkSize(50).setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"bike")});
        hopper.importOrLoad();
        int count = 0;
        AllEdgesIterator iter = hopper.getBaseGraph().getAllEdges();
        while (iter.next()) {
            ++count;
        }
        Assertions.assertEquals((int)hopper.getBaseGraph().getEdges(), (int)count);
    }

    @Test
    public void testCurbsides() {
        GraphHopper h = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(BAYREUTH).setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"car").setTurnCostsConfig(TurnCostsConfig.car())});
        h.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("car")});
        h.importOrLoad();
        GHPoint p = new GHPoint(50.015072, 11.499145);
        GHPoint q = new GHPoint(50.014141, 11.497552);
        String itz = "Itzgrund";
        String rotmain = "An den Rotmainauen";
        String bayreuth = "Bayreuther Stra\u00dfe";
        String kulmbach = "Kulmbacher Stra\u00dfe";
        String adamSeiler = "Adam-Seiler-Stra\u00dfe";
        String friedhof = "Friedhofsweg";
        this.assertCurbsidesPath(h, p, q, Arrays.asList("right", "right"), 344, Arrays.asList("Itzgrund", "An den Rotmainauen", "An den Rotmainauen"));
        this.assertCurbsidesPath(h, p, q, Arrays.asList("right", "left"), 1564, Arrays.asList("Itzgrund", "An den Rotmainauen", "An den Rotmainauen", "Bayreuther Stra\u00dfe", "Adam-Seiler-Stra\u00dfe", "Adam-Seiler-Stra\u00dfe", "Friedhofsweg", "Kulmbacher Stra\u00dfe", "An den Rotmainauen"));
        this.assertCurbsidesPath(h, p, q, Arrays.asList("left", "right"), 1199, Arrays.asList("Itzgrund", "Bayreuther Stra\u00dfe", "Adam-Seiler-Stra\u00dfe", "Adam-Seiler-Stra\u00dfe", "Friedhofsweg", "Kulmbacher Stra\u00dfe", "Itzgrund", "An den Rotmainauen", "An den Rotmainauen"));
        this.assertCurbsidesPath(h, p, q, Arrays.asList("left", "left"), 266, Arrays.asList("Itzgrund", "Bayreuther Stra\u00dfe", "An den Rotmainauen"));
        this.assertCurbsidesPath(h, p, q, Arrays.asList("any", "any"), 266, Arrays.asList("Itzgrund", "Bayreuther Stra\u00dfe", "An den Rotmainauen"));
        this.assertCurbsidesPath(h, p, q, Arrays.asList("any", ""), 266, Arrays.asList("Itzgrund", "Bayreuther Stra\u00dfe", "An den Rotmainauen"));
        this.assertCurbsidesPath(h, p, q, Collections.emptyList(), 266, Arrays.asList("Itzgrund", "Bayreuther Stra\u00dfe", "An den Rotmainauen"));
        this.assertCurbsidesPath(h, p, p, Arrays.asList("right", "right"), 0, Collections.emptyList());
        this.assertCurbsidesPath(h, p, p, Arrays.asList("right", "any"), 0, Collections.emptyList());
        this.assertCurbsidesPath(h, p, p, Arrays.asList("right", ""), 0, Collections.emptyList());
        this.assertCurbsidesPath(h, p, p, Arrays.asList("any", "right"), 0, Collections.emptyList());
        this.assertCurbsidesPath(h, p, p, Arrays.asList("", "right"), 0, Collections.emptyList());
        this.assertCurbsidesPath(h, p, p, Arrays.asList("left", "left"), 0, Collections.emptyList());
        this.assertCurbsidesPath(h, p, p, Arrays.asList("left", "any"), 0, Collections.emptyList());
        this.assertCurbsidesPath(h, p, p, Arrays.asList("left", ""), 0, Collections.emptyList());
        this.assertCurbsidesPath(h, p, p, Arrays.asList("any", "left"), 0, Collections.emptyList());
        this.assertCurbsidesPath(h, p, p, Arrays.asList("", "left"), 0, Collections.emptyList());
        this.assertCurbsidesPath(h, p, p, Arrays.asList("right", "left"), 1908, Arrays.asList("Itzgrund", "An den Rotmainauen", "An den Rotmainauen", "Bayreuther Stra\u00dfe", "Adam-Seiler-Stra\u00dfe", "Adam-Seiler-Stra\u00dfe", "Friedhofsweg", "Kulmbacher Stra\u00dfe", "An den Rotmainauen", "An den Rotmainauen", "Itzgrund"));
        this.assertCurbsidesPath(h, p, p, Arrays.asList("left", "right"), 855, Arrays.asList("Itzgrund", "Bayreuther Stra\u00dfe", "Adam-Seiler-Stra\u00dfe", "Adam-Seiler-Stra\u00dfe", "Friedhofsweg", "Kulmbacher Stra\u00dfe", "Itzgrund"));
    }

    @Test
    public void testForceCurbsides() {
        GraphHopper h = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"car").setTurnCostsConfig(TurnCostsConfig.car())});
        h.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("car")});
        h.importOrLoad();
        GHPoint p = new GHPoint(43.738399, 7.420782);
        GHPoint q = new GHPoint(43.737949, 7.423523);
        String boulevard = "Boulevard de Suisse";
        String avenue = "Avenue de la Costa";
        this.assertCurbsidesPathError(h, p, q, Arrays.asList("right", "right"), "Impossible curbside constraint: 'curbside=right' at point 0", "strict");
        this.assertCurbsidesPathError(h, p, q, Arrays.asList("right", "left"), "Impossible curbside constraint: 'curbside=right' at point 0", "strict");
        this.assertCurbsidesPath(h, p, q, Arrays.asList("left", "right"), 463, Arrays.asList("Boulevard de Suisse", "Avenue de la Costa"));
        this.assertCurbsidesPathError(h, p, q, Arrays.asList("left", "left"), "Impossible curbside constraint: 'curbside=left' at point 1", "strict");
        this.assertCurbsidesPath(h, p, q, Arrays.asList("any", "any"), 463, Arrays.asList("Boulevard de Suisse", "Avenue de la Costa"));
        this.assertCurbsidesPath(h, p, q, Collections.emptyList(), 463, Arrays.asList("Boulevard de Suisse", "Avenue de la Costa"));
        this.assertCurbsidesPath(h, p, q, Arrays.asList("right", "right"), 463, Arrays.asList("Boulevard de Suisse", "Avenue de la Costa"), "soft");
        this.assertCurbsidesPath(h, p, q, Arrays.asList("right", "left"), 463, Arrays.asList("Boulevard de Suisse", "Avenue de la Costa"), "soft");
        this.assertCurbsidesPath(h, p, q, Arrays.asList("left", "right"), 463, Arrays.asList("Boulevard de Suisse", "Avenue de la Costa"), "soft");
        this.assertCurbsidesPath(h, p, q, Arrays.asList("left", "left"), 463, Arrays.asList("Boulevard de Suisse", "Avenue de la Costa"), "soft");
    }

    private void assertCurbsidesPath(GraphHopper hopper, GHPoint source, GHPoint target, List<String> curbsides, int expectedDistance, List<String> expectedStreets) {
        this.assertCurbsidesPath(hopper, source, target, curbsides, expectedDistance, expectedStreets, "strict");
    }

    private void assertCurbsidesPath(GraphHopper hopper, GHPoint source, GHPoint target, List<String> curbsides, int expectedDistance, List<String> expectedStreets, String curbsideStrictness) {
        GHResponse rsp = this.calcCurbsidePath(hopper, source, target, curbsides, curbsideStrictness);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        ResponsePath path = rsp.getBest();
        ArrayList<String> streets = new ArrayList<String>(path.getInstructions().size());
        for (Instruction instruction : path.getInstructions()) {
            if (Helper.isEmpty((String)instruction.getName())) continue;
            streets.add(instruction.getName());
        }
        Assertions.assertEquals(expectedStreets, streets);
        Assertions.assertEquals((double)expectedDistance, (double)path.getDistance(), (double)1.0);
    }

    private void assertCurbsidesPathError(GraphHopper hopper, GHPoint source, GHPoint target, List<String> curbsides, String errorMessage, String curbsideStrictness) {
        GHResponse rsp = this.calcCurbsidePath(hopper, source, target, curbsides, curbsideStrictness);
        Assertions.assertTrue((boolean)rsp.hasErrors());
        Assertions.assertTrue((boolean)rsp.getErrors().toString().contains(errorMessage), (String)("unexpected error. expected message containing: " + errorMessage + ", but got: " + String.valueOf(rsp.getErrors())));
    }

    private GHResponse calcCurbsidePath(GraphHopper hopper, GHPoint source, GHPoint target, List<String> curbsides, String curbsideStrictness) {
        GHRequest req = new GHRequest(source, target);
        req.putHint("curbside_strictness", (Object)curbsideStrictness);
        req.setProfile("car");
        req.setCurbsides(curbsides);
        return hopper.route(req);
    }

    @Test
    public void testCHWithFiniteUTurnCosts() {
        GraphHopper h = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"my_profile", (String)"car").setTurnCostsConfig(new TurnCostsConfig(List.of("motorcar", "motor_vehicle"), 40))});
        h.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("my_profile")});
        h.importOrLoad();
        GHPoint p = new GHPoint(43.73397, 7.414173);
        GHPoint q = new GHPoint(43.73222, 7.415557);
        GHRequest req = new GHRequest(p, q);
        req.setProfile("my_profile");
        req.setCurbsides(Arrays.asList("right", "right"));
        GHResponse res = h.route(req);
        Assertions.assertFalse((boolean)res.hasErrors(), (String)("routing should not fail but had errors: " + String.valueOf(res.getErrors())));
        Assertions.assertEquals((double)242.5, (double)res.getBest().getRouteWeight(), (double)0.1);
        Assertions.assertEquals((double)1917.0, (double)res.getBest().getDistance(), (double)1.0);
        Assertions.assertEquals((float)163000.0f, (float)res.getBest().getTime(), (float)1000.0f);
    }

    @Test
    public void simplifyWithInstructionsAndPathDetails() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper();
        hopper.setOSMFile(BAYREUTH).setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"profile", (String)"car")}).setGraphHopperLocation(GH_LOCATION);
        hopper.importOrLoad();
        GHRequest req = new GHRequest().addPoint(new GHPoint(50.026932, 11.493201)).addPoint(new GHPoint(50.016895, 11.4923)).addPoint(new GHPoint(50.003464, 11.49157)).setProfile("profile").setPathDetails(Arrays.asList("street_ref", "max_speed"));
        req.putHint("elevation", (Object)true);
        GHResponse rsp = hopper.route(req);
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        ResponsePath path = rsp.getBest();
        Assertions.assertEquals((int)55, (int)path.getPoints().size());
        InstructionList instructions = path.getInstructions();
        int totalLength = 0;
        for (Instruction instruction : instructions) {
            totalLength += instruction.getLength();
        }
        Assertions.assertEquals((int)54, (int)totalLength);
        this.assertInstruction(instructions.get(0), "KU 11", "[0, 4[", 4, 4);
        this.assertInstruction(instructions.get(1), "B 85", "[4, 24[", 20, 20);
        this.assertInstruction(instructions.get(2), null, "[24, 25[", 0, 1);
        this.assertInstruction(instructions.get(3), "B 85", "[24, 45[", 21, 21);
        this.assertInstruction(instructions.get(4), null, "[45, 48[", 3, 3);
        this.assertInstruction(instructions.get(5), "KU 18", "[48, 51[", 3, 3);
        this.assertInstruction(instructions.get(6), "St 2189", "[51, 52[", 1, 1);
        this.assertInstruction(instructions.get(7), null, "[52, 54[", 2, 2);
        this.assertInstruction(instructions.get(8), null, "[54, 55[", 0, 1);
        List speeds = (List)path.getPathDetails().get("max_speed");
        this.assertDetail((PathDetail)speeds.get(0), "null [0, 4]");
        this.assertDetail((PathDetail)speeds.get(1), "70.0 [4, 8]");
        this.assertDetail((PathDetail)speeds.get(2), "100.0 [8, 24]");
        this.assertDetail((PathDetail)speeds.get(3), "100.0 [24, 42]");
        this.assertDetail((PathDetail)speeds.get(4), "80.0 [42, 45]");
        this.assertDetail((PathDetail)speeds.get(5), "null [45, 51]");
        this.assertDetail((PathDetail)speeds.get(6), "50.0 [51, 52]");
        this.assertDetail((PathDetail)speeds.get(7), "null [52, 54]");
        List streetNames = (List)path.getPathDetails().get("street_ref");
        this.assertDetail((PathDetail)streetNames.get(0), "KU 11 [0, 4]");
        this.assertDetail((PathDetail)streetNames.get(1), "B 85 [4, 24]");
        this.assertDetail((PathDetail)streetNames.get(2), "B 85 [24, 45]");
        this.assertDetail((PathDetail)streetNames.get(3), "null [45, 48]");
        this.assertDetail((PathDetail)streetNames.get(4), "KU 18 [48, 51]");
        this.assertDetail((PathDetail)streetNames.get(5), "St 2189 [51, 52]");
        this.assertDetail((PathDetail)streetNames.get(6), "null [52, 54]");
    }

    private void assertInstruction(Instruction instruction, String expectedRef, String expectedInterval, int expectedLength, int expectedPoints) {
        Assertions.assertEquals((Object)expectedRef, instruction.getExtraInfoJSON().get("street_ref"));
        Assertions.assertEquals((Object)expectedInterval, (Object)((ShallowImmutablePointList)instruction.getPoints()).getIntervalString());
        Assertions.assertEquals((int)expectedLength, (int)instruction.getLength());
        Assertions.assertEquals((int)expectedPoints, (int)instruction.getPoints().size());
    }

    private void assertDetail(PathDetail detail, String expected) {
        Assertions.assertEquals((Object)expected, (Object)detail.toString());
    }

    @ParameterizedTest
    @CsvSource(value={"true,true", "true,false", "false,true", "false,false"})
    public void simplifyKeepsWaypoints(boolean elevation, boolean instructions) {
        GraphHopper h = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"car")});
        if (elevation) {
            h.setElevationProvider((ElevationProvider)new SRTMProvider(DIR));
        }
        h.importOrLoad();
        List<GHPoint> reqPoints = Arrays.asList(new GHPoint(43.741736, 7.428043), new GHPoint(43.741248, 7.4274), new GHPoint(43.73906, 7.426694), new GHPoint(43.736337, 7.420592), new GHPoint(43.735585, 7.419734), new GHPoint(43.734857, 7.41909), new GHPoint(43.73389, 7.418578), new GHPoint(43.733204, 7.418755), new GHPoint(43.731969, 7.416949));
        GHRequest req = new GHRequest(reqPoints).setProfile("car");
        req.putHint("instructions", (Object)instructions);
        GHResponse res = h.route(req);
        Assertions.assertFalse((boolean)res.hasErrors());
        Assertions.assertEquals((double)(elevation ? 1829.0 : 1794.0), (double)res.getBest().getDistance(), (double)1.0);
        PointList points = res.getBest().getPoints();
        PointList wayPoints = res.getBest().getWaypoints();
        Assertions.assertEquals((int)reqPoints.size(), (int)wayPoints.size());
        Assertions.assertEquals((Object)points.is3D(), (Object)wayPoints.is3D());
        GraphHopperTest.assertPointlistContainsSublist(points, wayPoints);
    }

    private static void assertPointlistContainsSublist(PointList pointList, PointList subList) {
        int j = 0;
        for (int i = 0; i < pointList.size(); ++i) {
            if (pointList.getLat(i) != subList.getLat(j) || pointList.getLon(i) != subList.getLon(j) || pointList.is3D() && pointList.getEle(i) != subList.getEle(j)) continue;
            ++j;
        }
        if (j != subList.size()) {
            Assertions.fail((String)("point list does not contain point " + j + " of sublist: " + String.valueOf(subList.get(j)) + "\npoint list: " + String.valueOf(pointList) + "\nsublist   : " + String.valueOf(subList)));
        }
    }

    @Test
    public void testNoLoad() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setProfiles(new Profile[]{TestProfiles.constantSpeed((String)profile)});
        IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> hopper.route(new GHRequest(42.0, 10.4, 42.0, 10.0).setProfile(profile)));
        Assertions.assertTrue((boolean)e.getMessage().startsWith("Do a successful call to load or importOrLoad before routing"), (String)e.getMessage());
    }

    @Test
    public void connectionNotFound() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(BAYREUTH).setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"profile", (String)"car")}).setStoreOnFlush(true);
        hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("profile")});
        hopper.setMinNetworkSize(0);
        hopper.importOrLoad();
        GHPoint from = new GHPoint(49.97964, 11.539593);
        GHPoint to = new GHPoint(50.029247, 11.582851);
        GHRequest req = new GHRequest(from, to).setProfile("profile");
        GHResponse res = hopper.route(req);
        Assertions.assertEquals((Object)"[com.graphhopper.util.exceptions.ConnectionNotFoundException: Connection between locations not found]", (Object)res.getErrors().toString());
    }

    @Test
    public void testDoNotInterpolateTwice1645() {
        final AtomicInteger counter = new AtomicInteger(0);
        GraphHopper hopper = new GraphHopper(){

            void interpolateBridgesTunnelsAndFerries() {
                counter.incrementAndGet();
                super.interpolateBridgesTunnelsAndFerries();
            }
        }.setGraphHopperLocation(GH_LOCATION).setOSMFile(BAYREUTH).setProfiles(new Profile[]{new Profile("profile").setCustomModel(new CustomModel().addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)"100")))}).setElevation(true).setStoreOnFlush(true);
        hopper.importOrLoad();
        hopper.flush();
        hopper.close();
        Assertions.assertEquals((int)1, (int)counter.get());
        hopper = new GraphHopper(){

            void interpolateBridgesTunnelsAndFerries() {
                counter.incrementAndGet();
                super.interpolateBridgesTunnelsAndFerries();
            }
        }.setProfiles(new Profile[]{new Profile("profile").setCustomModel(new CustomModel().addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)"100")))}).setElevation(true).setGraphHopperLocation(GH_LOCATION);
        hopper.load();
        Assertions.assertEquals((int)1, (int)counter.get());
    }

    @Test
    public void issue2306_1() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile("../map-matching/files/leipzig_germany.osm.pbf").setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"profile", (String)"car")}).setMinNetworkSize(200);
        hopper.importOrLoad();
        Weighting weighting = hopper.createWeighting(hopper.getProfile("profile"), new PMap());
        DefaultSnapFilter edgeFilter = new DefaultSnapFilter(weighting, hopper.getEncodingManager().getBooleanEncodedValue(Subnetwork.key((String)"profile")));
        LocationIndexTree locationIndex = (LocationIndexTree)hopper.getLocationIndex();
        locationIndex.setMaxRegionSearch(6);
        Snap snap = locationIndex.findClosest(51.229248, 12.328892, (EdgeFilter)edgeFilter);
        Assertions.assertTrue((boolean)snap.isValid());
        Assertions.assertTrue((snap.getQueryDistance() < 3000.0 ? 1 : 0) != 0);
    }

    @Test
    public void issue2306_2() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile("../map-matching/files/leipzig_germany.osm.pbf").setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"profile", (String)"car")}).setMinNetworkSize(200);
        hopper.importOrLoad();
        Weighting weighting = hopper.createWeighting(hopper.getProfile("profile"), new PMap());
        DefaultSnapFilter edgeFilter = new DefaultSnapFilter(weighting, hopper.getEncodingManager().getBooleanEncodedValue(Subnetwork.key((String)"profile")));
        Snap snap = hopper.getLocationIndex().findClosest(51.229248, 12.328892, (EdgeFilter)edgeFilter);
        if (snap.isValid()) {
            Assertions.assertTrue((snap.getQueryDistance() < 3000.0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBarriers() {
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile("../map-matching/files/leipzig_germany.osm.pbf").setEncodedValuesString("car_access|block_private=false,road_access,car_average_speed, bike_access, bike_priority, bike_average_speed, foot_access, foot_priority, foot_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"car"), TestProfiles.accessSpeedAndPriority((String)"bike"), TestProfiles.accessSpeedAndPriority((String)"foot")}).setMinNetworkSize(0);
        hopper.importOrLoad();
        GHResponse bikeRsp = hopper.route(new GHRequest(51.257709, 12.309269, 51.257594, 12.308882).setProfile("bike"));
        Assertions.assertEquals((double)1185.0, (double)bikeRsp.getBest().getDistance(), (double)1.0);
        GHResponse footRsp = hopper.route(new GHRequest(51.257709, 12.309269, 51.257594, 12.308882).setProfile("foot"));
        Assertions.assertEquals((double)28.0, (double)footRsp.getBest().getDistance(), (double)1.0);
        GHResponse carRsp = hopper.route(new GHRequest(51.301113, 12.432168, 51.30123, 12.431728).setProfile("car"));
        Assertions.assertEquals((double)368.0, (double)carRsp.getBest().getDistance(), (double)1.0);
        GHResponse bikeRsp2 = hopper.route(new GHRequest(51.301113, 12.432168, 51.30123, 12.431728).setProfile("bike"));
        Assertions.assertEquals((double)48.0, (double)bikeRsp2.getBest().getDistance(), (double)1.0);
        carRsp = hopper.route(new GHRequest(51.350105, 12.289968, 51.350246, 12.287779).setProfile("car"));
        Assertions.assertEquals((double)285.0, (double)carRsp.getBest().getDistance(), (double)1.0);
        bikeRsp2 = hopper.route(new GHRequest(51.350105, 12.289968, 51.350246, 12.287779).setProfile("bike"));
        Assertions.assertEquals((double)152.0, (double)bikeRsp2.getBest().getDistance(), (double)1.0);
        carRsp = hopper.route(new GHRequest(51.327121, 12.572396, 51.327173, 12.574038).setProfile("car"));
        Assertions.assertEquals((double)124.0, (double)carRsp.getBest().getDistance(), (double)1.0);
        bikeRsp2 = hopper.route(new GHRequest(51.327121, 12.572396, 51.327173, 12.574038).setProfile("bike"));
        Assertions.assertEquals((double)124.0, (double)bikeRsp2.getBest().getDistance(), (double)1.0);
        carRsp = hopper.route(new GHRequest(51.344134, 12.317986, 51.344231, 12.317482).setProfile("car"));
        Assertions.assertEquals((double)36.0, (double)carRsp.getBest().getDistance(), (double)1.0);
        bikeRsp2 = hopper.route(new GHRequest(51.344134, 12.317986, 51.344231, 12.317482).setProfile("bike"));
        Assertions.assertEquals((double)36.0, (double)bikeRsp2.getBest().getDistance(), (double)1.0);
        carRsp = hopper.route(new GHRequest(51.355455, 12.40202, 51.355318, 12.401741).setProfile("car"));
        Assertions.assertEquals((double)24.0, (double)carRsp.getBest().getDistance(), (double)1.0);
        bikeRsp2 = hopper.route(new GHRequest(51.355455, 12.40202, 51.355318, 12.401741).setProfile("bike"));
        Assertions.assertEquals((double)24.0, (double)bikeRsp2.getBest().getDistance(), (double)1.0);
        GHResponse footRsp2 = hopper.route(new GHRequest(51.290141, 12.365849, 51.290996, 12.366155).setProfile("foot"));
        Assertions.assertEquals((double)105.0, (double)footRsp2.getBest().getDistance(), (double)1.0);
        footRsp2 = hopper.route(new GHRequest(51.290141, 12.365849, 51.290996, 12.366155).setCustomModel(new CustomModel().addToPriority(Statement.If((String)"road_environment == FORD", (Statement.Op)Statement.Op.MULTIPLY, (String)"0"))).setProfile("foot"));
        Assertions.assertEquals((double)330.0, (double)footRsp2.getBest().getDistance(), (double)1.0);
        GHResponse rsp = hopper.route(new GHRequest(51.327411, 12.429598, 51.32723, 12.429979).setProfile("car"));
        Assertions.assertEquals((double)39.0, (double)rsp.getBest().getDistance(), (double)1.0);
        rsp = hopper.route(new GHRequest(51.327411, 12.429598, 51.32723, 12.429979).setCustomModel(new CustomModel().addToPriority(Statement.If((String)"road_access == PRIVATE", (Statement.Op)Statement.Op.MULTIPLY, (String)"0"))).setProfile("car"));
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Assertions.assertEquals((double)20.0, (double)rsp.getBest().getDistance(), (double)1.0);
    }

    @Test
    public void turnRestrictionWithSnapToViaEdge_issue2996() {
        String profile = "profile";
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile("../map-matching/files/leipzig_germany.osm.pbf").setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"profile", (String)"car").setTurnCostsConfig(TurnCostsConfig.car())}).setMinNetworkSize(200);
        hopper.importOrLoad();
        GHResponse res = hopper.route(new GHRequest(51.34665, 12.391847, 51.346254, 12.39256).setProfile("profile"));
        Assertions.assertEquals((double)81.0, (double)res.getBest().getDistance(), (double)1.0);
        res = hopper.route(new GHRequest(51.34665, 12.391847, 51.346306, 12.392091).setProfile("profile"));
        Assertions.assertEquals((double)48.0, (double)res.getBest().getDistance(), (double)1.0);
    }

    @Test
    public void germanyCountryRuleAvoidsTracks() {
        String profile = "profile";
        Profile p = TestProfiles.accessAndSpeed((String)"profile", (String)"car");
        p.getCustomModel().addToPriority(Statement.If((String)"road_access == DESTINATION", (Statement.Op)Statement.Op.MULTIPLY, (String)".1"));
        GraphHopper hopper = new GraphHopper().setEncodedValuesString("car_access, car_average_speed, road_access").setProfiles(new Profile[]{p}).setCountryRuleFactory(null).setGraphHopperLocation(GH_LOCATION).setOSMFile(BAYREUTH);
        hopper.importOrLoad();
        GHRequest request = new GHRequest(50.010373, 11.51792, 50.005146, 11.516633);
        request.setProfile("profile");
        GHResponse response = hopper.route(request);
        Assertions.assertFalse((boolean)response.hasErrors());
        double distance = response.getBest().getDistance();
        Assertions.assertEquals((double)1447.0, (double)distance, (double)1.0);
        hopper.clean();
        hopper = new GraphHopper().setEncodedValuesString("car_access, car_average_speed, road_access").setProfiles(new Profile[]{p}).setGraphHopperLocation(GH_LOCATION).setCountryRuleFactory(new CountryRuleFactory()).setOSMFile(BAYREUTH);
        hopper.importOrLoad();
        request = new GHRequest(50.010373, 11.51792, 50.005146, 11.516633);
        request.setProfile("profile");
        response = hopper.route(request);
        Assertions.assertFalse((boolean)response.hasErrors());
        distance = response.getBest().getDistance();
        Assertions.assertEquals((double)4186.0, (double)distance, (double)1.0);
    }

    @Test
    void curbsideWithSubnetwork_issue2502() {
        GraphHopper hopper = new GraphHopper().setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"car").setTurnCostsConfig(TurnCostsConfig.car())}).setGraphHopperLocation(GH_LOCATION).setMinNetworkSize(200).setOSMFile("../core/files/one_way_dead_end.osm.pbf");
        hopper.importOrLoad();
        GHPoint pointA = new GHPoint(28.77428, -81.61593);
        GHPoint pointB = new GHPoint(28.773038, -81.611595);
        GHRequest request = new GHRequest(pointA, pointB);
        request.setProfile("car");
        request.setCurbsides(Arrays.asList("right", "right"));
        GHResponse response = hopper.route(request);
        Assertions.assertFalse((boolean)response.hasErrors(), (String)response.getErrors().toString());
        double distance = response.getBest().getDistance();
        Assertions.assertEquals((double)382.0, (double)distance, (double)1.0);
        request = new GHRequest(pointB, pointA);
        request.setProfile("car");
        request.setCurbsides(Arrays.asList("right", "right"));
        response = hopper.route(request);
        Assertions.assertFalse((boolean)response.hasErrors(), (String)response.getErrors().toString());
        distance = response.getBest().getDistance();
        Assertions.assertEquals((double)2318.0, (double)distance, (double)1.0);
    }

    @Test
    void averageSpeedPathDetailBug() {
        GraphHopper hopper = new GraphHopper().setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"car").setTurnCostsConfig(TurnCostsConfig.car())}).setGraphHopperLocation(GH_LOCATION).setMinNetworkSize(200).setOSMFile(BAYREUTH);
        hopper.importOrLoad();
        GHPoint pointA = new GHPoint(50.020562, 11.500196);
        GHPoint pointB = new GHPoint(50.019935, 11.500567);
        GHPoint pointC = new GHPoint(50.022027, 11.498255);
        GHRequest request = new GHRequest(Arrays.asList(pointA, pointB, pointC));
        request.setProfile("car");
        request.setPathDetails(Collections.singletonList("average_speed"));
        GHResponse response = hopper.route(request);
        Assertions.assertFalse((boolean)response.hasErrors(), (String)response.getErrors().toString());
        double distance = response.getBest().getDistance();
        Assertions.assertEquals((double)467.0, (double)distance, (double)1.0);
    }

    @Test
    void timeDetailBug() {
        GraphHopper hopper = new GraphHopper().setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"car").setTurnCostsConfig(TurnCostsConfig.car())}).setGraphHopperLocation(GH_LOCATION).setMinNetworkSize(200).setOSMFile(BAYREUTH);
        hopper.importOrLoad();
        GHRequest request = new GHRequest(Arrays.asList(new GHPoint(50.020838, 11.494918), new GHPoint(50.024795, 11.498973), new GHPoint(50.023141, 11.496441)));
        request.setProfile("car");
        request.getHints().putObject("instructions", (Object)true);
        request.setPathDetails(Arrays.asList("distance", "time"));
        GHResponse response = hopper.route(request);
        Assertions.assertFalse((boolean)response.hasErrors(), (String)response.getErrors().toString());
        this.consistenceCheck(response.getBest());
    }

    private void consistenceCheck(ResponsePath path) {
        double distance = path.getDistance();
        long time = path.getTime();
        double instructionDistance = 0.0;
        long instructionTime = 0L;
        for (Instruction i : path.getInstructions()) {
            instructionDistance += i.getDistance();
            instructionTime += i.getTime();
        }
        Assertions.assertEquals((long)time, (long)instructionTime);
        Assertions.assertEquals((double)distance, (double)instructionDistance, (double)0.001);
        double pathDetailDistance = 0.0;
        for (PathDetail pd : (List)path.getPathDetails().get("distance")) {
            pathDetailDistance += ((Double)pd.getValue()).doubleValue();
        }
        Assertions.assertEquals((double)distance, (double)pathDetailDistance, (double)0.001);
        long pathDetailTime = 0L;
        for (PathDetail pd : (List)path.getPathDetails().get("time")) {
            pathDetailTime += ((Long)pd.getValue()).longValue();
        }
        Assertions.assertEquals((long)time, (long)pathDetailTime);
    }

    @Test
    public void testLoadGraph_implicitEncodedValues_issue1862() {
        GraphHopper hopper = new GraphHopper().setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"p_car"), TestProfiles.constantSpeed((String)"p_bike")}).setGraphHopperLocation(GH_LOCATION).setOSMFile(BAYREUTH);
        hopper.importOrLoad();
        int nodes = hopper.getBaseGraph().getNodes();
        hopper.close();
        hopper = new GraphHopper().setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"p_car"), TestProfiles.constantSpeed((String)"p_bike")}).setGraphHopperLocation(GH_LOCATION);
        Assertions.assertTrue((boolean)hopper.load());
        hopper.getBaseGraph();
        Assertions.assertEquals((int)nodes, (int)hopper.getBaseGraph().getNodes());
        hopper.close();
        hopper = new GraphHopper().setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"p_car"), TestProfiles.constantSpeed((String)"p_bike")}).setGraphHopperLocation(GH_LOCATION);
        Assertions.assertTrue((boolean)hopper.load());
        Assertions.assertEquals((int)nodes, (int)hopper.getBaseGraph().getNodes());
        hopper.close();
    }

    @Test
    void testLoadingWithAnotherSpeedFactorWorks() {
        GraphHopper hopper = new GraphHopper().setEncodedValuesString("car_average_speed|speed_factor=3, car_access").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"car")}).setGraphHopperLocation(GH_LOCATION).setOSMFile(BAYREUTH);
        hopper.importOrLoad();
        hopper = new GraphHopper().setEncodedValuesString("car_average_speed|speed_factor=9").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"car")}).setGraphHopperLocation(GH_LOCATION);
        hopper.load();
        Assertions.assertEquals((int)2969, (int)hopper.getBaseGraph().getNodes());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void legDistanceWithDuplicateEndpoint(boolean simplifyResponse) {
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"car")}).importOrLoad();
        hopper.getRouterConfig().setSimplifyResponse(simplifyResponse);
        GHRequest request = new GHRequest().setProfile("car");
        request.addPoint(new GHPoint(43.732496, 7.427231));
        request.addPoint(new GHPoint(43.732499, 7.426758));
        request.addPoint(new GHPoint(43.732499, 7.426758));
        request.setPathDetails(List.of("leg_distance"));
        GHResponse routeRsp = hopper.route(request);
        Assertions.assertEquals((int)4, (int)routeRsp.getBest().getPoints().size());
        Assertions.assertEquals((double)40.08, (double)routeRsp.getBest().getDistance(), (double)0.001);
        List p = (List)routeRsp.getBest().getPathDetails().get("leg_distance");
        Assertions.assertEquals((int)2, (int)p.size());
        Assertions.assertEquals((int)0, (int)((PathDetail)p.get(0)).getFirst());
        Assertions.assertEquals((int)3, (int)((PathDetail)p.get(0)).getLast());
        Assertions.assertEquals((double)40.08, (double)((Double)((PathDetail)p.get(0)).getValue()), (double)0.001);
        Assertions.assertEquals((int)3, (int)((PathDetail)p.get(1)).getFirst());
        Assertions.assertEquals((int)3, (int)((PathDetail)p.get(1)).getLast());
        Assertions.assertEquals((double)0.0, (double)((Double)((PathDetail)p.get(1)).getValue()), (double)0.001);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void legDistanceWithDuplicateEndpoint_onlyTwoPoints(boolean simplifyResponse) {
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(GH_LOCATION).setOSMFile(MONACO).setEncodedValuesString("car_access, car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"car")}).importOrLoad();
        hopper.getRouterConfig().setSimplifyResponse(simplifyResponse);
        GHRequest request = new GHRequest().setProfile("car");
        request.addPoint(new GHPoint(43.732399, 7.426658));
        request.addPoint(new GHPoint(43.732499, 7.426758));
        request.addPoint(new GHPoint(43.732499, 7.426758));
        request.setPathDetails(List.of("leg_distance"));
        GHResponse routeRsp = hopper.route(request);
        Assertions.assertEquals((int)2, (int)routeRsp.getBest().getPoints().size());
        Assertions.assertEquals((double)10.439, (double)routeRsp.getBest().getDistance(), (double)0.001);
        List p = (List)routeRsp.getBest().getPathDetails().get("leg_distance");
        Assertions.assertEquals((int)2, (int)p.size());
        Assertions.assertEquals((int)0, (int)((PathDetail)p.get(0)).getFirst());
        Assertions.assertEquals((int)1, (int)((PathDetail)p.get(0)).getLast());
        Assertions.assertEquals((double)10.439, (double)((Double)((PathDetail)p.get(0)).getValue()), (double)0.001);
        Assertions.assertEquals((int)1, (int)((PathDetail)p.get(1)).getFirst());
        Assertions.assertEquals((int)1, (int)((PathDetail)p.get(1)).getLast());
        Assertions.assertEquals((double)0.0, (double)((Double)((PathDetail)p.get(1)).getValue()), (double)0.001);
    }
}

