/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.apache.commons.collections;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.apache.commons.collections.IntFloatBinaryHeap;
import com.graphhopper.coll.BinaryHeapTestInterface;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IntFloatBinaryHeapTest
implements BinaryHeapTestInterface {
    private IntFloatBinaryHeap heap;

    @Override
    public void create(int capacity) {
        this.heap = new IntFloatBinaryHeap(capacity);
    }

    @Override
    public int size() {
        return this.heap.getSize();
    }

    @Override
    public boolean isEmpty() {
        return this.heap.isEmpty();
    }

    @Override
    public void push(int id, float val) {
        this.heap.insert((double)val, id);
    }

    @Override
    public int peekId() {
        return this.heap.peekElement();
    }

    @Override
    public float peekVal() {
        return this.heap.peekKey();
    }

    @Override
    public void update(int id, float val) {
        this.heap.update((double)val, id);
    }

    @Override
    public int poll() {
        return this.heap.poll();
    }

    @Override
    public void clear() {
        this.heap.clear();
    }

    @Test
    public void growIfNeeded() {
        this.create(3);
        this.push(4, 1.6f);
        this.push(8, 1.8f);
        this.push(12, 0.7f);
        this.push(5, 1.2f);
        Assertions.assertEquals((int)4, (int)this.size());
        IntArrayList elements = new IntArrayList();
        while (!this.isEmpty()) {
            elements.add(this.poll());
        }
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{12, 5, 4, 8}), (Object)elements);
    }
}

