/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.apache.commons.lang3;

import com.graphhopper.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringUtilsTest {
    @Test
    public void testGetLevenshteinDistance_StringString() {
        Assertions.assertEquals((int)0, (int)StringUtils.getLevenshteinDistance((CharSequence)"", (CharSequence)""));
        Assertions.assertEquals((int)1, (int)StringUtils.getLevenshteinDistance((CharSequence)"", (CharSequence)"a"));
        Assertions.assertEquals((int)7, (int)StringUtils.getLevenshteinDistance((CharSequence)"aaapppp", (CharSequence)""));
        Assertions.assertEquals((int)1, (int)StringUtils.getLevenshteinDistance((CharSequence)"frog", (CharSequence)"fog"));
        Assertions.assertEquals((int)3, (int)StringUtils.getLevenshteinDistance((CharSequence)"fly", (CharSequence)"ant"));
        Assertions.assertEquals((int)7, (int)StringUtils.getLevenshteinDistance((CharSequence)"elephant", (CharSequence)"hippo"));
        Assertions.assertEquals((int)7, (int)StringUtils.getLevenshteinDistance((CharSequence)"hippo", (CharSequence)"elephant"));
        Assertions.assertEquals((int)8, (int)StringUtils.getLevenshteinDistance((CharSequence)"hippo", (CharSequence)"zzzzzzzz"));
        Assertions.assertEquals((int)8, (int)StringUtils.getLevenshteinDistance((CharSequence)"zzzzzzzz", (CharSequence)"hippo"));
        Assertions.assertEquals((int)1, (int)StringUtils.getLevenshteinDistance((CharSequence)"hello", (CharSequence)"hallo"));
    }

    @Test
    public void testGetLevenshteinDistance_NullString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.getLevenshteinDistance((CharSequence)"a", null));
    }

    @Test
    public void testGetLevenshteinDistance_StringNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.getLevenshteinDistance(null, (CharSequence)"a"));
    }
}

