/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.coll;

import com.graphhopper.coll.GHBitSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractMyBitSetTest {
    public abstract GHBitSet createBitSet(int var1);

    @Test
    public void testCopy() {
        GHBitSet bs = this.createBitSet(100);
        bs.add(100);
        bs.add(70);
        bs.add(30);
        GHBitSet copyBS = this.createBitSet(10);
        copyBS.add(20);
        copyBS.add(40);
        bs.copyTo(copyBS);
        Assertions.assertFalse((boolean)copyBS.contains(20));
        Assertions.assertTrue((boolean)copyBS.contains(30));
        Assertions.assertFalse((boolean)copyBS.contains(40));
        Assertions.assertTrue((boolean)copyBS.contains(70));
        Assertions.assertFalse((boolean)copyBS.contains(0));
        Assertions.assertFalse((boolean)copyBS.contains(91));
        Assertions.assertFalse((boolean)copyBS.contains(90));
        Assertions.assertTrue((boolean)copyBS.contains(100));
        bs = this.createBitSet(100);
        bs.add(0);
        copyBS = this.createBitSet(10);
        bs.copyTo(copyBS);
        Assertions.assertTrue((boolean)copyBS.contains(0));
        Assertions.assertFalse((boolean)copyBS.contains(1));
    }

    @Test
    public void testToString() {
        GHBitSet bs = this.createBitSet(100);
        bs.add(12);
        bs.add(1);
        Assertions.assertEquals((Object)"{1, 12}", (Object)bs.toString());
    }

    @Test
    public void testNext() {
        GHBitSet bs = this.createBitSet(100);
        bs.add(7);
        bs.add(90);
        Assertions.assertEquals((int)7, (int)bs.next(0));
        Assertions.assertEquals((int)7, (int)bs.next(7));
        Assertions.assertEquals((int)90, (int)bs.next(8));
        Assertions.assertEquals((int)-1, (int)bs.next(91));
    }

    @Test
    public void testEnsureCapacity() {
        GHBitSet bs = this.createBitSet(8);
        bs.add(7);
        try {
            bs.add(8);
            Assertions.assertTrue((boolean)false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        bs.add(8);
        bs.add(9);
        Assertions.assertFalse((boolean)bs.contains(6));
        Assertions.assertTrue((boolean)bs.contains(7));
        Assertions.assertTrue((boolean)bs.contains(8));
    }

    @Test
    public void testClear() {
        GHBitSet bs = this.createBitSet(100);
        bs.add(12);
        bs.add(1);
        Assertions.assertTrue((boolean)bs.contains(1));
        Assertions.assertFalse((boolean)bs.contains(2));
        Assertions.assertTrue((boolean)bs.contains(12));
        bs.clear();
        Assertions.assertFalse((boolean)bs.contains(1));
        Assertions.assertFalse((boolean)bs.contains(2));
        Assertions.assertFalse((boolean)bs.contains(12));
        Assertions.assertEquals((int)0, (int)bs.getCardinality());
        bs.add(12);
        bs.add(1);
        Assertions.assertTrue((boolean)bs.contains(1));
        Assertions.assertFalse((boolean)bs.contains(2));
        Assertions.assertTrue((boolean)bs.contains(12));
    }
}

