/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.coll;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntHashSet;
import java.util.PriorityQueue;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public interface BinaryHeapTestInterface {
    public void create(int var1);

    public int size();

    public boolean isEmpty();

    public void push(int var1, float var2);

    public int peekId();

    public float peekVal();

    public void update(int var1, float var2);

    public int poll();

    public void clear();

    @Test
    default public void testSize() {
        this.create(10);
        Assertions.assertEquals((int)0, (int)this.size());
        Assertions.assertTrue((boolean)this.isEmpty());
        this.push(9, 3.6f);
        this.push(5, 2.3f);
        this.push(3, 2.3f);
        Assertions.assertEquals((int)3, (int)this.size());
        Assertions.assertFalse((boolean)this.isEmpty());
    }

    @Test
    default public void testClear() {
        this.create(5);
        Assertions.assertTrue((boolean)this.isEmpty());
        this.push(3, 1.2f);
        this.push(4, 0.3f);
        Assertions.assertEquals((int)2, (int)this.size());
        this.clear();
        Assertions.assertTrue((boolean)this.isEmpty());
        this.push(4, 6.3f);
        this.push(1, 2.1f);
        Assertions.assertEquals((int)2, (int)this.size());
        Assertions.assertEquals((int)1, (int)this.peekId());
        Assertions.assertEquals((float)2.1f, (float)this.peekVal());
        Assertions.assertEquals((int)1, (int)this.poll());
        Assertions.assertEquals((int)4, (int)this.poll());
        Assertions.assertTrue((boolean)this.isEmpty());
    }

    @Test
    default public void testPeek() {
        this.create(5);
        this.push(4, -1.6f);
        this.push(2, 1.3f);
        this.push(1, -5.1f);
        this.push(3, 0.4f);
        Assertions.assertEquals((int)1, (int)this.peekId());
        Assertions.assertEquals((double)-5.1f, (double)this.peekVal(), (double)1.0E-6);
    }

    @Test
    default public void pushAndPoll() {
        this.create(10);
        this.push(9, 3.6f);
        this.push(5, 2.3f);
        this.push(3, 2.3f);
        Assertions.assertEquals((int)3, (int)this.size());
        this.poll();
        Assertions.assertEquals((int)2, (int)this.size());
        this.poll();
        this.poll();
        Assertions.assertTrue((boolean)this.isEmpty());
    }

    @Test
    default public void pollSorted() {
        this.create(10);
        this.push(9, 3.6f);
        this.push(5, 2.1f);
        this.push(3, 2.3f);
        this.push(8, 5.7f);
        this.push(7, 2.2f);
        IntArrayList polled = new IntArrayList();
        while (!this.isEmpty()) {
            polled.add(this.poll());
        }
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 7, 3, 9, 8}), (Object)polled);
    }

    @Test
    default public void update() {
        this.create(10);
        this.push(9, 3.6f);
        this.push(5, 2.1f);
        this.push(3, 2.3f);
        this.update(3, 0.1f);
        Assertions.assertEquals((int)3, (int)this.peekId());
        this.update(3, 10.0f);
        Assertions.assertEquals((int)5, (int)this.peekId());
        this.update(9, -1.3f);
        Assertions.assertEquals((int)9, (int)this.peekId());
        Assertions.assertEquals((double)-1.3f, (double)this.peekVal(), (double)1.0E-6);
        IntArrayList polled = new IntArrayList();
        while (!this.isEmpty()) {
            polled.add(this.poll());
        }
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{9, 5, 3}), (Object)polled);
    }

    @Test
    default public void randomPushsThenPolls() {
        long seed = System.nanoTime();
        Random rnd = new Random(seed);
        int size = 1 + rnd.nextInt(100);
        PriorityQueue<Entry> pq = new PriorityQueue<Entry>(size);
        this.create(size);
        IntHashSet set = new IntHashSet();
        while (pq.size() < size) {
            int id = rnd.nextInt(size);
            if (!set.add(id)) continue;
            float val = 100.0f * rnd.nextFloat();
            pq.add(new Entry(id, val));
            this.push(id, val);
        }
        while (!pq.isEmpty()) {
            Entry entry = (Entry)pq.poll();
            Assertions.assertEquals((float)entry.val, (float)this.peekVal());
            Assertions.assertEquals((int)entry.id, (int)this.poll());
            Assertions.assertEquals((int)pq.size(), (int)this.size());
        }
    }

    @Test
    default public void randomPushsAndPolls() {
        long seed = System.nanoTime();
        Random rnd = new Random(seed);
        int size = 1 + rnd.nextInt(100);
        PriorityQueue<Entry> pq = new PriorityQueue<Entry>(size);
        this.create(size);
        IntHashSet set = new IntHashSet();
        int pushCount = 0;
        for (int i = 0; i < 1000; ++i) {
            boolean push;
            boolean bl = push = pq.isEmpty() || rnd.nextBoolean();
            if (push) {
                int id = rnd.nextInt(size);
                if (!set.add(id)) continue;
                float val = 100.0f * rnd.nextFloat();
                pq.add(new Entry(id, val));
                this.push(id, val);
                ++pushCount;
                continue;
            }
            Entry entry = (Entry)pq.poll();
            Assertions.assertEquals((float)entry.val, (float)this.peekVal());
            Assertions.assertEquals((int)entry.id, (int)this.poll());
            Assertions.assertEquals((int)pq.size(), (int)this.size());
            set.removeAll(entry.id);
        }
        Assertions.assertTrue((pushCount > 0 ? 1 : 0) != 0);
    }

    public static class Entry
    implements Comparable<Entry> {
        int id;
        float val;

        public Entry(int id, float val) {
            this.id = id;
            this.val = val;
        }

        @Override
        public int compareTo(Entry o) {
            return Float.compare(this.val, o.val);
        }
    }
}

