/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.coll;

import com.graphhopper.coll.GHLongLongBTree;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GHLongLongBTreeTest {
    @Test
    public void testThrowException_IfPutting_NoNumber() {
        GHLongLongBTree instance = new GHLongLongBTree(2, 4, -1L);
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> instance.put(1L, -1L));
        Assertions.assertTrue((boolean)ex.getMessage().contains("Value cannot be the 'empty value' -1"));
    }

    @Test
    public void testEmptyValueIfMissing() {
        GHLongLongBTree instance = new GHLongLongBTree(2, 4, -1L);
        long key = 9485854858458484L;
        Assertions.assertEquals((long)-1L, (long)instance.put(key, 21L));
        Assertions.assertEquals((long)21L, (long)instance.get(key));
        Assertions.assertEquals((long)-1L, (long)instance.get(404L));
    }

    @Test
    public void testTwoSplits() {
        GHLongLongBTree instance = new GHLongLongBTree(3, 4, -1L);
        instance.put(1L, 2L);
        instance.put(2L, 4L);
        instance.put(3L, 6L);
        Assertions.assertEquals((int)1, (int)instance.height());
        instance.put(4L, 8L);
        Assertions.assertEquals((int)2, (int)instance.height());
        instance.put(5L, 10L);
        instance.put(6L, 12L);
        instance.put(7L, 14L);
        instance.put(8L, 16L);
        instance.put(9L, 18L);
        Assertions.assertEquals((int)2, (int)instance.height());
        instance.put(10L, 20L);
        Assertions.assertEquals((int)3, (int)instance.height());
        Assertions.assertEquals((int)3, (int)instance.height());
        Assertions.assertEquals((long)10L, (long)instance.getSize());
        Assertions.assertEquals((int)0, (int)instance.getMemoryUsage());
        this.check(instance, 1);
    }

    @Test
    public void testSplitAndOverwrite() {
        GHLongLongBTree instance = new GHLongLongBTree(3, 4, -1L);
        instance.put(1L, 2L);
        instance.put(2L, 4L);
        instance.put(3L, 6L);
        instance.put(2L, 5L);
        Assertions.assertEquals((long)3L, (long)instance.getSize());
        Assertions.assertEquals((int)1, (int)instance.height());
        Assertions.assertEquals((long)5L, (long)instance.get(2L));
        Assertions.assertEquals((long)6L, (long)instance.get(3L));
    }

    void check(GHLongLongBTree instance, int from) {
        int i = from;
        while ((long)i < instance.getSize()) {
            Assertions.assertEquals((long)((long)i * 2L), (long)instance.get((long)i), (String)("idx:" + i));
            ++i;
        }
    }

    @Test
    public void testPut() {
        GHLongLongBTree instance = new GHLongLongBTree(3, 4, -1L);
        instance.put(2L, 4L);
        Assertions.assertEquals((long)4L, (long)instance.get(2L));
        instance.put(7L, 14L);
        Assertions.assertEquals((long)4L, (long)instance.get(2L));
        Assertions.assertEquals((long)14L, (long)instance.get(7L));
        instance.put(5L, 10L);
        instance.put(6L, 12L);
        instance.put(3L, 6L);
        instance.put(4L, 8L);
        instance.put(9L, 18L);
        instance.put(0L, 0L);
        instance.put(1L, 2L);
        instance.put(8L, 16L);
        this.check(instance, 0);
        instance.put(10L, 20L);
        instance.put(11L, 22L);
        Assertions.assertEquals((long)12L, (long)instance.getSize());
        Assertions.assertEquals((int)3, (int)instance.height());
        Assertions.assertEquals((long)12L, (long)instance.get(6L));
        this.check(instance, 0);
    }

    @Test
    public void testUpdate() {
        GHLongLongBTree instance = new GHLongLongBTree(2, 4, -1L);
        long result = instance.put(100L, 10L);
        Assertions.assertEquals((long)instance.getEmptyValue(), (long)result);
        result = instance.get(100L);
        Assertions.assertEquals((long)10L, (long)result);
        result = instance.put(100L, 9L);
        Assertions.assertEquals((long)10L, (long)result);
        result = instance.get(100L);
        Assertions.assertEquals((long)9L, (long)result);
    }

    @Test
    public void testNegativeValues() {
        GHLongLongBTree instance = new GHLongLongBTree(2, 5, -1L);
        byte[] bytes = instance.fromLong(-3L);
        Assertions.assertEquals((long)-3L, (long)instance.toLong(bytes));
        instance.put(0L, -3L);
        instance.put(4L, -2L);
        instance.put(3L, Integer.MIN_VALUE);
        instance.put(2L, -4294967296L);
        instance.put(1L, -8589934592L);
        Assertions.assertEquals((long)-3L, (long)instance.get(0L));
        Assertions.assertEquals((long)-2L, (long)instance.get(4L));
        Assertions.assertEquals((long)-8589934592L, (long)instance.get(1L));
        Assertions.assertEquals((long)-4294967296L, (long)instance.get(2L));
        Assertions.assertEquals((long)Integer.MIN_VALUE, (long)instance.get(3L));
    }

    @Test
    public void testNegativeKey() {
        GHLongLongBTree instance = new GHLongLongBTree(2, 5, -1L);
        instance.put(-3L, 0L);
        instance.put(-2L, 4L);
        instance.put(Integer.MIN_VALUE, 3L);
        instance.put(-4294967296L, 2L);
        instance.put(-8589934592L, 1L);
        Assertions.assertEquals((long)0L, (long)instance.get(-3L));
        Assertions.assertEquals((long)4L, (long)instance.get(-2L));
        Assertions.assertEquals((long)1L, (long)instance.get(-8589934592L));
        Assertions.assertEquals((long)2L, (long)instance.get(-4294967296L));
        Assertions.assertEquals((long)3L, (long)instance.get(Integer.MIN_VALUE));
    }

    @Test
    public void testInternalFromToLong() {
        Random rand = new Random(0L);
        for (int byteCnt = 4; byteCnt < 9; ++byteCnt) {
            for (int i = 0; i < 1000; ++i) {
                GHLongLongBTree instance = new GHLongLongBTree(2, byteCnt, -1L);
                long val = rand.nextLong() % instance.getMaxValue();
                byte[] bytes = instance.fromLong(val);
                Assertions.assertEquals((long)val, (long)instance.toLong(bytes));
            }
        }
    }

    @Test
    public void testDifferentEmptyValue() {
        GHLongLongBTree instance = new GHLongLongBTree(2, 3, -2L);
        instance.put(123L, -1L);
        instance.put(12L, 2L);
        Assertions.assertEquals((long)-2L, (long)instance.get(1234L));
        Assertions.assertEquals((long)-1L, (long)instance.get(123L));
        Assertions.assertEquals((long)2L, (long)instance.get(12L));
    }

    @Test
    public void testLargeValue() {
        GHLongLongBTree instance = new GHLongLongBTree(2, 5, -1L);
        for (int key = 0; key < 100; ++key) {
            long val = 0x80000000L;
            for (int i = 0; i < 8; ++i) {
                instance.put((long)key, val);
                Assertions.assertEquals((long)val, (long)instance.get((long)key), (String)("i:" + i + ", key:" + key + ", val:" + val));
                val *= 2L;
            }
        }
    }

    @Test
    public void testRandom() {
        long seed = System.nanoTime();
        Random rand = new Random(seed);
        int size = 10000;
        for (int bytesPerValue = 4; bytesPerValue <= 8; ++bytesPerValue) {
            for (int j = 3; j < 12; j += 4) {
                int i;
                GHLongLongBTree instance = new GHLongLongBTree(j, bytesPerValue, -1L);
                LinkedHashSet<Integer> addedValues = new LinkedHashSet<Integer>(10000);
                for (i = 0; i < 10000; ++i) {
                    int val = rand.nextInt();
                    addedValues.add(val);
                    try {
                        instance.put((long)val, (long)val);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        Assertions.fail((String)(j + "| Problem with " + i + ", seed: " + seed + " " + String.valueOf(ex)));
                    }
                    Assertions.assertEquals((long)addedValues.size(), (long)instance.getSize(), (String)(j + "| Size not equal to set! In " + i + " added " + val));
                }
                i = 0;
                Iterator iterator = addedValues.iterator();
                while (iterator.hasNext()) {
                    int val = (Integer)iterator.next();
                    Assertions.assertEquals((long)val, (long)instance.get((long)val), (String)(j + "| Problem with " + i));
                    ++i;
                }
                instance.optimize();
                i = 0;
                iterator = addedValues.iterator();
                while (iterator.hasNext()) {
                    int val = (Integer)iterator.next();
                    Assertions.assertEquals((long)val, (long)instance.get((long)val), (String)(j + "| Problem with " + i));
                    ++i;
                }
            }
        }
    }
}

