/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.coll;

import com.graphhopper.coll.BinaryHeapTestInterface;
import com.graphhopper.coll.MinHeapWithUpdate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MinHeapWithUpdateTest
implements BinaryHeapTestInterface {
    private MinHeapWithUpdate heap;

    @Override
    public void create(int capacity) {
        this.heap = new MinHeapWithUpdate(capacity);
    }

    @Override
    public int size() {
        return this.heap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.heap.isEmpty();
    }

    @Override
    public void push(int id, float val) {
        this.heap.push(id, val);
    }

    boolean contains(int id) {
        return this.heap.contains(id);
    }

    @Override
    public int peekId() {
        return this.heap.peekId();
    }

    @Override
    public float peekVal() {
        return this.heap.peekValue();
    }

    @Override
    public void update(int id, float val) {
        this.heap.update(id, val);
    }

    @Override
    public int poll() {
        return this.heap.poll();
    }

    @Override
    public void clear() {
        this.heap.clear();
    }

    @Test
    public void outOfRange() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new MinHeapWithUpdate(4).push(4, 1.2f));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new MinHeapWithUpdate(4).push(-1, 1.2f));
    }

    @Test
    void tooManyElements() {
        this.create(3);
        this.push(1, 0.1f);
        this.push(2, 0.1f);
        this.push(0, 0.1f);
        Assertions.assertThrows(IllegalStateException.class, () -> this.push(1, 0.1f));
        Assertions.assertThrows(IllegalStateException.class, () -> this.push(2, 6.1f));
    }

    @Test
    void duplicateElements() {
        this.create(5);
        this.push(1, 0.2f);
        this.push(0, 0.4f);
        this.push(2, 0.1f);
        Assertions.assertEquals((int)2, (int)this.poll());
        this.push(2, 0.6f);
        Assertions.assertThrows(IllegalStateException.class, () -> this.push(2, 0.4f));
    }

    @Test
    void testContains() {
        this.create(4);
        this.push(1, 0.1f);
        this.push(2, 0.7f);
        this.push(0, 0.5f);
        Assertions.assertFalse((boolean)this.contains(3));
        Assertions.assertTrue((boolean)this.contains(1));
        Assertions.assertEquals((int)1, (int)this.poll());
        Assertions.assertFalse((boolean)this.contains(1));
    }

    @Test
    void containsAfterClear() {
        this.create(4);
        this.push(1, 0.1f);
        this.push(2, 0.1f);
        Assertions.assertEquals((int)2, (int)this.size());
        this.clear();
        Assertions.assertFalse((boolean)this.contains(0));
        Assertions.assertFalse((boolean)this.contains(1));
        Assertions.assertFalse((boolean)this.contains(2));
    }
}

