/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.geohash;

import com.graphhopper.geohash.SpatialKeyAlgo;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.shapes.BBox;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SpatialKeyAlgoTest {
    @Test
    public void testEncode() {
        SpatialKeyAlgo algo = new SpatialKeyAlgo(32, new BBox(-180.0, 180.0, -90.0, 90.0));
        long val = algo.encodeLatLon(-24.2353458404541, 47.23423385620117);
        Assertions.assertEquals((Object)"01100110101000111100000110010100", (Object)BitUtil.LITTLE.toLastBitString(val, 32));
    }

    @Test
    public void testEdgeCases() {
        double minLon = -1.0;
        double maxLon = 1.6;
        double minLat = -1.0;
        double maxLat = 0.5;
        int parts = 4;
        int bits = (int)(Math.log(parts * parts) / Math.log(2.0));
        SpatialKeyAlgo spatialKeyAlgo = new SpatialKeyAlgo(bits, new BBox(minLon, maxLon, minLat, maxLat));
        Assertions.assertEquals((long)11L, (long)spatialKeyAlgo.encodeLatLon(0.125, -0.2));
        Assertions.assertEquals((long)9L, (long)spatialKeyAlgo.encodeLatLon(0.124, -0.2));
        Assertions.assertEquals((long)11L, (long)spatialKeyAlgo.encodeLatLon(0.2, -0.35));
        Assertions.assertEquals((long)10L, (long)spatialKeyAlgo.encodeLatLon(0.2, -0.351));
    }

    @Test
    public void testFourBits() {
        SpatialKeyAlgo spatialKeyAlgo = new SpatialKeyAlgo(4, new BBox(-180.0, 180.0, -90.0, 90.0));
        Assertions.assertEquals((long)0L, (long)spatialKeyAlgo.encode(0, 0));
        Assertions.assertEquals((long)1L, (long)spatialKeyAlgo.encode(1, 0));
        Assertions.assertEquals((long)4L, (long)spatialKeyAlgo.encode(2, 0));
        Assertions.assertEquals((long)5L, (long)spatialKeyAlgo.encode(3, 0));
        Assertions.assertEquals((long)2L, (long)spatialKeyAlgo.encode(0, 1));
        Assertions.assertEquals((long)8L, (long)spatialKeyAlgo.encode(0, 2));
        Assertions.assertEquals((long)10L, (long)spatialKeyAlgo.encode(0, 3));
        Assertions.assertEquals((long)12L, (long)spatialKeyAlgo.encode(2, 2));
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                int[] xy = spatialKeyAlgo.decode(spatialKeyAlgo.encode(x, y));
                Assertions.assertEquals((int)x, (int)xy[0]);
                Assertions.assertEquals((int)y, (int)xy[1]);
            }
        }
        Assertions.assertEquals((long)spatialKeyAlgo.encode(2, 0), (long)spatialKeyAlgo.right(spatialKeyAlgo.right(spatialKeyAlgo.encode(0, 0))));
    }

    @Test
    public void testTwentyBits() {
        SpatialKeyAlgo spatialKeyAlgo = new SpatialKeyAlgo(20, new BBox(-180.0, 180.0, -90.0, 90.0));
        Assertions.assertEquals((long)1048575L, (long)spatialKeyAlgo.encode(1023, 1023));
        for (int x = 0; x < 1024; ++x) {
            for (int y = 0; y < 1024; ++y) {
                int[] xy = spatialKeyAlgo.decode(spatialKeyAlgo.encode(x, y));
                Assertions.assertEquals((int)x, (int)xy[0]);
                Assertions.assertEquals((int)y, (int)xy[1]);
            }
        }
    }
}

