/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.isochrone.algorithm;

import com.graphhopper.isochrone.algorithm.ContourBuilder;
import com.graphhopper.isochrone.algorithm.ReadableQuadEdge;
import com.graphhopper.isochrone.algorithm.ReadableTriangulation;
import com.graphhopper.isochrone.algorithm.Triangulation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.triangulate.IncrementalDelaunayTriangulator;
import org.locationtech.jts.triangulate.quadedge.QuadEdge;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;
import org.locationtech.jts.triangulate.quadedge.Vertex;

public class QuadEdgeSubdivisionTest {
    @Test
    public void testJtsDelaunayTriangulator() {
        Vertex v1 = new Vertex(0.0, 0.0, 0.0);
        Vertex v2 = new Vertex(1.0, -1.0, 1.0);
        Vertex v3 = new Vertex(1.0, 1.0, 0.0);
        Vertex v4 = new Vertex(2.0, 0.0, 0.0);
        Vertex v5 = new Vertex(1.0, -3.0, 0.0);
        QuadEdgeSubdivision quadEdgeSubdivision = new QuadEdgeSubdivision(new Envelope(0.0, 2.0, -1.0, 1.0), 0.001);
        IncrementalDelaunayTriangulator triangulator = new IncrementalDelaunayTriangulator(quadEdgeSubdivision);
        triangulator.insertSite(v1);
        triangulator.insertSite(v2);
        triangulator.insertSite(v3);
        triangulator.insertSite(v4);
        triangulator.insertSite(v5);
        Assertions.assertEquals((int)5, (int)quadEdgeSubdivision.getVertices(false).size());
    }

    @Test
    public void createQuadEdgeSubdivisionFromScratch() {
        Vertex v1 = new Vertex(0.0, 0.0, 0.0);
        Vertex v2 = new Vertex(1.0, -1.0, 1.0);
        Vertex v3 = new Vertex(1.0, 1.0, 0.0);
        Vertex v4 = new Vertex(2.0, 0.0, 0.0);
        QuadEdgeSubdivision quadEdgeSubdivision = new QuadEdgeSubdivision(new Envelope(0.0, 2.0, -1.0, 1.0), 0.001);
        QuadEdge e1 = quadEdgeSubdivision.makeEdge(v1, v3);
        QuadEdge e2 = quadEdgeSubdivision.makeEdge(v3, v2);
        QuadEdge.splice((QuadEdge)e1.sym(), (QuadEdge)e2);
        QuadEdge e3 = quadEdgeSubdivision.connect(e2, e1);
        QuadEdge e4 = quadEdgeSubdivision.makeEdge(v4, v2);
        QuadEdge.splice((QuadEdge)e2.sym(), (QuadEdge)e4.lNext());
        QuadEdge e41 = quadEdgeSubdivision.connect(e2.sym(), e4);
        Vertex v5 = new Vertex(1.0, -3.0, 0.0);
        QuadEdge e5 = quadEdgeSubdivision.makeEdge(v5, v1);
        QuadEdge.splice((QuadEdge)e3.sym(), (QuadEdge)e5.lNext());
        QuadEdge e6 = quadEdgeSubdivision.connect(e3.sym(), e5);
        QuadEdge e7 = quadEdgeSubdivision.connect(e4.sym(), e6.sym());
        this.assertTriangle((ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e1), (ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e2), (ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e3));
        this.assertTriangle((ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e4), (ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e2.sym()), (ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e41));
        this.assertTriangle((ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e5), (ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e3.sym()), (ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e6));
        this.assertTriangle((ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e6.sym()), (ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e4.sym()), (ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e7));
        this.assertVertex((ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e1), (ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e3.sym()), (ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e5.sym()));
        this.assertVertex((ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e5), (ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e6.sym()), (ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e7.sym()));
        this.assertVertex((ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e7), (ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e4), (ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e41.sym()));
        this.assertVertex((ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e41), (ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e2), (ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e1.sym()));
        this.assertVertex((ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e3), (ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e2.sym()), (ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e4.sym()), (ReadableQuadEdge)ReadableQuadEdge.wrap((QuadEdge)e6));
        ReadableTriangulation triangulation = ReadableTriangulation.wrap((QuadEdgeSubdivision)quadEdgeSubdivision);
        ContourBuilder contourBuilder = new ContourBuilder(triangulation);
        MultiPolygon geometry = contourBuilder.computeIsoline(0.5, triangulation.getEdges());
        Assertions.assertEquals((Object)"MULTIPOLYGON (((1 0, 0.5 -0.5, 1 -2, 1.5 -0.5, 1 0)))", (Object)geometry.toString());
    }

    @Test
    public void createQuadEdgeSubdivisionFromTriangleList() {
        Triangulation triangulation = new Triangulation();
        triangulation.getVertices().put(1, (Object)new Vertex(0.0, 0.0, 0.0));
        triangulation.getVertices().put(2, (Object)new Vertex(1.0, -1.0, 1.0));
        triangulation.getVertices().put(3, (Object)new Vertex(1.0, 1.0, 0.0));
        triangulation.getVertices().put(4, (Object)new Vertex(2.0, 0.0, 0.0));
        triangulation.getVertices().put(5, (Object)new Vertex(1.0, -3.0, 0.0));
        triangulation.makeTriangle(1, 3, 2);
        triangulation.makeTriangle(1, 2, 5);
        triangulation.makeTriangle(2, 4, 5);
        triangulation.makeTriangle(3, 4, 2);
        ReadableTriangulation readableTriangulation = ReadableTriangulation.wrap((Triangulation)triangulation);
        ReadableQuadEdge e1 = readableTriangulation.getEdge(1, 3);
        ReadableQuadEdge e2 = readableTriangulation.getEdge(3, 2);
        ReadableQuadEdge e3 = readableTriangulation.getEdge(2, 1);
        ReadableQuadEdge e4 = readableTriangulation.getEdge(4, 2);
        ReadableQuadEdge e41 = readableTriangulation.getEdge(3, 4);
        ReadableQuadEdge e5 = readableTriangulation.getEdge(5, 1);
        ReadableQuadEdge e6 = readableTriangulation.getEdge(2, 5);
        ReadableQuadEdge e7 = readableTriangulation.getEdge(4, 5);
        this.assertTriangle(e1, e2, e3);
        this.assertTriangle(e4, e2.sym(), e41);
        this.assertTriangle(e5, e3.sym(), e6);
        this.assertTriangle(e6.sym(), e4.sym(), e7);
        this.assertVertex(e1, e3.sym(), e5.sym());
        this.assertVertex(e5, e6.sym(), e7.sym());
        this.assertVertex(e7, e4, e41.sym());
        this.assertVertex(e41, e2, e1.sym());
        this.assertVertex(e3, e2.sym(), e4.sym(), e6);
        ReadableTriangulation triangulation1 = ReadableTriangulation.wrap((Triangulation)triangulation);
        ContourBuilder contourBuilder = new ContourBuilder(triangulation1);
        MultiPolygon geometry = contourBuilder.computeIsoline(0.5, triangulation1.getEdges());
        Assertions.assertEquals((Object)"MULTIPOLYGON (((0.5 -0.5, 1 -2, 1.5 -0.5, 1 0, 0.5 -0.5)))", (Object)geometry.toString());
    }

    @Test
    public void createQuadEdgeSubdivisionFromTriangleList2() {
        Triangulation triangulation = new Triangulation();
        triangulation.getVertices().put(0, (Object)new Vertex(0.0, -1.0, 0.0));
        triangulation.getVertices().put(1, (Object)new Vertex(0.0, 0.0, 0.0));
        triangulation.getVertices().put(2, (Object)new Vertex(1.0, -1.0, 1.0));
        triangulation.getVertices().put(3, (Object)new Vertex(1.0, 1.0, 0.0));
        triangulation.getVertices().put(4, (Object)new Vertex(2.0, 0.0, 0.0));
        triangulation.getVertices().put(5, (Object)new Vertex(1.0, -3.0, 0.0));
        triangulation.makeTriangle(0, 3, 1);
        triangulation.makeTriangle(1, 2, 5);
        triangulation.makeTriangle(2, 4, 5);
        triangulation.makeTriangle(3, 4, 2);
        triangulation.makeTriangle(1, 3, 2);
        ReadableTriangulation readableTriangulation = ReadableTriangulation.wrap((Triangulation)triangulation);
        ReadableQuadEdge e1 = readableTriangulation.getEdge(1, 3);
        ReadableQuadEdge e2 = readableTriangulation.getEdge(3, 2);
        ReadableQuadEdge e3 = readableTriangulation.getEdge(2, 1);
        ReadableQuadEdge e4 = readableTriangulation.getEdge(4, 2);
        ReadableQuadEdge e41 = readableTriangulation.getEdge(3, 4);
        ReadableQuadEdge e5 = readableTriangulation.getEdge(5, 1);
        ReadableQuadEdge e6 = readableTriangulation.getEdge(2, 5);
        ReadableQuadEdge e7 = readableTriangulation.getEdge(4, 5);
        ReadableQuadEdge e0 = readableTriangulation.getEdge(1, 0);
        ReadableQuadEdge e00 = readableTriangulation.getEdge(3, 0);
        this.assertTriangle(e1, e2, e3);
        this.assertTriangle(e4, e2.sym(), e41);
        this.assertTriangle(e5, e3.sym(), e6);
        this.assertTriangle(e6.sym(), e4.sym(), e7);
        this.assertVertex(e1, e3.sym(), e5.sym(), e0);
        this.assertVertex(e5, e6.sym(), e7.sym());
        this.assertVertex(e7, e4, e41.sym());
        this.assertVertex(e41, e2, e1.sym(), e00);
        this.assertVertex(e3, e2.sym(), e4.sym(), e6);
        ReadableTriangulation triangulation1 = ReadableTriangulation.wrap((Triangulation)triangulation);
        ContourBuilder contourBuilder = new ContourBuilder(triangulation1);
        MultiPolygon geometry = contourBuilder.computeIsoline(0.5, triangulation1.getEdges());
        Assertions.assertEquals((Object)"MULTIPOLYGON (((0.5 -0.5, 1 -2, 1.5 -0.5, 1 0, 0.5 -0.5)))", (Object)geometry.toString());
    }

    private void assertVertex(ReadableQuadEdge ee1, ReadableQuadEdge ee2, ReadableQuadEdge ee3) {
        Assertions.assertEquals((Object)ee2, (Object)ee1.oNext());
        Assertions.assertEquals((Object)ee3, (Object)ee2.oNext());
        Assertions.assertEquals((Object)ee1, (Object)ee3.oNext());
    }

    private void assertVertex(ReadableQuadEdge ee1, ReadableQuadEdge ee2, ReadableQuadEdge ee3, ReadableQuadEdge ee4) {
        Assertions.assertEquals((Object)ee2, (Object)ee1.oNext());
        Assertions.assertEquals((Object)ee3, (Object)ee2.oNext());
        Assertions.assertEquals((Object)ee4, (Object)ee3.oNext());
        Assertions.assertEquals((Object)ee1, (Object)ee4.oNext());
    }

    private void assertTriangle(ReadableQuadEdge e1, ReadableQuadEdge e2, ReadableQuadEdge e3) {
        Assertions.assertEquals((Object)e2, (Object)e1.lNext());
        Assertions.assertEquals((Object)e3, (Object)e2.lNext());
        Assertions.assertEquals((Object)e1, (Object)e3.lNext());
    }
}

