/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.isochrone.algorithm;

import com.graphhopper.isochrone.algorithm.ShortestPathTree;
import com.graphhopper.json.Statement;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.SimpleBooleanEncodedValue;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.routing.weighting.custom.CustomModelParser;
import com.graphhopper.routing.weighting.custom.CustomWeighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class ShortestPathTreeTest {
    public static final TurnCostProvider FORBIDDEN_UTURNS = new TurnCostProvider(){

        public double calcTurnWeight(int inEdge, int viaNode, int outEdge) {
            return inEdge == outEdge ? Double.POSITIVE_INFINITY : 0.0;
        }

        public long calcTurnMillis(int inEdge, int viaNode, int outEdge) {
            return 0L;
        }
    };
    private final BooleanEncodedValue accessEnc = new SimpleBooleanEncodedValue("access", true);
    private final DecimalEncodedValue speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, false);
    private final BooleanEncodedValue ferryEnc = new SimpleBooleanEncodedValue("ferry", false);
    private final EncodingManager encodingManager = EncodingManager.start().add((EncodedValue)this.accessEnc).add((EncodedValue)this.speedEnc).add((EncodedValue)this.ferryEnc).build();
    private BaseGraph graph;

    private Weighting createWeighting() {
        return this.createWeighting(TurnCostProvider.NO_TURN_COST_PROVIDER);
    }

    private Weighting createWeighting(TurnCostProvider turnCostProvider) {
        return CustomModelParser.createWeighting((EncodedValueLookup)this.encodingManager, (TurnCostProvider)turnCostProvider, (CustomModel)this.createBaseCustomModel());
    }

    private CustomModel createBaseCustomModel() {
        CustomModel customModel = new CustomModel();
        customModel.addToPriority(Statement.If((String)("!" + this.accessEnc.getName()), (Statement.Op)Statement.Op.MULTIPLY, (String)"0"));
        customModel.addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)this.speedEnc.getName()));
        return customModel;
    }

    @BeforeEach
    public void setUp() {
        this.graph = new BaseGraph.Builder(this.encodingManager).create();
        GHUtility.setSpeed((double)10.0, (boolean)true, (boolean)false, (BooleanEncodedValue)this.accessEnc, (DecimalEncodedValue)this.speedEnc, (EdgeIteratorState)this.graph.edge(0, 1).setDistance(70.0));
        GHUtility.setSpeed((double)20.0, (boolean)true, (boolean)false, (BooleanEncodedValue)this.accessEnc, (DecimalEncodedValue)this.speedEnc, (EdgeIteratorState)this.graph.edge(0, 4).setDistance(50.0));
        GHUtility.setSpeed((double)10.0, (boolean)true, (boolean)true, (BooleanEncodedValue)this.accessEnc, (DecimalEncodedValue)this.speedEnc, (EdgeIteratorState)this.graph.edge(1, 4).setDistance(70.0));
        GHUtility.setSpeed((double)10.0, (boolean)true, (boolean)true, (BooleanEncodedValue)this.accessEnc, (DecimalEncodedValue)this.speedEnc, (EdgeIteratorState)this.graph.edge(1, 5).setDistance(70.0));
        GHUtility.setSpeed((double)10.0, (boolean)true, (boolean)true, (BooleanEncodedValue)this.accessEnc, (DecimalEncodedValue)this.speedEnc, (EdgeIteratorState)this.graph.edge(1, 2).setDistance(200.0));
        GHUtility.setSpeed((double)10.0, (boolean)true, (boolean)false, (BooleanEncodedValue)this.accessEnc, (DecimalEncodedValue)this.speedEnc, (EdgeIteratorState)this.graph.edge(5, 2).setDistance(50.0));
        GHUtility.setSpeed((double)10.0, (boolean)true, (boolean)false, (BooleanEncodedValue)this.accessEnc, (DecimalEncodedValue)this.speedEnc, (EdgeIteratorState)this.graph.edge(2, 3).setDistance(50.0));
        GHUtility.setSpeed((double)20.0, (boolean)true, (boolean)false, (BooleanEncodedValue)this.accessEnc, (DecimalEncodedValue)this.speedEnc, (EdgeIteratorState)this.graph.edge(5, 3).setDistance(110.0));
        GHUtility.setSpeed((double)10.0, (boolean)true, (boolean)false, (BooleanEncodedValue)this.accessEnc, (DecimalEncodedValue)this.speedEnc, (EdgeIteratorState)this.graph.edge(3, 7).setDistance(70.0));
        GHUtility.setSpeed((double)20.0, (boolean)true, (boolean)false, (BooleanEncodedValue)this.accessEnc, (DecimalEncodedValue)this.speedEnc, (EdgeIteratorState)this.graph.edge(4, 6).setDistance(50.0));
        GHUtility.setSpeed((double)10.0, (boolean)true, (boolean)false, (BooleanEncodedValue)this.accessEnc, (DecimalEncodedValue)this.speedEnc, (EdgeIteratorState)this.graph.edge(5, 4).setDistance(70.0));
        GHUtility.setSpeed((double)10.0, (boolean)true, (boolean)false, (BooleanEncodedValue)this.accessEnc, (DecimalEncodedValue)this.speedEnc, (EdgeIteratorState)this.graph.edge(5, 6).setDistance(70.0));
        GHUtility.setSpeed((double)20.0, (boolean)true, (boolean)false, (BooleanEncodedValue)this.accessEnc, (DecimalEncodedValue)this.speedEnc, (EdgeIteratorState)this.graph.edge(7, 5).setDistance(50.0));
        GHUtility.setSpeed((double)20.0, (boolean)true, (boolean)true, (BooleanEncodedValue)this.accessEnc, (DecimalEncodedValue)this.speedEnc, (EdgeIteratorState)this.graph.edge(6, 7).setDistance(50.0));
        GHUtility.setSpeed((double)20.0, (boolean)true, (boolean)true, (BooleanEncodedValue)this.accessEnc, (DecimalEncodedValue)this.speedEnc, (EdgeIteratorState)this.graph.edge(3, 8).setDistance(25.0));
    }

    private int countDirectedEdges(BaseGraph graph) {
        int result = 0;
        AllEdgesIterator iter = graph.getAllEdges();
        while (iter.next()) {
            if (iter.get(this.accessEnc)) {
                ++result;
            }
            if (!iter.getReverse(this.accessEnc)) continue;
            ++result;
        }
        return result;
    }

    @AfterEach
    public void tearDown() {
        this.graph.close();
    }

    @Test
    public void testSPTAndIsochrone25Seconds() {
        ArrayList result = new ArrayList();
        ShortestPathTree instance = new ShortestPathTree((Graph)this.graph, this.createWeighting(), false, TraversalMode.NODE_BASED);
        instance.setTimeLimit(25000.0);
        instance.search(0, result::add);
        Assertions.assertEquals((int)3, (int)result.size());
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((long)0L, (long)((ShortestPathTree.IsoLabel)result.get((int)0)).time), () -> Assertions.assertEquals((int)0, (int)((ShortestPathTree.IsoLabel)result.get((int)0)).node), () -> Assertions.assertEquals((long)9000L, (long)((ShortestPathTree.IsoLabel)result.get((int)1)).time), () -> Assertions.assertEquals((int)4, (int)((ShortestPathTree.IsoLabel)result.get((int)1)).node), () -> Assertions.assertEquals((long)18000L, (long)((ShortestPathTree.IsoLabel)result.get((int)2)).time), () -> Assertions.assertEquals((int)6, (int)((ShortestPathTree.IsoLabel)result.get((int)2)).node)});
        Collection isochroneEdges = instance.getIsochroneEdges();
        Assertions.assertArrayEquals((int[])new int[]{1, 7}, (int[])isochroneEdges.stream().mapToInt(l -> l.node).sorted().toArray());
    }

    @Test
    public void testSPT26Seconds() {
        ArrayList result = new ArrayList();
        ShortestPathTree instance = new ShortestPathTree((Graph)this.graph, this.createWeighting(), false, TraversalMode.NODE_BASED);
        instance.setTimeLimit(26000.0);
        instance.search(0, result::add);
        Assertions.assertEquals((int)4, (int)result.size());
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((long)0L, (long)((ShortestPathTree.IsoLabel)result.get((int)0)).time), () -> Assertions.assertEquals((long)9000L, (long)((ShortestPathTree.IsoLabel)result.get((int)1)).time), () -> Assertions.assertEquals((long)18000L, (long)((ShortestPathTree.IsoLabel)result.get((int)2)).time), () -> Assertions.assertEquals((long)25200L, (long)((ShortestPathTree.IsoLabel)result.get((int)3)).time)});
    }

    @Test
    public void testNoTimeLimit() {
        ArrayList result = new ArrayList();
        ShortestPathTree instance = new ShortestPathTree((Graph)this.graph, this.createWeighting(), false, TraversalMode.NODE_BASED);
        instance.setTimeLimit(Double.MAX_VALUE);
        instance.search(0, result::add);
        Assertions.assertEquals((int)9, (int)result.size());
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((long)0L, (long)((ShortestPathTree.IsoLabel)result.get((int)0)).time), () -> Assertions.assertEquals((int)0, (int)((ShortestPathTree.IsoLabel)result.get((int)0)).node), () -> Assertions.assertEquals((long)9000L, (long)((ShortestPathTree.IsoLabel)result.get((int)1)).time), () -> Assertions.assertEquals((int)4, (int)((ShortestPathTree.IsoLabel)result.get((int)1)).node), () -> Assertions.assertEquals((long)18000L, (long)((ShortestPathTree.IsoLabel)result.get((int)2)).time), () -> Assertions.assertEquals((int)6, (int)((ShortestPathTree.IsoLabel)result.get((int)2)).node), () -> Assertions.assertEquals((long)25200L, (long)((ShortestPathTree.IsoLabel)result.get((int)3)).time), () -> Assertions.assertEquals((int)1, (int)((ShortestPathTree.IsoLabel)result.get((int)3)).node), () -> Assertions.assertEquals((long)27000L, (long)((ShortestPathTree.IsoLabel)result.get((int)4)).time), () -> Assertions.assertEquals((int)7, (int)((ShortestPathTree.IsoLabel)result.get((int)4)).node), () -> Assertions.assertEquals((long)36000L, (long)((ShortestPathTree.IsoLabel)result.get((int)5)).time), () -> Assertions.assertEquals((int)5, (int)((ShortestPathTree.IsoLabel)result.get((int)5)).node), () -> Assertions.assertEquals((long)54000L, (long)((ShortestPathTree.IsoLabel)result.get((int)6)).time), () -> Assertions.assertEquals((int)2, (int)((ShortestPathTree.IsoLabel)result.get((int)6)).node), () -> Assertions.assertEquals((long)55800L, (long)((ShortestPathTree.IsoLabel)result.get((int)7)).time), () -> Assertions.assertEquals((int)3, (int)((ShortestPathTree.IsoLabel)result.get((int)7)).node), () -> Assertions.assertEquals((long)60300L, (long)((ShortestPathTree.IsoLabel)result.get((int)8)).time), () -> Assertions.assertEquals((int)8, (int)((ShortestPathTree.IsoLabel)result.get((int)8)).node)});
    }

    @Test
    public void testFerry() {
        AllEdgesIterator allEdges = this.graph.getAllEdges();
        while (allEdges.next()) {
            allEdges.set(this.ferryEnc, false);
        }
        EdgeIteratorState edge = this.findEdge(6, 7);
        edge.set(this.ferryEnc, true);
        ArrayList result = new ArrayList();
        CustomModel customModel = this.createBaseCustomModel();
        customModel.addToPriority(Statement.If((String)"ferry", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.005"));
        CustomWeighting weighting = CustomModelParser.createWeighting((EncodedValueLookup)this.encodingManager, (TurnCostProvider)TurnCostProvider.NO_TURN_COST_PROVIDER, (CustomModel)customModel);
        ShortestPathTree instance = new ShortestPathTree((Graph)this.graph, (Weighting)weighting, false, TraversalMode.NODE_BASED);
        instance.setTimeLimit(30000.0);
        instance.search(0, result::add);
        Assertions.assertEquals((int)4, (int)result.size());
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((long)0L, (long)((ShortestPathTree.IsoLabel)result.get((int)0)).time), () -> Assertions.assertEquals((int)0, (int)((ShortestPathTree.IsoLabel)result.get((int)0)).node), () -> Assertions.assertEquals((long)9000L, (long)((ShortestPathTree.IsoLabel)result.get((int)1)).time), () -> Assertions.assertEquals((int)4, (int)((ShortestPathTree.IsoLabel)result.get((int)1)).node), () -> Assertions.assertEquals((long)18000L, (long)((ShortestPathTree.IsoLabel)result.get((int)2)).time), () -> Assertions.assertEquals((int)6, (int)((ShortestPathTree.IsoLabel)result.get((int)2)).node), () -> Assertions.assertEquals((long)25200L, (long)((ShortestPathTree.IsoLabel)result.get((int)3)).time), () -> Assertions.assertEquals((int)1, (int)((ShortestPathTree.IsoLabel)result.get((int)3)).node)});
        Assertions.assertEquals((int)7, (int)instance.getVisitedNodes(), (String)"If this increases, make sure we are not traversing entire graph irl");
    }

    @Test
    public void testEdgeBasedWithFreeUTurns() {
        ArrayList result = new ArrayList();
        ShortestPathTree instance = new ShortestPathTree((Graph)this.graph, this.createWeighting(), false, TraversalMode.EDGE_BASED);
        instance.setTimeLimit(Double.MAX_VALUE);
        instance.search(0, result::add);
        Assertions.assertEquals((int)(this.countDirectedEdges(this.graph) + 1), (int)result.size());
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((long)0L, (long)((ShortestPathTree.IsoLabel)result.get((int)0)).time), () -> Assertions.assertEquals((long)9000L, (long)((ShortestPathTree.IsoLabel)result.get((int)1)).time), () -> Assertions.assertEquals((long)18000L, (long)((ShortestPathTree.IsoLabel)result.get((int)2)).time), () -> Assertions.assertEquals((long)25200L, (long)((ShortestPathTree.IsoLabel)result.get((int)3)).time), () -> Assertions.assertEquals((long)27000L, (long)((ShortestPathTree.IsoLabel)result.get((int)4)).time), () -> Assertions.assertEquals((long)34200L, (long)((ShortestPathTree.IsoLabel)result.get((int)5)).time), () -> Assertions.assertEquals((long)36000L, (long)((ShortestPathTree.IsoLabel)result.get((int)6)).time), () -> Assertions.assertEquals((long)36000L, (long)((ShortestPathTree.IsoLabel)result.get((int)7)).time), () -> Assertions.assertEquals((long)50400L, (long)((ShortestPathTree.IsoLabel)result.get((int)8)).time), () -> Assertions.assertEquals((long)50400L, (long)((ShortestPathTree.IsoLabel)result.get((int)9)).time), () -> Assertions.assertEquals((long)54000L, (long)((ShortestPathTree.IsoLabel)result.get((int)10)).time), () -> Assertions.assertEquals((long)55800L, (long)((ShortestPathTree.IsoLabel)result.get((int)11)).time), () -> Assertions.assertEquals((long)60300L, (long)((ShortestPathTree.IsoLabel)result.get((int)12)).time), () -> Assertions.assertEquals((long)61200L, (long)((ShortestPathTree.IsoLabel)result.get((int)13)).time), () -> Assertions.assertEquals((long)61200L, (long)((ShortestPathTree.IsoLabel)result.get((int)14)).time), () -> Assertions.assertEquals((long)61200L, (long)((ShortestPathTree.IsoLabel)result.get((int)15)).time), () -> Assertions.assertEquals((long)64800L, (long)((ShortestPathTree.IsoLabel)result.get((int)16)).time), () -> Assertions.assertEquals((long)72000L, (long)((ShortestPathTree.IsoLabel)result.get((int)17)).time), () -> Assertions.assertEquals((long)81000L, (long)((ShortestPathTree.IsoLabel)result.get((int)18)).time), () -> Assertions.assertEquals((long)97200L, (long)((ShortestPathTree.IsoLabel)result.get((int)19)).time), () -> Assertions.assertEquals((long)126000L, (long)((ShortestPathTree.IsoLabel)result.get((int)20)).time)});
    }

    @Test
    public void testEdgeBasedWithForbiddenUTurns() {
        Weighting fastestWeighting = this.createWeighting(FORBIDDEN_UTURNS);
        ArrayList result = new ArrayList();
        ShortestPathTree instance = new ShortestPathTree((Graph)this.graph, fastestWeighting, false, TraversalMode.EDGE_BASED);
        instance.setTimeLimit(Double.MAX_VALUE);
        instance.search(0, result::add);
        Assertions.assertEquals((int)(this.countDirectedEdges(this.graph) + 1 - 1), (int)result.size());
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((long)0L, (long)((ShortestPathTree.IsoLabel)result.get((int)0)).time), () -> Assertions.assertEquals((long)9000L, (long)((ShortestPathTree.IsoLabel)result.get((int)1)).time), () -> Assertions.assertEquals((long)18000L, (long)((ShortestPathTree.IsoLabel)result.get((int)2)).time), () -> Assertions.assertEquals((long)25200L, (long)((ShortestPathTree.IsoLabel)result.get((int)3)).time), () -> Assertions.assertEquals((long)27000L, (long)((ShortestPathTree.IsoLabel)result.get((int)4)).time), () -> Assertions.assertEquals((long)34200L, (long)((ShortestPathTree.IsoLabel)result.get((int)5)).time), () -> Assertions.assertEquals((long)36000L, (long)((ShortestPathTree.IsoLabel)result.get((int)6)).time), () -> Assertions.assertEquals((long)50400L, (long)((ShortestPathTree.IsoLabel)result.get((int)7)).time), () -> Assertions.assertEquals((long)50400L, (long)((ShortestPathTree.IsoLabel)result.get((int)8)).time), () -> Assertions.assertEquals((long)54000L, (long)((ShortestPathTree.IsoLabel)result.get((int)9)).time), () -> Assertions.assertEquals((long)55800L, (long)((ShortestPathTree.IsoLabel)result.get((int)10)).time), () -> Assertions.assertEquals((long)60300L, (long)((ShortestPathTree.IsoLabel)result.get((int)11)).time), () -> Assertions.assertEquals((long)61200L, (long)((ShortestPathTree.IsoLabel)result.get((int)12)).time), () -> Assertions.assertEquals((long)61200L, (long)((ShortestPathTree.IsoLabel)result.get((int)13)).time), () -> Assertions.assertEquals((long)61200L, (long)((ShortestPathTree.IsoLabel)result.get((int)14)).time), () -> Assertions.assertEquals((long)72000L, (long)((ShortestPathTree.IsoLabel)result.get((int)15)).time), () -> Assertions.assertEquals((long)81000L, (long)((ShortestPathTree.IsoLabel)result.get((int)16)).time), () -> Assertions.assertEquals((long)90000L, (long)((ShortestPathTree.IsoLabel)result.get((int)17)).time), () -> Assertions.assertEquals((long)97200L, (long)((ShortestPathTree.IsoLabel)result.get((int)18)).time), () -> Assertions.assertEquals((long)126000L, (long)((ShortestPathTree.IsoLabel)result.get((int)19)).time)});
    }

    @Test
    public void testEdgeBasedWithFinitePositiveUTurnCost() {
        TimeBasedUTurnCost turnCost = new TimeBasedUTurnCost(80000);
        Weighting fastestWeighting = this.createWeighting(turnCost);
        ArrayList result = new ArrayList();
        ShortestPathTree instance = new ShortestPathTree((Graph)this.graph, fastestWeighting, false, TraversalMode.EDGE_BASED);
        instance.setTimeLimit(Double.MAX_VALUE);
        instance.search(0, result::add);
        Assertions.assertEquals((int)(this.countDirectedEdges(this.graph) + 1), (int)result.size());
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((long)0L, (long)((ShortestPathTree.IsoLabel)result.get((int)0)).time), () -> Assertions.assertEquals((long)9000L, (long)((ShortestPathTree.IsoLabel)result.get((int)1)).time), () -> Assertions.assertEquals((long)18000L, (long)((ShortestPathTree.IsoLabel)result.get((int)2)).time), () -> Assertions.assertEquals((long)25200L, (long)((ShortestPathTree.IsoLabel)result.get((int)3)).time), () -> Assertions.assertEquals((long)27000L, (long)((ShortestPathTree.IsoLabel)result.get((int)4)).time), () -> Assertions.assertEquals((long)34200L, (long)((ShortestPathTree.IsoLabel)result.get((int)5)).time), () -> Assertions.assertEquals((long)36000L, (long)((ShortestPathTree.IsoLabel)result.get((int)6)).time), () -> Assertions.assertEquals((long)50400L, (long)((ShortestPathTree.IsoLabel)result.get((int)7)).time), () -> Assertions.assertEquals((long)50400L, (long)((ShortestPathTree.IsoLabel)result.get((int)8)).time), () -> Assertions.assertEquals((long)54000L, (long)((ShortestPathTree.IsoLabel)result.get((int)9)).time), () -> Assertions.assertEquals((long)55800L, (long)((ShortestPathTree.IsoLabel)result.get((int)10)).time), () -> Assertions.assertEquals((long)60300L, (long)((ShortestPathTree.IsoLabel)result.get((int)11)).time), () -> Assertions.assertEquals((long)61200L, (long)((ShortestPathTree.IsoLabel)result.get((int)12)).time), () -> Assertions.assertEquals((long)61200L, (long)((ShortestPathTree.IsoLabel)result.get((int)13)).time), () -> Assertions.assertEquals((long)61200L, (long)((ShortestPathTree.IsoLabel)result.get((int)14)).time), () -> Assertions.assertEquals((long)72000L, (long)((ShortestPathTree.IsoLabel)result.get((int)15)).time), () -> Assertions.assertEquals((long)81000L, (long)((ShortestPathTree.IsoLabel)result.get((int)16)).time), () -> Assertions.assertEquals((long)90000L, (long)((ShortestPathTree.IsoLabel)result.get((int)17)).time), () -> Assertions.assertEquals((long)97200L, (long)((ShortestPathTree.IsoLabel)result.get((int)18)).time), () -> Assertions.assertEquals((long)126000L, (long)((ShortestPathTree.IsoLabel)result.get((int)19)).time), () -> Assertions.assertEquals((long)144800L, (long)((ShortestPathTree.IsoLabel)result.get((int)20)).time)});
    }

    @Test
    public void testEdgeBasedWithSmallerUTurnCost() {
        TimeBasedUTurnCost turnCost = new TimeBasedUTurnCost(20000);
        ArrayList result = new ArrayList();
        ShortestPathTree instance = new ShortestPathTree((Graph)this.graph, this.createWeighting(turnCost), false, TraversalMode.EDGE_BASED);
        instance.setTimeLimit(Double.MAX_VALUE);
        instance.search(0, result::add);
        Assertions.assertEquals((int)(this.countDirectedEdges(this.graph) + 1), (int)result.size());
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((long)0L, (long)((ShortestPathTree.IsoLabel)result.get((int)0)).time), () -> Assertions.assertEquals((long)9000L, (long)((ShortestPathTree.IsoLabel)result.get((int)1)).time), () -> Assertions.assertEquals((long)18000L, (long)((ShortestPathTree.IsoLabel)result.get((int)2)).time), () -> Assertions.assertEquals((long)25200L, (long)((ShortestPathTree.IsoLabel)result.get((int)3)).time), () -> Assertions.assertEquals((long)27000L, (long)((ShortestPathTree.IsoLabel)result.get((int)4)).time), () -> Assertions.assertEquals((long)34200L, (long)((ShortestPathTree.IsoLabel)result.get((int)5)).time), () -> Assertions.assertEquals((long)36000L, (long)((ShortestPathTree.IsoLabel)result.get((int)6)).time), () -> Assertions.assertEquals((long)50400L, (long)((ShortestPathTree.IsoLabel)result.get((int)7)).time), () -> Assertions.assertEquals((long)50400L, (long)((ShortestPathTree.IsoLabel)result.get((int)8)).time), () -> Assertions.assertEquals((long)54000L, (long)((ShortestPathTree.IsoLabel)result.get((int)9)).time), () -> Assertions.assertEquals((long)55800L, (long)((ShortestPathTree.IsoLabel)result.get((int)10)).time), () -> Assertions.assertEquals((long)56000L, (long)((ShortestPathTree.IsoLabel)result.get((int)11)).time), () -> Assertions.assertEquals((long)60300L, (long)((ShortestPathTree.IsoLabel)result.get((int)12)).time), () -> Assertions.assertEquals((long)61200L, (long)((ShortestPathTree.IsoLabel)result.get((int)13)).time), () -> Assertions.assertEquals((long)61200L, (long)((ShortestPathTree.IsoLabel)result.get((int)14)).time), () -> Assertions.assertEquals((long)61200L, (long)((ShortestPathTree.IsoLabel)result.get((int)15)).time), () -> Assertions.assertEquals((long)72000L, (long)((ShortestPathTree.IsoLabel)result.get((int)16)).time), () -> Assertions.assertEquals((long)81000L, (long)((ShortestPathTree.IsoLabel)result.get((int)17)).time), () -> Assertions.assertEquals((long)84800L, (long)((ShortestPathTree.IsoLabel)result.get((int)18)).time), () -> Assertions.assertEquals((long)97200L, (long)((ShortestPathTree.IsoLabel)result.get((int)19)).time), () -> Assertions.assertEquals((long)126000L, (long)((ShortestPathTree.IsoLabel)result.get((int)20)).time)});
    }

    @Test
    public void testSearchByDistance() {
        ArrayList result = new ArrayList();
        ShortestPathTree instance = new ShortestPathTree((Graph)this.graph, this.createWeighting(), false, TraversalMode.NODE_BASED);
        instance.setDistanceLimit(110.0);
        instance.search(5, result::add);
        Assertions.assertEquals((int)6, (int)result.size());
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((double)0.0, (double)((ShortestPathTree.IsoLabel)result.get((int)0)).distance), () -> Assertions.assertEquals((double)50.0, (double)((ShortestPathTree.IsoLabel)result.get((int)1)).distance), () -> Assertions.assertEquals((double)110.0, (double)((ShortestPathTree.IsoLabel)result.get((int)2)).distance), () -> Assertions.assertEquals((double)70.0, (double)((ShortestPathTree.IsoLabel)result.get((int)3)).distance), () -> Assertions.assertEquals((double)70.0, (double)((ShortestPathTree.IsoLabel)result.get((int)4)).distance), () -> Assertions.assertEquals((double)70.0, (double)((ShortestPathTree.IsoLabel)result.get((int)5)).distance)});
    }

    EdgeIteratorState findEdge(int a, int b) {
        EdgeIterator edgeIterator = this.graph.createEdgeExplorer().setBaseNode(a);
        while (edgeIterator.next()) {
            if (edgeIterator.getAdjNode() != b) continue;
            return edgeIterator;
        }
        throw new RuntimeException("nope");
    }

    private static class TimeBasedUTurnCost
    implements TurnCostProvider {
        private final int turnMillis;

        public TimeBasedUTurnCost(int turnMillis) {
            this.turnMillis = turnMillis;
        }

        public double calcTurnWeight(int inEdge, int viaNode, int outEdge) {
            return (double)this.calcTurnMillis(inEdge, viaNode, outEdge) / 1000.0;
        }

        public long calcTurnMillis(int inEdge, int viaNode, int outEdge) {
            return inEdge == outEdge ? (long)this.turnMillis : 0L;
        }
    }
}

