/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.coll.GHIntHashSet;
import com.graphhopper.reader.dem.EdgeElevationInterpolator;
import com.graphhopper.reader.dem.EdgeElevationInterpolatorTest;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.RoadEnvironment;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BridgeElevationInterpolatorTest
extends EdgeElevationInterpolatorTest {
    @Override
    protected RoadEnvironment getInterpolatableRoadEnvironment() {
        return RoadEnvironment.BRIDGE;
    }

    @Override
    protected EdgeElevationInterpolator createEdgeElevationInterpolator() {
        return new EdgeElevationInterpolator(this.graph, this.roadEnvEnc, RoadEnvironment.BRIDGE);
    }

    @Test
    public void interpolatesElevationOfPillarNodes() {
        EdgeIteratorState edge37;
        EdgeIteratorState edge27;
        EdgeIteratorState edge17;
        EdgeIteratorState edge89;
        EdgeIteratorState edge78;
        EdgeIteratorState edge67;
        EdgeIteratorState edge56;
        EdgeIteratorState edge34;
        EdgeIteratorState edge23;
        EdgeIteratorState edge12;
        NodeAccess na = this.graph.getNodeAccess();
        na.setNode(0, 0.0, 0.0, 0.0);
        na.setNode(1, 10.0, 0.0, 10.0);
        na.setNode(2, 20.0, 0.0, 20.0);
        na.setNode(3, 30.0, 0.0, 30.0);
        na.setNode(4, 40.0, 0.0, 40.0);
        na.setNode(5, 0.0, 10.0, 40.0);
        na.setNode(6, 10.0, 10.0, 30.0);
        na.setNode(7, 20.0, 10.0, 1000.0);
        na.setNode(8, 30.0, 10.0, 10.0);
        na.setNode(9, 40.0, 10.0, 0.0);
        EdgeIteratorState edge01 = this.graph.edge(0, 1).setDistance(10.0);
        GHUtility.setSpeed((double)60.0, (double)60.0, (BooleanEncodedValue)this.accessEnc, (DecimalEncodedValue)this.speedEnc, (EdgeIteratorState[])new EdgeIteratorState[]{edge01, edge12 = this.graph.edge(1, 2).setDistance(10.0), edge23 = this.graph.edge(2, 3).setDistance(10.0), edge34 = this.graph.edge(3, 4).setDistance(10.0), edge56 = this.graph.edge(5, 6).setDistance(10.0), edge67 = this.graph.edge(6, 7).setDistance(10.0), edge78 = this.graph.edge(7, 8).setDistance(10.0), edge89 = this.graph.edge(8, 9).setDistance(10.0), edge17 = this.graph.edge(1, 7).setDistance(10.0), edge27 = this.graph.edge(2, 7).setDistance(10.0), edge37 = this.graph.edge(3, 7).setDistance(10.0)});
        edge17.setWayGeometry(Helper.createPointList3D((double[])new double[]{12.0, 2.0, 200.0, 14.0, 4.0, 400.0, 16.0, 6.0, 600.0, 18.0, 8.0, 800.0}));
        edge01.set(this.roadEnvEnc, (Enum)this.normalRoadEnvironment);
        edge12.set(this.roadEnvEnc, (Enum)this.normalRoadEnvironment);
        edge23.set(this.roadEnvEnc, (Enum)this.normalRoadEnvironment);
        edge34.set(this.roadEnvEnc, (Enum)this.normalRoadEnvironment);
        edge56.set(this.roadEnvEnc, (Enum)this.normalRoadEnvironment);
        edge67.set(this.roadEnvEnc, (Enum)this.interpolatableRoadEnvironment);
        edge78.set(this.roadEnvEnc, (Enum)this.interpolatableRoadEnvironment);
        edge89.set(this.roadEnvEnc, (Enum)this.normalRoadEnvironment);
        edge17.set(this.roadEnvEnc, (Enum)this.interpolatableRoadEnvironment);
        edge27.set(this.roadEnvEnc, (Enum)this.interpolatableRoadEnvironment);
        edge37.set(this.roadEnvEnc, (Enum)this.interpolatableRoadEnvironment);
        GHIntHashSet outerNodeIds = new GHIntHashSet();
        GHIntHashSet innerNodeIds = new GHIntHashSet();
        this.gatherOuterAndInnerNodeIdsOfStructure(edge27, outerNodeIds, innerNodeIds);
        Assertions.assertEquals((Object)GHIntHashSet.from((int[])new int[]{1, 2, 3, 6, 8}), (Object)outerNodeIds);
        Assertions.assertEquals((Object)GHIntHashSet.from((int[])new int[]{7}), (Object)innerNodeIds);
        this.edgeElevationInterpolator.execute();
        Assertions.assertEquals((double)0.0, (double)na.getEle(0), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)10.0, (double)na.getEle(1), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)20.0, (double)na.getEle(2), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)30.0, (double)na.getEle(3), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)40.0, (double)na.getEle(4), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)40.0, (double)na.getEle(5), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)30.0, (double)na.getEle(6), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)20.0, (double)na.getEle(7), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)10.0, (double)na.getEle(8), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)0.0, (double)na.getEle(9), (double)1.0000000000000002E-10);
        PointList edge17PointList = edge17.fetchWayGeometry(FetchMode.ALL);
        Assertions.assertEquals((int)6, (int)edge17PointList.size());
        Assertions.assertEquals((double)10.0, (double)edge17PointList.getEle(0), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)12.0, (double)edge17PointList.getEle(1), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)14.0, (double)edge17PointList.getEle(2), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)16.0, (double)edge17PointList.getEle(3), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)18.0, (double)edge17PointList.getEle(4), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)20.0, (double)edge17PointList.getEle(5), (double)1.0000000000000002E-10);
    }
}

