/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.reader.dem.CGIARProvider;
import com.graphhopper.util.Downloader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class CGIARProviderTest {
    private double precision = 0.1;
    CGIARProvider instance;

    @BeforeEach
    public void setUp() {
        this.instance = new CGIARProvider();
    }

    @AfterEach
    public void tearDown() {
        this.instance.release();
    }

    @Test
    public void testDown() {
        Assertions.assertEquals((int)50, (int)this.instance.down(52.5));
        Assertions.assertEquals((int)0, (int)this.instance.down(0.1));
        Assertions.assertEquals((int)0, (int)this.instance.down(0.01));
        Assertions.assertEquals((int)-5, (int)this.instance.down(-0.01));
        Assertions.assertEquals((int)-5, (int)this.instance.down(-2.0));
        Assertions.assertEquals((int)-10, (int)this.instance.down(-5.1));
        Assertions.assertEquals((int)50, (int)this.instance.down(50.0));
        Assertions.assertEquals((int)45, (int)this.instance.down(49.0));
    }

    @Test
    public void testFileName() {
        Assertions.assertEquals((Object)"srtm_36_02", (Object)this.instance.getFileName(52.0, -0.1));
        Assertions.assertEquals((Object)"srtm_35_02", (Object)this.instance.getFileName(50.0, -10.0));
        Assertions.assertEquals((Object)"srtm_36_23", (Object)this.instance.getFileName(-52.0, -0.1));
        Assertions.assertEquals((Object)"srtm_35_22", (Object)this.instance.getFileName(-50.0, -10.0));
        Assertions.assertEquals((Object)"srtm_39_03", (Object)this.instance.getFileName(49.9, 11.5));
        Assertions.assertEquals((Object)"srtm_34_08", (Object)this.instance.getFileName(20.0, -11.0));
        Assertions.assertEquals((Object)"srtm_34_08", (Object)this.instance.getFileName(20.0, -14.0));
        Assertions.assertEquals((Object)"srtm_34_08", (Object)this.instance.getFileName(20.0, -15.0));
        Assertions.assertEquals((Object)"srtm_37_02", (Object)this.instance.getFileName(52.1943832, 0.1363176));
    }

    @Test
    public void testFileNotFound() {
        File file = new File(this.instance.getCacheDir(), this.instance.getFileName(46.0, -20.0) + ".gh");
        File zipFile = new File(this.instance.getCacheDir(), this.instance.getFileName(46.0, -20.0) + ".zip");
        file.delete();
        zipFile.delete();
        this.instance.setDownloader(new Downloader("test GH"){

            public void downloadFile(String url, String toFile) throws IOException {
                throw new FileNotFoundException("xyz");
            }
        });
        Assertions.assertEquals((double)0.0, (double)this.instance.getEle(46.0, -20.0), (double)1.0);
        Assertions.assertTrue((boolean)file.exists());
        Assertions.assertEquals((long)1048676L, (long)file.length());
        this.instance.setDownloader(new Downloader("test GH"){

            public void downloadFile(String url, String toFile) throws IOException {
                throw new SocketTimeoutException("xyz");
            }
        });
        try {
            this.instance.setSleep(30L);
            this.instance.getEle(16.0, -20.0);
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        file.delete();
        zipFile.delete();
    }

    @Disabled
    @Test
    public void testGetEle() {
        Assertions.assertEquals((double)337.0, (double)this.instance.getEle(49.949784, 11.57517), (double)this.precision);
        Assertions.assertEquals((double)466.0, (double)this.instance.getEle(49.968668, 11.575127), (double)this.precision);
        Assertions.assertEquals((double)455.0, (double)this.instance.getEle(49.968682, 11.574842), (double)this.precision);
        Assertions.assertEquals((double)3134.0, (double)this.instance.getEle(-22.532854, -65.110474), (double)this.precision);
        Assertions.assertEquals((double)120.0, (double)this.instance.getEle(38.065392, -87.099609), (double)this.precision);
        Assertions.assertEquals((double)1615.0, (double)this.instance.getEle(40.0, -105.2277023), (double)this.precision);
        Assertions.assertEquals((double)1615.0, (double)this.instance.getEle(39.99999999, -105.2277023), (double)this.precision);
        Assertions.assertEquals((double)1615.0, (double)this.instance.getEle(39.9999999, -105.2277023), (double)this.precision);
        Assertions.assertEquals((double)1616.0, (double)this.instance.getEle(39.999999, -105.2277023), (double)this.precision);
        Assertions.assertEquals((double)986.0, (double)this.instance.getEle(47.468668, 14.575127), (double)this.precision);
        Assertions.assertEquals((double)1091.0, (double)this.instance.getEle(47.467753, 14.573911), (double)this.precision);
        Assertions.assertEquals((double)1951.0, (double)this.instance.getEle(46.468835, 12.578777), (double)this.precision);
        Assertions.assertEquals((double)841.0, (double)this.instance.getEle(48.469123, 9.576393), (double)this.precision);
        Assertions.assertEquals((double)Double.NaN, (double)this.instance.getEle(56.4787319, 17.6118363), (double)this.precision);
        Assertions.assertEquals((double)0.0, (double)this.instance.getEle(60.0000001, 16.0), (double)this.precision);
        Assertions.assertEquals((double)0.0, (double)this.instance.getEle(60.0000001, 16.0), (double)this.precision);
        Assertions.assertEquals((double)0.0, (double)this.instance.getEle(60.0000001, 19.0), (double)this.precision);
        Assertions.assertEquals((double)0.0, (double)this.instance.getEle(60.251, 18.805), (double)this.precision);
    }

    @Disabled
    @Test
    public void testGetEleVerticalBorder() {
        Assertions.assertEquals((Object)"srtm_39_04", (Object)this.instance.getFileName(44.999999, 11.5));
        Assertions.assertEquals((double)5.0, (double)this.instance.getEle(44.999999, 11.5), (double)this.precision);
        Assertions.assertEquals((Object)"srtm_39_03", (Object)this.instance.getFileName(45.000001, 11.5));
        Assertions.assertEquals((double)6.0, (double)this.instance.getEle(45.000001, 11.5), (double)this.precision);
    }

    @Disabled
    @Test
    public void testGetEleHorizontalBorder() {
        Assertions.assertEquals((Object)"srtm_38_04", (Object)this.instance.getFileName(44.94, 9.999999));
        Assertions.assertEquals((double)48.0, (double)this.instance.getEle(44.94, 9.999999), (double)this.precision);
        Assertions.assertEquals((Object)"srtm_39_04", (Object)this.instance.getFileName(44.94, 10.000001));
        Assertions.assertEquals((double)48.0, (double)this.instance.getEle(44.94, 10.000001), (double)this.precision);
    }
}

