/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.carrotsearch.hppc.IntSet;
import com.graphhopper.coll.GHBitSet;
import com.graphhopper.coll.GHBitSetImpl;
import com.graphhopper.coll.GHIntHashSet;
import com.graphhopper.reader.dem.EdgeElevationInterpolator;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadEnvironment;
import com.graphhopper.routing.ev.SimpleBooleanEncodedValue;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.util.EdgeIteratorState;
import org.junit.jupiter.api.BeforeEach;

public abstract class EdgeElevationInterpolatorTest {
    protected static final double PRECISION = 1.0000000000000002E-10;
    protected RoadEnvironment interpolatableRoadEnvironment;
    protected RoadEnvironment normalRoadEnvironment;
    protected BaseGraph graph;
    protected EnumEncodedValue<RoadEnvironment> roadEnvEnc;
    protected BooleanEncodedValue accessEnc;
    protected DecimalEncodedValue speedEnc;
    protected EncodingManager encodingManager;
    protected EdgeElevationInterpolator edgeElevationInterpolator;

    @BeforeEach
    public void setUp() {
        this.accessEnc = new SimpleBooleanEncodedValue("access", true);
        this.speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, false);
        this.encodingManager = EncodingManager.start().add((EncodedValue)this.accessEnc).add((EncodedValue)this.speedEnc).add((EncodedValue)RoadEnvironment.create()).build();
        this.graph = new BaseGraph.Builder(this.encodingManager).set3D(true).create();
        this.roadEnvEnc = this.encodingManager.getEnumEncodedValue("road_environment", RoadEnvironment.class);
        this.edgeElevationInterpolator = this.createEdgeElevationInterpolator();
        this.interpolatableRoadEnvironment = this.getInterpolatableRoadEnvironment();
        this.normalRoadEnvironment = RoadEnvironment.ROAD;
    }

    protected abstract RoadEnvironment getInterpolatableRoadEnvironment();

    protected EdgeElevationInterpolator createEdgeElevationInterpolator() {
        return new EdgeElevationInterpolator(this.graph, this.roadEnvEnc, RoadEnvironment.BRIDGE);
    }

    protected void gatherOuterAndInnerNodeIdsOfStructure(EdgeIteratorState edge, GHIntHashSet outerNodeIds, GHIntHashSet innerNodeIds) {
        this.edgeElevationInterpolator.gatherOuterAndInnerNodeIds(this.edgeElevationInterpolator.getGraph().createEdgeExplorer(), edge, (GHBitSet)new GHBitSetImpl(), (IntSet)outerNodeIds, innerNodeIds);
    }
}

