/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.reader.dem.EdgeElevationSmoothingRamer;
import com.graphhopper.util.PointList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EdgeElevationSmoothingRamerTest {
    @Test
    public void smoothRamer() {
        PointList pl1 = new PointList(3, true);
        pl1.add(0.0, 0.0, 0.0);
        pl1.add(5.0E-4, 5.0E-4, 100.0);
        pl1.add(0.001, 0.001, 50.0);
        EdgeElevationSmoothingRamer.smooth((PointList)pl1, (double)70.0);
        Assertions.assertEquals((int)3, (int)pl1.size());
        Assertions.assertEquals((double)100.0, (double)pl1.getEle(1), (double)0.1);
        EdgeElevationSmoothingRamer.smooth((PointList)pl1, (double)75.0);
        Assertions.assertEquals((int)3, (int)pl1.size());
        Assertions.assertEquals((double)25.0, (double)pl1.getEle(1), (double)0.1);
    }

    @Test
    public void smoothRamer2() {
        PointList pl2 = new PointList(3, true);
        pl2.add(0.001, 0.001, 50.0);
        pl2.add(0.0015, 0.0015, 160.0);
        pl2.add(0.0016, 0.0015, 150.0);
        pl2.add(0.0017, 0.0015, 220.0);
        pl2.add(0.002, 0.002, 20.0);
        EdgeElevationSmoothingRamer.smooth((PointList)pl2, (double)100.0);
        Assertions.assertEquals((int)5, (int)pl2.size());
        Assertions.assertEquals((double)182.5, (double)pl2.getEle(1), (double)1.0);
        Assertions.assertEquals((double)201.3, (double)pl2.getEle(2), (double)1.0);
        Assertions.assertEquals((double)220.0, (double)pl2.getEle(3), (double)0.1);
    }

    @Test
    public void smoothRamerNoMaximumFound() {
        PointList pl2 = new PointList(3, true);
        pl2.add(60.03307, 20.82262, 5.35);
        pl2.add(60.03309, 20.82269, 5.42);
        pl2.add(60.03307, 20.82262, 5.35);
        EdgeElevationSmoothingRamer.smooth((PointList)pl2, (double)10.0);
        Assertions.assertEquals((int)3, (int)pl2.size());
        Assertions.assertEquals((double)5.35, (double)pl2.getEle(0), (double)0.01);
        Assertions.assertEquals((double)5.35, (double)pl2.getEle(1), (double)0.01);
        Assertions.assertEquals((double)5.35, (double)pl2.getEle(2), (double)0.01);
    }
}

