/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.reader.dem.EdgeSampling;
import com.graphhopper.reader.dem.ElevationProvider;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.PointList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EdgeSamplingTest {
    private final ElevationProvider elevation = new ElevationProvider(){

        public double getEle(double lat, double lon) {
            return 10.0;
        }

        public boolean canInterpolate() {
            return false;
        }

        public void release() {
        }
    };

    private double round(double d) {
        return (double)Math.round(d * 1000.0) / 1000.0;
    }

    private PointList round(PointList list) {
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, this.round(list.getLat(i)), this.round(list.getLon(i)), list.getEle(i));
        }
        return list;
    }

    @Test
    public void doesNotAddExtraPointBelowThreshold() {
        PointList in = new PointList(2, true);
        in.add(0.0, 0.0, 0.0);
        in.add(1.4, 0.0, 0.0);
        PointList out = EdgeSampling.sample((PointList)in, (double)111194.92664455873, (DistanceCalc)new DistanceCalcEarth(), (ElevationProvider)this.elevation);
        Assertions.assertEquals((Object)"(0.0,0.0,0.0), (1.4,0.0,0.0)", (Object)this.round(out).toString());
    }

    @Test
    public void addsExtraPointAboveThreshold() {
        PointList in = new PointList(2, true);
        in.add(0.0, 0.0, 0.0);
        in.add(0.8, 0.0, 0.0);
        PointList out = EdgeSampling.sample((PointList)in, (double)55597.46332227936, (DistanceCalc)new DistanceCalcEarth(), (ElevationProvider)this.elevation);
        Assertions.assertEquals((Object)"(0.0,0.0,0.0), (0.4,0.0,10.0), (0.8,0.0,0.0)", (Object)this.round(out).toString());
    }

    @Test
    public void addsExtraPointBelowSecondThreshold() {
        PointList in = new PointList(2, true);
        in.add(0.0, 0.0, 0.0);
        in.add(0.8, 0.0, 0.0);
        PointList out = EdgeSampling.sample((PointList)in, (double)37064.975548186245, (DistanceCalc)new DistanceCalcEarth(), (ElevationProvider)this.elevation);
        Assertions.assertEquals((Object)"(0.0,0.0,0.0), (0.4,0.0,10.0), (0.8,0.0,0.0)", (Object)this.round(out).toString());
    }

    @Test
    public void addsTwoPointsAboveThreshold() {
        PointList in = new PointList(2, true);
        in.add(0.0, 0.0, 0.0);
        in.add(0.75, 0.0, 0.0);
        PointList out = EdgeSampling.sample((PointList)in, (double)27798.73166113968, (DistanceCalc)new DistanceCalcEarth(), (ElevationProvider)this.elevation);
        Assertions.assertEquals((Object)"(0.0,0.0,0.0), (0.25,0.0,10.0), (0.5,0.0,10.0), (0.75,0.0,0.0)", (Object)this.round(out).toString());
    }

    @Test
    public void doesntAddPointsCrossingInternationalDateLine() {
        PointList in = new PointList(2, true);
        in.add(0.0, -178.5, 0.0);
        in.add(0.0, 178.5, 0.0);
        PointList out = EdgeSampling.sample((PointList)in, (double)111194.92664455873, (DistanceCalc)new DistanceCalcEarth(), (ElevationProvider)this.elevation);
        Assertions.assertEquals((Object)"(0.0,-178.5,0.0), (0.0,-179.5,10.0), (0.0,179.5,10.0), (0.0,178.5,0.0)", (Object)this.round(out).toString());
    }

    @Test
    public void usesGreatCircleInterpolationOnLongPaths() {
        PointList in = new PointList(2, true);
        in.add(88.5, -90.0, 0.0);
        in.add(88.5, 90.0, 0.0);
        PointList out = EdgeSampling.sample((PointList)in, (double)111194.92664455873, (DistanceCalc)new DistanceCalcEarth(), (ElevationProvider)this.elevation);
        Assertions.assertEquals((Object)"(88.5,-90.0,0.0), (89.5,-90.0,10.0), (89.5,90.0,10.0), (88.5,90.0,0.0)", (Object)this.round(out).toString());
    }
}

