/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.reader.dem.ElevationInterpolator;
import com.graphhopper.util.Helper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ElevationInterpolatorTest {
    private static final double PRECISION = 1.0000000000000002E-10;
    private ElevationInterpolator elevationInterpolator = new ElevationInterpolator();

    @Test
    public void calculatesElevationOnTwoPoints() {
        Assertions.assertEquals((double)15.0, (double)this.elevationInterpolator.calculateElevationBasedOnTwoPoints(0.0, 0.0, -10.0, -10.0, 10.0, 10.0, 10.0, 20.0), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)15.0, (double)this.elevationInterpolator.calculateElevationBasedOnTwoPoints(-10.0, 10.0, -10.0, -10.0, 10.0, 10.0, 10.0, 20.0), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)15.0, (double)this.elevationInterpolator.calculateElevationBasedOnTwoPoints(-5.0, 5.0, -10.0, -10.0, 10.0, 10.0, 10.0, 20.0), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)19.0, (double)this.elevationInterpolator.calculateElevationBasedOnTwoPoints(8.0, 8.0, -10.0, -10.0, 10.0, 10.0, 10.0, 20.0), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)10.0, (double)this.elevationInterpolator.calculateElevationBasedOnTwoPoints(0.0, 0.0, -3.3333333333333337E-6, 0.0, 10.0, 5.0E-6, 0.0, 20.0), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)20.0, (double)this.elevationInterpolator.calculateElevationBasedOnTwoPoints(0.0, 0.0, -5.0E-6, 0.0, 10.0, 3.3333333333333337E-6, 0.0, 20.0), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)10.0, (double)this.elevationInterpolator.calculateElevationBasedOnTwoPoints(0.0, 0.0, 0.0, 0.0, 10.0, 0.0, 0.0, 20.0), (double)1.0000000000000002E-10);
    }

    @Test
    public void calculatesElevationOnThreePoints() {
        Assertions.assertEquals((double)-0.88, (double)this.elevationInterpolator.calculateElevationBasedOnThreePoints(0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 6.0, 9.0, 12.0, 11.0, 9.0), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)15.0, (double)this.elevationInterpolator.calculateElevationBasedOnThreePoints(10.0, 0.0, 0.0, 0.0, 0.0, 10.0, 10.0, 10.0, 10.0, -10.0, 20.0), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)5.0, (double)this.elevationInterpolator.calculateElevationBasedOnThreePoints(5.0, 5.0, 0.0, 0.0, 0.0, 10.0, 10.0, 10.0, 20.0, 20.0, 20.0), (double)1.0000000000000002E-10);
    }

    @Test
    public void calculatesElevationOnNPoints() {
        Assertions.assertEquals((double)0.0, (double)this.elevationInterpolator.calculateElevationBasedOnPointList(5.0, 5.0, Helper.createPointList3D((double[])new double[]{0.0, 0.0, 0.0, 10.0, 0.0, 0.0, 10.0, 10.0, 0.0, 0.0, 10.0, 0.0})), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)10.0, (double)this.elevationInterpolator.calculateElevationBasedOnPointList(5.0, 5.0, Helper.createPointList3D((double[])new double[]{0.0, 0.0, 0.0, 10.0, 0.0, 10.0, 10.0, 10.0, 20.0, 0.0, 10.0, 10.0})), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)5.0, (double)this.elevationInterpolator.calculateElevationBasedOnPointList(5.0, 5.0, Helper.createPointList3D((double[])new double[]{0.0, 0.0, 0.0, 10.0, 0.0, 10.0, 10.0, 10.0, 0.0, 0.0, 10.0, 10.0})), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)2.65, (double)this.elevationInterpolator.calculateElevationBasedOnPointList(2.5, 2.5, Helper.createPointList3D((double[])new double[]{0.0, 0.0, 0.0, 10.0, 0.0, 10.0, 10.0, 10.0, 0.0, 0.0, 10.0, 10.0})), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)0.0, (double)this.elevationInterpolator.calculateElevationBasedOnPointList(0.1, 0.1, Helper.createPointList3D((double[])new double[]{0.0, 0.0, 0.0, 10.0, 0.0, 10.0, 10.0, 10.0, 0.0, 0.0, 10.0, 10.0})), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)0.0, (double)this.elevationInterpolator.calculateElevationBasedOnPointList(5.0E-6, 5.0E-6, Helper.createPointList3D((double[])new double[]{0.0, 0.0, 0.0, 10.0, 0.0, 10.0, 10.0, 10.0, 0.0, 0.0, 10.0, 10.0})), (double)1.0000000000000002E-10);
        Assertions.assertEquals((double)0.0, (double)this.elevationInterpolator.calculateElevationBasedOnPointList(5.0, 0.0, Helper.createPointList3D((double[])new double[]{0.0, 0.0, 0.0, 10.0, 1.0, 10.0, 10.0, -1.0, -10.0, 20.0, 0.0, 0.0})), (double)1.0000000000000002E-10);
    }
}

