/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.reader.dem.GMTEDProvider;
import com.graphhopper.util.Downloader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class GMTEDProviderTest {
    private double precision = 0.1;
    GMTEDProvider instance;

    @BeforeEach
    public void setUp() {
        this.instance = new GMTEDProvider();
    }

    @AfterEach
    public void tearDown() {
        this.instance.release();
    }

    @Test
    public void testMinLat() {
        Assertions.assertEquals((int)50, (int)this.instance.getMinLatForTile(52.5));
        Assertions.assertEquals((int)10, (int)this.instance.getMinLatForTile(29.9));
        Assertions.assertEquals((int)-70, (int)this.instance.getMinLatForTile(-59.9));
    }

    @Test
    public void testMinLon() {
        Assertions.assertEquals((int)-60, (int)this.instance.getMinLonForTile(-59.9));
        Assertions.assertEquals((int)0, (int)this.instance.getMinLonForTile(0.9));
    }

    @Test
    public void testGetDownloadUrl() {
        Assertions.assertTrue((boolean)this.instance.getDownloadURL(42.940339, 11.953125).contains("E000/30N000E_20101117_gmted_mea075.tif"));
        Assertions.assertTrue((boolean)this.instance.getDownloadURL(38.548165, -77.167969).contains("W090/30N090W_20101117_gmted_mea075.tif"));
        Assertions.assertTrue((boolean)this.instance.getDownloadURL(74.116047, -169.277344).contains("W180/70N180W_20101117_gmted_mea075.tif"));
        Assertions.assertTrue((boolean)this.instance.getDownloadURL(-61.015725, -156.621094).contains("W180/70S180W_20101117_gmted_mea075.tif"));
        Assertions.assertTrue((boolean)this.instance.getDownloadURL(74.590108, 166.640625).contains("E150/70N150E_20101117_gmted_mea075.tif"));
        Assertions.assertTrue((boolean)this.instance.getDownloadURL(-61.015725, 162.949219).contains("E150/70S150E_20101117_gmted_mea075.tif"));
    }

    @Test
    public void testGetFileName() {
        Assertions.assertEquals((Object)"30n000e_20101117_gmted_mea075", (Object)this.instance.getFileName(42.940339, 11.953125));
        Assertions.assertEquals((Object)"30n090w_20101117_gmted_mea075", (Object)this.instance.getFileName(38.548165, -77.167969));
        Assertions.assertEquals((Object)"70n180w_20101117_gmted_mea075", (Object)this.instance.getFileName(74.116047, -169.277344));
        Assertions.assertEquals((Object)"70s180w_20101117_gmted_mea075", (Object)this.instance.getFileName(-61.015725, -156.621094));
        Assertions.assertEquals((Object)"70n150e_20101117_gmted_mea075", (Object)this.instance.getFileName(74.590108, 166.640625));
        Assertions.assertEquals((Object)"70s150e_20101117_gmted_mea075", (Object)this.instance.getFileName(-61.015725, 162.949219));
    }

    @Test
    public void testFileNotFound() {
        File file = new File(this.instance.getCacheDir(), this.instance.getFileName(46.0, -20.0) + ".gh");
        File zipFile = new File(this.instance.getCacheDir(), this.instance.getFileName(46.0, -20.0) + ".tif");
        file.delete();
        zipFile.delete();
        this.instance.setDownloader(new Downloader("test GH"){

            public void downloadFile(String url, String toFile) throws IOException {
                throw new FileNotFoundException("xyz");
            }
        });
        Assertions.assertEquals((double)0.0, (double)this.instance.getEle(46.0, -20.0), (double)1.0);
        Assertions.assertTrue((boolean)file.exists());
        Assertions.assertEquals((long)1048676L, (long)file.length());
        this.instance.setDownloader(new Downloader("test GH"){

            public void downloadFile(String url, String toFile) throws IOException {
                throw new SocketTimeoutException("xyz");
            }
        });
        try {
            this.instance.setSleep(30L);
            this.instance.getEle(16.0, -20.0);
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        file.delete();
        zipFile.delete();
    }

    @Disabled
    @Test
    public void testGetEle() {
        Assertions.assertEquals((double)339.0, (double)this.instance.getEle(49.949784, 11.57517), (double)this.precision);
        Assertions.assertEquals((double)438.0, (double)this.instance.getEle(49.968668, 11.575127), (double)this.precision);
        Assertions.assertEquals((double)432.0, (double)this.instance.getEle(49.968682, 11.574842), (double)this.precision);
        Assertions.assertEquals((double)3169.0, (double)this.instance.getEle(-22.532854, -65.110474), (double)this.precision);
        Assertions.assertEquals((double)124.0, (double)this.instance.getEle(38.065392, -87.099609), (double)this.precision);
        Assertions.assertEquals((double)1615.0, (double)this.instance.getEle(40.0, -105.2277023), (double)this.precision);
        Assertions.assertEquals((double)1618.0, (double)this.instance.getEle(39.99999999, -105.2277023), (double)this.precision);
        Assertions.assertEquals((double)1618.0, (double)this.instance.getEle(39.9999999, -105.2277023), (double)this.precision);
        Assertions.assertEquals((double)1618.0, (double)this.instance.getEle(39.999999, -105.2277023), (double)this.precision);
        Assertions.assertEquals((double)1070.0, (double)this.instance.getEle(47.468668, 14.575127), (double)this.precision);
        Assertions.assertEquals((double)1115.0, (double)this.instance.getEle(47.467753, 14.573911), (double)this.precision);
        Assertions.assertEquals((double)1990.0, (double)this.instance.getEle(46.468835, 12.578777), (double)this.precision);
        Assertions.assertEquals((double)841.0, (double)this.instance.getEle(48.469123, 9.576393), (double)this.precision);
        Assertions.assertEquals((double)0.0, (double)this.instance.getEle(56.4787319, 17.6118363), (double)this.precision);
        Assertions.assertEquals((double)0.0, (double)this.instance.getEle(56.4787319, 17.6118363), (double)this.precision);
        Assertions.assertEquals((double)108.0, (double)this.instance.getEle(60.0000001, 16.0), (double)this.precision);
        Assertions.assertEquals((double)0.0, (double)this.instance.getEle(60.0000001, 19.0), (double)this.precision);
        Assertions.assertEquals((double)14.0, (double)this.instance.getEle(60.251, 18.805), (double)this.precision);
    }

    @Disabled
    @Test
    public void testGetEleVerticalBorder() {
        Assertions.assertEquals((Object)"50n000e_20101117_gmted_mea075", (Object)this.instance.getFileName(69.999999, 19.493));
        Assertions.assertEquals((double)268.0, (double)this.instance.getEle(69.999999, 19.5249), (double)this.precision);
        Assertions.assertEquals((Object)"70n000e_20101117_gmted_mea075", (Object)this.instance.getFileName(70.0, 19.493));
        Assertions.assertEquals((double)298.0, (double)this.instance.getEle(70.0, 19.5249), (double)this.precision);
        Assertions.assertEquals((Object)"50n000e_20101117_gmted_mea075", (Object)this.instance.getFileName(69.999999, 19.236));
        Assertions.assertEquals((double)245.0, (double)this.instance.getEle(69.999999, 19.236), (double)this.precision);
        Assertions.assertEquals((Object)"70n000e_20101117_gmted_mea075", (Object)this.instance.getFileName(70.0, 19.236));
        Assertions.assertEquals((double)241.0, (double)this.instance.getEle(70.0, 19.236), (double)this.precision);
    }

    @Disabled
    @Test
    public void testGetEleHorizontalBorder() {
        Assertions.assertEquals((Object)"50n000e_20101117_gmted_mea075", (Object)this.instance.getFileName(53.0, 29.999999));
        Assertions.assertEquals((double)143.0, (double)this.instance.getEle(53.0, 29.999999), (double)this.precision);
        Assertions.assertEquals((Object)"50n030e_20101117_gmted_mea075", (Object)this.instance.getFileName(53.0, 30.000001));
        Assertions.assertEquals((double)142.0, (double)this.instance.getEle(53.0, 30.000001), (double)this.precision);
    }
}

