/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.reader.dem.HeightTile;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.RAMDirectory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HeightTileTest {
    @Test
    public void testGetHeight() {
        int width = 10;
        int height = 20;
        HeightTile instance = new HeightTile(0, 0, width, height, 1.0E-6, 10, 20);
        DataAccess heights = new RAMDirectory().create("tmp");
        heights.create((long)(2 * width * height));
        instance.setHeights(heights);
        this.init(heights, width, height, 1);
        heights.setShort((long)(2 * (17 * width + 1)), (short)70);
        heights.setShort((long)(2 * (19 * width + 2)), (short)90);
        Assertions.assertEquals((double)1.0, (double)instance.getHeight(5.0, 5.0), (double)0.001);
        Assertions.assertEquals((double)70.0, (double)instance.getHeight(2.5, 1.5), (double)0.001);
        Assertions.assertEquals((double)1.0, (double)instance.getHeight(3.0, 2.0), (double)0.001);
        Assertions.assertEquals((double)70.0, (double)instance.getHeight(2.0, 1.0), (double)0.001);
        Assertions.assertEquals((double)1.0, (double)instance.getHeight(1.0, 2.0), (double)0.001);
        Assertions.assertEquals((double)90.0, (double)instance.getHeight(0.5, 2.5), (double)0.001);
        Assertions.assertEquals((double)90.0, (double)instance.getHeight(0.0, 2.5), (double)0.001);
        Assertions.assertEquals((double)1.0, (double)instance.getHeight(0.0, 3.0), (double)0.001);
        Assertions.assertEquals((double)1.0, (double)instance.getHeight(-0.5, 3.5), (double)0.001);
        Assertions.assertEquals((double)1.0, (double)instance.getHeight(-0.5, 3.0), (double)0.001);
        Assertions.assertEquals((double)90.0, (double)instance.getHeight(-0.5, 2.5), (double)0.001);
        Assertions.assertEquals((double)1.0, (double)instance.getHeight(0.0, 0.0), (double)0.001);
        Assertions.assertEquals((double)1.0, (double)instance.getHeight(9.0, 10.0), (double)0.001);
        Assertions.assertEquals((double)1.0, (double)instance.getHeight(10.0, 9.0), (double)0.001);
        Assertions.assertEquals((double)1.0, (double)instance.getHeight(10.0, 10.0), (double)0.001);
        Assertions.assertEquals((double)1.0, (double)instance.getHeight(10.5, 5.0), (double)0.001);
        Assertions.assertEquals((double)1.0, (double)instance.getHeight(-0.5, 5.0), (double)0.001);
        Assertions.assertEquals((double)1.0, (double)instance.getHeight(1.0, -0.5), (double)0.001);
        Assertions.assertEquals((double)1.0, (double)instance.getHeight(1.0, 10.5), (double)0.001);
    }

    @Test
    public void testGetHeightForNegativeTile() {
        int width = 10;
        HeightTile instance = new HeightTile(-20, -20, width, width, 1.0E-6, 10, 10);
        DataAccess heights = new RAMDirectory().create("tmp");
        heights.create(200L);
        instance.setHeights(heights);
        this.init(heights, width, width, 1);
        heights.setShort((long)(2 * (7 * width + 1)), (short)70);
        heights.setShort((long)(2 * (9 * width + 2)), (short)90);
        Assertions.assertEquals((double)1.0, (double)instance.getHeight(-15.0, -15.0), (double)0.001);
        Assertions.assertEquals((double)70.0, (double)instance.getHeight(-17.5, -18.5), (double)0.001);
        Assertions.assertEquals((double)1.0, (double)instance.getHeight(-17.0, -18.0), (double)0.001);
        Assertions.assertEquals((double)70.0, (double)instance.getHeight(-18.0, -19.0), (double)0.001);
    }

    @Test
    public void testInterpolate() {
        HeightTile instance = new HeightTile(0, 0, 2, 2, 1.0E-6, 10, 10).setInterpolate(true);
        DataAccess heights = new RAMDirectory().create("tmp");
        heights.create(8L);
        instance.setHeights(heights);
        double topLeft = 0.0;
        double topRight = 1.0;
        double bottomLeft = 2.0;
        double bottomRight = 3.0;
        this.set(heights, 2, 0, 0, (short)topLeft);
        this.set(heights, 2, 1, 0, (short)topRight);
        this.set(heights, 2, 0, 1, (short)bottomLeft);
        this.set(heights, 2, 1, 1, (short)bottomRight);
        Assertions.assertEquals((double)bottomLeft, (double)instance.getHeight(0.0, 0.0), (double)0.001);
        Assertions.assertEquals((double)topLeft, (double)instance.getHeight(10.0, 0.0), (double)0.001);
        Assertions.assertEquals((double)bottomRight, (double)instance.getHeight(0.0, 10.0), (double)0.001);
        Assertions.assertEquals((double)topRight, (double)instance.getHeight(10.0, 10.0), (double)0.001);
        Assertions.assertEquals((double)this.avg(topLeft, topRight), (double)instance.getHeight(10.0, 5.0), (double)0.001);
        Assertions.assertEquals((double)this.avg(bottomLeft, bottomRight), (double)instance.getHeight(0.0, 5.0), (double)0.001);
        Assertions.assertEquals((double)this.avg(topLeft, bottomLeft), (double)instance.getHeight(5.0, 0.0), (double)0.001);
        Assertions.assertEquals((double)this.avg(topRight, bottomRight, topLeft, bottomLeft), (double)instance.getHeight(5.0, 5.0), (double)0.001);
        this.set(heights, 2, 1, 0, (short)Short.MIN_VALUE);
        this.set(heights, 2, 0, 1, (short)Short.MIN_VALUE);
        this.set(heights, 2, 1, 1, (short)Short.MIN_VALUE);
        Assertions.assertEquals((double)topLeft, (double)instance.getHeight(0.0, 0.0), (double)0.001);
        Assertions.assertEquals((double)topLeft, (double)instance.getHeight(10.0, 0.0), (double)0.001);
        Assertions.assertEquals((double)topLeft, (double)instance.getHeight(0.0, 10.0), (double)0.001);
        Assertions.assertEquals((double)topLeft, (double)instance.getHeight(10.0, 10.0), (double)0.001);
        this.set(heights, 2, 0, 0, (short)Short.MIN_VALUE);
        Assertions.assertEquals((double)Double.NaN, (double)instance.getHeight(5.0, 5.0), (double)0.001);
    }

    private void init(DataAccess da, int width, int height, int i) {
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                this.set(da, width, x, y, (short)1);
            }
        }
    }

    private void set(DataAccess da, int width, int x, int y, short height) {
        da.setShort((long)(2 * (y * width + x)), height);
    }

    private double avg(double ... ns) {
        double sum = 0.0;
        for (double n : ns) {
            sum += n;
        }
        return sum / (double)ns.length;
    }
}

