/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.reader.dem.CGIARProvider;
import com.graphhopper.reader.dem.GMTEDProvider;
import com.graphhopper.reader.dem.MultiSourceElevationProvider;
import com.graphhopper.reader.dem.TileBasedElevationProvider;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class MultiSourceElevationProviderTest {
    MultiSourceElevationProvider instance;

    @AfterEach
    public void tearDown() {
        this.instance.release();
    }

    @Test
    public void testGetEleMocked() {
        this.instance = new MultiSourceElevationProvider((TileBasedElevationProvider)new CGIARProvider(){

            public double getEle(double lat, double lon) {
                return 1.0;
            }
        }, (TileBasedElevationProvider)new GMTEDProvider(){

            public double getEle(double lat, double lon) {
                return 2.0;
            }
        });
        Assertions.assertEquals((double)1.0, (double)this.instance.getEle(0.0, 0.0), (double)0.1);
        Assertions.assertEquals((double)2.0, (double)this.instance.getEle(60.0001, 0.0), (double)0.1);
        Assertions.assertEquals((double)2.0, (double)this.instance.getEle(-56.0001, 0.0), (double)0.1);
    }

    @Disabled
    @Test
    public void testGetEle() {
        this.instance = new MultiSourceElevationProvider();
        double precision = 0.1;
        Assertions.assertEquals((double)338.0, (double)this.instance.getEle(49.949784, 11.57517), (double)precision);
        Assertions.assertEquals((double)468.0, (double)this.instance.getEle(49.968668, 11.575127), (double)precision);
        Assertions.assertEquals((double)467.0, (double)this.instance.getEle(49.968682, 11.574842), (double)precision);
        Assertions.assertEquals((double)3110.0, (double)this.instance.getEle(-22.532854, -65.110474), (double)precision);
        Assertions.assertEquals((double)120.0, (double)this.instance.getEle(38.065392, -87.099609), (double)precision);
        Assertions.assertEquals((double)1617.0, (double)this.instance.getEle(40.0, -105.2277023), (double)precision);
        Assertions.assertEquals((double)1617.0, (double)this.instance.getEle(39.99999999, -105.2277023), (double)precision);
        Assertions.assertEquals((double)1617.0, (double)this.instance.getEle(39.9999999, -105.2277023), (double)precision);
        Assertions.assertEquals((double)1617.0, (double)this.instance.getEle(39.999999, -105.2277023), (double)precision);
        Assertions.assertEquals((double)1015.0, (double)this.instance.getEle(47.468668, 14.575127), (double)precision);
        Assertions.assertEquals((double)1107.0, (double)this.instance.getEle(47.467753, 14.573911), (double)precision);
        Assertions.assertEquals((double)1930.0, (double)this.instance.getEle(46.468835, 12.578777), (double)precision);
        Assertions.assertEquals((double)844.0, (double)this.instance.getEle(48.469123, 9.576393), (double)precision);
        Assertions.assertEquals((double)0.0, (double)this.instance.getEle(56.4787319, 17.6118363), (double)precision);
        Assertions.assertEquals((double)0.0, (double)this.instance.getEle(56.4787319, 17.6118363), (double)precision);
        Assertions.assertEquals((double)108.0, (double)this.instance.getEle(60.0000001, 16.0), (double)precision);
        Assertions.assertEquals((double)0.0, (double)this.instance.getEle(60.0000001, 19.0), (double)precision);
        Assertions.assertEquals((double)14.0, (double)this.instance.getEle(60.251, 18.805), (double)precision);
    }
}

