/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.reader.dem.SRTMGL1Provider;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class SRTMGL1ProviderTest {
    private double precision = 0.1;
    SRTMGL1Provider instance;

    @BeforeEach
    public void setUp() {
        this.instance = new SRTMGL1Provider();
    }

    @AfterEach
    public void tearDown() {
        this.instance.release();
    }

    @Test
    public void testMinLat() {
        Assertions.assertEquals((int)52, (int)this.instance.getMinLatForTile(52.5));
        Assertions.assertEquals((int)29, (int)this.instance.getMinLatForTile(29.9));
        Assertions.assertEquals((int)-60, (int)this.instance.getMinLatForTile(-59.9));
    }

    @Test
    public void testMinLon() {
        Assertions.assertEquals((int)-60, (int)this.instance.getMinLonForTile(-59.9));
        Assertions.assertEquals((int)0, (int)this.instance.getMinLonForTile(0.9));
    }

    @Test
    public void testGetDownloadUrl() {
        Assertions.assertEquals((Object)"North/North_30_60/N42E011.hgt", (Object)this.instance.getDownloadURL(42.940339, 11.953125));
        Assertions.assertEquals((Object)"North/North_30_60/N38W078.hgt", (Object)this.instance.getDownloadURL(38.548165, -77.167969));
        Assertions.assertEquals((Object)"North/North_0_29/N14W005.hgt", (Object)this.instance.getDownloadURL(14.116047, -4.277344));
        Assertions.assertEquals((Object)"South/S52W058.hgt", (Object)this.instance.getDownloadURL(-51.015725, -57.621094));
        Assertions.assertEquals((Object)"North/North_0_29/N24E120.hgt", (Object)this.instance.getDownloadURL(24.590108, 120.640625));
        Assertions.assertEquals((Object)"South/S42W063.hgt", (Object)this.instance.getDownloadURL(-41.015725, -62.949219));
    }

    @Test
    public void testGetFileName() {
        Assertions.assertEquals((Object)"n42e011", (Object)this.instance.getFileName(42.940339, 11.953125));
        Assertions.assertEquals((Object)"n38w078", (Object)this.instance.getFileName(38.548165, -77.167969));
        Assertions.assertEquals((Object)"n14w005", (Object)this.instance.getFileName(14.116047, -4.277344));
        Assertions.assertEquals((Object)"s52w058", (Object)this.instance.getFileName(-51.015725, -57.621094));
        Assertions.assertEquals((Object)"n24e120", (Object)this.instance.getFileName(24.590108, 120.640625));
        Assertions.assertEquals((Object)"s42w063", (Object)this.instance.getFileName(-41.015725, -62.949219));
    }

    @Disabled
    @Test
    public void testGetEle() {
        Assertions.assertEquals((double)338.0, (double)this.instance.getEle(49.949784, 11.57517), (double)this.precision);
        Assertions.assertEquals((double)468.0, (double)this.instance.getEle(49.968668, 11.575127), (double)this.precision);
        Assertions.assertEquals((double)467.0, (double)this.instance.getEle(49.968682, 11.574842), (double)this.precision);
        Assertions.assertEquals((double)3110.0, (double)this.instance.getEle(-22.532854, -65.110474), (double)this.precision);
        Assertions.assertEquals((double)120.0, (double)this.instance.getEle(38.065392, -87.099609), (double)this.precision);
        Assertions.assertEquals((double)1617.0, (double)this.instance.getEle(40.0, -105.2277023), (double)this.precision);
        Assertions.assertEquals((double)1617.0, (double)this.instance.getEle(39.99999999, -105.2277023), (double)this.precision);
        Assertions.assertEquals((double)1617.0, (double)this.instance.getEle(39.9999999, -105.2277023), (double)this.precision);
        Assertions.assertEquals((double)1617.0, (double)this.instance.getEle(39.999999, -105.2277023), (double)this.precision);
        Assertions.assertEquals((double)1015.0, (double)this.instance.getEle(47.468668, 14.575127), (double)this.precision);
        Assertions.assertEquals((double)1107.0, (double)this.instance.getEle(47.467753, 14.573911), (double)this.precision);
        Assertions.assertEquals((double)1930.0, (double)this.instance.getEle(46.468835, 12.578777), (double)this.precision);
        Assertions.assertEquals((double)844.0, (double)this.instance.getEle(48.469123, 9.576393), (double)this.precision);
        Assertions.assertEquals((double)0.0, (double)this.instance.getEle(56.4787319, 17.6118363), (double)this.precision);
        Assertions.assertEquals((double)0.0, (double)this.instance.getEle(56.4787319, 17.6118363), (double)this.precision);
        Assertions.assertEquals((double)0.0, (double)this.instance.getEle(60.0000001, 16.0), (double)this.precision);
        Assertions.assertEquals((double)0.0, (double)this.instance.getEle(60.0000001, 16.0), (double)this.precision);
        Assertions.assertEquals((double)0.0, (double)this.instance.getEle(60.0000001, 19.0), (double)this.precision);
        Assertions.assertEquals((double)0.0, (double)this.instance.getEle(60.251, 18.805), (double)this.precision);
    }

    @Disabled
    @Test
    public void testGetEleVerticalBorder() {
        Assertions.assertEquals((Object)"n42e011", (Object)this.instance.getFileName(42.999999, 11.48));
        Assertions.assertEquals((double)420.0, (double)this.instance.getEle(42.999999, 11.48), (double)this.precision);
        Assertions.assertEquals((Object)"n43e011", (Object)this.instance.getFileName(43.000001, 11.48));
        Assertions.assertEquals((double)420.0, (double)this.instance.getEle(43.000001, 11.48), (double)this.precision);
    }

    @Disabled
    @Test
    public void testGetEleHorizontalBorder() {
        Assertions.assertEquals((Object)"n42e011", (Object)this.instance.getFileName(42.1, 11.999999));
        Assertions.assertEquals((double)324.0, (double)this.instance.getEle(42.1, 11.999999), (double)this.precision);
        Assertions.assertEquals((Object)"n42e012", (Object)this.instance.getFileName(42.1, 12.000001));
        Assertions.assertEquals((double)324.0, (double)this.instance.getEle(42.1, 12.000001), (double)this.precision);
    }
}

