/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.reader.dem.SRTMProvider;
import java.io.IOException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class SRTMProviderTest {
    private double precision = 0.1;
    SRTMProvider instance;

    @BeforeEach
    public void setUp() {
        this.instance = new SRTMProvider();
    }

    @AfterEach
    public void tearDown() {
        this.instance.release();
    }

    @Test
    public void testGetFileString() {
        Assertions.assertEquals((Object)"Eurasia/N49E011", (Object)this.instance.getFileName(49.0, 11.0));
        Assertions.assertEquals((Object)"Eurasia/N52W002", (Object)this.instance.getFileName(52.268157, -1.230469));
        Assertions.assertEquals((Object)"Africa/S06E034", (Object)this.instance.getFileName(-5.965754, 34.804687));
        Assertions.assertEquals((Object)"Australia/S29E131", (Object)this.instance.getFileName(-28.304381, 131.484375));
        Assertions.assertEquals((Object)"South_America/S09W045", (Object)this.instance.getFileName(-9.0, -45.0));
        Assertions.assertEquals((Object)"South_America/S10W046", (Object)this.instance.getFileName(-9.1, -45.1));
        Assertions.assertEquals((Object)"South_America/S10W045", (Object)this.instance.getFileName(-9.6, -45.0));
        Assertions.assertEquals((Object)"South_America/S28W071", (Object)this.instance.getFileName(-28.0, -71.0));
        Assertions.assertEquals((Object)"South_America/S29W072", (Object)this.instance.getFileName(-28.88316, -71.070557));
    }

    @Test
    public void testGetHeight() throws IOException {
        this.instance = new SRTMProvider("./files/");
        Assertions.assertEquals((double)466.0, (double)this.instance.getEle(49.968651, 11.574869), (double)0.1);
        Assertions.assertEquals((double)330.0, (double)this.instance.getEle(49.958233, 11.558647), (double)0.1);
        Assertions.assertEquals((double)1678.0, (double)this.instance.getEle(-28.88316, -71.070557), (double)0.1);
        Assertions.assertEquals((double)0.0, (double)this.instance.getEle(-28.671311, -71.38916), (double)0.1);
        Assertions.assertEquals((double)0.0, (double)this.instance.getEle(55.4711873, 19.2501641), (double)0.1);
        Assertions.assertEquals((double)161.0, (double)this.instance.getEle(55.8943144, -3.0), (double)0.1);
    }

    @Test
    public void testGetHeight_issue545() throws IOException {
        this.instance = new SRTMProvider("./files/");
        Assertions.assertEquals((double)84.0, (double)this.instance.getEle(48.003878, -124.660492), (double)0.1);
    }

    @Test
    public void testGetHeightMMap() throws IOException {
        this.instance = new SRTMProvider("./files/");
        Assertions.assertEquals((double)161.0, (double)this.instance.getEle(55.8943144, -3.0), (double)0.1);
    }

    @Disabled
    @Test
    public void testGetEle() {
        this.instance = new SRTMProvider();
        Assertions.assertEquals((double)337.0, (double)this.instance.getEle(49.949784, 11.57517), (double)this.precision);
        Assertions.assertEquals((double)466.0, (double)this.instance.getEle(49.968668, 11.575127), (double)this.precision);
        Assertions.assertEquals((double)466.0, (double)this.instance.getEle(49.968682, 11.574842), (double)this.precision);
        Assertions.assertEquals((double)3100.0, (double)this.instance.getEle(-22.532854, -65.110474), (double)this.precision);
        Assertions.assertEquals((double)122.0, (double)this.instance.getEle(38.065392, -87.099609), (double)this.precision);
        Assertions.assertEquals((double)1617.0, (double)this.instance.getEle(40.0, -105.2277023), (double)this.precision);
        Assertions.assertEquals((double)1617.0, (double)this.instance.getEle(39.99999999, -105.2277023), (double)this.precision);
        Assertions.assertEquals((double)1617.0, (double)this.instance.getEle(39.9999999, -105.2277023), (double)this.precision);
        Assertions.assertEquals((double)1617.0, (double)this.instance.getEle(39.999999, -105.2277023), (double)this.precision);
        Assertions.assertEquals((double)1046.0, (double)this.instance.getEle(47.468668, 14.575127), (double)this.precision);
        Assertions.assertEquals((double)1113.0, (double)this.instance.getEle(47.467753, 14.573911), (double)this.precision);
        Assertions.assertEquals((double)1946.0, (double)this.instance.getEle(46.468835, 12.578777), (double)this.precision);
        Assertions.assertEquals((double)845.0, (double)this.instance.getEle(48.469123, 9.576393), (double)this.precision);
        Assertions.assertEquals((double)0.0, (double)this.instance.getEle(56.4787319, 17.6118363), (double)this.precision);
        Assertions.assertEquals((double)0.0, (double)this.instance.getEle(56.4787319, 17.6118363), (double)this.precision);
        Assertions.assertEquals((double)0.0, (double)this.instance.getEle(60.0000001, 16.0), (double)this.precision);
        Assertions.assertEquals((double)0.0, (double)this.instance.getEle(60.0000001, 16.0), (double)this.precision);
        Assertions.assertEquals((double)0.0, (double)this.instance.getEle(60.0000001, 19.0), (double)this.precision);
        Assertions.assertEquals((double)0.0, (double)this.instance.getEle(60.251, 18.805), (double)this.precision);
    }

    @Disabled
    @Test
    public void testGetEleVerticalBorder() {
        this.instance = new SRTMProvider();
        Assertions.assertEquals((Object)"Eurasia/N42E011", (Object)this.instance.getFileName(42.999999, 11.48));
        Assertions.assertEquals((double)419.0, (double)this.instance.getEle(42.999999, 11.48), (double)this.precision);
        Assertions.assertEquals((Object)"Eurasia/N43E011", (Object)this.instance.getFileName(43.000001, 11.48));
        Assertions.assertEquals((double)419.0, (double)this.instance.getEle(43.000001, 11.48), (double)this.precision);
    }

    @Disabled
    @Test
    public void testGetEleHorizontalBorder() {
        this.instance = new SRTMProvider();
        Assertions.assertEquals((Object)"Eurasia/N42E011", (Object)this.instance.getFileName(42.1, 11.999999));
        Assertions.assertEquals((double)324.0, (double)this.instance.getEle(42.1, 11.999999), (double)this.precision);
        Assertions.assertEquals((Object)"Eurasia/N42E012", (Object)this.instance.getFileName(42.1, 12.000001));
        Assertions.assertEquals((double)324.0, (double)this.instance.getEle(42.1, 12.000001), (double)this.precision);
    }

    @Disabled
    @Test
    public void testDownloadIssue_1274() {
        this.instance = new SRTMProvider();
        Assertions.assertEquals((Object)"North_America/N55W061", (Object)this.instance.getFileName(55.055, -60.541));
        Assertions.assertEquals((double)204.0, (double)this.instance.getEle(55.055, -60.541), (double)0.1);
    }
}

