/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm;

import com.carrotsearch.hppc.LongArrayList;
import com.graphhopper.reader.ReaderElement;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.osm.OSMRestrictionConverter;
import com.graphhopper.reader.osm.OSMRestrictionException;
import com.graphhopper.reader.osm.RestrictionMembers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ExtractMembersTest {
    private ReaderRelation relation;

    ExtractMembersTest() {
    }

    @BeforeEach
    void setup() {
        this.relation = new ReaderRelation(0L);
        this.relation.setTag("type", (Object)"restriction");
    }

    @Test
    void simpleViaNode() throws OSMRestrictionException {
        this.relation.add(new ReaderRelation.Member(ReaderElement.Type.WAY, 1L, "from"));
        this.relation.add(new ReaderRelation.Member(ReaderElement.Type.NODE, 2L, "via"));
        this.relation.add(new ReaderRelation.Member(ReaderElement.Type.WAY, 3L, "to"));
        RestrictionMembers restrictionMembers = OSMRestrictionConverter.extractMembers((ReaderRelation)this.relation);
        Assertions.assertEquals((Object)LongArrayList.from((long[])new long[]{1L}), (Object)restrictionMembers.getFromWays());
        Assertions.assertEquals((long)2L, (long)restrictionMembers.getViaOSMNode());
        Assertions.assertEquals((Object)LongArrayList.from((long[])new long[]{3L}), (Object)restrictionMembers.getToWays());
        Assertions.assertNull((Object)restrictionMembers.getViaWays());
    }

    @Test
    void noVia() {
        this.relation.add(new ReaderRelation.Member(ReaderElement.Type.WAY, 1L, "from"));
        this.relation.add(new ReaderRelation.Member(ReaderElement.Type.WAY, 2L, "to"));
        OSMRestrictionException e = (OSMRestrictionException)Assertions.assertThrows(OSMRestrictionException.class, () -> OSMRestrictionConverter.extractMembers((ReaderRelation)this.relation));
        Assertions.assertTrue((boolean)e.getMessage().contains("has no member with role 'via'"), (String)e.getMessage());
    }

    @Test
    void multipleViaNodes() {
        this.relation.add(new ReaderRelation.Member(ReaderElement.Type.WAY, 1L, "from"));
        this.relation.add(new ReaderRelation.Member(ReaderElement.Type.NODE, 2L, "via"));
        this.relation.add(new ReaderRelation.Member(ReaderElement.Type.NODE, 3L, "via"));
        this.relation.add(new ReaderRelation.Member(ReaderElement.Type.WAY, 4L, "to"));
        OSMRestrictionException e = (OSMRestrictionException)Assertions.assertThrows(OSMRestrictionException.class, () -> OSMRestrictionConverter.extractMembers((ReaderRelation)this.relation));
        Assertions.assertTrue((boolean)e.getMessage().contains("has multiple members with role 'via' and type 'node'"), (String)e.getMessage());
    }

    @Test
    void multipleFromButNotNoEntry() {
        this.relation.add(new ReaderRelation.Member(ReaderElement.Type.WAY, 1L, "from"));
        this.relation.add(new ReaderRelation.Member(ReaderElement.Type.WAY, 2L, "from"));
        this.relation.add(new ReaderRelation.Member(ReaderElement.Type.NODE, 3L, "via"));
        this.relation.add(new ReaderRelation.Member(ReaderElement.Type.WAY, 4L, "to"));
        OSMRestrictionException e = (OSMRestrictionException)Assertions.assertThrows(OSMRestrictionException.class, () -> OSMRestrictionConverter.extractMembers((ReaderRelation)this.relation));
        Assertions.assertTrue((boolean)e.getMessage().contains("has multiple members with role 'from' even though it is not a 'no_entry' restriction"), (String)e.getMessage());
    }

    @Test
    void noEntry() throws OSMRestrictionException {
        this.relation.setTag("restriction", (Object)"no_entry");
        this.relation.add(new ReaderRelation.Member(ReaderElement.Type.WAY, 1L, "from"));
        this.relation.add(new ReaderRelation.Member(ReaderElement.Type.WAY, 2L, "from"));
        this.relation.add(new ReaderRelation.Member(ReaderElement.Type.NODE, 3L, "via"));
        this.relation.add(new ReaderRelation.Member(ReaderElement.Type.WAY, 4L, "to"));
        RestrictionMembers res = OSMRestrictionConverter.extractMembers((ReaderRelation)this.relation);
        Assertions.assertEquals((Object)LongArrayList.from((long[])new long[]{1L, 2L}), (Object)res.getFromWays());
        Assertions.assertEquals((long)3L, (long)res.getViaOSMNode());
        Assertions.assertEquals((Object)LongArrayList.from((long[])new long[]{4L}), (Object)res.getToWays());
    }

    @Test
    void multipleToButNoNoExit() {
        this.relation.setTag("restriction", (Object)"no_left_turn");
        this.relation.add(new ReaderRelation.Member(ReaderElement.Type.WAY, 1L, "from"));
        this.relation.add(new ReaderRelation.Member(ReaderElement.Type.NODE, 2L, "via"));
        this.relation.add(new ReaderRelation.Member(ReaderElement.Type.WAY, 3L, "to"));
        this.relation.add(new ReaderRelation.Member(ReaderElement.Type.WAY, 4L, "to"));
        OSMRestrictionException e = (OSMRestrictionException)Assertions.assertThrows(OSMRestrictionException.class, () -> OSMRestrictionConverter.extractMembers((ReaderRelation)this.relation));
        Assertions.assertTrue((boolean)e.getMessage().contains("has multiple members with role 'to' even though it is not a 'no_exit' restriction"), (String)e.getMessage());
    }

    @Test
    void noExit() throws OSMRestrictionException {
        this.relation.setTag("restriction", (Object)"no_exit");
        this.relation.add(new ReaderRelation.Member(ReaderElement.Type.WAY, 1L, "from"));
        this.relation.add(new ReaderRelation.Member(ReaderElement.Type.NODE, 2L, "via"));
        this.relation.add(new ReaderRelation.Member(ReaderElement.Type.WAY, 3L, "to"));
        this.relation.add(new ReaderRelation.Member(ReaderElement.Type.WAY, 4L, "to"));
        RestrictionMembers res = OSMRestrictionConverter.extractMembers((ReaderRelation)this.relation);
        Assertions.assertEquals((Object)LongArrayList.from((long[])new long[]{1L}), (Object)res.getFromWays());
        Assertions.assertEquals((long)2L, (long)res.getViaOSMNode());
        Assertions.assertEquals((Object)LongArrayList.from((long[])new long[]{3L, 4L}), (Object)res.getToWays());
    }
}

