/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.ResponsePath;
import com.graphhopper.coll.GHBitSet;
import com.graphhopper.coll.GHBitSetImpl;
import com.graphhopper.config.CHProfile;
import com.graphhopper.config.LMProfile;
import com.graphhopper.config.Profile;
import com.graphhopper.routing.TestProfiles;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.GHDirectory;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.util.BreadthFirstSearch;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class GraphHopperOSMTest {
    private static final String ghLoc = "./target/tmp/ghosm";
    private static final String testOsm = "./src/test/resources/com/graphhopper/reader/osm/test-osm.xml";
    private static final String testOsm3 = "./src/test/resources/com/graphhopper/reader/osm/test-osm3.xml";
    private static final String testOsm8 = "./src/test/resources/com/graphhopper/reader/osm/test-osm8.xml";
    private GraphHopper instance;

    @BeforeEach
    public void setUp() {
        Helper.removeDir((File)new File(ghLoc));
    }

    @AfterEach
    public void tearDown() {
        if (this.instance != null) {
            this.instance.close();
        }
        Helper.removeDir((File)new File(ghLoc));
    }

    @Test
    public void testLoadOSM() {
        String profile = "car_profile";
        GraphHopper hopper = new GraphHopper().setStoreOnFlush(true).setProfiles(new Profile[]{TestProfiles.constantSpeed((String)profile)}).setGraphHopperLocation(ghLoc).setOSMFile(testOsm);
        hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile(profile)});
        hopper.importOrLoad();
        GHResponse rsp = hopper.route(new GHRequest(51.2492152, 9.4317166, 51.2, 9.4).setProfile(profile));
        Assertions.assertFalse((boolean)rsp.hasErrors());
        Assertions.assertEquals((int)3, (int)rsp.getBest().getPoints().size());
        hopper.close();
        hopper = new GraphHopper().setProfiles(new Profile[]{TestProfiles.constantSpeed((String)profile)}).setStoreOnFlush(true);
        hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile(profile)});
        hopper.setGraphHopperLocation(ghLoc);
        Assertions.assertTrue((boolean)hopper.load());
        rsp = hopper.route(new GHRequest(51.2492152, 9.4317166, 51.2, 9.4).setProfile(profile));
        Assertions.assertFalse((boolean)rsp.hasErrors());
        Assertions.assertEquals((int)3, (int)rsp.getBest().getPoints().size());
        hopper.close();
        try {
            rsp = hopper.route(new GHRequest(51.2492152, 9.4317166, 51.2, 9.4).setProfile(profile));
            Assertions.fail();
        }
        catch (Exception ex) {
            Assertions.assertEquals((Object)"You need to create a new GraphHopper instance as it is already closed", (Object)ex.getMessage());
        }
        try {
            hopper.getLocationIndex().findClosest(51.2492152, 9.4317166, EdgeFilter.ALL_EDGES);
            Assertions.fail();
        }
        catch (Exception ex) {
            Assertions.assertEquals((Object)"You need to create a new LocationIndex instance as it is already closed", (Object)ex.getMessage());
        }
    }

    @Test
    public void testLoadOSMNoCH() {
        String profile = "profile";
        GraphHopper gh = new GraphHopper().setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"profile")}).setStoreOnFlush(true).setGraphHopperLocation(ghLoc).setOSMFile(testOsm);
        gh.importOrLoad();
        Assertions.assertTrue((boolean)gh.getCHGraphs().isEmpty());
        GHResponse rsp = gh.route(new GHRequest(51.2492152, 9.4317166, 51.2, 9.4).setProfile("profile"));
        Assertions.assertFalse((boolean)rsp.hasErrors());
        Assertions.assertEquals((int)3, (int)rsp.getBest().getPoints().size());
        gh.close();
        gh = new GraphHopper().setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"profile")}).setStoreOnFlush(true).setGraphHopperLocation(ghLoc);
        Assertions.assertTrue((boolean)gh.load());
        rsp = gh.route(new GHRequest(51.2492152, 9.4317166, 51.2, 9.4).setProfile("profile"));
        Assertions.assertFalse((boolean)rsp.hasErrors());
        Assertions.assertEquals((int)3, (int)rsp.getBest().getPoints().size());
        gh.close();
        gh = new GraphHopper().setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"profile")}).setGraphHopperLocation(ghLoc).setOSMFile(testOsm);
        Assertions.assertTrue((boolean)gh.getCHGraphs().isEmpty());
        gh.close();
    }

    @Test
    public void testQueryLocationIndexWithBBox() {
        final GraphHopper gh = new GraphHopper().setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"car")}).setStoreOnFlush(true).setGraphHopperLocation(ghLoc).setOSMFile("../core/files/monaco.osm.gz");
        gh.importOrLoad();
        final NodeAccess na = gh.getBaseGraph().getNodeAccess();
        TreeSet indexNodeList = new TreeSet();
        LocationIndexTree index = (LocationIndexTree)gh.getLocationIndex();
        EdgeExplorer edgeExplorer = gh.getBaseGraph().createEdgeExplorer();
        final BBox bbox = new BBox(7.422, 7.429, 43.729, 43.734);
        index.query(bbox, edgeId -> {
            EdgeIteratorState edge = gh.getBaseGraph().getEdgeIteratorStateForKey(edgeId * 2);
            for (int i = 0; i < 2; ++i) {
                double lon;
                int nodeId = i == 0 ? edge.getBaseNode() : edge.getAdjNode();
                double lat = na.getLat(nodeId);
                if (!bbox.contains(lat, lon = na.getLon(nodeId))) continue;
                indexNodeList.add(nodeId);
            }
        });
        Assertions.assertEquals((int)152, (int)indexNodeList.size());
        Iterator iterator = indexNodeList.iterator();
        while (iterator.hasNext()) {
            int nodeId = (Integer)iterator.next();
            if (bbox.contains(na.getLat(nodeId), na.getLon(nodeId))) continue;
            Assertions.fail((String)("bbox " + String.valueOf(bbox) + " should contain " + nodeId));
        }
        final TreeSet bfsNodeList = new TreeSet();
        new BreadthFirstSearch(){

            protected GHBitSet createBitSet() {
                return new GHBitSetImpl(gh.getBaseGraph().getNodes());
            }

            protected boolean goFurther(int nodeId) {
                double lon;
                double lat = na.getLat(nodeId);
                if (bbox.contains(lat, lon = na.getLon(nodeId))) {
                    bfsNodeList.add(nodeId);
                }
                return true;
            }
        }.start(edgeExplorer, index.findClosest(43.731, 7.425, EdgeFilter.ALL_EDGES).getClosestNode());
        Assertions.assertTrue((indexNodeList.size() >= bfsNodeList.size() ? 1 : 0) != 0, (String)("index size: " + indexNodeList.size() + ", bfs size: " + bfsNodeList.size()));
        Assertions.assertTrue((boolean)indexNodeList.containsAll(bfsNodeList), (String)("index size: " + indexNodeList.size() + ", bfs size: " + bfsNodeList.size()));
    }

    @Test
    public void testLoadingWithDifferentCHConfig_issue471_pr1488() {
        Profile profile = TestProfiles.constantSpeed((String)"car");
        GraphHopper gh = new GraphHopper().setStoreOnFlush(true).setProfiles(new Profile[]{profile}).setGraphHopperLocation(ghLoc).setOSMFile(testOsm);
        gh.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile(profile.getName())});
        gh.importOrLoad();
        GHResponse rsp = gh.route(new GHRequest(51.2492152, 9.4317166, 51.2, 9.4).setProfile("car"));
        Assertions.assertFalse((boolean)rsp.hasErrors());
        Assertions.assertEquals((int)3, (int)rsp.getBest().getPoints().size());
        gh.close();
        gh = new GraphHopper().setProfiles(new Profile[]{profile}).setStoreOnFlush(true).setGraphHopperLocation(ghLoc);
        gh.load();
        Helper.removeDir((File)new File(ghLoc));
        gh = new GraphHopper().setStoreOnFlush(true).setProfiles(new Profile[]{profile}).setGraphHopperLocation(ghLoc).setOSMFile(testOsm);
        gh.importOrLoad();
        rsp = gh.route(new GHRequest(51.2492152, 9.4317166, 51.2, 9.4).setProfile("car"));
        Assertions.assertFalse((boolean)rsp.hasErrors());
        Assertions.assertEquals((int)3, (int)rsp.getBest().getPoints().size());
        gh.close();
        gh = new GraphHopper().setProfiles(new Profile[]{new Profile(profile)}).setStoreOnFlush(true);
        gh.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("car")});
        gh.setGraphHopperLocation(ghLoc);
        gh.importOrLoad();
        rsp = gh.route(new GHRequest(51.2492152, 9.4317166, 51.2, 9.4).setProfile("car"));
        Assertions.assertFalse((boolean)rsp.hasErrors());
        Assertions.assertEquals((int)3, (int)rsp.getBest().getPoints().size());
    }

    @Test
    public void testAllowMultipleReadingInstances() {
        GraphHopper instance1 = new GraphHopper().setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"car")}).setStoreOnFlush(true).setGraphHopperLocation(ghLoc).setOSMFile(testOsm);
        instance1.importOrLoad();
        GraphHopper instance2 = new GraphHopper().setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"car")}).setStoreOnFlush(true).setOSMFile(testOsm).setGraphHopperLocation(ghLoc);
        instance2.load();
        GraphHopper instance3 = new GraphHopper().setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"car")}).setStoreOnFlush(true).setOSMFile(testOsm).setGraphHopperLocation(ghLoc);
        instance3.load();
        instance1.close();
        instance2.close();
        instance3.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoNotAllowWritingAndLoadingAtTheSameTime() throws Exception {
        final CountDownLatch latch1 = new CountDownLatch(1);
        final CountDownLatch latch2 = new CountDownLatch(1);
        final GraphHopper instance1 = new GraphHopper(){

            protected void importOSM() {
                try {
                    latch2.countDown();
                    latch1.await(3L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                super.importOSM();
            }
        }.setStoreOnFlush(true).setGraphHopperLocation(ghLoc).setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"car")}).setOSMFile(testOsm);
        final AtomicReference ar = new AtomicReference();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    instance1.importOrLoad();
                }
                catch (Exception ex) {
                    ar.set(ex);
                }
            }
        };
        thread.start();
        GraphHopper instance2 = new GraphHopper().setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"car")}).setStoreOnFlush(true).setOSMFile(testOsm).setGraphHopperLocation(ghLoc);
        try {
            latch2.await(3L, TimeUnit.SECONDS);
            instance2.load();
            Assertions.fail((String)"There should have been an error because of the lock");
        }
        catch (RuntimeException ex) {
            Assertions.assertNotNull((Object)ex);
            Assertions.assertTrue((boolean)ex.getMessage().startsWith("To avoid reading partial data"), (String)ex.getMessage());
        }
        finally {
            instance2.close();
            latch1.countDown();
            thread.join();
        }
        if (ar.get() != null) {
            Assertions.assertNull(ar.get(), (String)((Exception)ar.get()).getMessage());
        }
        instance1.close();
    }

    @Test
    public void testPrepare() {
        String profile = "profile";
        this.instance = new GraphHopper().setStoreOnFlush(false).setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"profile")}).setGraphHopperLocation(ghLoc).setOSMFile(testOsm);
        this.instance.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("profile")});
        this.instance.importOrLoad();
        GHResponse rsp = this.instance.route(new GHRequest(51.2492152, 9.4317166, 51.2, 9.4).setProfile("profile").setAlgorithm("dijkstrabi"));
        Assertions.assertFalse((boolean)rsp.hasErrors());
        Assertions.assertEquals((Object)Helper.createPointList((double[])new double[]{51.249215, 9.431716, 52.0, 9.0, 51.2, 9.4}), (Object)rsp.getBest().getPoints());
        Assertions.assertEquals((int)3, (int)rsp.getBest().getPoints().size());
    }

    @Test
    public void testFootAndCar() {
        String profile1 = "profile1";
        String profile2 = "profile2";
        this.instance = new GraphHopper().setEncodedValuesString("car_access, car_average_speed, foot_access, foot_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"profile1", (String)"car"), TestProfiles.accessAndSpeed((String)"profile2", (String)"foot")}).setStoreOnFlush(false).setGraphHopperLocation(ghLoc).setOSMFile(testOsm8);
        this.instance.importOrLoad();
        ((LocationIndexTree)this.instance.getLocationIndex()).setMaxRegionSearch(300);
        Assertions.assertEquals((int)5, (int)this.instance.getBaseGraph().getNodes());
        Assertions.assertEquals((int)8, (int)this.instance.getBaseGraph().getEdges());
        GHResponse grsp = this.instance.route(new GHRequest(11.1, 50.0, 11.3, 51.0).setProfile("profile1"));
        Assertions.assertFalse((boolean)grsp.hasErrors(), (String)grsp.getErrors().toString());
        ResponsePath rsp = grsp.getBest();
        Assertions.assertEquals((int)2, (int)rsp.getPoints().size());
        Assertions.assertEquals((double)50.0, (double)rsp.getPoints().getLon(0), (double)0.001);
        Assertions.assertEquals((double)11.1, (double)rsp.getPoints().getLat(0), (double)0.001);
        Assertions.assertEquals((double)51.0, (double)rsp.getPoints().getLon(1), (double)0.001);
        Assertions.assertEquals((double)11.3, (double)rsp.getPoints().getLat(1), (double)0.001);
        grsp = this.instance.route(new GHRequest(11.1, 50.0, 11.3, 51.0).setProfile("profile2"));
        Assertions.assertFalse((boolean)grsp.hasErrors());
        rsp = grsp.getBest();
        Assertions.assertEquals((int)2, (int)rsp.getPoints().size());
        Assertions.assertEquals((double)11.68, (double)rsp.getPoints().getLat(1), (double)0.001);
        Assertions.assertEquals((double)50.644, (double)rsp.getPoints().getLon(1), (double)0.001);
        grsp = this.instance.route(new GHRequest(11.1, 50.0, 10.0, 51.0).setProfile("profile2"));
        Assertions.assertFalse((boolean)grsp.hasErrors());
        rsp = grsp.getBest();
        Assertions.assertEquals((int)2, (int)rsp.getPoints().size());
        grsp = this.instance.route(new GHRequest(11.1, 50.0, 10.0, 51.0).setProfile("profile1"));
        Assertions.assertFalse((boolean)grsp.hasErrors());
        rsp = grsp.getBest();
        Assertions.assertEquals((int)3, (int)rsp.getPoints().size());
    }

    @Test
    public void testNothingHappensWhenProfilesAreChangedForLoad() {
        this.instance = new GraphHopper().init(new GraphHopperConfig().putObject("datareader.file", (Object)testOsm3).putObject("datareader.dataaccess", (Object)"RAM").putObject("import.osm.ignored_highways", (Object)"").setProfiles(List.of(TestProfiles.constantSpeed((String)"foot"), TestProfiles.constantSpeed((String)"car")))).setGraphHopperLocation(ghLoc);
        this.instance.importOrLoad();
        Assertions.assertEquals((int)5, (int)this.instance.getBaseGraph().getNodes());
        this.instance.close();
        GraphHopper tmpGH = new GraphHopper().init(new GraphHopperConfig().putObject("datareader.file", (Object)testOsm3).putObject("datareader.dataaccess", (Object)"RAM").putObject("import.osm.ignored_highways", (Object)"").setProfiles(List.of(TestProfiles.constantSpeed((String)"foot")))).setOSMFile(testOsm3).setGraphHopperLocation(ghLoc);
        IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> ((GraphHopper)tmpGH).load());
        Assertions.assertTrue((boolean)e.getMessage().contains("Profiles do not match"), (String)e.getMessage());
        this.instance = new GraphHopper().init(new GraphHopperConfig().putObject("datareader.file", (Object)testOsm3).putObject("datareader.dataaccess", (Object)"RAM").putObject("graph.encoded_values", (Object)"road_class").putObject("import.osm.ignored_highways", (Object)"").setProfiles(List.of(TestProfiles.constantSpeed((String)"foot"), TestProfiles.constantSpeed((String)"car")))).setOSMFile(testOsm3).setGraphHopperLocation(ghLoc);
        this.instance.load();
        Assertions.assertEquals((int)5, (int)this.instance.getBaseGraph().getNodes());
        Assertions.assertEquals((Object)"road_class,road_environment,roundabout,car_access,road_class_link,max_speed,foot_subnetwork,car_subnetwork", (Object)this.instance.getEncodingManager().getEncodedValues().stream().map(EncodedValue::getName).collect(Collectors.joining(",")));
    }

    @Test
    public void testFailsForWrongEVConfig() {
        this.instance = new GraphHopper().init(new GraphHopperConfig().putObject("datareader.file", (Object)testOsm3).putObject("datareader.dataaccess", (Object)"RAM").putObject("import.osm.ignored_highways", (Object)"").setProfiles(List.of(TestProfiles.constantSpeed((String)"car")))).setGraphHopperLocation(ghLoc);
        this.instance.importOrLoad();
        this.instance.getProperties().remove("graph.encoded_values");
        this.instance.getBaseGraph().flush();
        Assertions.assertEquals((int)5, (int)this.instance.getBaseGraph().getNodes());
        this.instance.close();
        this.instance = new GraphHopper().init(new GraphHopperConfig().putObject("datareader.file", (Object)testOsm3).putObject("datareader.dataaccess", (Object)"RAM").putObject("graph.location", (Object)ghLoc).putObject("graph.encoded_values", (Object)"road_environment,road_class").putObject("import.osm.ignored_highways", (Object)"").setProfiles(List.of(TestProfiles.constantSpeed((String)"car")))).setOSMFile(testOsm3);
        this.instance.load();
        Assertions.assertEquals((int)5, (int)this.instance.getBaseGraph().getNodes());
        Assertions.assertEquals((Object)"road_class,road_environment,roundabout,car_access,road_class_link,max_speed,car_subnetwork", (Object)this.instance.getEncodingManager().getEncodedValues().stream().map(EncodedValue::getName).collect(Collectors.joining(",")));
    }

    @Test
    public void testNoNPE_ifLoadNotSuccessful() {
        String profile = "profile";
        this.instance = new GraphHopper().setProfiles(new Profile[]{new Profile(profile)}).setStoreOnFlush(true).setGraphHopperLocation(ghLoc);
        try {
            new File(ghLoc).mkdirs();
            Assertions.assertFalse((boolean)this.instance.load());
            this.instance.route(new GHRequest(10.0, 40.0, 12.0, 32.0).setProfile(profile));
            Assertions.fail();
        }
        catch (IllegalStateException ex) {
            Assertions.assertEquals((Object)"Do a successful call to load or importOrLoad before routing", (Object)ex.getMessage());
        }
    }

    @Test
    public void testDoesNotCreateEmptyFolderIfLoadingFromNonExistingPath() {
        this.instance = new GraphHopper();
        this.instance.setProfiles(new Profile[]{new Profile("car")});
        this.instance.setGraphHopperLocation(ghLoc);
        Assertions.assertFalse((boolean)this.instance.load());
        Assertions.assertFalse((boolean)new File(ghLoc).exists());
    }

    @Test
    public void testFailsForMissingParameters() {
        this.instance = new GraphHopper();
        this.instance.setOSMFile(testOsm);
        Exception ex = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> ((GraphHopper)this.instance).importOrLoad());
        Assertions.assertEquals((Object)"GraphHopperLocation is not specified. Call setGraphHopperLocation or init before", (Object)ex.getMessage());
        this.instance = new GraphHopper();
        ex = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> ((GraphHopper)this.instance).importOrLoad());
        Assertions.assertEquals((Object)"GraphHopperLocation is not specified. Call setGraphHopperLocation or init before", (Object)ex.getMessage());
        this.instance = new GraphHopper().setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"car")}).setStoreOnFlush(true).setGraphHopperLocation(ghLoc);
        ex = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> ((GraphHopper)this.instance).importOrLoad());
        Assertions.assertEquals((Object)"Couldn't load from existing folder: ./target/tmp/ghosm but also cannot use file for DataReader as it wasn't specified!", (Object)ex.getMessage());
        this.instance = new GraphHopper().setStoreOnFlush(true).setGraphHopperLocation(ghLoc).setOSMFile(testOsm3);
        ex = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> ((GraphHopper)this.instance).importOrLoad());
        Assertions.assertTrue((boolean)ex.getMessage().startsWith("There has to be at least one profile"), (String)ex.getMessage());
        this.instance = new GraphHopper().setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"car")}).setStoreOnFlush(false).setGraphHopperLocation(ghLoc);
        ex = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> ((GraphHopper)this.instance).importOrLoad());
        Assertions.assertEquals((Object)"Couldn't load from existing folder: ./target/tmp/ghosm but also cannot use file for DataReader as it wasn't specified!", (Object)ex.getMessage());
    }

    @Test
    public void testFootOnly() {
        String profile = "foot_profile";
        this.instance = new GraphHopper().setStoreOnFlush(false).setEncodedValuesString("foot_access, foot_priority, foot_average_speed").setProfiles(new Profile[]{TestProfiles.accessSpeedAndPriority((String)"foot_profile", (String)"foot")}).setGraphHopperLocation(ghLoc).setOSMFile(testOsm3);
        this.instance.getReaderConfig().setIgnoredHighways(List.of("motorway"));
        this.instance.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("foot_profile")});
        this.instance.importOrLoad();
        ((LocationIndexTree)this.instance.getLocationIndex()).setMaxRegionSearch(300);
        Assertions.assertEquals((int)2, (int)this.instance.getBaseGraph().getNodes());
        Assertions.assertEquals((int)2, (int)this.instance.getBaseGraph().getAllEdges().length());
        GHResponse grsp = this.instance.route(new GHRequest(11.1, 50.0, 11.19, 52.0).setProfile("foot_profile"));
        Assertions.assertFalse((boolean)grsp.hasErrors());
        ResponsePath rsp = grsp.getBest();
        Assertions.assertEquals((Object)Helper.createPointList((double[])new double[]{11.1, 50.0, 10.0, 51.0, 11.194015, 51.995013}), (Object)rsp.getPoints());
    }

    @Test
    public void testVia() {
        String profile = "profile";
        this.instance = new GraphHopper().setStoreOnFlush(true).init(new GraphHopperConfig().putObject("datareader.file", (Object)testOsm3).putObject("prepare.min_network_size", (Object)0).putObject("graph.encoded_values", (Object)"car_access, car_average_speed").putObject("import.osm.ignored_highways", (Object)"").setProfiles(List.of(TestProfiles.accessAndSpeed((String)"profile", (String)"car"))).setCHProfiles(Collections.singletonList(new CHProfile("profile")))).setGraphHopperLocation(ghLoc);
        this.instance.importOrLoad();
        GHPoint first = new GHPoint(11.1, 50.0);
        GHPoint second = new GHPoint(12.0, 51.0);
        GHPoint third = new GHPoint(11.2, 51.9);
        GHResponse rsp12 = this.instance.route(new GHRequest(first, second).setProfile("profile"));
        Assertions.assertFalse((boolean)rsp12.hasErrors(), (String)"should find 1->2");
        Assertions.assertEquals((double)147930.5, (double)rsp12.getBest().getDistance(), (double)0.1);
        GHResponse rsp23 = this.instance.route(new GHRequest(second, third).setProfile("profile"));
        Assertions.assertFalse((boolean)rsp23.hasErrors(), (String)"should find 2->3");
        Assertions.assertEquals((double)176608.9, (double)rsp23.getBest().getDistance(), (double)0.1);
        GHResponse grsp = this.instance.route(new GHRequest(Arrays.asList(first, second, third)).setProfile("profile"));
        Assertions.assertFalse((boolean)grsp.hasErrors(), (String)"should find 1->2->3");
        ResponsePath rsp = grsp.getBest();
        Assertions.assertEquals((double)(rsp12.getBest().getDistance() + rsp23.getBest().getDistance()), (double)rsp.getDistance(), (double)1.0E-6);
        Assertions.assertEquals((int)4, (int)rsp.getPoints().size());
        Assertions.assertEquals((int)5, (int)rsp.getInstructions().size());
        Assertions.assertEquals((int)5, (int)rsp.getInstructions().get(1).getSign());
    }

    @Test
    public void testMultipleCHPreparationsInParallel() {
        HashMap<String, Integer> shortcutCountMap = new HashMap<String, Integer>();
        for (int threadCount = 1; threadCount < 6; ++threadCount) {
            GraphHopper hopper = new GraphHopper().setStoreOnFlush(false).setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"p1", (double)60.0), TestProfiles.constantSpeed((String)"p2", (double)70.0), TestProfiles.constantSpeed((String)"p3", (double)80.0), TestProfiles.constantSpeed((String)"p4", (double)90.0)}).setGraphHopperLocation(ghLoc).setOSMFile(testOsm);
            hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("p1"), new CHProfile("p2"), new CHProfile("p3"), new CHProfile("p4")}).setPreparationThreads(threadCount);
            hopper.importOrLoad();
            Assertions.assertEquals((int)4, (int)hopper.getCHGraphs().size());
            for (Map.Entry chGraph : hopper.getCHGraphs().entrySet()) {
                String name = (String)chGraph.getKey();
                Integer shortcutCount = (Integer)shortcutCountMap.get(name);
                if (shortcutCount == null) {
                    shortcutCountMap.put(name, ((RoutingCHGraph)chGraph.getValue()).getShortcuts());
                } else {
                    Assertions.assertEquals((long)shortcutCount.intValue(), (long)((RoutingCHGraph)chGraph.getValue()).getShortcuts());
                }
                String keyError = "prepare.ch.error." + name;
                String valueError = hopper.getProperties().get(keyError);
                Assertions.assertTrue((boolean)valueError.isEmpty(), (String)("Properties for " + name + " should NOT contain error " + valueError + " [" + threadCount + "]"));
                String key = "prepare.ch.date." + name;
                String value = hopper.getProperties().get(key);
                Assertions.assertFalse((boolean)value.isEmpty(), (String)("Properties for " + name + " did NOT contain finish date [" + threadCount + "]"));
            }
            hopper.close();
        }
    }

    @Test
    public void testMultipleLMPreparationsInParallel() {
        HashMap<String, Integer> landmarkCount = new HashMap<String, Integer>();
        for (int threadCount = 1; threadCount < 6; ++threadCount) {
            GraphHopper hopper = new GraphHopper().setStoreOnFlush(false).setProfiles(Arrays.asList(TestProfiles.constantSpeed((String)"p1", (double)60.0), TestProfiles.constantSpeed((String)"p2", (double)70.0), TestProfiles.constantSpeed((String)"p3", (double)80.0), TestProfiles.constantSpeed((String)"p4", (double)90.0))).setGraphHopperLocation(ghLoc).setOSMFile(testOsm);
            hopper.getLMPreparationHandler().setLMProfiles(new LMProfile[]{new LMProfile("p1"), new LMProfile("p2"), new LMProfile("p3"), new LMProfile("p4")}).setPreparationThreads(threadCount);
            hopper.importOrLoad();
            Assertions.assertEquals((int)4, (int)hopper.getLandmarks().size());
            for (Map.Entry landmarks : hopper.getLandmarks().entrySet()) {
                String name = (String)landmarks.getKey();
                Integer landmarksCount = (Integer)landmarkCount.get(name);
                if (landmarksCount == null) {
                    landmarkCount.put(name, ((LandmarkStorage)landmarks.getValue()).getSubnetworksWithLandmarks());
                } else {
                    Assertions.assertEquals((int)landmarksCount, (int)((LandmarkStorage)landmarks.getValue()).getSubnetworksWithLandmarks());
                }
                String keyError = "prepare.lm.error." + name;
                String valueError = hopper.getProperties().get(keyError);
                Assertions.assertTrue((boolean)valueError.isEmpty(), (String)("Properties for " + name + " should NOT contain error " + valueError + " [" + threadCount + "]"));
                String key = "prepare.lm.date." + name;
                String value = hopper.getProperties().get(key);
                Assertions.assertFalse((boolean)value.isEmpty(), (String)("Properties for " + name + " did NOT contain finish date [" + threadCount + "]"));
            }
            hopper.close();
        }
    }

    @Test
    public void testMultipleProfilesForCH() {
        GraphHopper hopper = new GraphHopper().setProfiles(new Profile[]{TestProfiles.constantSpeed((String)"profile1", (double)60.0), TestProfiles.constantSpeed((String)"profile2", (double)100.0)}).setStoreOnFlush(false).setGraphHopperLocation(ghLoc).setOSMFile(testOsm);
        hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("profile1"), new CHProfile("profile2")});
        hopper.importOrLoad();
        Assertions.assertEquals((int)2, (int)hopper.getCHGraphs().size());
    }

    @Test
    public void testProfilesMustNotBeChanged() {
        GraphHopper hopper = this.createHopperWithProfiles(List.of(TestProfiles.constantSpeed((String)"bike1", (double)60.0), TestProfiles.constantSpeed((String)"bike2", (double)120.0)));
        hopper.importOrLoad();
        hopper.close();
        hopper = this.createHopperWithProfiles(List.of(TestProfiles.constantSpeed((String)"bike1", (double)60.0), TestProfiles.constantSpeed((String)"bike2", (double)120.0)));
        hopper.importOrLoad();
        hopper.close();
        hopper = this.createHopperWithProfiles(List.of(TestProfiles.constantSpeed((String)"bike1", (double)60.0), TestProfiles.constantSpeed((String)"bike2", (double)110.0)));
        IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> ((GraphHopper)hopper).importOrLoad());
        Assertions.assertTrue((boolean)e.getMessage().contains("Profiles do not match"), (String)e.getMessage());
        hopper.close();
        hopper = this.createHopperWithProfiles(List.of(TestProfiles.constantSpeed((String)"bike1", (double)60.0), TestProfiles.constantSpeed((String)"bike2", (double)120.0), TestProfiles.constantSpeed((String)"bike3", (double)110.0)));
        e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> ((GraphHopper)hopper).importOrLoad());
        Assertions.assertTrue((boolean)e.getMessage().contains("Profiles do not match"), (String)e.getMessage());
        hopper.close();
        hopper = this.createHopperWithProfiles(List.of(TestProfiles.constantSpeed((String)"bike1", (double)60.0)));
        e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> ((GraphHopper)hopper).importOrLoad());
        Assertions.assertTrue((boolean)e.getMessage().contains("Profiles do not match"), (String)e.getMessage());
        hopper.close();
    }

    private GraphHopper createHopperWithProfiles(List<Profile> profiles) {
        GraphHopper hopper = new GraphHopper();
        hopper.init(new GraphHopperConfig().putObject("graph.location", (Object)ghLoc).putObject("datareader.file", (Object)testOsm).putObject("import.osm.ignored_highways", (Object)"").setProfiles(profiles));
        return hopper;
    }

    @Test
    public void testLoadingLMAndCHProfiles() {
        Profile profile = TestProfiles.constantSpeed((String)"car");
        GraphHopper hopper = new GraphHopper().setGraphHopperLocation(ghLoc).setOSMFile(testOsm).setProfiles(new Profile[]{profile});
        hopper.getLMPreparationHandler().setLMProfiles(new LMProfile[]{new LMProfile("car")});
        hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("car")});
        hopper.importOrLoad();
        hopper.close();
        hopper = new GraphHopper().setProfiles(new Profile[]{profile});
        hopper.getLMPreparationHandler().setLMProfiles(new LMProfile[]{new LMProfile("car")});
        hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("car")});
        hopper.setGraphHopperLocation(ghLoc);
        Assertions.assertTrue((boolean)hopper.load());
        hopper.close();
        StorableProperties props = new StorableProperties((Directory)new GHDirectory(ghLoc, DAType.RAM_STORE));
        props.loadExisting();
        props.put("graph.profiles.ch.car.version", (Object)404);
        props.put("graph.profiles.lm.car.version", (Object)505);
        props.flush();
        hopper = new GraphHopper().setProfiles(new Profile[]{profile});
        hopper.getLMPreparationHandler().setLMProfiles(new LMProfile[]{new LMProfile("car")});
        hopper.setGraphHopperLocation(ghLoc);
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ((GraphHopper)hopper).load());
        Assertions.assertEquals((Object)"LM preparation of car already exists in storage and doesn't match configuration", (Object)ex.getMessage());
        hopper.close();
        hopper = new GraphHopper().setProfiles(new Profile[]{profile});
        hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("car")});
        hopper.setGraphHopperLocation(ghLoc);
        ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ((GraphHopper)hopper).load());
        Assertions.assertEquals((Object)"CH preparation of car already exists in storage and doesn't match configuration", (Object)ex.getMessage());
        hopper.close();
    }
}

