/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopper;
import com.graphhopper.config.Profile;
import com.graphhopper.reader.ReaderElement;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.reader.dem.ElevationProvider;
import com.graphhopper.reader.dem.SRTMProvider;
import com.graphhopper.reader.osm.OSMReader;
import com.graphhopper.routing.OSMReaderConfig;
import com.graphhopper.routing.TestProfiles;
import com.graphhopper.routing.ev.BikeNetwork;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.Country;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntsRefEdgeIntAccess;
import com.graphhopper.routing.ev.MtbNetwork;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.TurnRestriction;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.AccessFilter;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.AreaIndex;
import com.graphhopper.routing.util.CustomArea;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.OSMParsers;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.countryrules.CountryRuleFactory;
import com.graphhopper.routing.util.parsers.CountryParser;
import com.graphhopper.routing.util.parsers.OSMBikeNetworkTagParser;
import com.graphhopper.routing.util.parsers.OSMMtbNetworkTagParser;
import com.graphhopper.routing.util.parsers.OSMRoadAccessParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.AbstractGraphStorageTester;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;
import com.graphhopper.util.TurnCostsConfig;
import com.graphhopper.util.details.PathDetail;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class OSMReaderTest {
    private final String file1 = "test-osm.xml";
    private final String file2 = "test-osm2.xml";
    private final String file3 = "test-osm3.xml";
    private final String file4 = "test-osm4.xml";
    private final String fileBarriers = "test-barriers.xml";
    private final String dir = "./target/tmp/test-db";
    private BooleanEncodedValue carAccessEnc;
    private DecimalEncodedValue carSpeedEnc;
    private BooleanEncodedValue footAccessEnc;
    private EdgeExplorer carOutExplorer;
    private EdgeExplorer carAllExplorer;

    @BeforeEach
    public void setUp() {
        new File("./target/tmp/test-db").mkdirs();
    }

    @AfterEach
    public void tearDown() {
        Helper.removeDir((File)new File("./target/tmp/test-db"));
    }

    @Test
    public void testMain() {
        GraphHopper hopper = new GraphHopperFacade("test-osm.xml").importOrLoad();
        BaseGraph graph = hopper.getBaseGraph();
        StorableProperties properties = hopper.getProperties();
        Assertions.assertNotNull((Object)properties.get("datareader.import.date"));
        Assertions.assertNotEquals((Object)"", (Object)properties.get("datareader.import.date"));
        Assertions.assertEquals((Object)"2013-01-02T01:10:14Z", (Object)properties.get("datareader.data.date"));
        Assertions.assertEquals((int)4, (int)graph.getNodes());
        int n20 = AbstractGraphStorageTester.getIdOf((Graph)graph, 52.0);
        int n10 = AbstractGraphStorageTester.getIdOf((Graph)graph, 51.2492152);
        int n30 = AbstractGraphStorageTester.getIdOf((Graph)graph, 51.2);
        int n50 = AbstractGraphStorageTester.getIdOf((Graph)graph, 49.0);
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{n20}), (Object)GHUtility.getNeighbors((EdgeIterator)this.carOutExplorer.setBaseNode(n10)));
        Assertions.assertEquals((int)3, (int)GHUtility.count((EdgeIterator)this.carOutExplorer.setBaseNode(n20)));
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{n20}), (Object)GHUtility.getNeighbors((EdgeIterator)this.carOutExplorer.setBaseNode(n30)));
        EdgeIterator iter = this.carOutExplorer.setBaseNode(n20);
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((Object)"street 123, B 122", (Object)iter.getName());
        Assertions.assertEquals((int)n50, (int)iter.getAdjNode());
        AbstractGraphStorageTester.assertPList(Helper.createPointList((double[])new double[]{51.25, 9.43}), iter.fetchWayGeometry(FetchMode.PILLAR_ONLY));
        Assertions.assertTrue((boolean)iter.get(this.carAccessEnc));
        Assertions.assertTrue((boolean)iter.getReverse(this.carAccessEnc));
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((Object)"route 666", (Object)iter.getName());
        Assertions.assertEquals((int)n30, (int)iter.getAdjNode());
        Assertions.assertEquals((double)93147.0, (double)iter.getDistance(), (double)1.0);
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((Object)"route 666", (Object)iter.getName());
        Assertions.assertEquals((int)n10, (int)iter.getAdjNode());
        Assertions.assertEquals((double)88643.0, (double)iter.getDistance(), (double)1.0);
        Assertions.assertTrue((boolean)iter.get(this.carAccessEnc));
        Assertions.assertTrue((boolean)iter.getReverse(this.carAccessEnc));
        Assertions.assertFalse((boolean)iter.next());
        iter = this.carOutExplorer.setBaseNode(n30);
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((Object)"route 666", (Object)iter.getName());
        Assertions.assertEquals((int)n20, (int)iter.getAdjNode());
        Assertions.assertEquals((double)93146.888, (double)iter.getDistance(), (double)1.0);
        NodeAccess na = graph.getNodeAccess();
        Assertions.assertEquals((double)9.4, (double)na.getLon(this.findID(hopper.getLocationIndex(), 51.2, 9.4)), (double)0.001);
        Assertions.assertEquals((double)10.0, (double)na.getLon(this.findID(hopper.getLocationIndex(), 49.0, 10.0)), (double)0.001);
        Assertions.assertEquals((double)51.249, (double)na.getLat(this.findID(hopper.getLocationIndex(), 51.2492152, 9.4317166)), (double)0.001);
        Assertions.assertEquals((double)9.0, (double)na.getLon(this.findID(hopper.getLocationIndex(), 51.25, 9.43)), (double)0.001);
    }

    protected int findID(LocationIndex index, double lat, double lon) {
        return index.findClosest(lat, lon, EdgeFilter.ALL_EDGES).getClosestNode();
    }

    @Test
    public void testOneWay() {
        GraphHopper hopper = new GraphHopperFacade("test-osm2.xml").setMinNetworkSize(0).importOrLoad();
        BaseGraph graph = hopper.getBaseGraph();
        StorableProperties properties = hopper.getProperties();
        Assertions.assertEquals((Object)"2014-01-02T01:10:14Z", (Object)properties.get("datareader.data.date"));
        int n20 = AbstractGraphStorageTester.getIdOf((Graph)graph, 52.0);
        int n22 = AbstractGraphStorageTester.getIdOf((Graph)graph, 52.133);
        int n23 = AbstractGraphStorageTester.getIdOf((Graph)graph, 52.144);
        int n10 = AbstractGraphStorageTester.getIdOf((Graph)graph, 51.2492152);
        int n30 = AbstractGraphStorageTester.getIdOf((Graph)graph, 51.2);
        Assertions.assertEquals((int)1, (int)GHUtility.count((EdgeIterator)this.carOutExplorer.setBaseNode(n10)));
        Assertions.assertEquals((int)2, (int)GHUtility.count((EdgeIterator)this.carOutExplorer.setBaseNode(n20)));
        Assertions.assertEquals((int)0, (int)GHUtility.count((EdgeIterator)this.carOutExplorer.setBaseNode(n30)));
        EdgeIterator iter = this.carOutExplorer.setBaseNode(n20);
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((int)n30, (int)iter.getAdjNode());
        iter = this.carAllExplorer.setBaseNode(n20);
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((int)n23, (int)iter.getAdjNode());
        Assertions.assertTrue((boolean)iter.get(this.carAccessEnc));
        Assertions.assertFalse((boolean)iter.getReverse(this.carAccessEnc));
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((int)n22, (int)iter.getAdjNode());
        Assertions.assertFalse((boolean)iter.get(this.carAccessEnc));
        Assertions.assertTrue((boolean)iter.getReverse(this.carAccessEnc));
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertFalse((boolean)iter.get(this.carAccessEnc));
        Assertions.assertTrue((boolean)iter.getReverse(this.carAccessEnc));
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((int)n30, (int)iter.getAdjNode());
        Assertions.assertTrue((boolean)iter.get(this.carAccessEnc));
        Assertions.assertFalse((boolean)iter.getReverse(this.carAccessEnc));
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((int)n10, (int)iter.getAdjNode());
        Assertions.assertFalse((boolean)iter.get(this.carAccessEnc));
        Assertions.assertTrue((boolean)iter.getReverse(this.carAccessEnc));
    }

    @Test
    public void testFerry() {
        GraphHopper hopper = new GraphHopperFacade("test-osm2.xml"){

            public void cleanUp() {
            }
        }.importOrLoad();
        BaseGraph graph = hopper.getBaseGraph();
        int n40 = AbstractGraphStorageTester.getIdOf((Graph)graph, 54.0);
        int n50 = AbstractGraphStorageTester.getIdOf((Graph)graph, 55.0);
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{n40}), (Object)GHUtility.getNeighbors((EdgeIterator)this.carAllExplorer.setBaseNode(n50)));
        int n80 = AbstractGraphStorageTester.getIdOf((Graph)graph, 54.1);
        EdgeIterator iter = this.carOutExplorer.setBaseNode(n80);
        iter.next();
        Assertions.assertEquals((double)6.0, (double)iter.get(this.carSpeedEnc), (double)0.1);
        iter = this.carOutExplorer.setBaseNode(n40);
        iter.next();
        Assertions.assertEquals((double)62.0, (double)iter.get(this.carSpeedEnc), (double)0.1);
    }

    @Test
    public void testMaxSpeed() {
        GraphHopper hopper = new GraphHopperFacade("test-osm2.xml"){

            public void cleanUp() {
            }
        }.importOrLoad();
        BaseGraph graph = hopper.getBaseGraph();
        int n60 = AbstractGraphStorageTester.getIdOf((Graph)graph, 56.0);
        EdgeIterator iter = this.carOutExplorer.setBaseNode(n60);
        iter.next();
        Assertions.assertEquals((double)36.0, (double)iter.get(this.carSpeedEnc), (double)0.1);
    }

    @Test
    public void testWayReferencesNotExistingAdjNode_issue19() {
        GraphHopper hopper = new GraphHopperFacade("test-osm4.xml").importOrLoad();
        BaseGraph graph = hopper.getBaseGraph();
        Assertions.assertEquals((int)2, (int)graph.getNodes());
        Assertions.assertEquals((int)1, (int)graph.getEdges());
        int n10 = AbstractGraphStorageTester.getIdOf((Graph)graph, 51.2492152);
        int n30 = AbstractGraphStorageTester.getIdOf((Graph)graph, 51.2);
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{n30}), (Object)GHUtility.getNeighbors((EdgeIterator)this.carOutExplorer.setBaseNode(n10)));
    }

    @Test
    public void testDoNotRejectEdgeIfFirstNodeIsMissing_issue2221() {
        GraphHopper hopper = new GraphHopperFacade("test-osm9.xml").setSortGraph(false).importOrLoad();
        BaseGraph graph = hopper.getBaseGraph();
        Assertions.assertEquals((int)2, (int)graph.getNodes());
        Assertions.assertEquals((int)1, (int)graph.getEdges());
        AllEdgesIterator iter = graph.getAllEdges();
        iter.next();
        Assertions.assertEquals((int)0, (int)iter.getBaseNode());
        Assertions.assertEquals((int)1, (int)iter.getAdjNode());
        Assertions.assertEquals((double)51.21, (double)graph.getNodeAccess().getLat(0), (double)0.001);
        Assertions.assertEquals((double)9.41, (double)graph.getNodeAccess().getLon(0), (double)0.001);
        Assertions.assertEquals((double)51.22, (double)graph.getNodeAccess().getLat(1), (double)0.001);
        Assertions.assertEquals((double)9.42, (double)graph.getNodeAccess().getLon(1), (double)0.001);
        Assertions.assertEquals((double)DistanceCalcEarth.DIST_EARTH.calcDistance(iter.fetchWayGeometry(FetchMode.ALL)), (double)iter.getDistance(), (double)0.001);
        Assertions.assertEquals((double)1312.1, (double)iter.getDistance(), (double)0.1);
        Assertions.assertEquals((double)1312.1, (double)DistanceCalcEarth.DIST_EARTH.calcDistance(iter.fetchWayGeometry(FetchMode.ALL)), (double)0.1);
        Assertions.assertFalse((boolean)iter.next());
    }

    @Test
    public void test_edgeDistanceWhenFirstNodeIsMissing_issue2221() {
        GraphHopper hopper = new GraphHopperFacade("test-osm10.xml").setSortGraph(false).importOrLoad();
        BaseGraph graph = hopper.getBaseGraph();
        Assertions.assertEquals((int)3, (int)graph.getNodes());
        Assertions.assertEquals((int)3, (int)graph.getEdges());
        AllEdgesIterator iter = graph.getAllEdges();
        while (iter.next()) {
            Assertions.assertEquals((double)DistanceCalcEarth.DIST_EARTH.calcDistance(iter.fetchWayGeometry(FetchMode.ALL)), (double)iter.getDistance(), (double)0.001);
        }
        Assertions.assertEquals((double)35.612, (double)graph.getEdgeIteratorState(0, Integer.MIN_VALUE).getDistance(), (double)0.001);
        Assertions.assertEquals((double)75.256, (double)graph.getEdgeIteratorState(1, Integer.MIN_VALUE).getDistance(), (double)0.001);
        Assertions.assertEquals((double)143.332, (double)graph.getEdgeIteratorState(2, Integer.MIN_VALUE).getDistance(), (double)0.001);
    }

    @Test
    public void testFoot() {
        GraphHopper hopper = new GraphHopperFacade("test-osm3.xml").setMinNetworkSize(0).importOrLoad();
        BaseGraph graph = hopper.getBaseGraph();
        int n10 = AbstractGraphStorageTester.getIdOf((Graph)graph, 11.1);
        int n20 = AbstractGraphStorageTester.getIdOf((Graph)graph, 12.0);
        int n30 = AbstractGraphStorageTester.getIdOf((Graph)graph, 11.2);
        int n40 = AbstractGraphStorageTester.getIdOf((Graph)graph, 11.3);
        int n50 = AbstractGraphStorageTester.getIdOf((Graph)graph, 10.0);
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{n20, n40}), (Object)GHUtility.getNeighbors((EdgeIterator)this.carAllExplorer.setBaseNode(n10)));
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[0]), (Object)GHUtility.getNeighbors((EdgeIterator)this.carOutExplorer.setBaseNode(n30)));
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{n10, n30, n40}), (Object)GHUtility.getNeighbors((EdgeIterator)this.carAllExplorer.setBaseNode(n20)));
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{n30, n40}), (Object)GHUtility.getNeighbors((EdgeIterator)this.carOutExplorer.setBaseNode(n20)));
        EdgeExplorer footOutExplorer = graph.createEdgeExplorer((EdgeFilter)AccessFilter.outEdges((BooleanEncodedValue)this.footAccessEnc));
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{n20, n50}), (Object)GHUtility.getNeighbors((EdgeIterator)footOutExplorer.setBaseNode(n10)));
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{n20, n50}), (Object)GHUtility.getNeighbors((EdgeIterator)footOutExplorer.setBaseNode(n30)));
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{n10, n30}), (Object)GHUtility.getNeighbors((EdgeIterator)footOutExplorer.setBaseNode(n20)));
    }

    @Test
    public void testNegativeIds() {
        String fileNegIds = "test-osm-negative-ids.xml";
        Exception exception = (Exception)Assertions.assertThrows(RuntimeException.class, () -> new GraphHopperFacade(fileNegIds).importOrLoad());
        Assertions.assertTrue((boolean)exception.getCause().getMessage().contains("Invalid OSM NODE Id: -10;"));
    }

    @Test
    public void testBarriers() {
        GraphHopper hopper = new GraphHopperFacade("test-barriers.xml").setSortGraph(false).setMinNetworkSize(0).importOrLoad();
        BaseGraph graph = hopper.getBaseGraph();
        Assertions.assertEquals((int)7, (int)graph.getNodes());
        Assertions.assertEquals((int)7, (int)graph.getEdges());
        int n10 = AbstractGraphStorageTester.getIdOf((Graph)graph, 51.0);
        int n20 = AbstractGraphStorageTester.getIdOf((Graph)graph, 52.0);
        int n30 = AbstractGraphStorageTester.getIdOf((Graph)graph, 53.0);
        int n50 = AbstractGraphStorageTester.getIdOf((Graph)graph, 55.0);
        int new20 = 4;
        Assertions.assertNotEquals((int)n20, (int)new20);
        NodeAccess na = graph.getNodeAccess();
        Assertions.assertEquals((double)na.getLat(n20), (double)na.getLat(new20), (double)1.0E-5);
        Assertions.assertEquals((double)na.getLon(n20), (double)na.getLon(new20), (double)1.0E-5);
        Assertions.assertEquals((int)n20, (int)this.findID(hopper.getLocationIndex(), 52.0, 9.4));
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{n20, n30}), (Object)GHUtility.getNeighbors((EdgeIterator)this.carOutExplorer.setBaseNode(n10)));
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{new20, n10, n50}), (Object)GHUtility.getNeighbors((EdgeIterator)this.carOutExplorer.setBaseNode(n30)));
        EdgeIterator iter = this.carOutExplorer.setBaseNode(n20);
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((int)n10, (int)iter.getAdjNode());
        Assertions.assertFalse((boolean)iter.next());
        iter = this.carOutExplorer.setBaseNode(new20);
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((int)n30, (int)iter.getAdjNode());
        Assertions.assertFalse((boolean)iter.next());
    }

    @Test
    public void testBarrierBetweenWays() {
        GraphHopper hopper = new GraphHopperFacade("test-barriers2.xml").setMinNetworkSize(0).importOrLoad();
        BaseGraph graph = hopper.getBaseGraph();
        Assertions.assertEquals((int)13, (int)graph.getEdges());
        int loops = 0;
        AllEdgesIterator iter = graph.getAllEdges();
        while (iter.next()) {
            Assertions.assertNotEquals((int)iter.getBaseNode(), (int)iter.getAdjNode());
            if (graph.getNodeAccess().getLat(iter.getBaseNode()) != graph.getNodeAccess().getLat(iter.getAdjNode())) continue;
            ++loops;
        }
        Assertions.assertEquals((int)5, (int)loops);
    }

    @Test
    public void testFords() {
        GraphHopper hopper = new GraphHopper();
        hopper.setEncodedValuesString("car_access|block_fords=true,car_average_speed");
        hopper.setOSMFile(this.getClass().getResource("test-barriers3.xml").getFile()).setGraphHopperLocation("./target/tmp/test-db").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"car")}).setMinNetworkSize(0).importOrLoad();
        BaseGraph graph = hopper.getBaseGraph();
        Assertions.assertEquals((int)5, (int)graph.getEdges());
        BooleanEncodedValue accessEnc = hopper.getEncodingManager().getBooleanEncodedValue(VehicleAccess.key((String)"car"));
        int blocked = 0;
        int notBlocked = 0;
        AllEdgesIterator edge = graph.getAllEdges();
        while (edge.next()) {
            if (!edge.get(accessEnc)) {
                ++blocked;
                continue;
            }
            ++notBlocked;
        }
        Assertions.assertEquals((int)2, (int)blocked);
        Assertions.assertEquals((int)3, (int)notBlocked);
    }

    @Test
    public void avoidsLoopEdges_1525() {
        GraphHopper hopper = new GraphHopperFacade("test-avoid-loops.xml").importOrLoad();
        this.checkLoop(hopper);
    }

    void checkLoop(GraphHopper hopper) {
        BaseGraph graph = hopper.getBaseGraph();
        Assertions.assertEquals((int)4, (int)graph.getNodes());
        AllEdgesIterator iter = graph.getAllEdges();
        Assertions.assertEquals((int)4, (int)iter.length());
        while (iter.next()) {
            Assertions.assertTrue((iter.getAdjNode() != iter.getBaseNode() ? 1 : 0) != 0, (String)"found a loop");
        }
        int nodeB = AbstractGraphStorageTester.getIdOf((Graph)graph, 12.0);
        Assertions.assertTrue((nodeB > -1 ? 1 : 0) != 0, (String)"could not find OSM node B");
        Assertions.assertEquals((int)4, (int)GHUtility.count((EdgeIterator)graph.createEdgeExplorer().setBaseNode(nodeB)));
    }

    @Test
    public void avoidsLoopEdgesIdenticalLatLon_1533() {
        this.checkLoop(new GraphHopperFacade("test-avoid-loops2.xml").importOrLoad());
    }

    @Test
    public void avoidsLoopEdgesIdenticalNodeIds_1533() {
        this.checkLoop(new GraphHopperFacade("test-avoid-loops3.xml").importOrLoad());
        this.checkLoop(new GraphHopperFacade("test-avoid-loops4.xml").importOrLoad());
    }

    @Test
    public void testBarriersOnTowerNodes() {
        GraphHopper hopper = new GraphHopperFacade("test-barriers.xml").setMinNetworkSize(0).importOrLoad();
        BaseGraph graph = hopper.getBaseGraph();
        Assertions.assertEquals((int)7, (int)graph.getNodes());
        Assertions.assertEquals((int)7, (int)graph.getEdges());
        int n60 = AbstractGraphStorageTester.getIdOf((Graph)graph, 56.0);
        int n50 = AbstractGraphStorageTester.getIdOf((Graph)graph, 55.0);
        int n30 = AbstractGraphStorageTester.getIdOf((Graph)graph, 53.0);
        int n80 = AbstractGraphStorageTester.getIdOf((Graph)graph, 58.0);
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{n50}), (Object)GHUtility.getNeighbors((EdgeIterator)this.carOutExplorer.setBaseNode(n60)));
        EdgeIterator iter = this.carOutExplorer.setBaseNode(n60);
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((int)n50, (int)iter.getAdjNode());
        Assertions.assertFalse((boolean)iter.next());
        Assertions.assertTrue((boolean)GHUtility.getNeighbors((EdgeIterator)this.carOutExplorer.setBaseNode(n30)).contains(n50));
        Assertions.assertEquals((Object)GHUtility.asSet((int[])new int[]{n30, n80, n60}), (Object)GHUtility.getNeighbors((EdgeIterator)this.carOutExplorer.setBaseNode(n50)));
    }

    @Test
    public void testBikeAndMtbRelation() {
        EnumEncodedValue bikeNetworkEnc = new EnumEncodedValue(BikeNetwork.KEY, RouteNetwork.class);
        EnumEncodedValue mtbNetworkEnc = new EnumEncodedValue(MtbNetwork.KEY, RouteNetwork.class);
        EncodingManager manager = new EncodingManager.Builder().add((EncodedValue)mtbNetworkEnc).add((EncodedValue)bikeNetworkEnc).build();
        OSMParsers osmParsers = new OSMParsers().addRelationTagParser(relConf -> new OSMBikeNetworkTagParser(bikeNetworkEnc, relConf)).addRelationTagParser(relConf -> new OSMMtbNetworkTagParser(mtbNetworkEnc, relConf));
        ReaderRelation osmRel = new ReaderRelation(1L);
        osmRel.add(new ReaderRelation.Member(ReaderElement.Type.WAY, 1L, ""));
        osmRel.add(new ReaderRelation.Member(ReaderElement.Type.WAY, 2L, ""));
        EnumEncodedValue transformEnc = ((OSMBikeNetworkTagParser)osmParsers.getRelationTagParsers().get(0)).getTransformerRouteRelEnc();
        osmRel.setTag("route", (Object)"bicycle");
        osmRel.setTag("network", (Object)"lcn");
        IntsRef relFlags = manager.createRelationFlags();
        IntsRefEdgeIntAccess intAccess = new IntsRefEdgeIntAccess(relFlags);
        int edgeId = 0;
        osmParsers.handleRelationTags(osmRel, relFlags);
        Assertions.assertEquals((Object)RouteNetwork.LOCAL, (Object)transformEnc.getEnum(false, edgeId, (EdgeIntAccess)intAccess));
        IntsRef before = IntsRef.deepCopyOf((IntsRef)relFlags);
        osmParsers.handleRelationTags(osmRel, relFlags);
        Assertions.assertEquals((Object)before, (Object)relFlags);
        Assertions.assertEquals((Object)RouteNetwork.LOCAL, (Object)transformEnc.getEnum(false, edgeId, (EdgeIntAccess)intAccess));
        Assertions.assertEquals((Object)RouteNetwork.LOCAL, (Object)transformEnc.getEnum(false, edgeId, (EdgeIntAccess)intAccess));
        osmRel.setTag("network", (Object)"ncn");
        osmParsers.handleRelationTags(osmRel, relFlags);
        Assertions.assertEquals((Object)RouteNetwork.NATIONAL, (Object)transformEnc.getEnum(false, edgeId, (EdgeIntAccess)intAccess));
        Assertions.assertNotEquals((Object)before, (Object)relFlags);
        osmRel.clearTags();
        transformEnc = ((OSMMtbNetworkTagParser)osmParsers.getRelationTagParsers().get(1)).getTransformerRouteRelEnc();
        osmRel.setTag("route", (Object)"mtb");
        osmRel.setTag("network", (Object)"lcn");
        osmParsers.handleRelationTags(osmRel, relFlags);
        Assertions.assertEquals((Object)RouteNetwork.LOCAL, (Object)transformEnc.getEnum(false, edgeId, (EdgeIntAccess)intAccess));
        osmParsers.handleRelationTags(osmRel, relFlags);
        Assertions.assertEquals((Object)RouteNetwork.LOCAL, (Object)transformEnc.getEnum(false, edgeId, (EdgeIntAccess)intAccess));
        Assertions.assertEquals((Object)RouteNetwork.LOCAL, (Object)transformEnc.getEnum(false, edgeId, (EdgeIntAccess)intAccess));
        osmRel.setTag("network", (Object)"ncn");
        osmParsers.handleRelationTags(osmRel, relFlags);
        Assertions.assertEquals((Object)RouteNetwork.NATIONAL, (Object)transformEnc.getEnum(false, edgeId, (EdgeIntAccess)intAccess));
        Assertions.assertNotEquals((Object)before, (Object)relFlags);
    }

    @Test
    public void testTurnRestrictionsFromXML() {
        String fileTurnRestrictions = "test-restrictions.xml";
        GraphHopper hopper = new GraphHopperFacade(fileTurnRestrictions, "").importOrLoad();
        BaseGraph graph = hopper.getBaseGraph();
        Assertions.assertEquals((int)15, (int)graph.getNodes());
        TurnCostStorage tcStorage = graph.getTurnCostStorage();
        Assertions.assertNotNull((Object)tcStorage);
        int n1 = AbstractGraphStorageTester.getIdOf((Graph)graph, 50.0, 10.0);
        int n2 = AbstractGraphStorageTester.getIdOf((Graph)graph, 52.0, 10.0);
        int n3 = AbstractGraphStorageTester.getIdOf((Graph)graph, 52.0, 11.0);
        int n4 = AbstractGraphStorageTester.getIdOf((Graph)graph, 52.0, 12.0);
        int n5 = AbstractGraphStorageTester.getIdOf((Graph)graph, 50.0, 12.0);
        int n6 = AbstractGraphStorageTester.getIdOf((Graph)graph, 51.0, 11.0);
        int n8 = AbstractGraphStorageTester.getIdOf((Graph)graph, 54.0, 11.0);
        int edge1_6 = GHUtility.getEdge((Graph)graph, (int)n1, (int)n6).getEdge();
        int edge2_3 = GHUtility.getEdge((Graph)graph, (int)n2, (int)n3).getEdge();
        int edge3_4 = GHUtility.getEdge((Graph)graph, (int)n3, (int)n4).getEdge();
        int edge3_8 = GHUtility.getEdge((Graph)graph, (int)n3, (int)n8).getEdge();
        int edge3_2 = GHUtility.getEdge((Graph)graph, (int)n3, (int)n2).getEdge();
        int edge4_3 = GHUtility.getEdge((Graph)graph, (int)n4, (int)n3).getEdge();
        int edge8_3 = GHUtility.getEdge((Graph)graph, (int)n8, (int)n3).getEdge();
        BooleanEncodedValue carTCEnc = hopper.getEncodingManager().getTurnBooleanEncodedValue(TurnRestriction.key((String)"car"));
        Assertions.assertTrue((boolean)tcStorage.get(carTCEnc, edge2_3, n3, edge3_8));
        Assertions.assertTrue((boolean)tcStorage.get(carTCEnc, edge4_3, n3, edge3_8));
        Assertions.assertTrue((boolean)tcStorage.get(carTCEnc, edge2_3, n3, edge3_8));
        Assertions.assertFalse((boolean)tcStorage.get(carTCEnc, edge2_3, n3, edge3_4));
        Assertions.assertFalse((boolean)tcStorage.get(carTCEnc, edge2_3, n3, edge3_2));
        Assertions.assertFalse((boolean)tcStorage.get(carTCEnc, edge2_3, n3, edge3_4));
        Assertions.assertFalse((boolean)tcStorage.get(carTCEnc, edge4_3, n3, edge3_2));
        Assertions.assertFalse((boolean)tcStorage.get(carTCEnc, edge8_3, n3, edge3_2));
        Assertions.assertTrue((boolean)tcStorage.get(carTCEnc, edge1_6, n1, edge1_6));
        Assertions.assertFalse((boolean)tcStorage.get(carTCEnc, edge1_6, n6, edge1_6));
        int edge4_5 = GHUtility.getEdge((Graph)graph, (int)n4, (int)n5).getEdge();
        int edge5_6 = GHUtility.getEdge((Graph)graph, (int)n5, (int)n6).getEdge();
        int edge5_1 = GHUtility.getEdge((Graph)graph, (int)n5, (int)n1).getEdge();
        Assertions.assertFalse((boolean)tcStorage.get(carTCEnc, edge4_5, n5, edge5_6));
        Assertions.assertTrue((boolean)tcStorage.get(carTCEnc, edge4_5, n5, edge5_1));
        BooleanEncodedValue bikeTCEnc = hopper.getEncodingManager().getTurnBooleanEncodedValue(TurnRestriction.key((String)"bike"));
        Assertions.assertFalse((boolean)tcStorage.get(bikeTCEnc, edge4_5, n5, edge5_6));
        int n10 = AbstractGraphStorageTester.getIdOf((Graph)graph, 40.0, 10.0);
        int n11 = AbstractGraphStorageTester.getIdOf((Graph)graph, 40.0, 11.0);
        int n14 = AbstractGraphStorageTester.getIdOf((Graph)graph, 39.0, 11.0);
        int edge10_11 = GHUtility.getEdge((Graph)graph, (int)n10, (int)n11).getEdge();
        int edge11_14 = GHUtility.getEdge((Graph)graph, (int)n11, (int)n14).getEdge();
        Assertions.assertFalse((boolean)tcStorage.get(carTCEnc, edge11_14, n11, edge10_11));
        Assertions.assertFalse((boolean)tcStorage.get(bikeTCEnc, edge11_14, n11, edge10_11));
        Assertions.assertTrue((boolean)tcStorage.get(carTCEnc, edge10_11, n11, edge11_14));
        Assertions.assertTrue((boolean)tcStorage.get(bikeTCEnc, edge10_11, n11, edge11_14));
    }

    @Test
    public void testTurnRestrictionsViaHgvTransportationMode() {
        String fileTurnRestrictions = "test-restrictions.xml";
        GraphHopper hopper = new GraphHopperFacade(fileTurnRestrictions, "").importOrLoad();
        BaseGraph graph = hopper.getBaseGraph();
        Assertions.assertEquals((int)15, (int)graph.getNodes());
        TurnCostStorage tcStorage = graph.getTurnCostStorage();
        Assertions.assertNotNull((Object)tcStorage);
        int n3 = AbstractGraphStorageTester.getIdOf((Graph)graph, 52.0, 11.0);
        int n8 = AbstractGraphStorageTester.getIdOf((Graph)graph, 54.0, 11.0);
        int n9 = AbstractGraphStorageTester.getIdOf((Graph)graph, 54.0, 10.0);
        int edge9_3 = GHUtility.getEdge((Graph)graph, (int)n9, (int)n3).getEdge();
        int edge3_8 = GHUtility.getEdge((Graph)graph, (int)n3, (int)n8).getEdge();
        BooleanEncodedValue carTCEnc = hopper.getEncodingManager().getTurnBooleanEncodedValue(TurnRestriction.key((String)"car"));
        BooleanEncodedValue truckTCEnc = hopper.getEncodingManager().getTurnBooleanEncodedValue(TurnRestriction.key((String)"truck"));
        Assertions.assertFalse((boolean)tcStorage.get(carTCEnc, edge9_3, n3, edge3_8));
        Assertions.assertTrue((boolean)tcStorage.get(truckTCEnc, edge9_3, n3, edge3_8));
    }

    @Test
    public void testRoadAttributes() {
        String fileRoadAttributes = "test-road-attributes.xml";
        GraphHopperFacade hopper = new GraphHopperFacade(fileRoadAttributes);
        hopper.importOrLoad();
        DecimalEncodedValue widthEnc = hopper.getEncodingManager().getDecimalEncodedValue("max_width");
        DecimalEncodedValue heightEnc = hopper.getEncodingManager().getDecimalEncodedValue("max_height");
        DecimalEncodedValue weightEnc = hopper.getEncodingManager().getDecimalEncodedValue("max_weight");
        BaseGraph graph = hopper.getBaseGraph();
        Assertions.assertEquals((int)5, (int)graph.getNodes());
        int na = AbstractGraphStorageTester.getIdOf((Graph)graph, 11.1, 50.0);
        int nb = AbstractGraphStorageTester.getIdOf((Graph)graph, 12.0, 51.0);
        int nc = AbstractGraphStorageTester.getIdOf((Graph)graph, 11.2, 52.0);
        int nd = AbstractGraphStorageTester.getIdOf((Graph)graph, 11.3, 51.0);
        int ne = AbstractGraphStorageTester.getIdOf((Graph)graph, 10.0, 51.0);
        EdgeIteratorState edge_ab = GHUtility.getEdge((Graph)graph, (int)na, (int)nb);
        EdgeIteratorState edge_ad = GHUtility.getEdge((Graph)graph, (int)na, (int)nd);
        EdgeIteratorState edge_ae = GHUtility.getEdge((Graph)graph, (int)na, (int)ne);
        EdgeIteratorState edge_bc = GHUtility.getEdge((Graph)graph, (int)nb, (int)nc);
        EdgeIteratorState edge_bd = GHUtility.getEdge((Graph)graph, (int)nb, (int)nd);
        EdgeIteratorState edge_cd = GHUtility.getEdge((Graph)graph, (int)nc, (int)nd);
        EdgeIteratorState edge_ce = GHUtility.getEdge((Graph)graph, (int)nc, (int)ne);
        EdgeIteratorState edge_de = GHUtility.getEdge((Graph)graph, (int)nd, (int)ne);
        Assertions.assertEquals((double)4.0, (double)edge_ab.get(heightEnc), (double)1.0E-5);
        Assertions.assertEquals((double)2.5, (double)edge_ab.get(widthEnc), (double)1.0E-5);
        Assertions.assertEquals((double)4.4, (double)edge_ab.get(weightEnc), (double)1.0E-5);
        Assertions.assertEquals((double)4.0, (double)edge_bc.get(heightEnc), (double)1.0E-5);
        Assertions.assertEquals((double)2.5, (double)edge_bc.get(widthEnc), (double)1.0E-5);
        Assertions.assertEquals((double)4.4, (double)edge_bc.get(weightEnc), (double)1.0E-5);
        Assertions.assertEquals((double)4.4, (double)edge_ad.get(heightEnc), (double)1.0E-5);
        Assertions.assertEquals((double)3.5, (double)edge_ad.get(widthEnc), (double)1.0E-5);
        Assertions.assertEquals((double)17.5, (double)edge_ad.get(weightEnc), (double)1.0E-5);
        Assertions.assertEquals((double)4.4, (double)edge_cd.get(heightEnc), (double)1.0E-5);
        Assertions.assertEquals((double)3.5, (double)edge_cd.get(widthEnc), (double)1.0E-5);
        Assertions.assertEquals((double)17.5, (double)edge_cd.get(weightEnc), (double)1.0E-5);
    }

    @Test
    public void testReadEleFromDataProvider() {
        GraphHopperFacade hopper = new GraphHopperFacade("test-osm5.xml");
        SRTMProvider provider = new SRTMProvider("../core/files");
        hopper.setElevationProvider((ElevationProvider)provider);
        hopper.importOrLoad();
        BaseGraph graph = hopper.getBaseGraph();
        int n10 = AbstractGraphStorageTester.getIdOf((Graph)graph, 49.501);
        int n30 = AbstractGraphStorageTester.getIdOf((Graph)graph, 49.5011);
        int n50 = AbstractGraphStorageTester.getIdOf((Graph)graph, 49.5001);
        EdgeIteratorState edge = GHUtility.getEdge((Graph)graph, (int)n50, (int)n30);
        Assertions.assertEquals((Object)Helper.createPointList3D((double[])new double[]{49.5001, 11.501, 426.0, 49.5002, 11.5015, 441.0, 49.5011, 11.502, 410.0}), (Object)edge.fetchWayGeometry(FetchMode.ALL));
        edge = GHUtility.getEdge((Graph)graph, (int)n10, (int)n50);
        Assertions.assertEquals((Object)Helper.createPointList3D((double[])new double[]{49.501, 11.5001, 383.0, 49.5001, 11.501, 426.0}), (Object)edge.fetchWayGeometry(FetchMode.ALL));
    }

    @Test
    public void testTurnFlagCombination() {
        GraphHopper hopper = new GraphHopper();
        hopper.setEncodedValuesString("car_average_speed,car_access,bike_access,bike_average_speed,bike_priority");
        hopper.setOSMFile(this.getClass().getResource("test-multi-profile-turn-restrictions.xml").getFile()).setGraphHopperLocation("./target/tmp/test-db").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"bike").setTurnCostsConfig(new TurnCostsConfig(List.of("bicycle"))), TestProfiles.accessAndSpeed((String)"car").setTurnCostsConfig(new TurnCostsConfig(List.of("motorcar", "motor_vehicle"))), TestProfiles.accessAndSpeed((String)"truck", (String)"car").setTurnCostsConfig(new TurnCostsConfig(List.of("hgv", "motor_vehicle")))}).setSortGraph(false).importOrLoad();
        EncodingManager manager = hopper.getEncodingManager();
        BooleanEncodedValue carTCEnc = manager.getTurnBooleanEncodedValue(TurnRestriction.key((String)"car"));
        BooleanEncodedValue truckTCEnc = manager.getTurnBooleanEncodedValue(TurnRestriction.key((String)"truck"));
        BooleanEncodedValue bikeTCEnc = manager.getTurnBooleanEncodedValue(TurnRestriction.key((String)"bike"));
        BaseGraph graph = hopper.getBaseGraph();
        TurnCostStorage tcStorage = graph.getTurnCostStorage();
        int edge1 = GHUtility.getEdge((Graph)graph, (int)1, (int)0).getEdge();
        int edge2 = GHUtility.getEdge((Graph)graph, (int)0, (int)2).getEdge();
        Assertions.assertTrue((boolean)tcStorage.get(carTCEnc, edge1, 0, edge2));
        Assertions.assertTrue((boolean)tcStorage.get(truckTCEnc, edge1, 0, edge2));
        Assertions.assertFalse((boolean)tcStorage.get(bikeTCEnc, edge1, 0, edge2));
        edge1 = GHUtility.getEdge((Graph)graph, (int)2, (int)0).getEdge();
        edge2 = GHUtility.getEdge((Graph)graph, (int)0, (int)3).getEdge();
        Assertions.assertFalse((boolean)tcStorage.get(carTCEnc, edge1, 0, edge2));
        Assertions.assertFalse((boolean)tcStorage.get(truckTCEnc, edge1, 0, edge2));
        Assertions.assertTrue((boolean)tcStorage.get(bikeTCEnc, edge1, 0, edge2));
        edge1 = GHUtility.getEdge((Graph)graph, (int)3, (int)0).getEdge();
        edge2 = GHUtility.getEdge((Graph)graph, (int)0, (int)2).getEdge();
        Assertions.assertFalse((boolean)tcStorage.get(carTCEnc, edge1, 0, edge2));
        Assertions.assertTrue((boolean)tcStorage.get(truckTCEnc, edge1, 0, edge2));
        Assertions.assertFalse((boolean)tcStorage.get(bikeTCEnc, edge1, 0, edge2));
    }

    @Test
    public void testConditionalTurnRestriction() {
        String fileConditionalTurnRestrictions = "test-conditional-turn-restrictions.xml";
        GraphHopper hopper = new GraphHopperFacade(fileConditionalTurnRestrictions, "").setMinNetworkSize(0).importOrLoad();
        BaseGraph graph = hopper.getBaseGraph();
        Assertions.assertEquals((int)8, (int)graph.getNodes());
        TurnCostStorage tcStorage = graph.getTurnCostStorage();
        Assertions.assertNotNull((Object)tcStorage);
        int n1 = AbstractGraphStorageTester.getIdOf((Graph)graph, 50.0, 10.0);
        int n2 = AbstractGraphStorageTester.getIdOf((Graph)graph, 52.0, 10.0);
        int n3 = AbstractGraphStorageTester.getIdOf((Graph)graph, 52.0, 11.0);
        int n4 = AbstractGraphStorageTester.getIdOf((Graph)graph, 52.0, 12.0);
        int n5 = AbstractGraphStorageTester.getIdOf((Graph)graph, 50.0, 12.0);
        int n6 = AbstractGraphStorageTester.getIdOf((Graph)graph, 51.0, 11.0);
        int n8 = AbstractGraphStorageTester.getIdOf((Graph)graph, 54.0, 11.0);
        int edge1_6 = GHUtility.getEdge((Graph)graph, (int)n1, (int)n6).getEdge();
        int edge2_3 = GHUtility.getEdge((Graph)graph, (int)n2, (int)n3).getEdge();
        int edge3_4 = GHUtility.getEdge((Graph)graph, (int)n3, (int)n4).getEdge();
        int edge3_8 = GHUtility.getEdge((Graph)graph, (int)n3, (int)n8).getEdge();
        int edge3_2 = GHUtility.getEdge((Graph)graph, (int)n3, (int)n2).getEdge();
        int edge4_3 = GHUtility.getEdge((Graph)graph, (int)n4, (int)n3).getEdge();
        int edge8_3 = GHUtility.getEdge((Graph)graph, (int)n8, (int)n3).getEdge();
        int edge4_5 = GHUtility.getEdge((Graph)graph, (int)n4, (int)n5).getEdge();
        int edge5_6 = GHUtility.getEdge((Graph)graph, (int)n5, (int)n6).getEdge();
        int edge5_1 = GHUtility.getEdge((Graph)graph, (int)n5, (int)n1).getEdge();
        BooleanEncodedValue carTCEnc = hopper.getEncodingManager().getTurnBooleanEncodedValue(TurnRestriction.key((String)"car"));
        Assertions.assertTrue((boolean)tcStorage.get(carTCEnc, edge2_3, n3, edge3_8));
        Assertions.assertTrue((boolean)tcStorage.get(carTCEnc, edge4_3, n3, edge3_8));
        Assertions.assertFalse((boolean)tcStorage.get(carTCEnc, edge2_3, n3, edge3_4));
        Assertions.assertFalse((boolean)tcStorage.get(carTCEnc, edge2_3, n3, edge3_2));
        Assertions.assertFalse((boolean)tcStorage.get(carTCEnc, edge2_3, n3, edge3_4));
        Assertions.assertFalse((boolean)tcStorage.get(carTCEnc, edge4_3, n3, edge3_2));
        Assertions.assertFalse((boolean)tcStorage.get(carTCEnc, edge8_3, n3, edge3_2));
        BooleanEncodedValue bikeTCEnc = hopper.getEncodingManager().getTurnBooleanEncodedValue(TurnRestriction.key((String)"bike"));
        Assertions.assertFalse((boolean)tcStorage.get(bikeTCEnc, edge2_3, n3, edge3_8));
        Assertions.assertFalse((boolean)tcStorage.get(bikeTCEnc, edge4_3, n3, edge3_8));
        Assertions.assertFalse((boolean)tcStorage.get(bikeTCEnc, edge2_3, n3, edge3_4));
        Assertions.assertFalse((boolean)tcStorage.get(bikeTCEnc, edge2_3, n3, edge3_2));
        Assertions.assertFalse((boolean)tcStorage.get(bikeTCEnc, edge2_3, n3, edge3_4));
        Assertions.assertFalse((boolean)tcStorage.get(bikeTCEnc, edge4_3, n3, edge3_2));
        Assertions.assertFalse((boolean)tcStorage.get(bikeTCEnc, edge8_3, n3, edge3_2));
        Assertions.assertTrue((boolean)tcStorage.get(carTCEnc, edge1_6, n1, edge1_6));
        Assertions.assertFalse((boolean)tcStorage.get(carTCEnc, edge1_6, n6, edge1_6));
        Assertions.assertFalse((boolean)tcStorage.get(bikeTCEnc, edge1_6, n1, edge1_6));
        Assertions.assertFalse((boolean)tcStorage.get(bikeTCEnc, edge1_6, n6, edge1_6));
        Assertions.assertFalse((boolean)tcStorage.get(carTCEnc, edge4_5, n5, edge5_6));
        Assertions.assertTrue((boolean)tcStorage.get(carTCEnc, edge4_5, n5, edge5_1));
        Assertions.assertFalse((boolean)tcStorage.get(bikeTCEnc, edge4_5, n5, edge5_6));
        Assertions.assertFalse((boolean)tcStorage.get(bikeTCEnc, edge4_5, n5, edge5_1));
    }

    @Test
    public void testMultipleTurnRestrictions() {
        String fileMultipleConditionalTurnRestrictions = "test-multiple-conditional-turn-restrictions.xml";
        GraphHopper hopper = new GraphHopperFacade(fileMultipleConditionalTurnRestrictions, "").importOrLoad();
        BaseGraph graph = hopper.getBaseGraph();
        Assertions.assertEquals((int)5, (int)graph.getNodes());
        TurnCostStorage tcStorage = graph.getTurnCostStorage();
        Assertions.assertNotNull((Object)tcStorage);
        int n1 = AbstractGraphStorageTester.getIdOf((Graph)graph, 50.0, 10.0);
        int n2 = AbstractGraphStorageTester.getIdOf((Graph)graph, 52.0, 10.0);
        int n3 = AbstractGraphStorageTester.getIdOf((Graph)graph, 52.0, 11.0);
        int n4 = AbstractGraphStorageTester.getIdOf((Graph)graph, 52.0, 12.0);
        int n5 = AbstractGraphStorageTester.getIdOf((Graph)graph, 50.0, 12.0);
        int edge1_2 = GHUtility.getEdge((Graph)graph, (int)n1, (int)n2).getEdge();
        int edge2_3 = GHUtility.getEdge((Graph)graph, (int)n2, (int)n3).getEdge();
        int edge3_4 = GHUtility.getEdge((Graph)graph, (int)n3, (int)n4).getEdge();
        int edge4_5 = GHUtility.getEdge((Graph)graph, (int)n4, (int)n5).getEdge();
        int edge5_1 = GHUtility.getEdge((Graph)graph, (int)n5, (int)n1).getEdge();
        BooleanEncodedValue carTCEnc = hopper.getEncodingManager().getTurnBooleanEncodedValue(TurnRestriction.key((String)"car"));
        BooleanEncodedValue bikeTCEnc = hopper.getEncodingManager().getTurnBooleanEncodedValue(TurnRestriction.key((String)"bike"));
        Assertions.assertTrue((boolean)tcStorage.get(carTCEnc, edge1_2, n2, edge2_3));
        Assertions.assertFalse((boolean)tcStorage.get(bikeTCEnc, edge1_2, n2, edge2_3));
        Assertions.assertTrue((boolean)tcStorage.get(carTCEnc, edge3_4, n4, edge4_5));
        Assertions.assertFalse((boolean)tcStorage.get(bikeTCEnc, edge3_4, n4, edge4_5));
        Assertions.assertFalse((boolean)tcStorage.get(carTCEnc, edge4_5, n5, edge5_1));
        Assertions.assertFalse((boolean)tcStorage.get(bikeTCEnc, edge4_5, n5, edge5_1));
        Assertions.assertTrue((boolean)tcStorage.get(carTCEnc, edge5_1, n1, edge1_2));
        Assertions.assertFalse((boolean)tcStorage.get(bikeTCEnc, edge5_1, n1, edge1_2));
    }

    @Test
    public void testPreferredLanguage() {
        GraphHopper hopper = new GraphHopperFacade("test-osm.xml", "de").importOrLoad();
        BaseGraph graph = hopper.getBaseGraph();
        int n20 = AbstractGraphStorageTester.getIdOf((Graph)graph, 52.0);
        EdgeIterator iter = this.carOutExplorer.setBaseNode(n20);
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((Object)"stra\u00dfe 123, B 122", (Object)iter.getName());
        hopper = new GraphHopperFacade("test-osm.xml", "el").importOrLoad();
        graph = hopper.getBaseGraph();
        n20 = AbstractGraphStorageTester.getIdOf((Graph)graph, 52.0);
        iter = this.carOutExplorer.setBaseNode(n20);
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertTrue((boolean)iter.next());
        Assertions.assertEquals((Object)"\u03b4\u03b9\u03b1\u03b4\u03c1\u03bf\u03bc\u03ae 666", (Object)iter.getName());
    }

    @Test
    public void testDataDateWithinPBF() {
        GraphHopper hopper = new GraphHopperFacade("test-osm6.pbf").setMinNetworkSize(0).importOrLoad();
        StorableProperties properties = hopper.getProperties();
        Assertions.assertEquals((Object)"2014-01-02T00:10:14Z", (Object)properties.get("datareader.data.date"));
    }

    @Test
    public void testCrossBoundary_issue667() {
        GraphHopper hopper = new GraphHopperFacade("test-osm-waterway.xml").importOrLoad();
        Snap snap = hopper.getLocationIndex().findClosest(0.1, 179.5, EdgeFilter.ALL_EDGES);
        Assertions.assertTrue((boolean)snap.isValid());
        Assertions.assertEquals((double)0.1, (double)snap.getSnappedPoint().lat, (double)0.1);
        Assertions.assertEquals((double)179.5, (double)snap.getSnappedPoint().lon, (double)0.1);
        Assertions.assertEquals((double)11.0, (double)(snap.getClosestEdge().getDistance() / 1000.0), (double)1.0);
        snap = hopper.getLocationIndex().findClosest(0.1, -179.6, EdgeFilter.ALL_EDGES);
        Assertions.assertTrue((boolean)snap.isValid());
        Assertions.assertEquals((double)0.1, (double)snap.getSnappedPoint().lat, (double)0.1);
        Assertions.assertEquals((double)-179.6, (double)snap.getSnappedPoint().lon, (double)0.1);
        Assertions.assertEquals((double)112.0, (double)(snap.getClosestEdge().getDistance() / 1000.0), (double)1.0);
    }

    @Test
    public void testRoadClassInfo() {
        GraphHopper gh = new GraphHopper(){

            protected File _getOSMFile() {
                return new File(((Object)((Object)this)).getClass().getResource("test-osm2.xml").getFile());
            }
        }.setOSMFile("dummy").setEncodedValuesString("car_access,car_average_speed").setProfiles(new Profile[]{TestProfiles.accessAndSpeed((String)"profile", (String)"car")}).setMinNetworkSize(0).setGraphHopperLocation("./target/tmp/test-db").importOrLoad();
        GHResponse response = gh.route(new GHRequest(51.2492152, 9.4317166, 52.133, 9.1).setProfile("profile").setPathDetails(Collections.singletonList("road_class")));
        Assertions.assertFalse((boolean)response.hasErrors(), (String)response.getErrors().toString());
        List list = (List)response.getBest().getPathDetails().get("road_class");
        Assertions.assertEquals((int)3, (int)list.size());
        Assertions.assertEquals((Object)"motorway", (Object)((PathDetail)list.get(0)).getValue());
        response = gh.route(new GHRequest(51.2492152, 9.4317166, 52.133, 9.1).setProfile("profile").setPathDetails(Arrays.asList("toll", "country")));
        Throwable ex = (Throwable)response.getErrors().get(0);
        Assertions.assertEquals((Object)"Cannot find the path details: [toll, country]", (Object)ex.getMessage());
    }

    @Test
    public void testCountries() throws IOException {
        EnumEncodedValue roadAccessEnc = RoadAccess.create();
        EncodingManager em = new EncodingManager.Builder().add((EncodedValue)roadAccessEnc).build();
        OSMParsers osmParsers = new OSMParsers();
        osmParsers.addWayTagParser((TagParser)new OSMRoadAccessParser(roadAccessEnc, OSMRoadAccessParser.toOSMRestrictions((TransportationMode)TransportationMode.CAR), RoadAccess::countryHook, RoadAccess::find));
        BaseGraph graph = new BaseGraph.Builder(em).create();
        OSMReader reader = new OSMReader(graph, osmParsers, new OSMReaderConfig());
        reader.setCountryRuleFactory(new CountryRuleFactory());
        reader.setAreaIndex(this.createCountryIndex());
        reader.setFile(new File(this.getClass().getResource("test-osm11.xml").getFile()));
        reader.readGraph();
        EdgeIteratorState edgeBerlin = graph.getEdgeIteratorState(0, Integer.MIN_VALUE);
        EdgeIteratorState edgeParis = graph.getEdgeIteratorState(1, Integer.MIN_VALUE);
        Assertions.assertEquals((Object)"berlin", (Object)edgeBerlin.getName());
        Assertions.assertEquals((Object)"paris", (Object)edgeParis.getName());
        Assertions.assertEquals((Object)RoadAccess.DESTINATION, (Object)edgeBerlin.get(roadAccessEnc));
        Assertions.assertEquals((Object)RoadAccess.YES, (Object)edgeParis.get(roadAccessEnc));
        ReaderWay way = new ReaderWay(0L);
        PointList list = new PointList();
        list.add(49.214906, -2.156067);
        reader.setArtificialWayTags(list, way, 10.0, Collections.singletonList(new HashMap()));
        Assertions.assertEquals((Object)"JEY", (Object)way.getTag("country", null).toString());
    }

    @Test
    public void testCurvedWayAlongBorder() throws IOException {
        EnumEncodedValue countryEnc = Country.create();
        EncodingManager em = EncodingManager.start().add((EncodedValue)VehicleSpeed.create((String)"car", (int)5, (double)5.0, (boolean)false)).add((EncodedValue)VehicleAccess.create((String)"car")).add((EncodedValue)countryEnc).build();
        OSMParsers osmParsers = new OSMParsers().addWayTagParser((TagParser)new CountryParser(countryEnc));
        BaseGraph graph = new BaseGraph.Builder(em).create();
        OSMReader reader = new OSMReader(graph, osmParsers, new OSMReaderConfig());
        reader.setCountryRuleFactory(new CountryRuleFactory());
        reader.setAreaIndex(this.createCountryIndex());
        reader.setFile(new File(this.getClass().getResource("test-osm12.xml").getFile()));
        reader.readGraph();
        Assertions.assertEquals((int)1, (int)graph.getEdges());
        AllEdgesIterator iter = graph.getAllEdges();
        iter.next();
        Assertions.assertEquals((Object)Country.BGR, (Object)iter.get(countryEnc));
    }

    @Test
    public void testFixWayName() {
        Assertions.assertEquals((Object)"B8, B12", (Object)OSMReader.fixWayName((String)"B8;B12"));
        Assertions.assertEquals((Object)"B8, B12", (Object)OSMReader.fixWayName((String)"B8; B12"));
    }

    private AreaIndex<CustomArea> createCountryIndex() {
        return new AreaIndex(GHUtility.readCountries());
    }

    class GraphHopperFacade
    extends GraphHopper {
        public GraphHopperFacade(String osmFile) {
            this(osmFile, "");
        }

        public GraphHopperFacade(String osmFile, String prefLang) {
            this.setStoreOnFlush(false);
            this.setOSMFile(osmFile);
            this.setGraphHopperLocation("./target/tmp/test-db");
            String str = "max_width,max_height,max_weight,foot_access, foot_priority, foot_average_speed, car_access, car_average_speed, bike_access, bike_priority, bike_average_speed";
            this.setEncodedValuesString(str);
            this.setProfiles(new Profile[]{TestProfiles.accessSpeedAndPriority((String)"foot"), TestProfiles.accessAndSpeed((String)"car").setTurnCostsConfig(new TurnCostsConfig(List.of("motorcar", "motor_vehicle"))), TestProfiles.accessSpeedAndPriority((String)"bike").setTurnCostsConfig(new TurnCostsConfig(List.of("bicycle"))), TestProfiles.constantSpeed((String)"truck", (double)100.0).setTurnCostsConfig(new TurnCostsConfig(List.of("hgv", "motor_vehicle")))});
            this.getReaderConfig().setPreferredLanguage(prefLang);
        }

        protected void importOSM() {
            BaseGraph baseGraph = new BaseGraph.Builder(this.getEncodingManager()).set3D(this.hasElevation()).withTurnCosts(this.getEncodingManager().needsTurnCostsSupport()).build();
            this.setBaseGraph(baseGraph);
            super.importOSM();
            OSMReaderTest.this.carAccessEnc = this.getEncodingManager().getBooleanEncodedValue(VehicleAccess.key((String)"car"));
            OSMReaderTest.this.carSpeedEnc = this.getEncodingManager().getDecimalEncodedValue(VehicleSpeed.key((String)"car"));
            OSMReaderTest.this.carOutExplorer = this.getBaseGraph().createEdgeExplorer((EdgeFilter)AccessFilter.outEdges((BooleanEncodedValue)OSMReaderTest.this.carAccessEnc));
            OSMReaderTest.this.carAllExplorer = this.getBaseGraph().createEdgeExplorer((EdgeFilter)AccessFilter.allEdges((BooleanEncodedValue)OSMReaderTest.this.carAccessEnc));
            OSMReaderTest.this.footAccessEnc = this.getEncodingManager().getBooleanEncodedValue(VehicleAccess.key((String)"foot"));
        }

        protected File _getOSMFile() {
            return new File(((Object)((Object)this)).getClass().getResource(this.getOSMFile()).getFile());
        }
    }
}

