/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm;

import com.graphhopper.reader.osm.OSMReaderUtility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OSMReaderUtilityTest {
    @Test
    public void testParseDuration() {
        Assertions.assertEquals((long)600L, (long)OSMReaderUtility.parseDuration((String)"00:10"));
        Assertions.assertEquals((long)2100L, (long)OSMReaderUtility.parseDuration((String)"35"));
        Assertions.assertEquals((long)4200L, (long)OSMReaderUtility.parseDuration((String)"01:10"));
        Assertions.assertEquals((long)4202L, (long)OSMReaderUtility.parseDuration((String)"01:10:02"));
        Assertions.assertEquals((long)0L, (long)OSMReaderUtility.parseDuration(null));
        Assertions.assertEquals((long)72000L, (long)OSMReaderUtility.parseDuration((String)"20:00"));
        Assertions.assertEquals((long)1200L, (long)OSMReaderUtility.parseDuration((String)"0:20:00"));
        Assertions.assertEquals((long)8402L, (long)OSMReaderUtility.parseDuration((String)"02:20:02"));
        Assertions.assertEquals((long)62L, (long)(OSMReaderUtility.parseDuration((String)"P2M") / 86400L));
        Assertions.assertEquals((long)120L, (long)OSMReaderUtility.parseDuration((String)"PT2M"));
        Assertions.assertEquals((long)18756L, (long)OSMReaderUtility.parseDuration((String)"PT5H12M36S"));
    }

    @Test
    public void testWrongDurationFormats() {
        this.assertParsDurationError("PT5h12m36s");
        this.assertParsDurationError("oh");
        this.assertParsDurationError("01:10:2");
    }

    private void assertParsDurationError(String value) {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> OSMReaderUtility.parseDuration((String)value));
        Assertions.assertEquals((Object)("Cannot parse duration tag value: " + value), (Object)e.getMessage());
    }
}

