/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm;

import com.graphhopper.reader.ReaderWay;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReaderElementTest {
    @Test
    public void testHasTag() {
        ReaderWay instance = new ReaderWay(1L);
        instance.setTag("surface", (Object)"something");
        Assertions.assertTrue((boolean)instance.hasTag("surface", new String[]{"now", "something"}));
        Assertions.assertFalse((boolean)instance.hasTag("surface", new String[]{"now", "not"}));
    }

    @Test
    public void testSetTags() {
        ReaderWay instance = new ReaderWay(1L);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("test", "xy");
        instance.setTags(map);
        Assertions.assertTrue((boolean)instance.hasTag("test", (Object)"xy"));
        instance.setTags(null);
        Assertions.assertFalse((boolean)instance.hasTag("test", (Object)"xy"));
    }

    @Test
    public void testInvalidIDs() {
        Exception exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> new ReaderWay(-1L));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Invalid OSM WAY Id: -1;"));
    }
}

