/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm;

import com.graphhopper.reader.osm.OSMRestrictionException;
import com.graphhopper.reader.osm.RestrictionTagParser;
import com.graphhopper.reader.osm.RestrictionType;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class RestrictionTagParserTest {
    private final Map<String, Object> tags = new LinkedHashMap<String, Object>();

    RestrictionTagParserTest() {
    }

    @BeforeEach
    void setup() {
        this.tags.clear();
        this.tags.put("type", "restriction");
    }

    private RestrictionTagParser.Result parseForVehicleTypes(String ... vehicleTypes) throws OSMRestrictionException {
        return new RestrictionTagParser(Arrays.asList(vehicleTypes), null).parseRestrictionTags(this.tags);
    }

    @Test
    void noRestrictions() {
        OSMRestrictionException e = (OSMRestrictionException)Assertions.assertThrows(OSMRestrictionException.class, () -> this.parseForVehicleTypes("motorcar"));
        Assertions.assertTrue((boolean)e.getMessage().contains("neither has a 'restriction' nor 'restriction:' tags"), (String)e.getMessage());
    }

    @Test
    void exceptButNoRestriction() {
        this.tags.put("restriction:bicycle", "no_right_turn");
        this.tags.put("except", "psv");
        OSMRestrictionException e = (OSMRestrictionException)Assertions.assertThrows(OSMRestrictionException.class, () -> this.parseForVehicleTypes("psv"));
        Assertions.assertTrue((boolean)e.getMessage().contains("has an 'except', but no 'restriction' or 'restriction:conditional' tag"), (String)e.getMessage());
    }

    @Test
    void exceptButOnlyLimitedRestriction() {
        this.tags.put("restriction:hgv:conditional", "no_right_turn @ (weight > 3.5)");
        this.tags.put("except", "psv");
        OSMRestrictionException e = (OSMRestrictionException)Assertions.assertThrows(OSMRestrictionException.class, () -> this.parseForVehicleTypes("psv"));
        Assertions.assertTrue((boolean)e.getMessage().contains("has an 'except', but no 'restriction' or 'restriction:conditional' tag"), (String)e.getMessage());
    }

    @Test
    void exceptWithConditional() throws OSMRestrictionException {
        this.tags.put("restriction:conditional", "no_right_turn @ (weight > 3.5)");
        this.tags.put("except", "psv");
        Assertions.assertNull((Object)this.parseForVehicleTypes("psv"));
    }

    @Test
    void restrictionAndLimitedRestriction() {
        this.tags.put("restriction", "no_left_turn");
        this.tags.put("restriction:psv", "no_left_turn");
        OSMRestrictionException e = (OSMRestrictionException)Assertions.assertThrows(OSMRestrictionException.class, () -> this.parseForVehicleTypes("psv"));
        Assertions.assertTrue((boolean)e.getMessage().contains("has a 'restriction' tag, but also 'restriction:' tags"), (String)e.getMessage());
    }

    @Test
    void restrictionAndLimitedRestriction_giveWay() throws OSMRestrictionException {
        this.tags.put("restriction:bicycle", "give_way");
        this.tags.put("restriction", "no_left_turn");
        RestrictionTagParser.Result res = this.parseForVehicleTypes("bicycle");
        Assertions.assertEquals((Object)"no_left_turn", (Object)res.getRestriction());
        Assertions.assertEquals((Object)RestrictionType.NO, (Object)res.getRestrictionType());
    }

    @Test
    void bicycle_giveWay() {
        this.tags.put("restriction:bicycle", "give_way");
        OSMRestrictionException e = (OSMRestrictionException)Assertions.assertThrows(OSMRestrictionException.class, () -> this.parseForVehicleTypes("bicycle"));
        Assertions.assertTrue((boolean)e.isWithoutWarning());
    }

    @Test
    void conditional() throws OSMRestrictionException {
        this.tags.put("restriction:conditional", "no_left_turn @ (weight > 3.5)");
        Assertions.assertNull((Object)this.parseForVehicleTypes("motorcar"));
    }

    @Test
    void except() throws OSMRestrictionException {
        this.tags.put("restriction", "no_left_turn");
        this.tags.put("except", "psv");
        Assertions.assertNull((Object)this.parseForVehicleTypes("psv"));
    }

    @Test
    void exceptOther() throws OSMRestrictionException {
        this.tags.put("restriction", "only_left_turn");
        this.tags.put("except", "psv");
        RestrictionTagParser.Result res = this.parseForVehicleTypes("motorcar");
        Assertions.assertEquals((Object)"only_left_turn", (Object)res.getRestriction());
        Assertions.assertEquals((Object)RestrictionType.ONLY, (Object)res.getRestrictionType());
    }

    @Test
    void limitedToVehicle() throws OSMRestrictionException {
        this.tags.put("restriction:motorcar", "no_left_turn");
        RestrictionTagParser.Result res = this.parseForVehicleTypes("motorcar");
        Assertions.assertEquals((Object)"no_left_turn", (Object)res.getRestriction());
        Assertions.assertEquals((Object)RestrictionType.NO, (Object)res.getRestrictionType());
    }

    @Test
    void limitedToOtherVehicle() throws OSMRestrictionException {
        this.tags.put("restriction:motorcar", "no_left_turn");
        RestrictionTagParser.Result res = this.parseForVehicleTypes("bicycle");
        Assertions.assertNull((Object)res);
    }

    @Test
    void limitedMultiple() throws OSMRestrictionException {
        this.tags.put("restriction:motorcar", "no_left_turn");
        this.tags.put("restriction:psv", "no_left_turn");
        RestrictionTagParser.Result res = this.parseForVehicleTypes("motorcar");
        Assertions.assertEquals((Object)"no_left_turn", (Object)res.getRestriction());
        Assertions.assertEquals((Object)RestrictionType.NO, (Object)res.getRestrictionType());
    }

    @Test
    void limitedMultipleOther() throws OSMRestrictionException {
        this.tags.put("restriction:motorcar", "no_left_turn");
        this.tags.put("restriction:psv", "no_left_turn");
        RestrictionTagParser.Result res = this.parseForVehicleTypes("bicycle");
        Assertions.assertNull((Object)res);
    }

    @Test
    void multipleVehicleTypes() throws OSMRestrictionException {
        this.tags.put("restriction", "only_right_turn");
        RestrictionTagParser.Result res = this.parseForVehicleTypes("motorcar", "motor_vehicle", "vehicle");
        Assertions.assertEquals((Object)"only_right_turn", (Object)res.getRestriction());
        Assertions.assertEquals((Object)RestrictionType.ONLY, (Object)res.getRestrictionType());
    }

    @Test
    void exceptBus() throws OSMRestrictionException {
        this.tags.put("restriction", "only_right_turn");
        this.tags.put("except", "psv");
        RestrictionTagParser.Result res = this.parseForVehicleTypes("motorcar", "motor_vehicle", "vehicle");
        Assertions.assertEquals((Object)"only_right_turn", (Object)res.getRestriction());
        Assertions.assertEquals((Object)RestrictionType.ONLY, (Object)res.getRestrictionType());
        Assertions.assertNull((Object)this.parseForVehicleTypes("psv"));
    }
}

