/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.LongArrayList;
import com.graphhopper.reader.osm.OSMRestrictionException;
import com.graphhopper.reader.osm.WayToEdgeConverter;
import com.graphhopper.storage.BaseGraph;
import java.util.Iterator;
import java.util.function.LongFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class WayToEdgeConverterTest {
    WayToEdgeConverterTest() {
    }

    @Test
    void convertForViaWays() throws OSMRestrictionException {
        BaseGraph graph = new BaseGraph.Builder(1).create();
        for (int i = 0; i < 10; ++i) {
            graph.edge(i, i + 1);
        }
        WayToEdgeConverter.EdgeResult edgeResult = new WayToEdgeConverter(graph, way -> IntArrayList.from((int[])new int[]{Math.toIntExact(way)}).iterator()).convertForViaWays(this.ways(0L), this.ways(2L, 6L, 4L, 1L, 7L, 3L, 5L, 8L), this.ways(9L));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 2, 3, 4, 5, 6, 7, 8}), (Object)edgeResult.getViaEdges());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9}), (Object)edgeResult.getNodes());
    }

    @Test
    void convertForViaWays_multipleEdgesForViaWay() throws OSMRestrictionException {
        BaseGraph graph = new BaseGraph.Builder(1).create();
        graph.edge(0, 1);
        graph.edge(1, 2);
        graph.edge(2, 3);
        graph.edge(3, 4);
        LongFunction<Iterator> edgesByWay = way -> {
            if (way == 0L) {
                return IntArrayList.from((int[])new int[]{0}).iterator();
            }
            if (way == 1L) {
                return IntArrayList.from((int[])new int[]{1, 2}).iterator();
            }
            if (way == 2L) {
                return IntArrayList.from((int[])new int[]{3}).iterator();
            }
            throw new IllegalArgumentException();
        };
        WayToEdgeConverter.EdgeResult edgeResult = new WayToEdgeConverter(graph, edgesByWay).convertForViaWays(this.ways(0L), this.ways(1L), this.ways(2L));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 2}), (Object)edgeResult.getViaEdges());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 2, 3}), (Object)edgeResult.getNodes());
    }

    @Test
    void convertForViaWays_multipleEdgesForViaWay_oppositeDirection() throws OSMRestrictionException {
        BaseGraph graph = new BaseGraph.Builder(1).create();
        graph.edge(0, 1);
        graph.edge(1, 2);
        graph.edge(2, 3);
        graph.edge(3, 4);
        LongFunction<Iterator> edgesByWay = way -> {
            if (way == 0L) {
                return IntArrayList.from((int[])new int[]{0}).iterator();
            }
            if (way == 1L) {
                return IntArrayList.from((int[])new int[]{2, 1}).iterator();
            }
            if (way == 2L) {
                return IntArrayList.from((int[])new int[]{3}).iterator();
            }
            throw new IllegalArgumentException();
        };
        WayToEdgeConverter.EdgeResult edgeResult = new WayToEdgeConverter(graph, edgesByWay).convertForViaWays(this.ways(0L), this.ways(1L), this.ways(2L));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 2}), (Object)edgeResult.getViaEdges());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 2, 3}), (Object)edgeResult.getNodes());
    }

    @Test
    void convertForViaWays_reorderEdges() throws OSMRestrictionException {
        BaseGraph graph = new BaseGraph.Builder(1).create();
        graph.edge(0, 1);
        graph.edge(1, 2);
        graph.edge(3, 4);
        graph.edge(2, 3);
        graph.edge(4, 5);
        graph.edge(5, 6);
        LongFunction<Iterator> edgesByWay = way -> {
            if (way == 1L) {
                return IntArrayList.from((int[])new int[]{1, 2, 3, 4}).iterator();
            }
            if (way == 0L) {
                return IntArrayList.from((int[])new int[]{0}).iterator();
            }
            if (way == 2L) {
                return IntArrayList.from((int[])new int[]{5}).iterator();
            }
            throw new IllegalArgumentException();
        };
        WayToEdgeConverter.EdgeResult edgeResult = new WayToEdgeConverter(graph, edgesByWay).convertForViaWays(this.ways(0L), this.ways(1L), this.ways(2L));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 3, 2, 4}), (Object)edgeResult.getViaEdges());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 2, 3, 4, 5}), (Object)edgeResult.getNodes());
    }

    @Test
    void convertForViaWays_loop() {
        BaseGraph graph = new BaseGraph.Builder(1).create();
        graph.edge(0, 1);
        graph.edge(1, 2);
        graph.edge(2, 3);
        graph.edge(3, 1);
        graph.edge(1, 4);
        LongFunction<Iterator> edgesByWay = way -> IntArrayList.from((int[])new int[]{Math.toIntExact(way)}).iterator();
        OSMRestrictionException e = (OSMRestrictionException)Assertions.assertThrows(OSMRestrictionException.class, () -> new WayToEdgeConverter(graph, edgesByWay).convertForViaWays(this.ways(0L), this.ways(1L, 2L, 3L), this.ways(4L)));
        Assertions.assertTrue((boolean)e.getMessage().contains("has member ways that do not form a unique path"), (String)e.getMessage());
    }

    @Test
    void convertForViaNode_multipleFrom() throws OSMRestrictionException {
        BaseGraph graph = new BaseGraph.Builder(1).create();
        graph.edge(1, 0);
        graph.edge(2, 0);
        graph.edge(3, 0);
        graph.edge(0, 4);
        WayToEdgeConverter.NodeResult nodeResult = new WayToEdgeConverter(graph, way -> IntArrayList.from((int[])new int[]{Math.toIntExact(way)}).iterator()).convertForViaNode(this.ways(0L, 1L, 2L), 0, this.ways(3L));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 1, 2}), (Object)nodeResult.getFromEdges());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{3}), (Object)nodeResult.getToEdges());
    }

    @Test
    void convertForViaNode_multipleTo() throws OSMRestrictionException {
        BaseGraph graph = new BaseGraph.Builder(1).create();
        graph.edge(1, 0);
        graph.edge(2, 0);
        graph.edge(3, 0);
        graph.edge(0, 4);
        WayToEdgeConverter.NodeResult nodeResult = new WayToEdgeConverter(graph, way -> IntArrayList.from((int[])new int[]{Math.toIntExact(way)}).iterator()).convertForViaNode(this.ways(3L), 0, this.ways(0L, 1L, 2L));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{3}), (Object)nodeResult.getFromEdges());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 1, 2}), (Object)nodeResult.getToEdges());
    }

    @Test
    void convertForViaWay_multipleFrom() throws OSMRestrictionException {
        BaseGraph graph = new BaseGraph.Builder(1).create();
        graph.edge(1, 0);
        graph.edge(2, 0);
        graph.edge(3, 0);
        graph.edge(0, 4);
        graph.edge(4, 5);
        WayToEdgeConverter.EdgeResult edgeResult = new WayToEdgeConverter(graph, way -> IntArrayList.from((int[])new int[]{Math.toIntExact(way)}).iterator()).convertForViaWays(this.ways(0L, 1L, 2L), this.ways(3L), this.ways(4L));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 1, 2}), (Object)edgeResult.getFromEdges());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{3}), (Object)edgeResult.getViaEdges());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{4}), (Object)edgeResult.getToEdges());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 4}), (Object)edgeResult.getNodes());
    }

    @Test
    void convertForViaWay_multipleTo() throws OSMRestrictionException {
        BaseGraph graph = new BaseGraph.Builder(1).create();
        graph.edge(1, 0);
        graph.edge(2, 0);
        graph.edge(3, 0);
        graph.edge(0, 4);
        graph.edge(4, 5);
        WayToEdgeConverter.EdgeResult edgeResult = new WayToEdgeConverter(graph, way -> IntArrayList.from((int[])new int[]{Math.toIntExact(way)}).iterator()).convertForViaWays(this.ways(4L), this.ways(3L), this.ways(0L, 1L, 2L));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 1, 2}), (Object)edgeResult.getToEdges());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{3}), (Object)edgeResult.getViaEdges());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{4}), (Object)edgeResult.getFromEdges());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{4, 0}), (Object)edgeResult.getNodes());
    }

    private LongArrayList ways(long ... ways) {
        return LongArrayList.from((long[])ways);
    }
}

