/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.reader.osm.WayToEdgesMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class WayToEdgesMapTest {
    WayToEdgesMapTest() {
    }

    @Test
    void notReserved() {
        WayToEdgesMap wayToEdgesMap = new WayToEdgesMap();
        wayToEdgesMap.reserve(5L);
        wayToEdgesMap.putIfReserved(5L, 4);
        wayToEdgesMap.putIfReserved(6L, 2);
        this.checkEdges(wayToEdgesMap, 5L, 4);
        this.checkEdges(wayToEdgesMap, 6L, new int[0]);
    }

    @Test
    void waysMustBeInOrder() {
        WayToEdgesMap wayToEdgesMap = new WayToEdgesMap();
        wayToEdgesMap.reserve(10L);
        wayToEdgesMap.reserve(11L);
        wayToEdgesMap.putIfReserved(10L, 3);
        wayToEdgesMap.putIfReserved(11L, 5);
        Assertions.assertThrows(IllegalArgumentException.class, () -> wayToEdgesMap.putIfReserved(10L, 3));
    }

    @Test
    void basic() {
        WayToEdgesMap wayToEdgesMap = new WayToEdgesMap();
        wayToEdgesMap.reserve(10L);
        wayToEdgesMap.reserve(11L);
        wayToEdgesMap.reserve(12L);
        wayToEdgesMap.reserve(6L);
        wayToEdgesMap.reserve(1234L);
        wayToEdgesMap.reserve(7L);
        wayToEdgesMap.putIfReserved(10L, 3);
        wayToEdgesMap.putIfReserved(10L, 5);
        wayToEdgesMap.putIfReserved(6L, 1);
        wayToEdgesMap.putIfReserved(1234L, 12);
        wayToEdgesMap.putIfReserved(1234L, 13);
        wayToEdgesMap.putIfReserved(1234L, 13);
        wayToEdgesMap.putIfReserved(7L, 2);
        this.checkEdges(wayToEdgesMap, 10L, 3, 5);
        this.checkEdges(wayToEdgesMap, 6L, 1);
        this.checkEdges(wayToEdgesMap, 1234L, 12, 13, 13);
        this.checkEdges(wayToEdgesMap, 7L, 2);
        this.checkEdges(wayToEdgesMap, 42L, new int[0]);
    }

    @Test
    void another() {
        WayToEdgesMap wayToEdgesMap = new WayToEdgesMap();
        wayToEdgesMap.reserve(1L);
        wayToEdgesMap.reserve(2L);
        wayToEdgesMap.reserve(3L);
        wayToEdgesMap.putIfReserved(1L, 0);
        wayToEdgesMap.putIfReserved(1L, 1);
        wayToEdgesMap.putIfReserved(3L, 3);
        wayToEdgesMap.putIfReserved(3L, 4);
        this.checkEdges(wayToEdgesMap, 1L, 0, 1);
        this.checkEdges(wayToEdgesMap, 3L, 3, 4);
    }

    @Test
    void reserveButDoNotPut() {
        WayToEdgesMap wayToEdgesMap = new WayToEdgesMap();
        wayToEdgesMap.reserve(1L);
        wayToEdgesMap.reserve(2L);
        wayToEdgesMap.putIfReserved(2L, 42);
        this.checkEdges(wayToEdgesMap, 1L, new int[0]);
        this.checkEdges(wayToEdgesMap, 2L, 42);
    }

    private void checkEdges(WayToEdgesMap wayToEdgesMap, long way, int ... expected) {
        IntArrayList edges = new IntArrayList();
        wayToEdgesMap.getEdges(way).forEachRemaining(c -> edges.add(c.value));
        Assertions.assertEquals((Object)IntArrayList.from((int[])expected), (Object)edges);
    }
}

