/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm.conditional;

import com.graphhopper.reader.osm.conditional.DateRange;
import com.graphhopper.reader.osm.conditional.DateRangeParser;
import com.graphhopper.reader.osm.conditional.ParsedCalendar;
import java.text.ParseException;
import java.util.Calendar;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DateRangeParserTest {
    final DateRangeParser dateRangeParser = new DateRangeParser();

    @Test
    public void testParseConditional() throws ParseException {
        this.assertSameDate(2014, 11, 15, "2014 Dec 15");
        this.assertSameDate(2015, 2, 2, "2015 Mar 2");
        this.assertSameDate(2015, 2, 1, "2015 Mar");
        this.assertSameDate(1970, 2, 31, "Mar 31");
        this.assertSameDate(1970, 11, 1, "Dec");
    }

    @Test
    public void testCreate() throws ParseException {
        DateRangeParser dateRangeParser = DateRangeParser.createInstance((String)"2019-10-08");
        Assertions.assertFalse((boolean)dateRangeParser.checkCondition("2014 Oct 8-2014 Dec 12").isCheckPassed());
        Assertions.assertTrue((boolean)dateRangeParser.checkCondition("2019 Oct 8-2019 Dec 12").isCheckPassed());
    }

    @Test
    public void testToString() throws ParseException {
        DateRange instance = DateRangeParser.getRange((String)"Mar-Oct");
        Assertions.assertEquals((Object)"yearless:true, dayOnly:false, reverse:false, from:1970-03-01T00:00:00Z, to:1970-10-31T23:59:59Z", (Object)instance.toString());
    }

    @Test
    public void testParseSimpleDateRange() throws ParseException {
        DateRange dateRange = DateRangeParser.getRange((String)"2014 Aug 10-2014 Aug 14");
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2014, 7, 9)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2014, 7, 10)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2014, 7, 12)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2014, 7, 14)));
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2014, 7, 15)));
    }

    @Test
    public void testParseSimpleDateRangeWithoutYear() throws ParseException {
        DateRange dateRange = DateRangeParser.getRange((String)"Aug 10-Aug 14");
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2014, 7, 9)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2014, 7, 10)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2014, 7, 12)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2014, 7, 14)));
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2014, 7, 15)));
    }

    @Test
    public void testParseSimpleDateRangeWithoutYearAndDay() throws ParseException {
        DateRange dateRange = DateRangeParser.getRange((String)"Jul-Aug");
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2014, 5, 9)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2014, 6, 10)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2014, 7, 12)));
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2014, 8, 14)));
    }

    @Test
    public void testParseSimpleDateRangeWithoutYearAndDay2() throws ParseException {
        DateRange dateRange = DateRangeParser.getRange((String)"Mar-Sep");
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2014, 1, 25)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2014, 2, 1)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2014, 8, 30)));
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2014, 10, 1)));
    }

    @Test
    public void testParseReverseDateRange() throws ParseException {
        DateRange dateRange = DateRangeParser.getRange((String)"2014 Aug 14-2015 Mar 10");
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2014, 7, 13)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2014, 7, 14)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2015, 2, 10)));
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2015, 2, 11)));
    }

    @Test
    public void testParseReverseDateRangeWithoutYear() throws ParseException {
        DateRange dateRange = DateRangeParser.getRange((String)"Aug 14-Aug 10");
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2014, 0, 9)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2014, 7, 9)));
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2014, 7, 10)));
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2014, 7, 12)));
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2014, 7, 14)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2014, 7, 15)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2014, 8, 15)));
    }

    @Test
    public void testParseReverseDateRangeWithoutYearAndDay() throws ParseException {
        DateRange dateRange = DateRangeParser.getRange((String)"Sep-Mar");
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2014, 7, 31)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2014, 8, 1)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2014, 11, 24)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2014, 0, 24)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2014, 2, 31)));
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2014, 3, 1)));
    }

    @Test
    public void testParseReverseDateRangeWithoutYearAndDay_645() throws ParseException {
        DateRange dateRange = DateRangeParser.getRange((String)"Aug 10-Jan");
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2016, 7, 9)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2016, 7, 10)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2016, 0, 1)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2016, 0, 20)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2016, 0, 31)));
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2016, 1, 1)));
    }

    @Test
    public void testParseSingleDateRange() throws ParseException {
        DateRange dateRange = DateRangeParser.getRange((String)"2014 Sep 1");
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2014, 7, 31)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2014, 8, 1)));
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2014, 8, 30)));
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2014, 9, 1)));
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2015, 8, 1)));
    }

    @Test
    public void testParseSingleDateRangeWithoutDay() throws ParseException {
        DateRange dateRange = DateRangeParser.getRange((String)"2014 Sep");
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2014, 7, 31)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2014, 8, 1)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2014, 8, 30)));
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2014, 9, 1)));
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2015, 8, 1)));
    }

    @Test
    public void testParseSingleDateRangeWithoutYearAndDay() throws ParseException {
        DateRange dateRange = DateRangeParser.getRange((String)"Sep");
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2014, 7, 31)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2014, 8, 1)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2014, 8, 30)));
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2014, 9, 1)));
    }

    @Test
    public void testParseSingleDateRangeOneDayOnly() throws ParseException {
        DateRange dateRange = DateRangeParser.getRange((String)"Sa");
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2015, 11, 25)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2015, 11, 26)));
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2015, 11, 27)));
    }

    @Test
    public void testParseSingleDateRangeOneDayOnlyIncludingPh() throws ParseException {
        DateRange dateRange = DateRangeParser.getRange((String)"Su, PH");
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2015, 11, 26)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2015, 11, 27)));
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2015, 11, 28)));
    }

    @Test
    public void testParseSingleDateRangeDayOnly() throws ParseException {
        DateRange dateRange = DateRangeParser.getRange((String)"Mo-Fr");
        Assertions.assertTrue((boolean)dateRange.dayOnly);
        Assertions.assertFalse((boolean)dateRange.reverse);
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2015, 11, 20)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2015, 11, 21)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2015, 11, 25)));
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2015, 11, 26)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2015, 11, 28)));
    }

    @Test
    public void testParseReverseDateRangeDayOnly() throws ParseException {
        DateRange dateRange = DateRangeParser.getRange((String)"Sa-Su");
        Assertions.assertTrue((boolean)dateRange.dayOnly);
        Assertions.assertTrue((boolean)dateRange.reverse);
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2015, 11, 25)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2015, 11, 26)));
        Assertions.assertTrue((boolean)dateRange.isInRange(this.getCalendar(2015, 11, 27)));
        Assertions.assertFalse((boolean)dateRange.isInRange(this.getCalendar(2015, 11, 28)));
    }

    @Test
    public void testParseUnparsableDate() {
        Assertions.assertThrows(ParseException.class, () -> DateRangeParser.getRange((String)"Sat"));
    }

    private void assertSameDate(int year, int month, int day, String dateString) throws ParseException {
        Calendar expected = this.getCalendar(year, month, day);
        ParsedCalendar actualParsed = DateRangeParser.parseDateString((String)dateString);
        Calendar actual = actualParsed.parsedCalendar;
        Assertions.assertEquals((int)expected.get(1), (int)actual.get(1));
        Assertions.assertEquals((int)expected.get(2), (int)actual.get(2));
        Assertions.assertEquals((int)expected.get(5), (int)actual.get(5));
    }

    protected Calendar getCalendar(int year, int month, int day) {
        Calendar calendar = DateRangeParser.createCalendar();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        return calendar;
    }
}

