/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.routing.AStarBidirection;
import com.graphhopper.routing.Dijkstra;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class AStarBidirectionTest {
    AStarBidirectionTest() {
    }

    @Test
    void infeasibleApproximator_noException() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 2, 1.0, true);
        EncodingManager em = EncodingManager.start().add((EncodedValue)speedEnc).build();
        BaseGraph graph = new BaseGraph.Builder(em).create();
        graph.edge(0, 1).set((DecimalEncodedValue)speedEnc, 1.0, 0.0).setDistance(100.0);
        graph.edge(2, 1).setDistance(300.0).set((DecimalEncodedValue)speedEnc, 0.0, 1.0);
        graph.edge(2, 3).set((DecimalEncodedValue)speedEnc, 1.0, 0.0).setDistance(100.0);
        graph.edge(3, 4).set((DecimalEncodedValue)speedEnc, 1.0, 0.0).setDistance(100.0);
        graph.edge(4, 5).set((DecimalEncodedValue)speedEnc, 1.0, 0.0).setDistance(10000.0);
        graph.edge(5, 6).set((DecimalEncodedValue)speedEnc, 1.0, 0.0).setDistance(100.0);
        graph.edge(6, 7).set((DecimalEncodedValue)speedEnc, 1.0, 0.0).setDistance(100.0);
        graph.edge(7, 8).set((DecimalEncodedValue)speedEnc, 1.0, 0.0).setDistance(100.0);
        graph.edge(8, 9).set((DecimalEncodedValue)speedEnc, 1.0, 0.0).setDistance(100.0);
        graph.edge(1, 10).set((DecimalEncodedValue)speedEnc, 1.0, 0.0).setDistance(100.0);
        graph.edge(10, 2).set((DecimalEncodedValue)speedEnc, 1.0, 0.0).setDistance(100.0);
        SpeedWeighting weighting = new SpeedWeighting((DecimalEncodedValue)speedEnc);
        AStarBidirection algo = new AStarBidirection((Graph)graph, (Weighting)weighting, TraversalMode.NODE_BASED);
        algo.setApproximation((WeightApproximator)new InfeasibleApproximator());
        Path path = algo.calcPath(0, 9);
        Assertions.assertEquals((double)11000.0, (double)path.getDistance());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}), (Object)path.calcNodes());
        Dijkstra dijkstra = new Dijkstra((Graph)graph, (Weighting)weighting, TraversalMode.NODE_BASED);
        Path optimalPath = dijkstra.calcPath(0, 9);
        Assertions.assertEquals((double)10900.0, (double)optimalPath.getDistance());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 1, 10, 2, 3, 4, 5, 6, 7, 8, 9}), (Object)optimalPath.calcNodes());
    }

    private static class InfeasibleApproximator
    implements WeightApproximator {
        int to;

        private InfeasibleApproximator() {
        }

        public double approximate(int currentNode) {
            if (this.to != 9) {
                return 0.0;
            }
            if (currentNode == 10) {
                return 1000.0;
            }
            return 0.0;
        }

        public void setTo(int to) {
            this.to = to;
        }

        public WeightApproximator reverse() {
            return new InfeasibleApproximator();
        }

        public double getSlack() {
            return 0.0;
        }
    }
}

