/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.AlternativeRouteCH;
import com.graphhopper.routing.ch.NodeOrderingProvider;
import com.graphhopper.routing.ch.PrepareContractionHierarchies;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.CHStorage;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.storage.RoutingCHGraphImpl;
import com.graphhopper.util.PMap;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AlternativeRouteCHTest {
    private final DecimalEncodedValue speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, false);
    private final EncodingManager em = EncodingManager.start().add((EncodedValue)this.speedEnc).build();

    public BaseGraph createTestGraph(EncodingManager tmpEM) {
        BaseGraph graph = new BaseGraph.Builder(tmpEM).create();
        graph.edge(5, 6).setDistance(10000.0).set(this.speedEnc, 60.0);
        graph.edge(6, 3).setDistance(10000.0).set(this.speedEnc, 60.0);
        graph.edge(3, 4).setDistance(10000.0).set(this.speedEnc, 60.0);
        graph.edge(4, 10).setDistance(10000.0).set(this.speedEnc, 60.0);
        graph.edge(6, 7).setDistance(10000.0).set(this.speedEnc, 60.0);
        graph.edge(7, 8).setDistance(10000.0).set(this.speedEnc, 60.0);
        graph.edge(8, 4).setDistance(10000.0).set(this.speedEnc, 60.0);
        graph.edge(5, 1).setDistance(10000.0).set(this.speedEnc, 60.0);
        graph.edge(1, 9).setDistance(10000.0).set(this.speedEnc, 60.0);
        graph.edge(9, 2).setDistance(10000.0).set(this.speedEnc, 60.0);
        graph.edge(2, 3).setDistance(10000.0).set(this.speedEnc, 60.0);
        graph.edge(4, 11).setDistance(9000.0).set(this.speedEnc, 60.0);
        graph.edge(11, 12).setDistance(9000.0).set(this.speedEnc, 60.0);
        graph.edge(12, 10).setDistance(10000.0).set(this.speedEnc, 60.0);
        graph.freeze();
        return graph;
    }

    private RoutingCHGraph prepareCH(BaseGraph graph) {
        int[] nodeOrdering = new int[]{0, 10, 12, 4, 3, 2, 5, 1, 6, 7, 8, 9, 11};
        CHConfig chConfig = CHConfig.nodeBased((String)"p", (Weighting)new SpeedWeighting(this.speedEnc));
        PrepareContractionHierarchies contractionHierarchies = PrepareContractionHierarchies.fromGraph((BaseGraph)graph, (CHConfig)chConfig);
        contractionHierarchies.useFixedNodeOrdering(NodeOrderingProvider.fromArray((int[])nodeOrdering));
        PrepareContractionHierarchies.Result res = contractionHierarchies.doWork();
        return RoutingCHGraphImpl.fromGraph((BaseGraph)graph, (CHStorage)res.getCHStorage(), (CHConfig)res.getCHConfig());
    }

    @Test
    public void testCalcAlternatives() {
        BaseGraph g = this.createTestGraph(this.em);
        PMap hints = new PMap();
        hints.putObject("alternative_route.max_weight_factor", (Object)2.3);
        hints.putObject("alternative_route.local_optimality_factor", (Object)0.5);
        hints.putObject("alternative_route.max_paths", (Object)4);
        RoutingCHGraph routingCHGraph = this.prepareCH(g);
        AlternativeRouteCH altDijkstra = new AlternativeRouteCH(routingCHGraph, hints);
        List pathInfos = altDijkstra.calcAlternatives(5, 10);
        Assertions.assertEquals((int)3, (int)pathInfos.size());
    }

    @Test
    public void testRelaxMaximumStretch() {
        BaseGraph g = this.createTestGraph(this.em);
        PMap hints = new PMap();
        hints.putObject("alternative_route.max_weight_factor", (Object)4);
        hints.putObject("alternative_route.local_optimality_factor", (Object)0.5);
        hints.putObject("alternative_route.max_paths", (Object)4);
        RoutingCHGraph routingCHGraph = this.prepareCH(g);
        AlternativeRouteCH altDijkstra = new AlternativeRouteCH(routingCHGraph, hints);
        List pathInfos = altDijkstra.calcAlternatives(5, 10);
        Assertions.assertEquals((int)4, (int)pathInfos.size());
    }
}

