/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.routing.AlternativeRouteEdgeCH;
import com.graphhopper.routing.DijkstraBidirectionEdgeCHNoSOD;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.ch.NodeOrderingProvider;
import com.graphhopper.routing.ch.PrepareContractionHierarchies;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.CHStorage;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.storage.RoutingCHGraphImpl;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.PMap;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AlternativeRouteEdgeCHTest {
    private final DecimalEncodedValue speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, false);
    private final DecimalEncodedValue turnCostEnc = TurnCost.create((String)"car", (int)1);
    private final EncodingManager em = EncodingManager.start().add((EncodedValue)this.speedEnc).addTurnCostEncodedValue((EncodedValue)this.turnCostEnc).build();

    public BaseGraph createTestGraph(EncodingManager tmpEM) {
        BaseGraph graph = new BaseGraph.Builder(tmpEM).withTurnCosts(true).create();
        graph.edge(5, 6).setDistance(10000.0).set(this.speedEnc, 60.0);
        EdgeIteratorState e6_3 = graph.edge(6, 3).setDistance(10000.0).set(this.speedEnc, 60.0);
        EdgeIteratorState e3_4 = graph.edge(3, 4).setDistance(10000.0).set(this.speedEnc, 60.0);
        graph.edge(4, 10).setDistance(10000.0).set(this.speedEnc, 60.0);
        graph.edge(6, 7).setDistance(10000.0).set(this.speedEnc, 60.0);
        graph.edge(7, 8).setDistance(10000.0).set(this.speedEnc, 60.0);
        graph.edge(8, 4).setDistance(10000.0).set(this.speedEnc, 60.0);
        graph.edge(5, 1).setDistance(10000.0).set(this.speedEnc, 60.0);
        graph.edge(1, 9).setDistance(10000.0).set(this.speedEnc, 60.0);
        graph.edge(9, 2).setDistance(10000.0).set(this.speedEnc, 60.0);
        graph.edge(2, 3).setDistance(10000.0).set(this.speedEnc, 60.0);
        EdgeIteratorState e4_11 = graph.edge(4, 11).setDistance(9000.0).set(this.speedEnc, 60.0);
        graph.edge(11, 12).setDistance(9000.0).set(this.speedEnc, 60.0);
        graph.edge(12, 10).setDistance(10000.0).set(this.speedEnc, 60.0);
        TurnCostStorage turnCostStorage = graph.getTurnCostStorage();
        turnCostStorage.set(this.turnCostEnc, e3_4.getEdge(), 4, e4_11.getEdge(), Double.POSITIVE_INFINITY);
        turnCostStorage.set(this.turnCostEnc, e6_3.getEdge(), 3, e3_4.getEdge(), Double.POSITIVE_INFINITY);
        graph.freeze();
        return graph;
    }

    private RoutingCHGraph prepareCH(BaseGraph graph) {
        CHConfig chConfig = CHConfig.edgeBased((String)"profile", (Weighting)new SpeedWeighting(this.speedEnc, this.turnCostEnc, graph.getTurnCostStorage(), Double.POSITIVE_INFINITY));
        PrepareContractionHierarchies contractionHierarchies = PrepareContractionHierarchies.fromGraph((BaseGraph)graph, (CHConfig)chConfig);
        PrepareContractionHierarchies.Result res = contractionHierarchies.doWork();
        return RoutingCHGraphImpl.fromGraph((BaseGraph)graph, (CHStorage)res.getCHStorage(), (CHConfig)res.getCHConfig());
    }

    @Test
    public void testAssumptions() {
        BaseGraph g = this.createTestGraph(this.em);
        CHConfig chConfig = CHConfig.edgeBased((String)"profile", (Weighting)new SpeedWeighting(this.speedEnc, this.turnCostEnc, g.getTurnCostStorage(), Double.POSITIVE_INFINITY));
        CHStorage chStorage = CHStorage.fromGraph((BaseGraph)g, (CHConfig)chConfig);
        RoutingCHGraph chGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)g, (CHStorage)chStorage, (CHConfig)chConfig);
        DijkstraBidirectionEdgeCHNoSOD router = new DijkstraBidirectionEdgeCHNoSOD(chGraph);
        Path path = router.calcPath(5, 10);
        Assertions.assertTrue((boolean)path.isFound());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 6, 7, 8, 4, 10}), (Object)path.calcNodes());
        Assertions.assertEquals((double)50000.0, (double)path.getDistance(), (double)0.0);
        g = this.createTestGraph(this.em);
        RoutingCHGraph routingCHGraph = this.prepareCH(g);
        router = new DijkstraBidirectionEdgeCHNoSOD(routingCHGraph);
        path = router.calcPath(5, 3, -2, GHUtility.getEdge((Graph)g, (int)2, (int)3).getEdge());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 1, 9, 2, 3}), (Object)path.calcNodes());
        Assertions.assertEquals((double)40000.0, (double)path.getDistance(), (double)0.0);
    }

    @Test
    public void testCalcAlternatives() {
        BaseGraph g = this.createTestGraph(this.em);
        PMap hints = new PMap();
        hints.putObject("alternative_route.max_weight_factor", (Object)4);
        hints.putObject("alternative_route.local_optimality_factor", (Object)0.5);
        hints.putObject("alternative_route.max_paths", (Object)4);
        RoutingCHGraph routingCHGraph = this.prepareCH(g);
        AlternativeRouteEdgeCH altDijkstra = new AlternativeRouteEdgeCH(routingCHGraph, hints);
        List pathInfos = altDijkstra.calcAlternatives(5, 10);
        Assertions.assertEquals((int)2, (int)pathInfos.size());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 6, 7, 8, 4, 10}), (Object)((AlternativeRouteEdgeCH.AlternativeInfo)pathInfos.get((int)0)).path.calcNodes());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 1, 9, 2, 3, 4, 10}), (Object)((AlternativeRouteEdgeCH.AlternativeInfo)pathInfos.get((int)1)).path.calcNodes());
    }

    @Test
    public void testCalcOtherAlternatives() {
        BaseGraph g = this.createTestGraph(this.em);
        PMap hints = new PMap();
        hints.putObject("alternative_route.max_weight_factor", (Object)4);
        hints.putObject("alternative_route.local_optimality_factor", (Object)0.5);
        hints.putObject("alternative_route.max_paths", (Object)4);
        RoutingCHGraph routingCHGraph = this.prepareCH(g);
        AlternativeRouteEdgeCH altDijkstra = new AlternativeRouteEdgeCH(routingCHGraph, hints);
        List pathInfos = altDijkstra.calcAlternatives(10, 5);
        Assertions.assertEquals((int)2, (int)pathInfos.size());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{10, 4, 3, 6, 5}), (Object)((AlternativeRouteEdgeCH.AlternativeInfo)pathInfos.get((int)0)).path.calcNodes());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{10, 12, 11, 4, 3, 6, 5}), (Object)((AlternativeRouteEdgeCH.AlternativeInfo)pathInfos.get((int)1)).path.calcNodes());
    }

    @Test
    void turnRestrictionAtConnectingNode() {
        BaseGraph graph = new BaseGraph.Builder(this.em).withTurnCosts(true).create();
        TurnCostStorage tcs = graph.getTurnCostStorage();
        NodeAccess na = graph.getNodeAccess();
        na.setNode(3, 45.0, 10.0);
        na.setNode(2, 45.0, 10.1);
        na.setNode(1, 44.9, 10.1);
        graph.edge(2, 3).setDistance(500.0).set(this.speedEnc, 60.0);
        graph.edge(2, 1).setDistance(1000.0).set(this.speedEnc, 60.0);
        graph.edge(3, 1).setDistance(500.0).set(this.speedEnc, 60.0);
        tcs.set(this.turnCostEnc, 0, 3, 2, Double.POSITIVE_INFINITY);
        graph.freeze();
        CHConfig chConfig = CHConfig.edgeBased((String)"profile", (Weighting)new SpeedWeighting(this.speedEnc, this.turnCostEnc, graph.getTurnCostStorage(), Double.POSITIVE_INFINITY));
        PrepareContractionHierarchies contractionHierarchies = PrepareContractionHierarchies.fromGraph((BaseGraph)graph, (CHConfig)chConfig);
        contractionHierarchies.useFixedNodeOrdering(NodeOrderingProvider.fromArray((int[])new int[]{3, 0, 2, 1}));
        PrepareContractionHierarchies.Result res = contractionHierarchies.doWork();
        RoutingCHGraph routingCHGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)graph, (CHStorage)res.getCHStorage(), (CHConfig)res.getCHConfig());
        int s = 2;
        boolean t = true;
        DijkstraBidirectionEdgeCHNoSOD dijkstra = new DijkstraBidirectionEdgeCHNoSOD(routingCHGraph);
        Path singlePath = dijkstra.calcPath(2, 1);
        PMap hints = new PMap();
        AlternativeRouteEdgeCH altDijkstra = new AlternativeRouteEdgeCH(routingCHGraph, hints);
        List pathInfos = altDijkstra.calcAlternatives(2, 1);
        AlternativeRouteEdgeCH.AlternativeInfo best = (AlternativeRouteEdgeCH.AlternativeInfo)pathInfos.get(0);
        Assertions.assertEquals((double)singlePath.getWeight(), (double)best.path.getWeight());
        Assertions.assertEquals((Object)singlePath.calcNodes(), (Object)best.path.calcNodes());
        for (int j = 1; j < pathInfos.size(); ++j) {
            Assertions.assertTrue((((AlternativeRouteEdgeCH.AlternativeInfo)pathInfos.get((int)j)).path.getWeight() >= best.path.getWeight() ? 1 : 0) != 0, (String)"alternatives must not have lower weight than best path");
            Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{2, 1}), (Object)((AlternativeRouteEdgeCH.AlternativeInfo)pathInfos.get((int)j)).path.calcNodes(), (String)"alternatives must start/end at start/end node");
        }
    }

    @Test
    void distanceTimeAndWeight() {
        BaseGraph graph = new BaseGraph.Builder(this.em).withTurnCosts(true).create();
        graph.edge(0, 1).setDistance(500.0).set(this.speedEnc, 60.0);
        graph.edge(1, 2).setDistance(500.0).set(this.speedEnc, 60.0);
        graph.edge(2, 3).setDistance(500.0).set(this.speedEnc, 60.0);
        graph.edge(2, 5).setDistance(1000.0).set(this.speedEnc, 60.0);
        graph.edge(3, 7).setDistance(1500.0).set(this.speedEnc, 60.0);
        graph.edge(5, 6).setDistance(500.0).set(this.speedEnc, 60.0);
        graph.edge(6, 7).setDistance(500.0).set(this.speedEnc, 60.0);
        graph.edge(7, 8).setDistance(500.0).set(this.speedEnc, 60.0);
        graph.freeze();
        CHConfig chConfig = CHConfig.edgeBased((String)"profile", (Weighting)new SpeedWeighting(this.speedEnc, this.turnCostEnc, graph.getTurnCostStorage(), Double.POSITIVE_INFINITY));
        PrepareContractionHierarchies contractionHierarchies = PrepareContractionHierarchies.fromGraph((BaseGraph)graph, (CHConfig)chConfig);
        contractionHierarchies.useFixedNodeOrdering(NodeOrderingProvider.fromArray((int[])new int[]{7, 6, 0, 2, 4, 5, 1, 3, 8}));
        PrepareContractionHierarchies.Result res = contractionHierarchies.doWork();
        RoutingCHGraph routingCHGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)graph, (CHStorage)res.getCHStorage(), (CHConfig)res.getCHConfig());
        boolean s = false;
        int t = 8;
        PMap hints = new PMap();
        AlternativeRouteEdgeCH altDijkstra = new AlternativeRouteEdgeCH(routingCHGraph, hints);
        List pathInfos = altDijkstra.calcAlternatives(0, 8);
        Assertions.assertTrue((pathInfos.size() > 1 ? 1 : 0) != 0, (String)"the graph, contraction order and alternative route algorith must be such that there is at least one alternative path, otherwise this test makes no sense");
        AlternativeRouteEdgeCH.AlternativeInfo best = (AlternativeRouteEdgeCH.AlternativeInfo)pathInfos.get(0);
        Assertions.assertEquals((double)3500.0, (double)best.path.getDistance());
        Assertions.assertEquals((double)58.3333, (double)best.path.getWeight(), (double)0.001);
        Assertions.assertEquals((float)58333.0f, (float)best.path.getTime(), (float)10.0f);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 1, 2, 5, 6, 7, 8}), (Object)best.path.calcNodes());
        for (int j = 1; j < pathInfos.size(); ++j) {
            Path alternative = ((AlternativeRouteEdgeCH.AlternativeInfo)pathInfos.get((int)j)).path;
            Assertions.assertEquals((double)3500.0, (double)alternative.getDistance());
            Assertions.assertEquals((double)58.3333, (double)alternative.getWeight(), (double)0.001);
            Assertions.assertEquals((float)58333.0f, (float)alternative.getTime(), (float)1.0f);
            Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 1, 2, 3, 7, 8}), (Object)alternative.calcNodes());
        }
    }
}

