/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.routing.AlternativeRoute;
import com.graphhopper.routing.DijkstraBidirectionRef;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.PMap;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;

public class AlternativeRouteTest {
    public static void initTestGraph(Graph graph, DecimalEncodedValue speedEnc) {
        graph.edge(1, 9).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        graph.edge(9, 2).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        graph.edge(2, 3).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        graph.edge(3, 4).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        graph.edge(4, 10).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        graph.edge(5, 6).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        graph.edge(6, 7).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        graph.edge(7, 8).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        graph.edge(1, 5).setDistance(2.0).set(speedEnc, 60.0, 60.0);
        graph.edge(6, 3).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        graph.edge(4, 8).setDistance(1.0).set(speedEnc, 60.0, 60.0);
        GHUtility.updateDistancesFor((Graph)graph, (int)5, (double[])new double[]{0.0, 0.05});
        GHUtility.updateDistancesFor((Graph)graph, (int)6, (double[])new double[]{0.0, 0.1});
        GHUtility.updateDistancesFor((Graph)graph, (int)7, (double[])new double[]{0.0, 0.15});
        GHUtility.updateDistancesFor((Graph)graph, (int)8, (double[])new double[]{0.0, 0.25});
        GHUtility.updateDistancesFor((Graph)graph, (int)1, (double[])new double[]{0.05, 0.0});
        GHUtility.updateDistancesFor((Graph)graph, (int)9, (double[])new double[]{0.1, 0.05});
        GHUtility.updateDistancesFor((Graph)graph, (int)2, (double[])new double[]{0.05, 0.1});
        GHUtility.updateDistancesFor((Graph)graph, (int)3, (double[])new double[]{0.05, 0.15});
        GHUtility.updateDistancesFor((Graph)graph, (int)4, (double[])new double[]{0.05, 0.25});
        GHUtility.updateDistancesFor((Graph)graph, (int)10, (double[])new double[]{0.05, 0.3});
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testCalcAlternatives(Fixture f) {
        AlternativeRouteTest.initTestGraph((Graph)f.graph, f.speedEnc);
        PMap hints = new PMap().putObject("alternative_route.max_share_factor", (Object)0.5).putObject("alternative_route.max_weight_factor", (Object)2).putObject("alternative_route.max_exploration_factor", (Object)1.3);
        AlternativeRoute altDijkstra = new AlternativeRoute((Graph)f.graph, f.weighting, f.traversalMode, hints);
        List pathInfos = altDijkstra.calcAlternatives(5, 4);
        this.checkAlternatives(pathInfos);
        Assertions.assertEquals((int)2, (int)pathInfos.size());
        DijkstraBidirectionRef dijkstra = new DijkstraBidirectionRef((Graph)f.graph, f.weighting, f.traversalMode);
        Path bestPath = dijkstra.calcPath(5, 4);
        Path bestAlt = ((AlternativeRoute.AlternativeInfo)pathInfos.get(0)).getPath();
        Path secondAlt = ((AlternativeRoute.AlternativeInfo)pathInfos.get(1)).getPath();
        Assertions.assertEquals((Object)bestPath.calcNodes(), (Object)bestAlt.calcNodes());
        Assertions.assertEquals((double)bestPath.getWeight(), (double)bestAlt.getWeight(), (double)0.001);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 6, 3, 4}), (Object)bestAlt.calcNodes());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 6, 7, 8, 4}), (Object)secondAlt.calcNodes());
        Assertions.assertEquals((double)463.3, (double)secondAlt.getWeight(), (double)0.1);
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testCalcAlternatives2(Fixture f) {
        AlternativeRouteTest.initTestGraph((Graph)f.graph, f.speedEnc);
        PMap hints = new PMap().putObject("alternative_route.max_paths", (Object)3).putObject("alternative_route.max_share_factor", (Object)0.7).putObject("alternative_route.min_plateau_factor", (Object)0.15).putObject("alternative_route.max_weight_factor", (Object)2).putObject("alternative_route.max_exploration_factor", (Object)1.8);
        AlternativeRoute altDijkstra = new AlternativeRoute((Graph)f.graph, f.weighting, f.traversalMode, hints);
        List pathInfos = altDijkstra.calcAlternatives(5, 4);
        this.checkAlternatives(pathInfos);
        Assertions.assertEquals((int)3, (int)pathInfos.size());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 6, 3, 4}), (Object)((AlternativeRoute.AlternativeInfo)pathInfos.get(0)).getPath().calcNodes());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 6, 7, 8, 4}), (Object)((AlternativeRoute.AlternativeInfo)pathInfos.get(1)).getPath().calcNodes());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 1, 9, 2, 3, 4}), (Object)((AlternativeRoute.AlternativeInfo)pathInfos.get(2)).getPath().calcNodes());
        Assertions.assertEquals((double)671.1, (double)((AlternativeRoute.AlternativeInfo)pathInfos.get(2)).getPath().getWeight(), (double)0.1);
    }

    private void checkAlternatives(List<AlternativeRoute.AlternativeInfo> alternativeInfos) {
        Assertions.assertFalse((boolean)alternativeInfos.isEmpty(), (String)"alternativeInfos should contain alternatives");
        AlternativeRoute.AlternativeInfo bestInfo = alternativeInfos.get(0);
        for (int i = 1; i < alternativeInfos.size(); ++i) {
            AlternativeRoute.AlternativeInfo a = alternativeInfos.get(i);
            if (a.getPath().getWeight() < bestInfo.getPath().getWeight()) {
                Assertions.fail((String)("alternative is not longer -> " + String.valueOf(a) + " vs " + String.valueOf(bestInfo)));
            }
            if (!(a.getShareWeight() > bestInfo.getPath().getWeight()) && !(a.getShareWeight() > a.getPath().getWeight())) continue;
            Assertions.fail((String)("share or sortby incorrect -> " + String.valueOf(a) + " vs " + String.valueOf(bestInfo)));
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testDisconnectedAreas(Fixture f) {
        AlternativeRouteTest.initTestGraph((Graph)f.graph, f.speedEnc);
        GHUtility.updateDistancesFor((Graph)f.graph, (int)20, (double[])new double[]{0.0, -0.01});
        PMap hints = new PMap().putObject("alternative_route.max_exploration_factor", (Object)1);
        AlternativeRoute altDijkstra = new AlternativeRoute((Graph)f.graph, f.weighting, f.traversalMode, hints);
        Path path = altDijkstra.calcPath(1, 20);
        Assertions.assertFalse((boolean)path.isFound());
        Assertions.assertEquals((int)3, (int)altDijkstra.getVisitedNodes());
    }

    private static final class Fixture {
        final Weighting weighting;
        final TraversalMode traversalMode;
        final BaseGraph graph;
        final DecimalEncodedValue speedEnc;
        final DecimalEncodedValue turnCostEnc;

        public Fixture(TraversalMode tMode) {
            this.traversalMode = tMode;
            this.speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
            this.turnCostEnc = TurnCost.create((String)"car", (int)1);
            EncodingManager em = EncodingManager.start().add((EncodedValue)this.speedEnc).add((EncodedValue)this.turnCostEnc).build();
            this.graph = new BaseGraph.Builder(em).withTurnCosts(true).create();
            this.weighting = tMode.isEdgeBased() ? new SpeedWeighting(this.speedEnc, this.turnCostEnc, this.graph.getTurnCostStorage(), Double.POSITIVE_INFINITY) : new SpeedWeighting(this.speedEnc);
        }

        public String toString() {
            return this.traversalMode.toString();
        }
    }

    private static class FixtureProvider
    implements ArgumentsProvider {
        private FixtureProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Stream.of(new Fixture(TraversalMode.NODE_BASED), new Fixture(TraversalMode.EDGE_BASED)).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
        }
    }
}

