/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.routing.AStarBidirectionEdgeCHNoSOD;
import com.graphhopper.routing.AbstractBidirectionEdgeCHNoSOD;
import com.graphhopper.routing.DijkstraBidirectionEdgeCHNoSOD;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.ch.PrepareEncoder;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.CHStorage;
import com.graphhopper.storage.CHStorageBuilder;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.RoutingCHGraphImpl;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;

public class CHQueryWithTurnCostsTest {
    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testFindPathWithTurnCosts_bidirected_no_shortcuts_smallGraph(Fixture f) {
        f.graph.edge(1, 0).setDistance(30.0).set(f.speedEnc, 10.0, 10.0);
        f.graph.edge(0, 2).setDistance(50.0).set(f.speedEnc, 10.0, 10.0);
        f.setTurnCost(1, 0, 2, 3.0);
        f.freeze();
        f.setIdentityLevels();
        for (int i = 0; i < 3; ++i) {
            f.testPathCalculation(i, i, 0, IntArrayList.from((int[])new int[]{i}));
        }
        f.testPathCalculation(1, 2, 8, IntArrayList.from((int[])new int[]{1, 0, 2}), 3);
        f.testPathCalculation(2, 1, 8, IntArrayList.from((int[])new int[]{2, 0, 1}));
        f.testPathCalculation(0, 1, 3, IntArrayList.from((int[])new int[]{0, 1}));
        f.testPathCalculation(0, 2, 5, IntArrayList.from((int[])new int[]{0, 2}));
        f.testPathCalculation(1, 0, 3, IntArrayList.from((int[])new int[]{1, 0}));
        f.testPathCalculation(2, 0, 5, IntArrayList.from((int[])new int[]{2, 0}));
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testFindPathWithTurnCosts_bidirected_no_shortcuts(Fixture f) {
        f.graph.edge(0, 2).setDistance(30.0).set(f.speedEnc, 10.0, 10.0);
        f.graph.edge(2, 4).setDistance(20.0).set(f.speedEnc, 10.0, 10.0);
        f.graph.edge(4, 6).setDistance(70.0).set(f.speedEnc, 10.0, 10.0);
        f.graph.edge(6, 5).setDistance(90.0).set(f.speedEnc, 10.0, 10.0);
        f.graph.edge(5, 3).setDistance(10.0).set(f.speedEnc, 10.0, 10.0);
        f.graph.edge(3, 1).setDistance(40.0).set(f.speedEnc, 10.0, 10.0);
        f.setTurnCost(0, 2, 4, 3.0);
        f.setTurnCost(4, 6, 5, 6.0);
        f.setTurnCost(5, 6, 4, 2.0);
        f.setTurnCost(5, 3, 1, 5.0);
        f.freeze();
        f.setIdentityLevels();
        f.testPathCalculation(0, 1, 26, IntArrayList.from((int[])new int[]{0, 2, 4, 6, 5, 3, 1}), 14);
        f.testPathCalculation(1, 0, 26, IntArrayList.from((int[])new int[]{1, 3, 5, 6, 4, 2, 0}), 2);
        f.testPathCalculation(4, 3, 17, IntArrayList.from((int[])new int[]{4, 6, 5, 3}), 6);
        f.testPathCalculation(0, 0, 0, IntArrayList.from((int[])new int[]{0}));
        f.testPathCalculation(4, 4, 0, IntArrayList.from((int[])new int[]{4}));
        Path path = f.createAlgo().calcPath(0, 1);
        Assertions.assertEquals((double)40.0, (double)path.getWeight(), (double)0.001, (String)"wrong weight");
        Assertions.assertEquals((double)260.0, (double)path.getDistance(), (double)0.001, (String)"wrong distance");
        double weightPerMeter = 0.1;
        Assertions.assertEquals((double)((260.0 * weightPerMeter + 14.0) * 1000.0), (double)path.getTime(), (double)0.001, (String)"wrong time");
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testFindPathWithTurnCosts_loopShortcutBwdSearch(Fixture f) {
        f.graph.edge(0, 7).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(7, 8).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(8, 4).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(4, 1).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(1, 3).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(3, 2).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(2, 4).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(4, 6).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(6, 5).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.setRestriction(8, 4, 6);
        f.setRestriction(8, 4, 2);
        f.setRestriction(1, 4, 6);
        f.freeze();
        f.setIdentityLevels();
        f.addShortcut(3, 4, 6, 8, 3, 4, 2.0, true);
        f.addShortcut(3, 4, 10, 12, 5, 6, 2.0, false);
        f.addShortcut(4, 4, 6, 13, 9, 10, 4.0, false);
        f.addShortcut(4, 8, 4, 12, 2, 11, 5.0, true);
        f.addShortcut(6, 8, 4, 14, 12, 7, 6.0, true);
        f.testPathCalculation(0, 5, 9, IntArrayList.from((int[])new int[]{0, 7, 8, 4, 1, 3, 2, 4, 6, 5}));
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testFindPathWithTurnCosts_loopShortcutFwdSearch(Fixture f) {
        f.graph.edge(5, 6).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(6, 4).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(4, 1).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(1, 3).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(3, 2).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(2, 4).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(4, 7).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(7, 8).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(8, 0).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.setRestriction(6, 4, 7);
        f.setRestriction(6, 4, 2);
        f.setRestriction(1, 4, 7);
        f.freeze();
        f.setIdentityLevels();
        f.addShortcut(3, 4, 4, 6, 2, 3, 2.0, true);
        f.addShortcut(3, 4, 8, 10, 4, 5, 2.0, false);
        f.addShortcut(4, 4, 4, 10, 9, 10, 4.0, false);
        f.addShortcut(4, 6, 3, 10, 1, 11, 5.0, true);
        f.addShortcut(6, 7, 2, 12, 12, 6, 6.0, false);
        f.testPathCalculation(5, 0, 9, IntArrayList.from((int[])new int[]{5, 6, 4, 1, 3, 2, 4, 7, 8, 0}));
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testFindPathWithTurnCosts_directed_single_shortcut(Fixture f) {
        f.graph.edge(1, 2).setDistance(40.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(2, 0).setDistance(20.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(0, 3).setDistance(30.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(3, 4).setDistance(20.0).set(f.speedEnc, 10.0, 0.0);
        f.setTurnCost(1, 2, 0, 5.0);
        f.setTurnCost(2, 0, 3, 2.0);
        f.setTurnCost(0, 3, 4, 1.0);
        f.freeze();
        f.setIdentityLevels();
        f.addShortcut(2, 3, 2, 4, 1, 2, 7.0, false);
        f.testPathCalculation(1, 4, 11, IntArrayList.from((int[])new int[]{1, 2, 0, 3, 4}), 8);
        f.testPathCalculation(2, 4, 7, IntArrayList.from((int[])new int[]{2, 0, 3, 4}), 3);
        f.testPathCalculation(0, 4, 5, IntArrayList.from((int[])new int[]{0, 3, 4}), 1);
        f.testPathCalculation(1, 0, 6, IntArrayList.from((int[])new int[]{1, 2, 0}), 5);
        f.testPathCalculation(0, 4, 5, IntArrayList.from((int[])new int[]{0, 3, 4}), 1);
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testFindPathWithTurnCosts_directed_single_shortcut_fwdSearchStopsQuickly(Fixture f) {
        f.graph.edge(1, 2).setDistance(20.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(2, 0).setDistance(30.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(0, 3).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(3, 4).setDistance(30.0).set(f.speedEnc, 10.0, 0.0);
        f.freeze();
        f.setTurnCost(1, 2, 0, 2.0);
        f.setTurnCost(0, 3, 4, 4.0);
        f.setIdentityLevels();
        f.addShortcut(2, 3, 2, 4, 1, 2, 4.0, false);
        f.testPathCalculation(1, 4, 9, IntArrayList.from((int[])new int[]{1, 2, 0, 3, 4}), 6);
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testFindPathWithTurnCosts_directed_two_shortcuts(Fixture f) {
        f.graph.edge(2, 3).setDistance(40.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(3, 1).setDistance(20.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(1, 0).setDistance(30.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(0, 4).setDistance(20.0).set(f.speedEnc, 10.0, 0.0);
        f.setTurnCost(2, 3, 1, 5.0);
        f.setTurnCost(3, 1, 0, 2.0);
        f.setTurnCost(1, 0, 4, 1.0);
        f.freeze();
        f.setIdentityLevels();
        f.addShortcut(1, 4, 4, 6, 2, 3, 6.0, false);
        f.addShortcut(3, 4, 2, 6, 1, 4, 10.0, false);
        f.testPathCalculation(2, 4, 11, IntArrayList.from((int[])new int[]{2, 3, 1, 0, 4}), 8);
        f.testPathCalculation(1, 4, 5, IntArrayList.from((int[])new int[]{1, 0, 4}), 1);
        f.testPathCalculation(2, 0, 9, IntArrayList.from((int[])new int[]{2, 3, 1, 0}), 7);
        f.testPathCalculation(3, 4, 7, IntArrayList.from((int[])new int[]{3, 1, 0, 4}), 3);
        f.testPathCalculation(2, 1, 6, IntArrayList.from((int[])new int[]{2, 3, 1}), 5);
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testFindPath_directConnectionIsNotTheBestPath(Fixture f) {
        f.graph.edge(0, 2).setDistance(30.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(2, 3).setDistance(20.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(3, 1).setDistance(90.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(0, 1).setDistance(500.0).set(f.speedEnc, 10.0, 0.0);
        f.setTurnCost(2, 3, 1, 4.0);
        f.freeze();
        f.setIdentityLevels();
        f.testPathCalculation(0, 1, 14, IntArrayList.from((int[])new int[]{0, 2, 3, 1}), 4);
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testFindPath_upwardSearchRunsIntoTarget(Fixture f) {
        f.graph.edge(0, 1).setDistance(90.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(1, 5).setDistance(20.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(1, 3).setDistance(20.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(3, 4).setDistance(40.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(5, 4).setDistance(60.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(4, 2).setDistance(30.0).set(f.speedEnc, 10.0, 0.0);
        f.setTurnCost(1, 3, 4, 3.0);
        f.freeze();
        f.setIdentityLevels();
        f.testPathCalculation(0, 4, 17, IntArrayList.from((int[])new int[]{0, 1, 5, 4}));
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testFindPath_downwardSearchRunsIntoTarget(Fixture f) {
        f.graph.edge(1, 0).setDistance(90.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(2, 0).setDistance(140.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(2, 1).setDistance(20.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(3, 2).setDistance(90.0).set(f.speedEnc, 10.0, 0.0);
        f.freeze();
        f.setIdentityLevels();
        f.testPathCalculation(3, 0, 20, IntArrayList.from((int[])new int[]{3, 2, 1, 0}));
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testFindPath_incomingShortcut(Fixture f) {
        f.graph.edge(0, 1).setDistance(90.0).set(f.speedEnc, 10.0, 10.0);
        f.graph.edge(0, 3).setDistance(140.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(3, 2).setDistance(90.0).set(f.speedEnc, 10.0, 0.0);
        f.freeze();
        f.setIdentityLevels();
        f.addShortcut(1, 3, 1, 2, 0, 1, 23.0, false);
        f.testPathCalculation(0, 2, 23, IntArrayList.from((int[])new int[]{0, 3, 2}));
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testFindPathWithTurnCosts_fwdBwdSearchesMeetWithUTurn(Fixture f) {
        f.graph.edge(0, 2).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(2, 3).setDistance(20.0).set(f.speedEnc, 10.0, 10.0);
        f.graph.edge(2, 1).setDistance(30.0).set(f.speedEnc, 10.0, 0.0);
        f.setRestriction(0, 2, 1);
        f.setTurnCost(0, 2, 3, 5.0);
        f.setTurnCost(2, 3, 2, 4.0);
        f.setTurnCost(3, 2, 1, 7.0);
        f.freeze();
        f.setIdentityLevels();
        f.testPathCalculation(0, 1, -1, IntArrayList.from((int[])new int[0]));
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testFindPath_doNotMakeUTurn(Fixture f) {
        this.checkUTurnNotBeingUsed(f, false);
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testFindPath_doNotMakeUTurn_toLowerLevelNode(Fixture f) {
        this.checkUTurnNotBeingUsed(f, true);
    }

    private void checkUTurnNotBeingUsed(Fixture f, boolean toLowerLevelNode) {
        int nodeA = 4;
        int nodeB = 5;
        if (toLowerLevelNode) {
            int tmp = nodeA;
            nodeA = nodeB;
            nodeB = tmp;
        }
        f.graph.edge(1, nodeA).setDistance(40.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(0, 3).setDistance(40.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(nodeB, 2).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        EdgeIteratorState e3toB = f.graph.edge(3, nodeB).setDistance(20.0).set(f.speedEnc, 10.0, 0.0);
        EdgeIteratorState e3toA = f.graph.edge(3, nodeA).setDistance(10.0).set(f.speedEnc, 10.0, 10.0);
        f.freeze();
        f.setRestriction(0, 3, nodeB);
        f.setIdentityLevels();
        if (toLowerLevelNode) {
            f.addShortcut(nodeB, nodeA, e3toA.detach(true).getEdgeKey(), e3toB.getEdgeKey(), e3toA.getEdge(), e3toB.getEdge(), 2.0, true);
        } else {
            f.addShortcut(nodeA, nodeB, e3toA.detach(true).getEdgeKey(), e3toB.getEdgeKey(), e3toA.getEdge(), e3toB.getEdge(), 2.0, false);
        }
        f.testPathCalculation(0, 2, -1, IntArrayList.from((int[])new int[0]));
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testFindPathWithTurnCosts_loop(Fixture f) {
        EdgeIteratorState edge1 = f.graph.edge(0, 2).setDistance(40.0).set(f.speedEnc, 10.0, 0.0);
        EdgeIteratorState edge2 = f.graph.edge(2, 3).setDistance(10.0).set(f.speedEnc, 10.0, 10.0);
        EdgeIteratorState edge3 = f.graph.edge(3, 2).setDistance(70.0).set(f.speedEnc, 10.0, 0.0);
        EdgeIteratorState edge4 = f.graph.edge(2, 1).setDistance(30.0).set(f.speedEnc, 10.0, 0.0);
        f.setRestriction(edge1, edge4, 2);
        f.setTurnCost(edge1, edge2, 2, 3.0);
        f.freeze();
        f.setIdentityLevels();
        f.testPathCalculation(0, 1, 15, IntArrayList.from((int[])new int[]{0, 2, 3, 2, 1}), 3);
        f.testPathCalculation(3, 1, 4, IntArrayList.from((int[])new int[]{3, 2, 1}));
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testFindPathWithTurnCosts_multiple_bridge_nodes(Fixture f) {
        f.graph.edge(0, 2).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(0, 3).setDistance(30.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(0, 4).setDistance(20.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(2, 1).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(3, 1).setDistance(20.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(4, 1).setDistance(60.0).set(f.speedEnc, 10.0, 0.0);
        f.setTurnCost(0, 2, 1, 9.0);
        f.setTurnCost(0, 3, 1, 2.0);
        f.setTurnCost(0, 4, 1, 1.0);
        f.freeze();
        f.setIdentityLevels();
        f.testPathCalculation(0, 1, 5, IntArrayList.from((int[])new int[]{0, 3, 1}), 2);
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testFindPath_shortcutLoopIsRecognizedAsIncomingEdge(Fixture f) {
        EdgeIteratorState edge0 = f.graph.edge(3, 4).setDistance(10.0).set(f.speedEnc, 10.0, 10.0);
        EdgeIteratorState edge1 = f.graph.edge(4, 2).setDistance(10.0).set(f.speedEnc, 10.0, 10.0);
        EdgeIteratorState edge2 = f.graph.edge(2, 0).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        EdgeIteratorState edge3 = f.graph.edge(0, 2).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        EdgeIteratorState edge4 = f.graph.edge(2, 1).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.setRestriction(edge1, edge4, 2);
        f.freeze();
        f.setIdentityLevels();
        f.addShortcut(2, 2, edge2.getEdgeKey(), edge3.getEdgeKey(), edge2.getEdge(), edge3.getEdge(), 2.0, false);
        f.testPathCalculation(3, 1, 5, IntArrayList.from((int[])new int[]{3, 4, 2, 0, 2, 1}));
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testFindPathWithTurnRestriction_single_loop(Fixture f) {
        f.graph.edge(3, 4).setDistance(20.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(4, 0).setDistance(10.0).set(f.speedEnc, 10.0, 10.0);
        f.graph.edge(0, 1).setDistance(30.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(4, 1).setDistance(50.0).set(f.speedEnc, 10.0, 10.0);
        f.graph.edge(4, 2).setDistance(40.0).set(f.speedEnc, 10.0, 0.0);
        f.setRestriction(3, 4, 2);
        f.freeze();
        f.setIdentityLevels();
        f.addShortcut(1, 4, 2, 4, 1, 2, 4.0, true);
        f.addShortcut(4, 4, 2, 6, 5, 3, 9.0, false);
        f.testPathCalculation(3, 2, 15, IntArrayList.from((int[])new int[]{3, 4, 0, 1, 4, 2}));
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testFindPath_singleLoopInFwdSearch(Fixture f) {
        this.runTestWithSingleLoop(f, true);
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testFindPath_singleLoopInBwdSearch(Fixture f) {
        this.runTestWithSingleLoop(f, false);
    }

    private void runTestWithSingleLoop(Fixture f, boolean loopInFwdSearch) {
        int nodeA = 0;
        int nodeB = 6;
        if (!loopInFwdSearch) {
            int tmp = nodeA;
            nodeA = nodeB;
            nodeB = tmp;
        }
        f.graph.edge(4, nodeA).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(nodeA, 5).setDistance(20.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(5, 2).setDistance(20.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(2, 3).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(3, 1).setDistance(20.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(1, 5).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(5, nodeB).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(nodeB, 7).setDistance(20.0).set(f.speedEnc, 10.0, 0.0);
        f.setRestriction(nodeA, 5, nodeB);
        f.freeze();
        f.setIdentityLevels();
        f.addShortcut(3, 5, 8, 10, 4, 5, 3.0, false);
        f.addShortcut(3, 5, 4, 6, 2, 3, 3.0, true);
        f.addShortcut(5, 5, 4, 10, 9, 8, 6.0, false);
        f.testPathCalculation(4, 7, 12, IntArrayList.from((int[])new int[]{4, nodeA, 5, 2, 3, 1, 5, nodeB, 7}));
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testFindPathWithTurnRestriction_double_loop(Fixture f) {
        EdgeIteratorState e0to1 = f.graph.edge(0, 1).setDistance(20.0).set(f.speedEnc, 10.0, 10.0);
        EdgeIteratorState e1to6 = f.graph.edge(1, 6).setDistance(10.0).set(f.speedEnc, 10.0, 10.0);
        EdgeIteratorState e0to6 = f.graph.edge(0, 6).setDistance(40.0).set(f.speedEnc, 10.0, 10.0);
        EdgeIteratorState e2to6 = f.graph.edge(2, 6).setDistance(50.0).set(f.speedEnc, 10.0, 10.0);
        EdgeIteratorState e2to3 = f.graph.edge(2, 3).setDistance(30.0).set(f.speedEnc, 10.0, 10.0);
        EdgeIteratorState e3to6 = f.graph.edge(3, 6).setDistance(20.0).set(f.speedEnc, 10.0, 10.0);
        EdgeIteratorState e6to7 = f.graph.edge(7, 6).setDistance(10.0).set(f.speedEnc, 10.0, 10.0);
        EdgeIteratorState e4to7 = f.graph.edge(7, 4).setDistance(30.0).set(f.speedEnc, 10.0, 10.0);
        EdgeIteratorState e5to7 = f.graph.edge(7, 5).setDistance(20.0).set(f.speedEnc, 10.0, 10.0);
        f.setRestriction(e6to7, e1to6, 6);
        f.setRestriction(e6to7, e2to6, 6);
        f.setRestriction(e6to7, e3to6, 6);
        f.setRestriction(e1to6, e3to6, 6);
        f.setRestriction(e1to6, e6to7, 6);
        f.setRestriction(e1to6, e0to6, 6);
        f.setRestriction(e4to7, e5to7, 7);
        f.setRestriction(e5to7, e4to7, 7);
        f.freeze();
        f.setIdentityLevels();
        f.addShortcut(1, 6, 4, 0, 2, 0, 6.0, true);
        f.addShortcut(3, 6, 6, 8, 3, 4, 8.0, true);
        f.addShortcut(6, 6, 4, 2, 9, 1, 7.0, false);
        f.addShortcut(6, 6, 6, 10, 10, 5, 10.0, false);
        f.addShortcut(6, 7, 12, 2, 6, 11, 8.0, true);
        f.addShortcut(6, 7, 12, 10, 13, 12, 18.0, true);
        f.addShortcut(7, 7, 12, 12, 14, 6, 19.0, false);
        f.testPathCalculation(4, 5, 24, IntArrayList.from((int[])new int[]{4, 7, 6, 0, 1, 6, 2, 3, 6, 7, 5}));
        f.testPathCalculation(5, 4, 24, IntArrayList.from((int[])new int[]{5, 7, 6, 0, 1, 6, 2, 3, 6, 7, 4}));
    }

    @ParameterizedTest
    @ArgumentsSource(value=FixtureProvider.class)
    public void testFindPathWithTurnRestriction_two_different_loops(Fixture f) {
        f.graph.edge(0, 1).setDistance(20.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(1, 5).setDistance(10.0).set(f.speedEnc, 10.0, 10.0);
        f.graph.edge(5, 0).setDistance(10.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(5, 4).setDistance(50.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(5, 6).setDistance(30.0).set(f.speedEnc, 10.0, 10.0);
        f.graph.edge(6, 4).setDistance(40.0).set(f.speedEnc, 10.0, 10.0);
        f.graph.edge(3, 6).setDistance(30.0).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(6, 2).setDistance(40.0).set(f.speedEnc, 10.0, 0.0);
        f.setRestriction(3, 6, 2);
        f.freeze();
        f.setIdentityLevels();
        f.addShortcut(1, 5, 4, 0, 2, 0, 3.0, true);
        f.addShortcut(5, 5, 4, 2, 8, 1, 4.0, false);
        f.addShortcut(5, 6, 6, 11, 3, 5, 9.0, false);
        f.addShortcut(5, 6, 9, 2, 4, 9, 7.0, true);
        f.addShortcut(6, 6, 9, 8, 11, 4, 10.0, false);
        List<List> distMatrix = Arrays.asList(Arrays.asList(0, 2, 10, -1, 8, 3, 6), Arrays.asList(2, 0, 8, -1, 6, 1, 4), Arrays.asList(-1, -1, 0, -1, -1, -1, -1), Arrays.asList(7, 7, 17, 0, 7, 6, 3), Arrays.asList(8, 8, 8, -1, 0, 7, 4), Arrays.asList(1, 1, 7, -1, 5, 0, 3), Arrays.asList(4, 4, 4, -1, 4, 3, 0));
        for (int i = 0; i < distMatrix.size(); ++i) {
            for (int j = 0; j < distMatrix.get(i).size(); ++j) {
                f.testPathCalculation(i, j, (Integer)distMatrix.get(i).get(j), null);
            }
        }
    }

    private static class Fixture {
        private final int maxCost = 10;
        private final DecimalEncodedValue speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
        private final DecimalEncodedValue turnCostEnc = TurnCost.create((String)"car", (int)10);
        private final BaseGraph graph;
        private final CHConfig chConfig;
        private final String algoString;
        private CHStorage chStore;
        private CHStorageBuilder chBuilder;

        public Fixture(String algoString) {
            this.algoString = algoString;
            EncodingManager encodingManager = EncodingManager.start().add((EncodedValue)this.speedEnc).addTurnCostEncodedValue((EncodedValue)this.turnCostEnc).build();
            this.graph = new BaseGraph.Builder(encodingManager).withTurnCosts(true).create();
            this.chConfig = CHConfig.edgeBased((String)"profile", (Weighting)new SpeedWeighting(this.speedEnc, this.turnCostEnc, this.graph.getTurnCostStorage(), Double.POSITIVE_INFINITY));
        }

        public String toString() {
            return this.algoString;
        }

        private AbstractBidirectionEdgeCHNoSOD createAlgo() {
            return "astar".equals(this.algoString) ? new AStarBidirectionEdgeCHNoSOD(RoutingCHGraphImpl.fromGraph((BaseGraph)this.graph, (CHStorage)this.chStore, (CHConfig)this.chConfig)) : new DijkstraBidirectionEdgeCHNoSOD(RoutingCHGraphImpl.fromGraph((BaseGraph)this.graph, (CHStorage)this.chStore, (CHConfig)this.chConfig));
        }

        private void freeze() {
            this.graph.freeze();
            this.chStore = CHStorage.fromGraph((BaseGraph)this.graph, (CHConfig)this.chConfig);
            this.chBuilder = new CHStorageBuilder(this.chStore);
        }

        private void addShortcut(int from, int to, int firstOrigEdgeKey, int lastOrigEdgeKey, int skipped1, int skipped2, double weight, boolean reverse) {
            int flags = reverse ? PrepareEncoder.getScBwdDir() : PrepareEncoder.getScFwdDir();
            this.chBuilder.addShortcutEdgeBased(from, to, flags, weight, skipped1, skipped2, firstOrigEdgeKey, lastOrigEdgeKey);
        }

        private void setIdentityLevels() {
            this.chBuilder.setIdentityLevels();
        }

        private void setTurnCost(int from, int via, int to, double cost) {
            this.setTurnCost(this.getEdge(from, via), this.getEdge(via, to), via, cost);
        }

        private void setTurnCost(EdgeIteratorState edge1, EdgeIteratorState edge2, int viaNode, double costs) {
            this.graph.getTurnCostStorage().set(this.turnCostEnc, edge1.getEdge(), viaNode, edge2.getEdge(), costs);
        }

        private void setRestriction(int from, int via, int to) {
            this.setTurnCost(this.getEdge(from, via), this.getEdge(via, to), via, Double.POSITIVE_INFINITY);
        }

        private void setRestriction(EdgeIteratorState edge1, EdgeIteratorState edge2, int viaNode) {
            this.setTurnCost(edge1, edge2, viaNode, Double.POSITIVE_INFINITY);
        }

        private EdgeIteratorState getEdge(int from, int to) {
            return GHUtility.getEdge((Graph)this.graph, (int)from, (int)to);
        }

        private void testPathCalculation(int from, int to, int expectedWeight, IntArrayList expectedNodes) {
            this.testPathCalculation(from, to, expectedWeight, expectedNodes, 0);
        }

        private void testPathCalculation(int from, int to, int expectedEdgeWeight, IntArrayList expectedNodes, int expectedTurnCost) {
            int expectedWeight = expectedEdgeWeight + expectedTurnCost;
            int expectedDistance = expectedEdgeWeight * 10;
            int expectedTime = (expectedEdgeWeight + expectedTurnCost) * 1000;
            AbstractBidirectionEdgeCHNoSOD algo = this.createAlgo();
            Path path = algo.calcPath(from, to);
            if (expectedWeight < 0) {
                Assertions.assertFalse((boolean)path.isFound(), (String)String.format(Locale.ROOT, "Unexpected path from %d to %d.", from, to));
            } else {
                if (expectedNodes != null) {
                    Assertions.assertEquals((Object)expectedNodes, (Object)path.calcNodes(), (String)String.format(Locale.ROOT, "Unexpected path from %d to %d", from, to));
                }
                Assertions.assertEquals((double)expectedWeight, (double)path.getWeight(), (double)1.0E-6, (String)String.format(Locale.ROOT, "Unexpected path weight from %d to %d", from, to));
                Assertions.assertEquals((double)expectedDistance, (double)path.getDistance(), (double)1.0E-6, (String)String.format(Locale.ROOT, "Unexpected path distance from %d to %d", from, to));
                Assertions.assertEquals((long)expectedTime, (long)path.getTime(), (String)String.format(Locale.ROOT, "Unexpected path time from %d to %d", from, to));
            }
        }
    }

    private static class FixtureProvider
    implements ArgumentsProvider {
        private FixtureProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Stream.of(new Fixture("astar"), new Fixture("dijkstra")).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
        }
    }
}

