/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.json.Statement;
import com.graphhopper.routing.TestProfiles;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.Helper;
import com.graphhopper.util.details.PathDetail;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CustomizableConditionalRestrictionsTest {
    private static final String GH_LOCATION = "target/routing-conditional-access-gh";

    @BeforeEach
    @AfterEach
    public void setup() {
        Helper.removeDir((File)new File(GH_LOCATION));
    }

    @Test
    public void testConditionalAccess() {
        GraphHopper hopper = new GraphHopper().setStoreOnFlush(false).setEncodedValuesString("foot_temporal_access");
        hopper.init(new GraphHopperConfig().setProfiles(List.of(TestProfiles.accessAndSpeed((String)"foot", (String)"foot"))).putObject("graph.location", (Object)GH_LOCATION).putObject("graph.encoded_values", (Object)"foot_temporal_access, foot_access, foot_average_speed").putObject("datareader.file", (Object)"../core/files/conditional-restrictions.osm.xml").putObject("prepare.min_network_size", (Object)"0").putObject("import.osm.ignored_highways", (Object)"").putObject("datareader.date_range_parser_day", (Object)"2023-08-01"));
        hopper.importOrLoad();
        String PD_KEY = "access_conditional";
        GHResponse rsp = hopper.route(new GHRequest(50.909136, 14.213924, 50.90918, 14.213549).setProfile("foot").setPathDetails(Arrays.asList(PD_KEY)));
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        List details = (List)rsp.getBest().getPathDetails().get(PD_KEY);
        Assertions.assertEquals((Object)"no@(Jan15-Aug15)", (Object)((PathDetail)details.get(0)).getValue());
        Assertions.assertEquals((int)2, (int)details.size());
        Assertions.assertEquals((double)32.0, (double)rsp.getBest().getDistance(), (double)1.0);
        rsp = hopper.route(new GHRequest(50.909136, 14.213924, 50.90918, 14.213549).setProfile("foot").setCustomModel(new CustomModel().addToPriority(Statement.If((String)"foot_temporal_access == NO", (Statement.Op)Statement.Op.MULTIPLY, (String)"0"))).setPathDetails(Arrays.asList(PD_KEY)));
        Assertions.assertFalse((boolean)rsp.hasErrors(), (String)rsp.getErrors().toString());
        Assertions.assertEquals((double)16.0, (double)rsp.getBest().getDistance(), (double)1.0);
        details = (List)rsp.getBest().getPathDetails().get(PD_KEY);
        Assertions.assertEquals((int)1, (int)details.size());
    }
}

