/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.routing.DefaultBidirPathExtractor;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.SPTEntry;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.TurnCostStorage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultBidirPathExtractorTest {
    private final DecimalEncodedValue speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
    private final DecimalEncodedValue turnCostEnc = TurnCost.create((String)"car", (int)10);
    private final EncodingManager encodingManager = EncodingManager.start().add((EncodedValue)this.speedEnc).addTurnCostEncodedValue((EncodedValue)this.turnCostEnc).build();

    BaseGraph createGraph() {
        return new BaseGraph.Builder(this.encodingManager).withTurnCosts(true).create();
    }

    @Test
    public void testExtract() {
        BaseGraph graph = this.createGraph();
        graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 60.0, 60.0);
        SPTEntry fwdEntry = new SPTEntry(0, 2, 0.0, new SPTEntry(1, 10.0));
        SPTEntry bwdEntry = new SPTEntry(2, 0.0);
        Path p = DefaultBidirPathExtractor.extractPath((Graph)graph, (Weighting)new SpeedWeighting(this.speedEnc), (SPTEntry)fwdEntry, (SPTEntry)bwdEntry, (double)0.0);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 2}), (Object)p.calcNodes());
        Assertions.assertEquals((double)10.0, (double)p.getDistance(), (double)1.0E-4);
    }

    @Test
    public void testExtract2() {
        BaseGraph graph = this.createGraph();
        graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, 0.0);
        graph.edge(2, 3).setDistance(20.0).set(this.speedEnc, 10.0, 0.0);
        TurnCostStorage turnCostStorage = graph.getTurnCostStorage();
        turnCostStorage.set(this.turnCostEnc, 0, 2, 1, 5.0);
        SPTEntry fwdEntry = new SPTEntry(0, 2, 0.6, new SPTEntry(1, 0.0));
        SPTEntry bwdEntry = new SPTEntry(1, 2, 1.2, new SPTEntry(3, 0.0));
        Path p = DefaultBidirPathExtractor.extractPath((Graph)graph, (Weighting)new SpeedWeighting(this.speedEnc, this.turnCostEnc, turnCostStorage, Double.POSITIVE_INFINITY), (SPTEntry)fwdEntry, (SPTEntry)bwdEntry, (double)0.0);
        p.setWeight(8.0);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 2, 3}), (Object)p.calcNodes());
        Assertions.assertEquals((double)30.0, (double)p.getDistance(), (double)1.0E-4);
        Assertions.assertEquals((double)8.0, (double)p.getWeight(), (double)1.0E-4);
        Assertions.assertEquals((double)8000.0, (double)p.getTime(), (double)1.0E-6);
    }
}

