/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.RoutingAlgorithmFactorySimple;
import com.graphhopper.routing.RoutingAlgorithmTest;
import com.graphhopper.routing.ch.CHRoutingAlgorithmFactory;
import com.graphhopper.routing.ch.PrepareContractionHierarchies;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.CHStorage;
import com.graphhopper.storage.CHStorageBuilder;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.storage.RoutingCHGraphImpl;
import com.graphhopper.util.PMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DijkstraBidirectionCHTest {
    private final EncodingManager encodingManager;
    private final DecimalEncodedValue carSpeedEnc = new DecimalEncodedValueImpl("car_speed", 5, 5.0, true);
    private final DecimalEncodedValue bike2SpeedEnc = new DecimalEncodedValueImpl("bike2_speed", 4, 2.0, true);
    private final DecimalEncodedValue motorcycleSpeedEnc = new DecimalEncodedValueImpl("motorcycle_speed", 5, 5.0, true);

    public DijkstraBidirectionCHTest() {
        this.encodingManager = EncodingManager.start().add((EncodedValue)this.carSpeedEnc).add((EncodedValue)this.bike2SpeedEnc).add((EncodedValue)this.motorcycleSpeedEnc).build();
    }

    @Test
    public void testBaseGraph() {
        BaseGraph graph = this.createGHStorage();
        RoutingAlgorithmTest.initDirectedAndDiffSpeed((Graph)graph, this.carSpeedEnc);
        SpeedWeighting weighting = new SpeedWeighting(this.carSpeedEnc);
        this.prepareCH(graph, CHConfig.nodeBased((String)weighting.getName(), (Weighting)weighting));
        Path p1 = new RoutingAlgorithmFactorySimple().createAlgo((Graph)graph, (Weighting)weighting, new AlgorithmOptions()).calcPath(0, 3);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 4, 6, 7, 5, 3}), (Object)p1.calcNodes());
        Assertions.assertEquals((double)1261.72, (double)p1.getDistance(), (double)0.01, (String)p1.toString());
        Assertions.assertEquals((long)30953L, (long)p1.getTime(), (String)p1.toString());
    }

    @Test
    public void testBaseGraphMultipleVehicles() {
        DecimalEncodedValueImpl footSpeedEnc = new DecimalEncodedValueImpl("foot_speed", 4, 1.0, true);
        DecimalEncodedValueImpl carSpeedEnc = new DecimalEncodedValueImpl("car_speed", 5, 5.0, true);
        EncodingManager em = EncodingManager.start().add((EncodedValue)footSpeedEnc).add((EncodedValue)carSpeedEnc).build();
        SpeedWeighting footWeighting = new SpeedWeighting((DecimalEncodedValue)footSpeedEnc);
        SpeedWeighting carWeighting = new SpeedWeighting((DecimalEncodedValue)carSpeedEnc);
        CHConfig carConfig = CHConfig.nodeBased((String)"p_car", (Weighting)carWeighting);
        BaseGraph g = new BaseGraph.Builder(em).create();
        RoutingAlgorithmTest.initFootVsCar((DecimalEncodedValue)carSpeedEnc, (DecimalEncodedValue)footSpeedEnc, (Graph)g);
        RoutingCHGraph chGraph = this.prepareCH(g, carConfig);
        Path p1 = this.createCHAlgo(chGraph, true).calcPath(0, 7);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 4, 6, 7}), (Object)p1.calcNodes());
        Assertions.assertEquals((double)15000.0, (double)p1.getDistance(), (double)1.0E-6, (String)p1.toString());
        Path p2 = new RoutingAlgorithmFactorySimple().createAlgo((Graph)g, (Weighting)carWeighting, new AlgorithmOptions()).calcPath(0, 7);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 4, 6, 7}), (Object)p2.calcNodes());
        Assertions.assertEquals((double)15000.0, (double)p2.getDistance(), (double)1.0E-6, (String)p2.toString());
        Assertions.assertEquals((long)750000L, (long)p2.getTime(), (String)p2.toString());
        Path p4 = new RoutingAlgorithmFactorySimple().createAlgo((Graph)g, (Weighting)footWeighting, new AlgorithmOptions()).calcPath(0, 7);
        Assertions.assertEquals((double)17000.0, (double)p4.getDistance(), (double)1.0E-6, (String)p4.toString());
        Assertions.assertEquals((long)3400000L, (long)p4.getTime(), (String)p4.toString());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 4, 5, 7}), (Object)p4.calcNodes());
    }

    @Test
    public void testStallingNodesReducesNumberOfVisitedNodes() {
        BaseGraph graph = this.createGHStorage();
        graph.edge(8, 9).setDistance(100.0).set(this.carSpeedEnc, 60.0, 0.0);
        graph.edge(8, 3).setDistance(2.0).set(this.carSpeedEnc, 60.0, 0.0);
        graph.edge(8, 5).setDistance(1.0).set(this.carSpeedEnc, 60.0, 0.0);
        graph.edge(8, 6).setDistance(1.0).set(this.carSpeedEnc, 60.0, 0.0);
        graph.edge(8, 7).setDistance(1.0).set(this.carSpeedEnc, 60.0, 0.0);
        graph.edge(1, 2).setDistance(2.0).set(this.carSpeedEnc, 60.0, 0.0);
        graph.edge(1, 8).setDistance(1.0).set(this.carSpeedEnc, 60.0, 0.0);
        graph.edge(2, 3).setDistance(3.0).set(this.carSpeedEnc, 60.0, 0.0);
        for (int i = 3; i < 7; ++i) {
            graph.edge(i, i + 1).setDistance(1.0).set(this.carSpeedEnc, 60.0, 0.0);
        }
        graph.edge(9, 0).setDistance(1.0).set(this.carSpeedEnc, 60.0, 0.0);
        graph.edge(3, 9).setDistance(200.0).set(this.carSpeedEnc, 60.0, 0.0);
        graph.freeze();
        SpeedWeighting weighting = new SpeedWeighting(this.carSpeedEnc);
        CHConfig chConfig = CHConfig.nodeBased((String)weighting.getName(), (Weighting)weighting);
        CHStorage store = CHStorage.fromGraph((BaseGraph)graph, (CHConfig)chConfig);
        new CHStorageBuilder(store).setIdentityLevels();
        RoutingCHGraph routingCHGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)graph, (CHStorage)store, (CHConfig)chConfig);
        RoutingAlgorithm algo = this.createCHAlgo(routingCHGraph, true);
        Path p = algo.calcPath(1, 0);
        Assertions.assertEquals((int)7, (int)algo.getVisitedNodes());
        Assertions.assertEquals((double)102.0, (double)p.getDistance(), (double)0.001);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 8, 9, 0}), (Object)p.calcNodes(), (String)p.toString());
        RoutingAlgorithm algoNoSod = this.createCHAlgo(routingCHGraph, false);
        Path pNoSod = algoNoSod.calcPath(1, 0);
        Assertions.assertEquals((int)11, (int)algoNoSod.getVisitedNodes());
        Assertions.assertEquals((double)102.0, (double)pNoSod.getDistance(), (double)0.001);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 8, 9, 0}), (Object)pNoSod.calcNodes(), (String)pNoSod.toString());
    }

    @Test
    public void testDirectionDependentSpeedFwdSearch() {
        this.runTestWithDirectionDependentEdgeSpeed(10.0, 20.0, 0, 2, IntArrayList.from((int[])new int[]{0, 1, 2}), this.motorcycleSpeedEnc);
        this.runTestWithDirectionDependentEdgeSpeed(10.0, 20.0, 0, 2, IntArrayList.from((int[])new int[]{0, 1, 2}), this.bike2SpeedEnc);
    }

    @Test
    public void testDirectionDependentSpeedBwdSearch() {
        this.runTestWithDirectionDependentEdgeSpeed(20.0, 10.0, 2, 0, IntArrayList.from((int[])new int[]{2, 1, 0}), this.motorcycleSpeedEnc);
        this.runTestWithDirectionDependentEdgeSpeed(20.0, 10.0, 2, 0, IntArrayList.from((int[])new int[]{2, 1, 0}), this.bike2SpeedEnc);
    }

    private void runTestWithDirectionDependentEdgeSpeed(double speed, double revSpeed, int from, int to, IntArrayList expectedPath, DecimalEncodedValue speedEnc) {
        BaseGraph graph = this.createGHStorage();
        graph.edge(0, 1).setDistance(2.0).set(speedEnc, speed, revSpeed);
        graph.edge(1, 2).setDistance(1.0).set(speedEnc, 20.0, 20.0);
        graph.freeze();
        SpeedWeighting weighting = new SpeedWeighting(speedEnc);
        CHConfig chConfig = CHConfig.nodeBased((String)weighting.getName(), (Weighting)weighting);
        CHStorage chStore = CHStorage.fromGraph((BaseGraph)graph, (CHConfig)chConfig);
        new CHStorageBuilder(chStore).setIdentityLevels();
        RoutingCHGraph routingCHGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)graph, (CHStorage)chStore, (CHConfig)chConfig);
        RoutingAlgorithm algo = this.createCHAlgo(routingCHGraph, true);
        Path p = algo.calcPath(from, to);
        Assertions.assertEquals((double)3.0, (double)p.getDistance(), (double)0.001);
        Assertions.assertEquals((Object)expectedPath, (Object)p.calcNodes(), (String)p.toString());
    }

    private BaseGraph createGHStorage() {
        return new BaseGraph.Builder(this.encodingManager).create();
    }

    private RoutingCHGraph prepareCH(BaseGraph graph, CHConfig chConfig) {
        graph.freeze();
        PrepareContractionHierarchies pch = PrepareContractionHierarchies.fromGraph((BaseGraph)graph, (CHConfig)chConfig);
        PrepareContractionHierarchies.Result res = pch.doWork();
        return RoutingCHGraphImpl.fromGraph((BaseGraph)graph, (CHStorage)res.getCHStorage(), (CHConfig)res.getCHConfig());
    }

    private RoutingAlgorithm createCHAlgo(RoutingCHGraph chGraph, boolean withSOD) {
        PMap opts = new PMap();
        if (!withSOD) {
            opts.putObject("stall_on_demand", (Object)false);
        }
        opts.putObject("algorithm", (Object)"dijkstrabi");
        return new CHRoutingAlgorithmFactory(chGraph).createAlgo(opts);
    }
}

