/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.routing.DijkstraOneToMany;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.RoutingAlgorithmTest;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DijkstraOneToManyTest {
    private final DecimalEncodedValue speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
    private final EncodingManager encodingManager = EncodingManager.start().add((EncodedValue)this.speedEnc).build();
    private final Weighting defaultWeighting = new SpeedWeighting(this.speedEnc);

    private static void initGraphWeightLimit(Graph graph, DecimalEncodedValue speedEnc) {
        graph.edge(0, 1).setDistance(100.0).set(speedEnc, 10.0, 10.0);
        graph.edge(1, 2).setDistance(100.0).set(speedEnc, 10.0, 10.0);
        graph.edge(3, 2).setDistance(100.0).set(speedEnc, 10.0, 10.0);
        graph.edge(3, 5).setDistance(100.0).set(speedEnc, 10.0, 10.0);
        graph.edge(5, 7).setDistance(100.0).set(speedEnc, 10.0, 10.0);
        graph.edge(3, 4).setDistance(100.0).set(speedEnc, 10.0, 10.0);
        graph.edge(4, 6).setDistance(100.0).set(speedEnc, 10.0, 10.0);
        graph.edge(6, 7).setDistance(100.0).set(speedEnc, 10.0, 10.0);
        graph.edge(6, 5).setDistance(100.0).set(speedEnc, 10.0, 10.0);
        graph.edge(0, 7).setDistance(100.0).set(speedEnc, 10.0, 10.0);
    }

    @Test
    public void testIssue182() {
        BaseGraph graph = this.createGHStorage();
        this.initGraph((Graph)graph);
        Path p = this.calcPath(graph, 0, 8);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 7, 8}), (Object)p.calcNodes());
        p = this.calcPath(graph, 0, 10);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 1, 2, 3, 4, 10}), (Object)p.calcNodes());
    }

    @Test
    public void testIssue239_and362() {
        BaseGraph graph = this.createGHStorage();
        graph.edge(0, 1).setDistance(1.0).set(this.speedEnc, 60.0, 60.0);
        graph.edge(1, 2).setDistance(1.0).set(this.speedEnc, 60.0, 60.0);
        graph.edge(2, 0).setDistance(1.0).set(this.speedEnc, 60.0, 60.0);
        graph.edge(4, 5).setDistance(1.0).set(this.speedEnc, 60.0, 60.0);
        graph.edge(5, 6).setDistance(1.0).set(this.speedEnc, 60.0, 60.0);
        graph.edge(6, 4).setDistance(1.0).set(this.speedEnc, 60.0, 60.0);
        DijkstraOneToMany algo = this.createAlgo(graph);
        Assertions.assertEquals((int)-1, (int)algo.findEndNode(0, 4));
        Assertions.assertEquals((int)-1, (int)algo.findEndNode(0, 4));
        Assertions.assertEquals((int)1, (int)algo.findEndNode(0, 1));
        Assertions.assertEquals((int)1, (int)algo.findEndNode(0, 1));
    }

    @Test
    public void testUseCache() {
        BaseGraph graph = this.createGHStorage();
        RoutingAlgorithmTest.initTestStorage((Graph)graph, this.speedEnc);
        DijkstraOneToMany algo = this.createAlgo(graph);
        Path p = algo.calcPath(0, 4);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 4}), (Object)p.calcNodes());
        p = algo.calcPath(0, 7);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 4, 5, 7}), (Object)p.calcNodes());
        p = algo.calcPath(0, 2);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 1, 2}), (Object)p.calcNodes());
    }

    private void initGraph(Graph graph) {
        graph.edge(0, 1).setDistance(1.0).set(this.speedEnc, 60.0, 60.0);
        graph.edge(1, 2).setDistance(1.0).set(this.speedEnc, 60.0, 60.0);
        graph.edge(2, 3).setDistance(1.0).set(this.speedEnc, 60.0, 60.0);
        graph.edge(3, 4).setDistance(1.0).set(this.speedEnc, 60.0, 60.0);
        graph.edge(4, 10).setDistance(1.0).set(this.speedEnc, 60.0, 60.0);
        graph.edge(0, 7).setDistance(1.0).set(this.speedEnc, 60.0, 60.0);
        graph.edge(7, 8).setDistance(1.0).set(this.speedEnc, 60.0, 60.0);
        graph.edge(7, 10).setDistance(10.0).set(this.speedEnc, 60.0, 60.0);
    }

    @Test
    public void testWeightLimit_issue380() {
        BaseGraph graph = this.createGHStorage();
        DijkstraOneToManyTest.initGraphWeightLimit((Graph)graph, this.speedEnc);
        DijkstraOneToMany algo = this.createAlgo(graph);
        algo.setWeightLimit(30.0);
        Path p = algo.calcPath(0, 4);
        Assertions.assertTrue((boolean)p.isFound());
        Assertions.assertEquals((double)30.0, (double)p.getWeight(), (double)1.0E-6);
        algo = this.createAlgo(graph);
        p = algo.calcPath(0, 3);
        Assertions.assertTrue((boolean)p.isFound());
        Assertions.assertEquals((double)30.0, (double)p.getWeight(), (double)1.0E-6);
    }

    @Test
    public void testUseCacheZeroPath_issue707() {
        BaseGraph graph = this.createGHStorage();
        RoutingAlgorithmTest.initTestStorage((Graph)graph, this.speedEnc);
        DijkstraOneToMany algo = this.createAlgo(graph);
        Path p = algo.calcPath(0, 0);
        Assertions.assertEquals((double)0.0, (double)p.getDistance(), (double)0.0);
        p = algo.calcPath(0, 4);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 4}), (Object)p.calcNodes());
        p = algo.calcPath(0, 7);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 4, 5, 7}), (Object)p.calcNodes());
        p = algo.calcPath(0, 2);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 1, 2}), (Object)p.calcNodes());
    }

    private BaseGraph createGHStorage() {
        return new BaseGraph.Builder(this.encodingManager).create();
    }

    private Path calcPath(BaseGraph graph, int from, int to) {
        return this.createAlgo(graph).calcPath(from, to);
    }

    private DijkstraOneToMany createAlgo(BaseGraph g) {
        return new DijkstraOneToMany((Graph)g, this.defaultWeighting, TraversalMode.NODE_BASED);
    }
}

