/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntSet;
import com.graphhopper.routing.Dijkstra;
import com.graphhopper.routing.DijkstraBidirectionRef;
import com.graphhopper.routing.EdgeToEdgeRoutingAlgorithm;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.AvoidEdgesWeighting;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;

public class DirectedBidirectionalDijkstraTest {
    private TurnCostStorage turnCostStorage;
    private int maxTurnCosts;
    private BaseGraph graph;
    private DecimalEncodedValue speedEnc;
    private Weighting weighting;
    private DecimalEncodedValue turnCostEnc;

    @BeforeEach
    public void setup() {
        this.maxTurnCosts = 10;
        this.speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
        this.turnCostEnc = TurnCost.create((String)"car", (int)this.maxTurnCosts);
        EncodingManager encodingManager = EncodingManager.start().add((EncodedValue)this.speedEnc).addTurnCostEncodedValue((EncodedValue)this.turnCostEnc).build();
        this.graph = new BaseGraph.Builder(encodingManager).withTurnCosts(true).create();
        this.turnCostStorage = this.graph.getTurnCostStorage();
        this.weighting = this.createWeighting(Double.POSITIVE_INFINITY);
    }

    private Weighting createWeighting(double uTurnCosts) {
        return new SpeedWeighting(this.speedEnc, this.turnCostEnc, this.turnCostStorage, uTurnCosts);
    }

    @Test
    public void connectionNotFound() {
        this.graph.edge(0, 1).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 3).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        Path path = this.calcPath(0, 3, 0, 1);
        this.assertNotFound(path);
    }

    @Test
    public void singleEdge() {
        this.graph.edge(0, 1).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.assertNotFound(this.calcPath(0, 1, 5, 0));
        this.assertNotFound(this.calcPath(0, 1, 0, 5));
        this.assertNotFound(this.calcPath(0, 1, -1, 0));
        this.assertNotFound(this.calcPath(0, 1, 0, -1));
        this.assertPath(this.calcPath(0, 1, -2, 0), 0.1, 1.0, 100L, this.nodes(0, 1));
        this.assertPath(this.calcPath(0, 1, 0, -2), 0.1, 1.0, 100L, this.nodes(0, 1));
        this.assertPath(this.calcPath(0, 1, 0, 0), 0.1, 1.0, 100L, this.nodes(0, 1));
    }

    @Test
    public void simpleGraph() {
        this.graph.edge(0, 1).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 2).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.assertNotFound(this.calcPath(0, 2, 5, 0));
        this.assertNotFound(this.calcPath(0, 2, 0, 5));
        this.assertNotFound(this.calcPath(0, 2, -1, 0));
        this.assertNotFound(this.calcPath(0, 2, 0, -1));
        this.assertPath(this.calcPath(0, 2, -2, 1), 0.2, 2.0, 200L, this.nodes(0, 1, 2));
        this.assertPath(this.calcPath(0, 2, 0, -2), 0.2, 2.0, 200L, this.nodes(0, 1, 2));
        this.assertPath(this.calcPath(0, 2, 0, 1), 0.2, 2.0, 200L, this.nodes(0, 1, 2));
    }

    @Test
    public void sourceEqualsTarget() {
        this.graph.edge(0, 1).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(0, 2).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 2).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.assertPath(this.calcPath(0, 0, 0, 1), 0.3, 3.0, 300L, this.nodes(0, 1, 2, 0));
        this.assertPath(this.calcPath(0, 0, 1, 0), 0.3, 3.0, 300L, this.nodes(0, 2, 1, 0));
        this.assertPath(this.calcPath(0, 0, -2, -2), 0.0, 0.0, 0L, this.nodes(0));
        this.assertNotFound(this.calcPath(0, 0, 1, 1));
        this.assertNotFound(this.calcPath(0, 0, 5, 1));
    }

    @Test
    public void restrictedEdges() {
        int costlySource = this.graph.edge(0, 1).setDistance(5.0).set(this.speedEnc, 10.0, 10.0).getEdge();
        this.graph.edge(1, 2).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(2, 3).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        int costlyTarget = this.graph.edge(3, 4).setDistance(5.0).set(this.speedEnc, 10.0, 10.0).getEdge();
        int cheapSource = this.graph.edge(0, 5).setDistance(1.0).set(this.speedEnc, 10.0, 10.0).getEdge();
        this.graph.edge(5, 6).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(6, 7).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        int cheapTarget = this.graph.edge(7, 4).setDistance(1.0).set(this.speedEnc, 10.0, 10.0).getEdge();
        this.graph.edge(2, 6).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.assertPath(this.calcPath(0, 4, cheapSource, cheapTarget), 0.4, 4.0, 400L, this.nodes(0, 5, 6, 7, 4));
        this.assertPath(this.calcPath(0, 4, cheapSource, costlyTarget), 0.9, 9.0, 900L, this.nodes(0, 5, 6, 2, 3, 4));
        this.assertPath(this.calcPath(0, 4, costlySource, cheapTarget), 0.9, 9.0, 900L, this.nodes(0, 1, 2, 6, 7, 4));
        this.assertPath(this.calcPath(0, 4, costlySource, costlyTarget), 1.2, 12.0, 1200L, this.nodes(0, 1, 2, 3, 4));
    }

    @Test
    public void notConnectedDueToRestrictions() {
        int sourceNorth = this.graph.edge(0, 1).setDistance(1.0).set(this.speedEnc, 10.0, 10.0).getEdge();
        int sourceSouth = this.graph.edge(0, 3).setDistance(2.0).set(this.speedEnc, 10.0, 10.0).getEdge();
        int targetNorth = this.graph.edge(1, 2).setDistance(3.0).set(this.speedEnc, 10.0, 10.0).getEdge();
        int targetSouth = this.graph.edge(3, 2).setDistance(4.0).set(this.speedEnc, 10.0, 10.0).getEdge();
        this.assertPath(this.calcPath(0, 2, sourceNorth, targetNorth), 0.4, 4.0, 400L, this.nodes(0, 1, 2));
        this.assertNotFound(this.calcPath(0, 2, sourceNorth, targetSouth));
        this.assertNotFound(this.calcPath(0, 2, sourceSouth, targetNorth));
        this.assertPath(this.calcPath(0, 2, sourceSouth, targetSouth), 0.6, 6.0, 600L, this.nodes(0, 3, 2));
    }

    @Test
    public void restrictions_one_ways() {
        this.graph.edge(0, 3).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 0).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 2).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 1).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 3).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.assertPath(this.calcPath(0, 2, 0, 2), 0.2, 2.0, 200L, this.nodes(0, 3, 2));
        this.assertNotFound(this.calcPath(0, 2, 1, 2));
        this.assertNotFound(this.calcPath(0, 2, 0, 3));
        this.assertNotFound(this.calcPath(0, 2, 1, 3));
    }

    @Test
    public void forcingDirectionDoesNotMeanWeCannotUseEdgeAtAll() {
        int north = this.graph.edge(1, 0).setDistance(1.0).set(this.speedEnc, 10.0, 10.0).getEdge();
        int south = this.graph.edge(1, 2).setDistance(1.0).set(this.speedEnc, 10.0, 10.0).getEdge();
        this.graph.edge(2, 5).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(5, 4).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(4, 3).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 2).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(1, 0).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(0, 6).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        int targetEdge = this.graph.edge(6, 7).setDistance(1.0).set(this.speedEnc, 10.0, 0.0).getEdge();
        this.assertPath(this.calcPath(1, 7, north, targetEdge), 0.3, 3.0, 300L, this.nodes(1, 0, 6, 7));
        this.assertPath(this.calcPath(1, 7, south, targetEdge), 0.9, 9.0, 900L, this.nodes(1, 2, 5, 4, 3, 2, 1, 0, 6, 7));
    }

    @Test
    public void directedCircle() {
        this.graph.edge(0, 6).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(6, 1).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 2).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 3).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 4).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(4, 5).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(5, 0).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.assertPath(this.calcPath(6, 0, 1, 6), 0.6, 6.0, 600L, this.nodes(6, 1, 2, 3, 4, 5, 0));
    }

    @Test
    public void directedRouting() {
        this.graph.edge(0, 1).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 2).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(2, 3).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(3, 4).setDistance(3.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState rightNorth = this.graph.edge(4, 10).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState rightSouth = this.graph.edge(10, 5).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(5, 6).setDistance(2.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(6, 2).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(2, 7).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(7, 8).setDistance(9.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState leftSouth = this.graph.edge(8, 9).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState leftNorth = this.graph.edge(9, 0).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.setTurnCost(7, 2, 3, 1.0);
        this.setTurnCost(7, 2, 6, 3.0);
        this.setTurnCost(1, 2, 3, 5.0);
        this.setTurnCost(1, 2, 6, 7.0);
        this.setTurnCost(1, 2, 7, 9.0);
        double unitEdgeWeight = 0.1;
        this.assertPath(this.calcPath(9, 9, leftNorth.getEdge(), leftSouth.getEdge()), 7.300000000000001, 23.0, 7300L, this.nodes(9, 0, 1, 2, 3, 4, 10, 5, 6, 2, 7, 8, 9));
        this.assertPath(this.calcPath(9, 9, leftSouth.getEdge(), leftNorth.getEdge()), 1.4000000000000001, 14.0, 1400L, this.nodes(9, 8, 7, 2, 1, 0, 9));
        this.assertPath(this.calcPath(9, 10, leftSouth.getEdge(), rightSouth.getEdge()), 4.5, 15.0, 4500L, this.nodes(9, 8, 7, 2, 6, 5, 10));
        this.assertPath(this.calcPath(9, 10, leftSouth.getEdge(), rightNorth.getEdge()), 2.6, 16.0, 2600L, this.nodes(9, 8, 7, 2, 3, 4, 10));
    }

    @Test
    public void sourceAndTargetAreNeighbors() {
        this.graph.edge(0, 1).setDistance(100.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 2).setDistance(100.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(2, 3).setDistance(100.0).set(this.speedEnc, 10.0, 10.0);
        this.assertPath(this.calcPath(1, 2, -2, -2), 10.0, 100.0, 10000L, this.nodes(1, 2));
        this.assertPath(this.calcPath(1, 2, 1, -2), 10.0, 100.0, 10000L, this.nodes(1, 2));
        this.assertPath(this.calcPath(1, 2, -2, 1), 10.0, 100.0, 10000L, this.nodes(1, 2));
        this.assertPath(this.calcPath(1, 2, 1, 1), 10.0, 100.0, 10000L, this.nodes(1, 2));
        this.assertNotFound(this.calcPath(1, 2, 1, 2));
        this.assertNotFound(this.calcPath(1, 2, 0, 1));
        this.assertNotFound(this.calcPath(1, 2, 0, 2));
        this.assertPath(this.calcPath(1, 2, 1, 2, this.createWeighting(100.0)), 130.0, 300.0, 130000L, this.nodes(1, 2, 3, 2));
        this.assertPath(this.calcPath(1, 2, 0, 1, this.createWeighting(100.0)), 130.0, 300.0, 130000L, this.nodes(1, 0, 1, 2));
        this.assertPath(this.calcPath(1, 2, 0, 2, this.createWeighting(100.0)), 250.0, 500.0, 250000L, this.nodes(1, 0, 1, 2, 3, 2));
    }

    @Test
    public void worksWithTurnCosts() {
        this.graph.edge(0, 1).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 2).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 4).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(0, 3).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(3, 4).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(4, 5).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(5, 2).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.setRestriction(0, 3, 4);
        this.setTurnCost(4, 5, 2, 6.0);
        this.assertPath(this.calcPath(0, 2, 0, 6), 6.4, 4.0, 6400L, this.nodes(0, 1, 4, 5, 2));
        this.assertNotFound(this.calcPath(0, 2, 3, -2));
        this.assertPath(this.calcPath(0, 2, -2, -2), 0.2, 2.0, 200L, this.nodes(0, 1, 2));
    }

    @Test
    public void finiteUTurnCosts() {
        int right0 = this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 10.0).getEdge();
        this.graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(2, 3).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(3, 4).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(4, 5).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(5, 2).setDistance(1000.0).set(this.speedEnc, 10.0, 10.0);
        int left6 = this.graph.edge(1, 6).setDistance(10.0).set(this.speedEnc, 10.0, 10.0).getEdge();
        int left0 = this.graph.edge(0, 7).setDistance(10.0).set(this.speedEnc, 10.0, 10.0).getEdge();
        this.graph.edge(7, 8).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(8, 9).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        int right6 = this.graph.edge(9, 6).setDistance(10.0).set(this.speedEnc, 10.0, 10.0).getEdge();
        this.setRestriction(0, 1, 6);
        this.setRestriction(5, 4, 3);
        this.assertPath(this.calcPath(0, 6, right0, left6), 107.0, 1070.0, 107000L, this.nodes(0, 1, 2, 3, 4, 5, 2, 1, 6));
        this.assertPath(this.calcPath(0, 6, right0, left6, this.createWeighting(5000.0)), 107.0, 1070.0, 107000L, this.nodes(0, 1, 2, 3, 4, 5, 2, 1, 6));
        this.assertPath(this.calcPath(0, 6, right0, left6, this.createWeighting(40.0)), 44.0, 40.0, 44000L, this.nodes(0, 1, 2, 1, 6));
        this.assertPath(this.calcPath(0, 6, left0, right6), 4.0, 40.0, 4000L, this.nodes(0, 7, 8, 9, 6));
        this.assertPath(this.calcPath(0, 6, left0, left6), 111.0, 1110.0, 111000L, this.nodes(0, 7, 8, 9, 6, 1, 2, 3, 4, 5, 2, 1, 6));
        this.assertPath(this.calcPath(0, 6, left0, left6, this.createWeighting(40.0)), 46.0, 60.0, 46000L, this.nodes(0, 7, 8, 9, 6, 1, 6));
    }

    @RepeatedTest(value=10)
    public void compare_standard_dijkstra() {
        this.compare_with_dijkstra(this.weighting);
    }

    @RepeatedTest(value=10)
    public void compare_standard_dijkstra_finite_uturn_costs() {
        this.compare_with_dijkstra(this.createWeighting(40.0));
    }

    private void compare_with_dijkstra(Weighting w) {
        long seed = System.nanoTime();
        int numQueries = 1000;
        Random rnd = new Random(seed);
        int numNodes = 100;
        GHUtility.buildRandomGraph((Graph)this.graph, (Random)rnd, (int)numNodes, (double)2.2, (boolean)true, (DecimalEncodedValue)this.speedEnc, null, (double)0.8, (double)0.8);
        GHUtility.addRandomTurnCosts((Graph)this.graph, (long)seed, null, (DecimalEncodedValue)this.turnCostEnc, (int)this.maxTurnCosts, (TurnCostStorage)this.turnCostStorage);
        long numStrictViolations = 0L;
        for (int i = 0; i < 1000; ++i) {
            int source = rnd.nextInt(numNodes);
            int target = rnd.nextInt(numNodes);
            Path dijkstraPath = new Dijkstra((Graph)this.graph, w, TraversalMode.EDGE_BASED).calcPath(source, target);
            Path path = this.calcPath(source, target, -2, -2, w);
            Assertions.assertEquals((Object)dijkstraPath.isFound(), (Object)path.isFound(), (String)("dijkstra found/did not find a path, from: " + source + ", to: " + target + ", seed: " + seed));
            Assertions.assertEquals((double)dijkstraPath.getWeight(), (double)path.getWeight(), (double)1.0E-6, (String)("weight does not match dijkstra, from: " + source + ", to: " + target + ", seed: " + seed));
            if (!(Math.abs(dijkstraPath.getDistance() - path.getDistance()) > 1.0E-6) && Math.abs(dijkstraPath.getTime() - path.getTime()) <= 10L && dijkstraPath.calcNodes().equals((Object)path.calcNodes())) continue;
            ++numStrictViolations;
        }
        if ((double)numStrictViolations > Math.max(1.0, 50.0)) {
            Assertions.fail((String)("Too many strict violations, seed: " + seed + " - " + numStrictViolations + " / 1000"));
        }
    }

    @Test
    public void blockArea() {
        EdgeIteratorState edge1 = this.graph.edge(0, 1).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 2).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        EdgeIteratorState edge2 = this.graph.edge(2, 3).setDistance(10.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(0, 4).setDistance(100.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(4, 5).setDistance(100.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(5, 6).setDistance(100.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(6, 3).setDistance(100.0).set(this.speedEnc, 10.0, 10.0);
        this.assertPath(this.calcPath(0, 3, -2, -2), 3.0, 30.0, 3000L, this.nodes(0, 1, 2, 3));
        this.assertPath(this.calcPath(0, 3, 3, -2), 40.0, 400.0, 40000L, this.nodes(0, 4, 5, 6, 3));
        this.assertPath(this.calcPath(0, 3, -2, 6), 40.0, 400.0, 40000L, this.nodes(0, 4, 5, 6, 3));
        this.assertPath(this.calcPath(0, 3, -2, -2, (Weighting)this.createAvoidEdgeWeighting(edge1)), 40.0, 400.0, 40000L, this.nodes(0, 4, 5, 6, 3));
        this.assertPath(this.calcPath(0, 3, -2, -2, (Weighting)this.createAvoidEdgeWeighting(edge2)), 40.0, 400.0, 40000L, this.nodes(0, 4, 5, 6, 3));
        this.assertNotFound(this.calcPath(0, 3, edge1.getEdge(), edge2.getEdge(), (Weighting)this.createAvoidEdgeWeighting(edge1)));
        this.assertNotFound(this.calcPath(0, 3, edge1.getEdge(), edge2.getEdge(), (Weighting)this.createAvoidEdgeWeighting(edge2)));
        this.assertNotFound(this.calcPath(0, 1, edge1.getEdge(), -2, (Weighting)this.createAvoidEdgeWeighting(edge1)));
        this.assertNotFound(this.calcPath(0, 1, -2, edge2.getEdge(), (Weighting)this.createAvoidEdgeWeighting(edge2)));
    }

    private AvoidEdgesWeighting createAvoidEdgeWeighting(EdgeIteratorState edgeOut) {
        AvoidEdgesWeighting avoidEdgesWeighting = new AvoidEdgesWeighting(this.weighting);
        avoidEdgesWeighting.setEdgePenaltyFactor(Double.POSITIVE_INFINITY);
        avoidEdgesWeighting.setAvoidedEdges((IntSet)IntHashSet.from((int[])new int[]{edgeOut.getEdge()}));
        return avoidEdgesWeighting;
    }

    @Test
    public void directedRouting_noUTurnAtVirtualEdge() {
        this.graph.edge(0, 1).setDistance(1.0).set(this.speedEnc, 10.0, 10.0);
        this.graph.edge(1, 2).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(2, 3).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(3, 4).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(4, 5).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        this.graph.edge(5, 0).setDistance(1.0).set(this.speedEnc, 10.0, 0.0);
        NodeAccess na = this.graph.getNodeAccess();
        na.setNode(0, 1.0, 0.0);
        na.setNode(1, 1.0, 1.0);
        na.setNode(2, 1.0, 2.0);
        na.setNode(3, 0.0, 2.0);
        na.setNode(4, 0.0, 1.0);
        na.setNode(5, 0.0, 0.0);
        LocationIndexTree locationIndex = new LocationIndexTree((Graph)this.graph, this.graph.getDirectory());
        locationIndex.prepareIndex();
        Snap snap = locationIndex.findClosest(1.1, 0.5, EdgeFilter.ALL_EDGES);
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)this.graph, (Snap)snap);
        Assertions.assertEquals((Object)Snap.Position.EDGE, (Object)snap.getSnappedPosition(), (String)"wanted to get EDGE");
        Assertions.assertEquals((int)6, (int)snap.getClosestNode());
        Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(0, 2)), (Object)GHUtility.getNeighbors((EdgeIterator)this.graph.createEdgeExplorer().setBaseNode(1)));
        Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(6, 2)), (Object)GHUtility.getNeighbors((EdgeIterator)queryGraph.createEdgeExplorer().setBaseNode(1)));
        EdgeIteratorState virtualEdge = GHUtility.getEdge((Graph)queryGraph, (int)6, (int)1);
        int outEdge = virtualEdge.getEdge();
        EdgeToEdgeRoutingAlgorithm algo = this.createAlgo((Graph)queryGraph, this.weighting);
        Path path = algo.calcPath(6, 0, outEdge, -2);
        Assertions.assertEquals((Object)this.nodes(6, 1, 2, 3, 4, 5, 0), (Object)path.calcNodes());
        Assertions.assertEquals((double)(5.0 + virtualEdge.getDistance()), (double)path.getDistance(), (double)0.001);
    }

    private Path calcPath(int source, int target, int sourceOutEdge, int targetInEdge) {
        return this.calcPath(source, target, sourceOutEdge, targetInEdge, this.weighting);
    }

    private Path calcPath(int source, int target, int sourceOutEdge, int targetInEdge, Weighting w) {
        EdgeToEdgeRoutingAlgorithm algo = this.createAlgo((Graph)this.graph, w);
        return algo.calcPath(source, target, sourceOutEdge, targetInEdge);
    }

    private EdgeToEdgeRoutingAlgorithm createAlgo(Graph graph, Weighting weighting) {
        return new DijkstraBidirectionRef(graph, weighting, TraversalMode.EDGE_BASED);
    }

    private IntArrayList nodes(int ... nodes) {
        return IntArrayList.from((int[])nodes);
    }

    private void assertPath(Path path, double weight, double distance, long time, IntArrayList nodes) {
        Assertions.assertTrue((boolean)path.isFound(), (String)"expected a path, but no path was found");
        Assertions.assertEquals((Object)nodes, (Object)path.calcNodes(), (String)"unexpected nodes");
        Assertions.assertEquals((double)weight, (double)path.getWeight(), (double)1.0E-6, (String)"unexpected weight");
        Assertions.assertEquals((double)distance, (double)path.getDistance(), (double)1.0E-6, (String)"unexpected distance");
        Assertions.assertEquals((long)time, (long)path.getTime(), (String)"unexpected time");
    }

    private void assertNotFound(Path path) {
        Assertions.assertFalse((boolean)path.isFound(), (String)"expected no path, but a path was found");
        Assertions.assertEquals((double)Double.MAX_VALUE, (double)path.getWeight(), (double)1.0E-6);
        Assertions.assertEquals((double)0.0, (double)path.getDistance(), (double)1.0E-6);
        Assertions.assertEquals((long)0L, (long)path.getTime());
        Assertions.assertEquals((Object)this.nodes(new int[0]), (Object)path.calcNodes());
    }

    private void setRestriction(int fromNode, int node, int toNode) {
        this.setTurnCost(fromNode, node, toNode, Double.POSITIVE_INFINITY);
    }

    private void setTurnCost(int fromNode, int node, int toNode, double turnCost) {
        this.turnCostStorage.set(this.turnCostEnc, GHUtility.getEdge((Graph)this.graph, (int)fromNode, (int)node).getEdge(), node, GHUtility.getEdge((Graph)this.graph, (int)node, (int)toNode).getEdge(), turnCost);
    }
}

