/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.AStar;
import com.graphhopper.routing.AStarBidirection;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.DijkstraBidirectionRef;
import com.graphhopper.routing.EdgeToEdgeRoutingAlgorithm;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.ch.CHRoutingAlgorithmFactory;
import com.graphhopper.routing.ch.PrepareContractionHierarchies;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.lm.LMConfig;
import com.graphhopper.routing.lm.LMRoutingAlgorithmFactory;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.lm.PrepareLandmarks;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.querygraph.QueryRoutingCHGraph;
import com.graphhopper.routing.subnetwork.PrepareRoutingSubnetworks;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.CHStorage;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.storage.RoutingCHGraphImpl;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.PMap;
import com.graphhopper.util.shapes.BBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectedRoutingTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectedRoutingTest.class);

    @ParameterizedTest
    @ArgumentsSource(value=RepeatedFixtureProvider.class)
    public void randomGraph(Fixture f) {
        long seed = System.nanoTime();
        int numQueries = 50;
        Random rnd = new Random(seed);
        GHUtility.buildRandomGraph((Graph)f.graph, (Random)rnd, (int)100, (double)2.2, (boolean)true, (DecimalEncodedValue)f.speedEnc, null, (double)0.8, (double)0.8);
        GHUtility.addRandomTurnCosts((Graph)f.graph, (long)seed, null, (DecimalEncodedValue)f.turnCostEnc, (int)f.maxTurnCosts, (TurnCostStorage)f.turnCostStorage);
        f.preProcessGraph();
        ArrayList<String> strictViolations = new ArrayList<String>();
        for (int i = 0; i < 50; ++i) {
            int source = f.getRandom(rnd);
            int target = f.getRandom(rnd);
            int sourceOutEdge = this.getSourceOutEdge(rnd, source, (Graph)f.graph);
            int targetInEdge = this.getTargetInEdge(rnd, target, (Graph)f.graph);
            Path refPath = new DijkstraBidirectionRef((Graph)f.graph, f.graph.wrapWeighting(f.weighting), TraversalMode.EDGE_BASED).calcPath(source, target, sourceOutEdge, targetInEdge);
            Path path = f.createAlgo().calcPath(source, target, sourceOutEdge, targetInEdge);
            strictViolations.addAll(this.comparePaths(refPath, path, source, target, false, seed));
        }
        if ((double)strictViolations.size() > Math.max(1.0, 2.5)) {
            for (String strictViolation : strictViolations) {
                LOGGER.info("strict violation: " + strictViolation);
            }
            Assertions.fail((String)("Too many strict violations, with seed: " + seed + " - " + strictViolations.size() + " / 50"));
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=RepeatedFixtureProvider.class)
    public void randomGraph_withQueryGraph(Fixture f) {
        long seed = System.nanoTime();
        int numQueries = 50;
        double pOffset = 0.0;
        Random rnd = new Random(seed);
        GHUtility.buildRandomGraph((Graph)f.graph, (Random)rnd, (int)50, (double)2.2, (boolean)true, (DecimalEncodedValue)f.speedEnc, null, (double)0.8, (double)pOffset);
        GHUtility.addRandomTurnCosts((Graph)f.graph, (long)seed, null, (DecimalEncodedValue)f.turnCostEnc, (int)f.maxTurnCosts, (TurnCostStorage)f.turnCostStorage);
        f.preProcessGraph();
        LocationIndexTree index = new LocationIndexTree((Graph)f.graph, f.dir);
        index.prepareIndex();
        ArrayList<String> strictViolations = new ArrayList<String>();
        for (int i = 0; i < 50; ++i) {
            List snaps = GHUtility.createRandomSnaps((BBox)f.graph.getBounds(), (LocationIndex)index, (Random)rnd, (int)2, (boolean)true, (EdgeFilter)EdgeFilter.ALL_EDGES);
            QueryGraph queryGraph = QueryGraph.create((BaseGraph)f.graph, (List)snaps);
            int source = ((Snap)snaps.get(0)).getClosestNode();
            int target = ((Snap)snaps.get(1)).getClosestNode();
            Random tmpRnd1 = new Random(seed);
            int sourceOutEdge = this.getSourceOutEdge(tmpRnd1, source, (Graph)queryGraph);
            int targetInEdge = this.getTargetInEdge(tmpRnd1, target, (Graph)queryGraph);
            Random tmpRnd2 = new Random(seed);
            int chSourceOutEdge = this.getSourceOutEdge(tmpRnd2, source, (Graph)queryGraph);
            int chTargetInEdge = this.getTargetInEdge(tmpRnd2, target, (Graph)queryGraph);
            Path refPath = new DijkstraBidirectionRef((Graph)queryGraph, queryGraph.wrapWeighting(f.weighting), TraversalMode.EDGE_BASED).calcPath(source, target, sourceOutEdge, targetInEdge);
            Path path = f.createAlgo((Graph)queryGraph).calcPath(source, target, chSourceOutEdge, chTargetInEdge);
            strictViolations.addAll(this.comparePaths(refPath, path, source, target, false, seed));
        }
        if ((double)strictViolations.size() > Math.max(1.0, 2.5)) {
            Assertions.fail((String)("Too many strict violations, with seed: " + seed + " - " + strictViolations.size() + " / 50"));
        }
    }

    @Disabled(value="fix this #1971")
    @ParameterizedTest
    @ArgumentsSource(value=RepeatedFixtureProvider.class)
    public void issue1971(Fixture f) {
        NodeAccess na = f.graph.getNodeAccess();
        na.setNode(0, 49.408463, 9.700777);
        na.setNode(1, 49.404298, 9.701958);
        na.setNode(2, 49.402072, 9.701939);
        na.setNode(3, 49.401666, 9.701269);
        na.setNode(4, 49.40859, 9.705463);
        na.setNode(5, 49.406499, 9.70035);
        na.setNode(6, 49.40754, 9.703129);
        na.setNode(7, 49.403293, 9.704648);
        na.setNode(8, 49.404845, 9.704984);
        na.setNode(9, 49.409987, 9.704574);
        f.graph.edge(4, 8).setDistance(417.83).set(f.speedEnc, 65.0, 0.0);
        f.graph.edge(0, 1).setDistance(470.936).set(f.speedEnc, 30.0, 75.0);
        f.graph.edge(3, 5).setDistance(541.431).set(f.speedEnc, 60.0, 0.0);
        f.graph.edge(3, 5).setDistance(541.431).set(f.speedEnc, 105.0, 95.0);
        f.graph.edge(4, 2).setDistance(768.268).set(f.speedEnc, 30.0, 100.0);
        f.graph.edge(7, 3).setDistance(304.057).set(f.speedEnc, 10.0, 0.0);
        f.graph.edge(3, 4).setDistance(827.52).set(f.speedEnc, 100.0, 90.0);
        f.graph.edge(6, 9).setDistance(291.534).set(f.speedEnc, 35.0, 65.0);
        f.graph.edge(2, 7).setDistance(238.355).set(f.speedEnc, 65.0, 20.0);
        f.graph.edge(0, 2).setDistance(715.518).set(f.speedEnc, 15.0, 0.0);
        f.graph.edge(4, 5).setDistance(436.976).set(f.speedEnc, 80.0, 20.0);
        f.preProcessGraph();
        LocationIndexTree index = new LocationIndexTree((Graph)f.graph, f.dir);
        index.prepareIndex();
        List<Snap> snaps = Arrays.asList(index.findClosest(49.409452, 9.700482, EdgeFilter.ALL_EDGES), index.findClosest(49.406555, 9.704395, EdgeFilter.ALL_EDGES));
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)f.graph, snaps);
        int source = snaps.get(0).getClosestNode();
        int target = snaps.get(1).getClosestNode();
        int sourceOutEdge = 9;
        int targetInEdge = 12;
        Path refPath = new DijkstraBidirectionRef((Graph)queryGraph, queryGraph.wrapWeighting(f.weighting), TraversalMode.EDGE_BASED).calcPath(source, target, sourceOutEdge, targetInEdge);
        Path path = f.createAlgo((Graph)queryGraph).calcPath(source, target, sourceOutEdge, targetInEdge);
        Assertions.assertTrue((boolean)this.comparePaths(refPath, path, source, target, false, -1L).isEmpty());
    }

    private List<String> comparePaths(Path refPath, Path path, int source, int target, boolean checkNodes, long seed) {
        double weight;
        ArrayList<String> strictViolations = new ArrayList<String>();
        double refWeight = refPath.getWeight();
        if (Math.abs(refWeight - (weight = path.getWeight())) > 0.01) {
            LOGGER.warn("expected: " + String.valueOf(refPath.calcNodes()));
            LOGGER.warn("given:    " + String.valueOf(path.calcNodes()));
            Assertions.fail((String)("wrong weight: " + source + "->" + target + ", expected: " + refWeight + ", given: " + weight + ", seed: " + seed));
        }
        if (Math.abs(path.getDistance() - refPath.getDistance()) > 0.1) {
            strictViolations.add("wrong distance " + source + "->" + target + ", expected: " + refPath.getDistance() + ", given: " + path.getDistance());
        }
        if (Math.abs(path.getTime() - refPath.getTime()) > 50L) {
            strictViolations.add("wrong time " + source + "->" + target + ", expected: " + refPath.getTime() + ", given: " + path.getTime());
        }
        if (checkNodes && !refPath.calcNodes().equals((Object)path.calcNodes())) {
            strictViolations.add("wrong nodes " + source + "->" + target + "\nexpected: " + String.valueOf(refPath.calcNodes()) + "\ngiven:    " + String.valueOf(path.calcNodes()));
        }
        return strictViolations;
    }

    private int getTargetInEdge(Random rnd, int node, Graph graph) {
        return this.getAdjEdge(rnd, node, graph);
    }

    private int getSourceOutEdge(Random rnd, int node, Graph graph) {
        return this.getAdjEdge(rnd, node, graph);
    }

    private int getAdjEdge(Random rnd, int node, Graph graph) {
        if (rnd.nextDouble() < 0.05) {
            return -2;
        }
        if (rnd.nextDouble() < 0.05) {
            return -1;
        }
        EdgeExplorer explorer = graph.createEdgeExplorer();
        EdgeIterator iter = explorer.setBaseNode(node);
        ArrayList<Integer> edgeIds = new ArrayList<Integer>();
        while (iter.next()) {
            edgeIds.add(iter.getEdge());
        }
        return edgeIds.isEmpty() ? -2 : (Integer)edgeIds.get(rnd.nextInt(edgeIds.size()));
    }

    private static class Fixture {
        private final Algo algo;
        private final double uTurnCosts;
        private final boolean prepareCH;
        private final boolean prepareLM;
        private final Directory dir;
        private final BaseGraph graph;
        private final DecimalEncodedValue speedEnc;
        private final DecimalEncodedValue turnCostEnc;
        private final TurnCostStorage turnCostStorage;
        private final int maxTurnCosts;
        private Weighting weighting;
        private final EncodingManager encodingManager;
        private RoutingCHGraph routingCHGraph;
        private LandmarkStorage lm;

        public Fixture(Algo algo, double uTurnCosts, boolean prepareCH, boolean prepareLM) {
            this.algo = algo;
            this.uTurnCosts = uTurnCosts;
            this.prepareCH = prepareCH;
            this.prepareLM = prepareLM;
            this.dir = new RAMDirectory();
            this.maxTurnCosts = 10;
            this.speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
            this.turnCostEnc = TurnCost.create((String)"car", (int)this.maxTurnCosts);
            this.encodingManager = EncodingManager.start().add((EncodedValue)this.speedEnc).addTurnCostEncodedValue((EncodedValue)this.turnCostEnc).add((EncodedValue)Subnetwork.create((String)"c2")).build();
            this.graph = new BaseGraph.Builder(this.encodingManager).setDir(this.dir).withTurnCosts(true).create();
            this.turnCostStorage = this.graph.getTurnCostStorage();
        }

        public String toString() {
            return String.valueOf((Object)this.algo) + ", u-turn-costs: " + this.uTurnCosts + ", prepareCH: " + this.prepareCH + ", prepareLM: " + this.prepareLM;
        }

        private void preProcessGraph() {
            this.graph.freeze();
            this.weighting = new SpeedWeighting(this.speedEnc, this.turnCostEnc, this.turnCostStorage, this.uTurnCosts);
            if (!this.prepareCH && !this.prepareLM) {
                return;
            }
            if (this.prepareCH) {
                CHConfig chConfig = CHConfig.edgeBased((String)"p1", (Weighting)this.weighting);
                PrepareContractionHierarchies pch = PrepareContractionHierarchies.fromGraph((BaseGraph)this.graph, (CHConfig)chConfig);
                PrepareContractionHierarchies.Result res = pch.doWork();
                this.routingCHGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)this.graph, (CHStorage)res.getCHStorage(), (CHConfig)res.getCHConfig());
            }
            if (this.prepareLM) {
                LMConfig lmConfig = new LMConfig("c2", (Weighting)new SpeedWeighting(this.speedEnc));
                PrepareRoutingSubnetworks preparation = new PrepareRoutingSubnetworks(this.graph, Arrays.asList(new PrepareRoutingSubnetworks.PrepareJob(this.encodingManager.getBooleanEncodedValue(Subnetwork.key((String)"c2")), lmConfig.getWeighting())));
                preparation.setMinNetworkSize(0);
                preparation.doWork();
                PrepareLandmarks prepare = new PrepareLandmarks(this.dir, this.graph, (EncodedValueLookup)this.encodingManager, lmConfig, 16);
                prepare.setMaximumWeight(1000.0);
                prepare.doWork();
                this.lm = prepare.getLandmarkStorage();
            }
        }

        private EdgeToEdgeRoutingAlgorithm createAlgo() {
            return this.createAlgo((Graph)this.graph);
        }

        private EdgeToEdgeRoutingAlgorithm createAlgo(Graph graph) {
            switch (this.algo.ordinal()) {
                case 0: {
                    return new AStar(graph, graph.wrapWeighting(this.weighting), TraversalMode.EDGE_BASED);
                }
                case 1: {
                    return new AStarBidirection(graph, graph.wrapWeighting(this.weighting), TraversalMode.EDGE_BASED);
                }
                case 3: {
                    CHRoutingAlgorithmFactory algoFactory = graph instanceof QueryGraph ? new CHRoutingAlgorithmFactory((RoutingCHGraph)new QueryRoutingCHGraph(this.routingCHGraph, (QueryGraph)graph)) : new CHRoutingAlgorithmFactory(this.routingCHGraph);
                    return algoFactory.createAlgo(new PMap().putObject("algorithm", (Object)"dijkstrabi"));
                }
                case 2: {
                    CHRoutingAlgorithmFactory algoFactory = graph instanceof QueryGraph ? new CHRoutingAlgorithmFactory((RoutingCHGraph)new QueryRoutingCHGraph(this.routingCHGraph, (QueryGraph)graph)) : new CHRoutingAlgorithmFactory(this.routingCHGraph);
                    return algoFactory.createAlgo(new PMap().putObject("algorithm", (Object)"astarbi"));
                }
                case 4: {
                    return (EdgeToEdgeRoutingAlgorithm)new LMRoutingAlgorithmFactory(this.lm).createAlgo(graph, this.weighting, new AlgorithmOptions().setAlgorithm("astarbi").setTraversalMode(TraversalMode.EDGE_BASED));
                }
            }
            throw new IllegalArgumentException("unknown algo " + String.valueOf((Object)this.algo));
        }

        private int getRandom(Random rnd) {
            return rnd.nextInt(this.graph.getNodes());
        }
    }

    private static enum Algo {
        ASTAR_UNI_BEELINE,
        ASTAR_BI_BEELINE,
        CH_ASTAR,
        CH_DIJKSTRA,
        LM;

    }

    private static class RepeatedFixtureProvider
    implements ArgumentsProvider {
        private RepeatedFixtureProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Stream.generate(() -> new FixtureProvider().provideArguments(context)).limit(10L).flatMap(s -> s);
        }
    }

    private static class FixtureProvider
    implements ArgumentsProvider {
        private FixtureProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Stream.of(new Fixture(Algo.ASTAR_UNI_BEELINE, Double.POSITIVE_INFINITY, false, false), new Fixture(Algo.ASTAR_BI_BEELINE, Double.POSITIVE_INFINITY, false, false), new Fixture(Algo.CH_ASTAR, Double.POSITIVE_INFINITY, true, false), new Fixture(Algo.CH_DIJKSTRA, Double.POSITIVE_INFINITY, true, false), new Fixture(Algo.ASTAR_UNI_BEELINE, 40.0, false, false), new Fixture(Algo.ASTAR_BI_BEELINE, 40.0, false, false), new Fixture(Algo.CH_ASTAR, 40.0, true, false), new Fixture(Algo.CH_DIJKSTRA, 40.0, true, false)).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
        }
    }
}

